<?php

// Start of session v.

/**
 * 現在のセッション名を取得または設定する
 * @link http://www.php.net/manual/ja/function.session-name.php
 * @param name string[optional] <p>
 * セッションの名前を参照します。これは、クッキーや URL
 * (例: PHPSESSID) で使われます。
 * セッション名は英数字のみで構成されている必要があり、また、
 * 短く、その内容が分かるようなものである必要があります
 * (これは、クッキー警告を有効にしているユーザー用です)。
 * </p>
 * <p>
 * <p>
 * セッション名は数字だけで構成することはできません。
 * 少なくとも文字がひとつ以上現れる必要があります。そうでない場合、
 * 新規セッション ID が毎回生成されます。
 * </p>
 * </p>
 * @return string 現在のセッションの名前を返します。
 */
function session_name ($name = null) {}

/**
 * 現在のセッションモジュールを取得または設定する
 * @link http://www.php.net/manual/ja/function.session-module-name.php
 * @param module string[optional] <p>
 * module が指定された場合、
 * そのモジュールを代わりに使用します。
 * </p>
 * @return string 現在のセッションモジュールの名前を返します。
 */
function session_module_name ($module = null) {}

/**
 * 現在のセッションデータ保存パスを取得または設定する
 * @link http://www.php.net/manual/ja/function.session-save-path.php
 * @param path string[optional] <p>
 * セッションデータのパス。これを指定すると、
 * データを保存するパスが変更されます。ただしそのためには
 * session_start がコールされる前に
 * session_save_path がコールされている必要があります。
 * </p>
 * <p>
 * <p>
 * いくつかのオペレーションシステムでは、多くの小さなファイルを効率的に
 * 処理するファイルシステム上にパスを指定することが望ましいです。
 * 例えば、Linux では ext2fs よりも reiserfs の方が性能面でより
 * 優れています。
 * </p>
 * </p>
 * @return string 現在のデータ保存先ディレクトリのパスを返します。
 */
function session_save_path ($path = null) {}

/**
 * 現在のセッション ID を取得または設定する
 * @link http://www.php.net/manual/ja/function.session-id.php
 * @param id string[optional] <p>
 * id が指定された場合、現在の
 * セッション ID を置換します。その際、
 * この関数は session_start
 * より前にコールされている必要があります。
 * セッションハンドラによっては、セッション ID として使用できる文字に
 * 制限がある場合があります。例えば、ファイルによるセッションハンドラでは
 * セッション ID として使える文字は
 * a-z A-Z 0-9 , (カンマ) そして - (マイナス)
 * に限られます!
 * </p>
 * セッション保持にクッキーを使用している場合、
 * session_id において
 * id 引数を指定すると、
 * 現在のセッション ID がセットされるものと
 * まったく同一であるかどうかに関わらず、
 * session_start
 * が呼び出される際に常に新しいクッキーが送信されます。
 * @return string session_id は現在のセッションのセッション ID を返します。
 * 現在のセッションが存在しない (現在のセッション ID が存在しない)
 * 場合は空文字列 ("") を返します。
 */
function session_id ($id = null) {}

/**
 * 現在のセッションIDを新しく生成したものと置き換える
 * @link http://www.php.net/manual/ja/function.session-regenerate-id.php
 * @param delete_old_session bool[optional] <p>
 * 関連付けられた古いセッションを削除するかどうか。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function session_regenerate_id ($delete_old_session = null) {}

/**
 * セッションエンコードされた文字列からセッションデータをデコードする
 * @link http://www.php.net/manual/ja/function.session-decode.php
 * @param data string <p>
 * エンコードされたデータ。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function session_decode ($data) {}

/**
 * 現在のセッションに1つ以上の変数を登録する
 * @link http://www.php.net/manual/ja/function.session-register.php
 * @param name mixed <p>
 * 変数名を含む文字列、
 * あるいは変数名や配列を含む配列。
 * </p>
 * @param _ mixed[optional] 
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function session_register ($name, $_ = null) {}

/**
 * 現在のセッションから変数の登録を削除する
 * @link http://www.php.net/manual/ja/function.session-unregister.php
 * @param name string <p>
 * 変数名。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function session_unregister ($name) {}

/**
 * 変数がセッションに登録されているかどうかを調べる
 * @link http://www.php.net/manual/ja/function.session-is-registered.php
 * @param name string <p>
 * 変数名。
 * </p>
 * @return bool session_is_registered は、
 * name
 * という名前のグローバル変数が現在のセッションに登録されている場合に
 * TRUE、それ以外の場合に FALSE を返します。
 */
function session_is_registered ($name) {}

/**
 * 現在のセッションデータを、セッションエンコードされた文字列に変換する
 * @link http://www.php.net/manual/ja/function.session-encode.php
 * @return string 現在のセッションの内容をエンコードしたものを返します。
 */
function session_encode () {}

/**
 * 新しいセッションを開始、あるいは既存のセッションを再開する
 * @link http://www.php.net/manual/ja/function.session-start.php
 * @return bool この関数は、セッションが正常に開始した場合に TRUE、それ以外の場合に FALSE
 * を返します。
 */
function session_start () {}

/**
 * セッションに登録されたデータを全て破棄する
 * @link http://www.php.net/manual/ja/function.session-destroy.php
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function session_destroy () {}

/**
 * 全てのセッション変数を開放する
 * @link http://www.php.net/manual/ja/function.session-unset.php
 * @return void 値を返しません。
 */
function session_unset () {}

/**
 * ユーザー定義のセッション保存関数を設定する
 * @link http://www.php.net/manual/ja/function.session-set-save-handler.php
 * @param open callable 
 * @param close callable 
 * @param read callable 
 * @param write callable 
 * @param destroy callable 
 * @param gc callable 
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function session_set_save_handler ($open, $close, $read, $write, $destroy, $gc) {}

/**
 * 現在のキャッシュリミッタを取得または設定する
 * @link http://www.php.net/manual/ja/function.session-cache-limiter.php
 * @param cache_limiter string[optional] <p>
 * cache_limiter
 * が指定された場合、現在のキャッシュリミッタは新しい値に変更されます。
 * </p>
 * <table>
 * 取り得る値
 * <tr valign="top">
 * <td>値</td>
 * <td>送信されるヘッダ</td>
 * </tr>
 * <tr valign="top">
 * <td>public</td>
 * <td>
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>private_no_expire</td>
 * <td>
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>private</td>
 * <td>
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>nocache</td>
 * <td>
 * </td>
 * </tr>
 * </table>
 * @return string 現在のキャッシュリミッタの名前を返します。
 */
function session_cache_limiter ($cache_limiter = null) {}

/**
 * 現在のキャッシュの有効期限を返す
 * @link http://www.php.net/manual/ja/function.session-cache-expire.php
 * @param new_cache_expire string[optional] <p>
 * new_cache_expire が指定された場合、
 * 現在のキャッシュの有効期限は、
 * new_cache_expire で置換されます。
 * </p>
 * <p>
 * session.cache_limiterが
 * nocache以外の値にセットされている場合にのみ
 * new_cache_expireが有効となります。
 * </p>
 * @return int session.cache_expire の現在の設定を返します。
 * 返り値は分単位で、デフォルトは 180 です。
 */
function session_cache_expire ($new_cache_expire = null) {}

/**
 * セッションクッキーパラメータを設定する
 * @link http://www.php.net/manual/ja/function.session-set-cookie-params.php
 * @param lifetime int <p>
 * セッションクッキーの 有効期限。秒数で定義します。
 * </p>
 * @param path string[optional] <p>
 * クッキーが動作するドメイン上の
 * パス。単一のスラッシュ ('/')
 * を指定すると、ドメイン上のすべてのパスで動作します。
 * </p>
 * @param domain string[optional] <p>
 * クッキーの ドメイン。たとえば 'www.php.net'。
 * すべてのサブドメインでクッキーを有効にしたい場合は、先頭にドットをつけて
 * '.php.net' のようにします。
 * </p>
 * @param secure bool[optional] <p>
 * TRUE の場合は、セキュア
 * な接続の場合にのみクッキーを送信します。
 * </p>
 * @param httponly bool[optional] <p>
 * TRUE の場合は、PHP でセッションクッキーを設定する際に
 * httponly フラグの送信を試みます。
 * </p>
 * @return void 値を返しません。
 */
function session_set_cookie_params ($lifetime, $path = null, $domain = null, $secure = null, $httponly = null) {}

/**
 * セッションクッキーのパラメータを得る
 * @link http://www.php.net/manual/ja/function.session-get-cookie-params.php
 * @return array 現在のセッションクッキーの情報を配列として返します。
 * この配列には次のような項目が含まれています。
 * "lifetime" - クッキーの生存期間(lifetime)
 * "path" - 情報が保存されている場所のパス
 * "domain" - クッキーのドメイン
 * "secure" - クッキーはセキュアな接続でのみ送信されます。
 * "httponly" - クッキーは HTTP を通してのみアクセス可能となります。
 */
function session_get_cookie_params () {}

/**
 * セッションデータを書き込んでセッションを終了する
 * @link http://www.php.net/manual/ja/function.session-write-close.php
 * @return void 値を返しません。
 */
function session_write_close () {}

/**
 * <function>session_write_close</function> のエイリアス
 * @link http://www.php.net/manual/ja/function.session-commit.php
 */
function session_commit () {}

// End of session v.
?>
