<?php

// Start of odbc v.1.0

/**
 * 自動コミットの動作をオンまたはオフにする
 * @link http://www.php.net/manual/ja/function.odbc-autocommit.php
 * @param connection_id resource ODBC 接続 ID。詳細は
 * odbc_connect を参照ください。</p>
 * @param OnOff bool[optional] <p>
 * OnOff が TRUE の場合は自動コミットが可能であり、
 * FALSE の場合は自動コミットが使用不可となっています。
 * </p>
 * @return mixed OnOff パラメータを指定しない場合、
 * この関数は、connection_id に関する
 * 自動コミットの状態を返します。自動コミットがオンの場合に
 * 非ゼロ、オフの場合にゼロ、エラーを生じた場合に FALSE を返します。
 * </p>
 * <p>
 * OnOff が設定されている場合は、
 * この関数は成功時に TRUE、失敗したときに 
 * FALSE を返します。
 */
function odbc_autocommit ($connection_id, $OnOff = null) {}

/**
 * バイナリカラムデータを処理する
 * @link http://www.php.net/manual/ja/function.odbc-binmode.php
 * @param result_id resource <p>
 * 結果 ID。
 * </p>
 * <p>
 * result_id に 0 を指定した場合、
 * ここで設定した値は、新規の結果に関するデフォルト値として用いられます。
 * longreadlen のデフォルト値は 4096 で、mode
 * のデフォルト値は ODBC_BINMODE_RETURN です。
 * バイナリロングカラムの処理は、odbc_longreadlen 
 * の影響も受けます。
 * </p>
 * @param mode int <p>
 * mode には、以下の値が指定できます。
 * ODBC_BINMODE_PASSTHRU: BINARY データとして通過
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function odbc_binmode ($result_id, $mode) {}

/**
 * ODBC 接続を閉じる
 * @link http://www.php.net/manual/ja/function.odbc-close.php
 * @param connection_id resource ODBC 接続 ID。詳細は
 * odbc_connect を参照ください。</p>
 * @return void 値を返しません。
 */
function odbc_close ($connection_id) {}

/**
 * 全ての ODBC 接続を閉じる
 * @link http://www.php.net/manual/ja/function.odbc-close-all.php
 * @return void 値を返しません。
 */
function odbc_close_all () {}

/**
 * 指定したテーブルにあるカラム名のリストを取得する
 * @link http://www.php.net/manual/ja/function.odbc-columns.php
 * @param connection_id resource ODBC 接続 ID。詳細は
 * odbc_connect を参照ください。</p>
 * @param qualifier string[optional] <p>
 * 修飾子。
 * </p>
 * @param schema string[optional] <p>
 * 所有者。
 * </p>
 * @param table_name string[optional] <p>
 * テーブル名。
 * </p>
 * @param column_name string[optional] <p>
 * カラム名。
 * </p>
 * @return resource ODBC 結果 ID を返します。失敗した場合に FALSE を返します。
 * </p>
 * <p>
 * 結果セットは以下のカラムを有しています。
 * TABLE_QUALIFIER
 * TABLE_SCHEM
 * TABLE_NAME
 * COLUMN_NAME
 * DATA_TYPE
 * TYPE_NAME
 * PRECISION
 * LENGTH
 * SCALE
 * RADIX
 * NULLABLE
 * REMARKS
 * </p>
 * <p>
 * 結果セットは TABLE_QUALIFIER、TABLE_SCHEM、TABLE_NAME でソートされます。
 */
function odbc_columns ($connection_id, $qualifier = null, $schema = null, $table_name = null, $column_name = null) {}

/**
 * ODBC トランザクションをコミットする
 * @link http://www.php.net/manual/ja/function.odbc-commit.php
 * @param connection_id resource ODBC 接続 ID。詳細は
 * odbc_connect を参照ください。</p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function odbc_commit ($connection_id) {}

/**
 * データソースに接続する
 * @link http://www.php.net/manual/ja/function.odbc-connect.php
 * @param dsn string <p>
 * 接続に使用するデータベースソース名。
 * あるいは、DSNではない接続文字列を使用することもできます。
 * </p>
 * @param user string <p>
 * ユーザー名。
 * </p>
 * @param password string <p>
 * パスワード。
 * </p>
 * @param cursor_type int[optional] <p>
 * この接続で使用するカーソルの型。
 * 通常はこのパラメータは必要ありませんが、いくつかの
 * ODBC ドライバの問題に対処する際には有用です。
 * </p>
 * 次のような定数がカーソル型として定義されています。
 * <p>
 * SQL_CUR_USE_IF_NEEDED
 * @return resource ODBC 接続、またはエラーの場合に FALSE を返します。
 */
function odbc_connect ($dsn, $user, $password, $cursor_type = null) {}

/**
 * カーソル名を得る
 * @link http://www.php.net/manual/ja/function.odbc-cursor.php
 * @param result_id resource <p>
 * 結果 ID。
 * </p>
 * @return string カーソル名を文字列で返します。
 */
function odbc_cursor ($result_id) {}

/**
 * 現在の接続についての情報を返す
 * @link http://www.php.net/manual/ja/function.odbc-data-source.php
 * @param connection_id resource ODBC 接続 ID。詳細は
 * odbc_connect を参照ください。</p>
 * @param fetch_type int <p>
 * fetch_type は次のふたつの定数
 * SQL_FETCH_FIRST, SQL_FETCH_NEXT
 * のうちのどちらかです。
 * この関数を最初にコールする際には SQL_FETCH_FIRST
 * を、それ以降は SQL_FETCH_NEXT
 * を使用します。
 * </p>
 * @return array エラー時には FALSE、成功時には配列を返します。
 */
function odbc_data_source ($connection_id, $fetch_type) {}

/**
 * プリペアドステートメントを実行する
 * @link http://www.php.net/manual/ja/function.odbc-execute.php
 * @param result_id resource <p>
 * odbc_prepare で取得した結果 ID リソース。
 * </p>
 * @param parameters_array array[optional] <p>
 * プリペアドステートメントの中のプレースホルダが、
 * parameter_array 内のパラメータで順に置き換えられます。
 * この関数をコールした際に、配列の要素は文字列に変換されます。
 * </p>
 * <p>
 * parameter_array の中でシングルクォートで括られたデータがある場合、
 * それはファイル名と解釈されます。そのファイルの内容が、
 * 該当するプレースホルダのデータとしてデータベースサーバーに送信されます。
 * </p>
 * シングルクォートで括られたデータを純粋に文字列として使用したい場合は、
 * 空白などの別の文字を前後に付加する必要があります。
 * それにより、パラメータがファイル名とみなされることがなくなります
 * (もしこのオプションが不要なら、別の仕組み、たとえば
 * odbc_exec
 * で直接クエリを実行するなどを使用する必要があります)。
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function odbc_execute ($result_id, array $parameters_array = null) {}

/**
 * 直近のエラーコードを得る
 * @link http://www.php.net/manual/ja/function.odbc-error.php
 * @param connection_id resource[optional] ODBC 接続 ID。詳細は
 * odbc_connect を参照ください。</p>
 * @return string connection_id が指定された場合、
 * その接続の直近の状態が返されます。そうでない場合、
 * 他の接続の直近の状態が返されます。
 * </p>
 * <p>
 * この関数の返り値が意味を持つのは、直近の odbc クエリが失敗した場合
 * (すなわち odbc_exec が FALSE を返した場合) のみです。
 */
function odbc_error ($connection_id = null) {}

/**
 * 直近のエラーメッセージを得る
 * @link http://www.php.net/manual/ja/function.odbc-errormsg.php
 * @param connection_id resource[optional] ODBC 接続 ID。詳細は
 * odbc_connect を参照ください。</p>
 * @return string connection_id が指定された場合、
 * その接続の直近の状態が返されます。さもなくば、他の接続の直近の状態が返されます。
 * </p>
 * <p>
 * この関数の返り値が意味を持つのは、直近の odbc クエリが失敗した場合
 * (すなわち odbc_exec が FALSE を返した場合) のみです。
 */
function odbc_errormsg ($connection_id = null) {}

/**
 * SQL文を準備し、実行する
 * @link http://www.php.net/manual/ja/function.odbc-exec.php
 * @param connection_id resource ODBC 接続 ID。詳細は
 * odbc_connect を参照ください。</p>
 * @param query_string string <p>
 * SQL 文。
 * </p>
 * @param flags int[optional] <p>
 * このパラメータは現在使用していません。
 * </p>
 * @return resource SQL コマンドの実行に成功した場合には、
 * ODBC 結果 ID を返します。エラー時には、FALSEを返します。
 */
function odbc_exec ($connection_id, $query_string, $flags = null) {}

/**
 * 連想配列として結果の行を取得する
 * @link http://www.php.net/manual/ja/function.odbc-fetch-array.php
 * @param result resource <p>
 * odbc_exec の結果リソース。
 * </p>
 * @param rownumber int[optional] <p>
 * どの行番号を取得するのかを任意で指定する。
 * </p>
 * @return array 取得した行に対応する配列を返します。もう行がない場合には FALSE
 * を返します。
 */
function odbc_fetch_array ($result, $rownumber = null) {}

/**
 * オブジェクトとして結果の行を取得する
 * @link http://www.php.net/manual/ja/function.odbc-fetch-object.php
 * @param result resource <p>
 * odbc_exec の結果リソース。
 * </p>
 * @param rownumber int[optional] <p>
 * どの行番号を取得するのかを任意で指定する。
 * </p>
 * @return object 取得した行に対応するオブジェクトを返します。もう行がない場合には FALSE
 * を返します。
 */
function odbc_fetch_object ($result, $rownumber = null) {}

/**
 * 行を取り込む
 * @link http://www.php.net/manual/ja/function.odbc-fetch-row.php
 * @param result_id resource <p>
 * 結果 ID。
 * </p>
 * @param row_number int[optional] <p>
 * row_number が指定されない場合、
 * odbc_fetch_row は、
 * 結果セットにおける次の行を取り込もうと試みます。
 * row_number を指定した
 * odbc_fetch_row
 * のコールと指定しないコールを混用することができます。
 * </p>
 * <p>
 * 結果を複数回走査したい場合、odbc_fetch_row を
 * row_number に 1 を指定してコールし、
 * 続いて結果を再度見るために
 * row_number を指定せずに
 * odbc_fetch_row を実行しつづけます。
 * 行を番号で取り込むことをドライバがサポートしていない場合、
 * row_number パラメータは無視されます。
 * </p>
 * @return bool 行があった場合には
 * TRUE、それ以外の場合に FALSE を返します。
 */
function odbc_fetch_row ($result_id, $row_number = null) {}

/**
 * 一行ぶんの結果を配列に取り込む
 * @link http://www.php.net/manual/ja/function.odbc-fetch-into.php
 * @param result_id resource <p>
 * 結果リソース。
 * </p>
 * @param result_array array <p>
 * 結果の配列。型変換によってい配列型となるので、どんな型であっても構いません。
 * この配列には、添字 0 から始まるカラム番号が代入されます。
 * </p>
 * @param rownumber int[optional] <p>
 * 行番号。
 * </p>
 * @return int 結果におけるカラム番号を返します。また、エラーの場合に FALSE
 * を返します。
 */
function odbc_fetch_into ($result_id, array &$result_array, $rownumber = null) {}

/**
 * フィールドの長さ (精度) を得る
 * @link http://www.php.net/manual/ja/function.odbc-field-len.php
 * @param result_id resource <p>
 * 結果 ID。
 * </p>
 * @param field_number int <p>
 * フィールド番号。フィールド番号は 1 から始まります。
 * </p>
 * @return int フィールド名を表す文字列、あるいはエラー時に FALSE を返します。
 */
function odbc_field_len ($result_id, $field_number) {}

/**
 * フィールドの精度を得る
 * @link http://www.php.net/manual/ja/function.odbc-field-scale.php
 * @param result_id resource <p>
 * 結果 ID。
 * </p>
 * @param field_number int <p>
 * フィールド番号。
 * フィールド番号は、1 から始まります。
 * </p>
 * @return int フィールド番号、あるいはエラー時に FALSE を返します。
 */
function odbc_field_scale ($result_id, $field_number) {}

/**
 * カラム名を得る
 * @link http://www.php.net/manual/ja/function.odbc-field-name.php
 * @param result_id resource <p>
 * 結果 ID。
 * </p>
 * @param field_number int <p>
 * フィールド番号。フィールド番号は、1 から始まります。
 * </p>
 * @return string フィールド名を表す文字列、あるいはエラー時に FALSE を返します。
 */
function odbc_field_name ($result_id, $field_number) {}

/**
 * フィールドのデータ型を返す
 * @link http://www.php.net/manual/ja/function.odbc-field-type.php
 * @param result_id resource <p>
 * 結果 ID。
 * </p>
 * @param field_number int <p>
 * フィールド番号。フィールド番号は 1 から始まります。
 * </p>
 * @return string フィールドの型を表す文字列、あるいはエラー時に FALSE を返します。
 */
function odbc_field_type ($result_id, $field_number) {}

/**
 * カラム番号を返す
 * @link http://www.php.net/manual/ja/function.odbc-field-num.php
 * @param result_id resource <p>
 * 結果 ID。
 * </p>
 * @param field_name string <p>
 * フィールド名。
 * </p>
 * @return int フィールド番号、あるいはエラー時に FALSE を返します。
 * フィールド番号は、1 から始まります。
 */
function odbc_field_num ($result_id, $field_name) {}

/**
 * 結果を保持するリソースを開放する
 * @link http://www.php.net/manual/ja/function.odbc-free-result.php
 * @param result_id resource <p>
 * 結果 ID。
 * </p>
 * @return bool 常に TRUE を返します。
 */
function odbc_free_result ($result_id) {}

/**
 * データソースがサポートするデータ型についての情報を取得する
 * @link http://www.php.net/manual/ja/function.odbc-gettypeinfo.php
 * @param connection_id resource ODBC 接続 ID。詳細は
 * odbc_connect を参照ください。</p>
 * @param data_type int[optional] <p>
 * データ型。単一のデータ型に情報を制限するために使用します。
 * </p>
 * @return resource ODBC 結果 ID または失敗した場合に FALSE を返します。
 * </p>
 * <p>
 * 結果は、以下のようなカラムを持つものとなります。
 * TYPE_NAME
 * DATA_TYPE
 * PRECISION
 * LITERAL_PREFIX
 * LITERAL_SUFFIX
 * CREATE_PARAMS
 * NULLABLE
 * CASE_SENSITIVE
 * SEARCHABLE
 * UNSIGNED_ATTRIBUTE
 * MONEY
 * AUTO_INCREMENT
 * LOCAL_TYPE_NAME
 * MINIMUM_SCALE
 * MAXIMUM_SCALE
 * </p>
 * <p>
 * 結果セットは、DATA_TYPE および TYPE_NAME でソートされます。
 */
function odbc_gettypeinfo ($connection_id, $data_type = null) {}

/**
 * LONG カラムを処理する
 * @link http://www.php.net/manual/ja/function.odbc-longreadlen.php
 * @param result_id resource <p>
 * 結果 ID。
 * </p>
 * @param length int <p>
 * PHP に返されるバイト数は、パラメータ length により制御されます。
 * これを 0 をセットした場合、ロングカラムデータは、
 * クライアントにそのまま渡されます。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function odbc_longreadlen ($result_id, $length) {}

/**
 * 複数の結果が利用可能などうか確認する
 * @link http://www.php.net/manual/ja/function.odbc-next-result.php
 * @param result_id resource <p>
 * 結果 ID。
 * </p>
 * @return bool 結果セットがまだある場合に TRUE、それ以外の場合に FALSE を返します。
 */
function odbc_next_result ($result_id) {}

/**
 * 結果のカラム数を返す
 * @link http://www.php.net/manual/ja/function.odbc-num-fields.php
 * @param result_id resource <p>
 * odbc_exec が返す結果 ID。
 * </p>
 * @return int フィールド数、あるいはエラー時に -1 を返します。
 */
function odbc_num_fields ($result_id) {}

/**
 * 結果における行数を返す
 * @link http://www.php.net/manual/ja/function.odbc-num-rows.php
 * @param result_id resource <p>
 * odbc_exec が返す結果 ID。
 * </p>
 * @return int ODBC 結果における行の数を返します。
 * この関数は、エラー時に-1を返します。
 */
function odbc_num_rows ($result_id) {}

/**
 * 持続的なデータベース接続を開く
 * @link http://www.php.net/manual/ja/function.odbc-pconnect.php
 * @param dsn string 
 * @param user string 
 * @param password string 
 * @param cursor_type int[optional] 
 * @return resource ODBC 接続 ID またはエラー時に 0 (FALSE) を返します。
 */
function odbc_pconnect ($dsn, $user, $password, $cursor_type = null) {}

/**
 * 実行用に文を準備する
 * @link http://www.php.net/manual/ja/function.odbc-prepare.php
 * @param connection_id resource ODBC 接続 ID。詳細は
 * odbc_connect を参照ください。</p>
 * @param query_string string <p>
 * 準備するクエリ文字列。
 * </p>
 * @return resource SQL コマンドの準備に成功した場合は、ODBC 結果 ID を返します。
 * エラー時には、FALSE を返します。
 */
function odbc_prepare ($connection_id, $query_string) {}

/**
 * 結果データを得る
 * @link http://www.php.net/manual/ja/function.odbc-result.php
 * @param result_id resource <p>
 * ODBC リソース。
 * </p>
 * @param field mixed <p>
 * 取得するフィールド。
 * カラム番号を表す整数またはフィールド名を表す文字列のどちらを指定できます。
 * </p>
 * @return mixed フィールドの内容を表す文字列を返します。エラー時には FALSE、NULL
 * データの場合は NULL、そしてバイナリデータの場合は TRUE を返します。
 */
function odbc_result ($result_id, $field) {}

/**
 * HTML テーブルとして結果を出力する
 * @link http://www.php.net/manual/ja/function.odbc-result-all.php
 * @param result_id resource <p>
 * 結果 ID。
 * </p>
 * @param format string[optional] <p>
 * テーブルのフォーマット指定。
 * </p>
 * @return int 成功の場合に結果の行数、エラーの場合に FALSE を返します。
 */
function odbc_result_all ($result_id, $format = null) {}

/**
 * トランザクションをロールバックする
 * @link http://www.php.net/manual/ja/function.odbc-rollback.php
 * @param connection_id resource ODBC 接続 ID。詳細は
 * odbc_connect を参照ください。</p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function odbc_rollback ($connection_id) {}

/**
 * ODBC の設定を変更する
 * @link http://www.php.net/manual/ja/function.odbc-setoption.php
 * @param id resource <p>
 * 設定を変更する接続 ID または
 * 結果 ID。SQLSetConnectOption() の場合、これは接続 ID です。
 * SQLSetStmtOption() の場合、これは結果 ID です。
 * </p>
 * @param function int <p>
 * 使用する ODBC 関数。
 * 値は SQLSetConnectOption() の場合 1、
 * SQLSetStmtOption() の場合 2 である必要があります。
 * </p>
 * @param option int <p>
 * 設定するオプション。
 * </p>
 * @param param int <p>
 * 指定した option の値。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function odbc_setoption ($id, $function, $option, $param) {}

/**
 * 特殊カラムを取得する
 * @link http://www.php.net/manual/ja/function.odbc-specialcolumns.php
 * @param connection_id resource ODBC 接続 ID。詳細は
 * odbc_connect を参照ください。</p>
 * @param type int 引数 type が SQL_BEST_ROWID の場合、
 * odbc_specialcolumns
 * はテーブルの各レコードを特定するカラムを返します。
 * 引数 type が SQL_ROWVER の場合、
 * odbc_specialcolumns はカラムから値を取得する
 * ことにより指定したテーブルでレコードを特定できる最適なカラムまたはカラムの組を返します。
 * @param qualifier string <p>
 * 修飾子。
 * </p>
 * @param owner string <p>
 * 所有者。
 * </p>
 * @param table string <p>
 * テーブル。
 * </p>
 * @param scope int <p>
 * スコープ。これは結果セットの並べかえる際に使用します。
 * </p>
 * @param nullable int <p>
 * nullable オプション。
 * </p>
 * @return resource ODBC 結果 ID または失敗した場合に FALSE を返します。
 * </p>
 * <p>
 * 結果セットのカラムは次のようになります。
 * SCOPE
 * COLUMN_NAME
 * DATA_TYPE
 * TYPE_NAME
 * PRECISION
 * LENGTH
 * SCALE
 * PSEUDO_COLUMN
 */
function odbc_specialcolumns ($connection_id, $type, $qualifier, $owner, $table, $scope, $nullable) {}

/**
 * テーブルに関する統計情報を取得する
 * @link http://www.php.net/manual/ja/function.odbc-statistics.php
 * @param connection_id resource ODBC 接続 ID。詳細は
 * odbc_connect を参照ください。</p>
 * @param qualifier string <p>
 * 修飾子。
 * </p>
 * @param owner string <p>
 * 所有者。
 * </p>
 * @param table_name string <p>
 * テーブル名。
 * </p>
 * @param unique int <p>
 * unique 属性。
 * </p>
 * @param accuracy int <p>
 * 正確さ。
 * </p>
 * @return resource ODBC 結果 ID を返します。失敗した場合に FALSE を返します。
 * </p>
 * <p>
 * 結果セットのカラムは次のようになります。
 * TABLE_QUALIFIER
 * TABLE_OWNER
 * TABLE_NAME
 * NON_UNIQUE
 * INDEX_QUALIFIER
 * INDEX_NAME
 * TYPE
 * SEQ_IN_INDEX
 * COLUMN_NAME
 * COLLATION
 * CARDINALITY
 * PAGES
 * FILTER_CONDITION
 */
function odbc_statistics ($connection_id, $qualifier, $owner, $table_name, $unique, $accuracy) {}

/**
 * 指定したデータソースに保存されたテーブルの名前のリストを取得する
 * @link http://www.php.net/manual/ja/function.odbc-tables.php
 * @param connection_id resource ODBC 接続 ID。詳細は
 * odbc_connect を参照ください。</p>
 * @param qualifier string[optional] <p>
 * 修飾子。
 * </p>
 * @param owner string[optional] <p>
 * 所有者。
 * 検索パターン (ゼロ以上の文字にマッチする '%' や単一の文字にマッチする '_')
 * を指定可能です。
 * </p>
 * @param name string[optional] <p>
 * 名前。
 * 検索パターン (ゼロ以上の文字にマッチする '%' や単一の文字にマッチする '_')
 * を指定可能です。
 * </p>
 * @param types string[optional] <p>
 * table_type が空の文字列ではない場合、検索する型に
 * ついてカンマで区切った値のリストを指定する必要があります。
 * 各値は、シングルクオート(')で括るかまたは括らない形で指定可能です。
 * 例えば、"'TABLE','VIEW'" または "TABLE, VIEW" となります。データソースが
 * が指定したテーブル型をサポートしていない場合、
 * odbc_tables はその型についていかなる結果も
 * 返しません。
 * </p>
 * @return resource 情報を含んでいる ODBC 結果 ID を返します。
 * 失敗した場合に FALSE を返します。
 * </p>
 * <p>
 * 結果セットのカラムは次のようになります。
 * TABLE_QUALIFIER
 * TABLE_OWNER
 * TABLE_NAME
 * TABLE_TYPE
 * REMARKS
 */
function odbc_tables ($connection_id, $qualifier = null, $owner = null, $name = null, $types = null) {}

/**
 * テーブルの主キーを取得する
 * @link http://www.php.net/manual/ja/function.odbc-primarykeys.php
 * @param connection_id resource ODBC 接続 ID。詳細は
 * odbc_connect を参照ください。</p>
 * @param qualifier string <p>
 * </p>
 * @param owner string <p>
 * </p>
 * @param table string <p>
 * </p>
 * @return resource ODBC 結果 ID を返します。失敗した場合に FALSE を返します。
 * </p>
 * <p>
 * 結果は以下のカラムを有します。
 * TABLE_QUALIFIER
 * TABLE_OWNER
 * TABLE_NAME
 * COLUMN_NAME
 * KEY_SEQ
 * PK_NAME
 */
function odbc_primarykeys ($connection_id, $qualifier, $owner, $table) {}

/**
 * 指定したテーブルに関するカラムおよび付随する権限のリストを取得する
 * @link http://www.php.net/manual/ja/function.odbc-columnprivileges.php
 * @param connection_id resource ODBC 接続 ID。詳細は
 * odbc_connect を参照ください。</p>
 * @param qualifier string <p>
 * 修飾子。
 * </p>
 * @param owner string <p>
 * 所有者。
 * </p>
 * @param table_name string <p>
 * テーブル名。
 * </p>
 * @param column_name string <p>
 * 引数 column_name には検索パターン
 * (ゼロ以上の文字にマッチする '%' や単一の文字にマッチする '_') を使用可能です。
 * </p>
 * @return resource ODBC 結果 ID を返します。失敗した場合に FALSE を返します。
 * この結果 ID を使用して、カラムや関連する権限の一覧を取得します。
 * </p>
 * <p>
 * 結果は以下のカラムを有します。
 * TABLE_QUALIFIER
 * TABLE_OWNER
 * TABLE_NAME
 * GRANTOR
 * GRANTEE
 * PRIVILEGE
 * IS_GRANTABLE
 * </p>
 * <p>
 * 結果セットは TABLE_QUALIFIER、TABLE_OWNER、TABLE_NAME でソートされます。
 */
function odbc_columnprivileges ($connection_id, $qualifier, $owner, $table_name, $column_name) {}

/**
 * 各テーブルのリストおよび関連する権限のリストを取得する
 * @link http://www.php.net/manual/ja/function.odbc-tableprivileges.php
 * @param connection_id resource ODBC 接続 ID。詳細は
 * odbc_connect を参照ください。</p>
 * @param qualifier string <p>
 * 修飾子。
 * </p>
 * @param owner string <p>
 * 所有者。
 * ゼロ以上の文字にマッチする '%' や単一の文字にマッチする '_' を使用可能です。
 * </p>
 * @param name string <p>
 * 名前。
 * ゼロ以上の文字にマッチする '%' や単一の文字にマッチする '_' を使用可能です。
 * </p>
 * @return resource ODBC 結果 ID を返します。失敗した場合に FALSE を返します。
 * </p>
 * <p>
 * 結果セットのカラムは次のようになります。
 * TABLE_QUALIFIER
 * TABLE_OWNER
 * TABLE_NAME
 * GRANTOR
 * GRANTEE
 * PRIVILEGE
 * IS_GRANTABLE
 */
function odbc_tableprivileges ($connection_id, $qualifier, $owner, $name) {}

/**
 * 外部キーのリストを取得する
 * @link http://www.php.net/manual/ja/function.odbc-foreignkeys.php
 * @param connection_id resource ODBC 接続 ID。詳細は
 * odbc_connect を参照ください。</p>
 * @param pk_qualifier string <p>
 * 主キーの修飾子。
 * </p>
 * @param pk_owner string <p>
 * 主キーの所有者。
 * </p>
 * @param pk_table string <p>
 * 主キーのテーブル。
 * </p>
 * @param fk_qualifier string <p>
 * 外部キーの修飾子。
 * </p>
 * @param fk_owner string <p>
 * 外部キーの所有者。
 * </p>
 * @param fk_table string <p>
 * 外部キーのテーブル。
 * </p>
 * @return resource ODBC 結果 ID を返します。失敗した場合に FALSE を返します。
 * </p>
 * <p>
 * 結果は、以下のようなカラムを持つものとなります。
 * PKTABLE_QUALIFIER
 * PKTABLE_OWNER
 * PKTABLE_NAME
 * PKCOLUMN_NAME
 * FKTABLE_QUALIFIER
 * FKTABLE_OWNER
 * FKTABLE_NAME
 * FKCOLUMN_NAME
 * KEY_SEQ
 * UPDATE_RULE
 * DELETE_RULE
 * FK_NAME
 * PK_NAME
 * </p>
 * pk_table がテーブル名を有している場合、
 * odbc_foreignkeys は指定したテーブルの主キー
 * およびそのキーを参照する全ての外部キーのリストを結果として返します。
 * fk_table がテーブル名を有している場合、
 * odbc_foreignkeys は指定したテーブルにある全ての
 * 外部キーおよびそのキーが参照する(他のテーブルの)主キーのリストを
 * 結果として返します。
 * pk_table および
 * fk_table が共にテーブル名を有している場合、
 * odbc_foreignkeys は
 * pk_table で指定されたテーブルの主キーを参照する
 * fk_table
 */
function odbc_foreignkeys ($connection_id, $pk_qualifier, $pk_owner, $pk_table, $fk_qualifier, $fk_owner, $fk_table) {}

/**
 * 指定したデータソースに保存されているプロシージャのリストを取得する
 * @link http://www.php.net/manual/ja/function.odbc-procedures.php
 * @param connection_id resource ODBC 接続 ID。詳細は
 * odbc_connect を参照ください。</p>
 * @return resource 情報を含む ODBC 結果 ID を返します。
 * 失敗した場合に FALSE を返します。
 * </p>
 * <p>
 * 結果セットのカラムは次のようになります。
 * PROCEDURE_QUALIFIER
 * PROCEDURE_OWNER
 * PROCEDURE_NAME
 * NUM_INPUT_PARAMS
 * NUM_OUTPUT_PARAMS
 * NUM_RESULT_SETS
 * REMARKS
 * PROCEDURE_TYPE
 */
function odbc_procedures ($connection_id) {}

/**
 * プロシージャへのパラメータに関する情報を取得する
 * @link http://www.php.net/manual/ja/function.odbc-procedurecolumns.php
 * @param connection_id resource ODBC 接続 ID。詳細は
 * odbc_connect を参照ください。</p>
 * @return resource 指定したプロシージャに関して入出力パラメータのリストとその結果を構成するカラムを返します。
 * ODBC 結果 ID を返します。失敗した場合に FALSE を返します。
 * </p>
 * <p>
 * 結果セットのカラムは次のようになります。
 * PROCEDURE_QUALIFIER
 * PROCEDURE_OWNER
 * PROCEDURE_NAME
 * COLUMN_NAME
 * COLUMN_TYPE
 * DATA_TYPE
 * TYPE_NAME
 * PRECISION
 * LENGTH
 * SCALE
 * RADIX
 * NULLABLE
 * REMARKS
 */
function odbc_procedurecolumns ($connection_id) {}

/**
 * <function>odbc_exec</function> のエイリアス
 * @link http://www.php.net/manual/ja/function.odbc-do.php
 * @param connection_id
 * @param query
 * @param flags[optional]
 */
function odbc_do ($connection_id, $query, $flags) {}

/**
 * <function>odbc_field_len</function> のエイリアス
 * @link http://www.php.net/manual/ja/function.odbc-field-precision.php
 * @param result_id
 * @param field_number
 */
function odbc_field_precision ($result_id, $field_number) {}

define ('ODBC_TYPE', "Win32");
define ('ODBC_BINMODE_PASSTHRU', 0);
define ('ODBC_BINMODE_RETURN', 1);
define ('ODBC_BINMODE_CONVERT', 2);
define ('SQL_ODBC_CURSORS', 110);
define ('SQL_CUR_USE_DRIVER', 2);
define ('SQL_CUR_USE_IF_NEEDED', 0);
define ('SQL_CUR_USE_ODBC', 1);
define ('SQL_CONCURRENCY', 7);
define ('SQL_CONCUR_READ_ONLY', 1);
define ('SQL_CONCUR_LOCK', 2);
define ('SQL_CONCUR_ROWVER', 3);
define ('SQL_CONCUR_VALUES', 4);
define ('SQL_CURSOR_TYPE', 6);
define ('SQL_CURSOR_FORWARD_ONLY', 0);
define ('SQL_CURSOR_KEYSET_DRIVEN', 1);
define ('SQL_CURSOR_DYNAMIC', 2);
define ('SQL_CURSOR_STATIC', 3);
define ('SQL_KEYSET_SIZE', 8);
define ('SQL_FETCH_FIRST', 2);
define ('SQL_FETCH_NEXT', 1);
define ('SQL_CHAR', 1);
define ('SQL_VARCHAR', 12);
define ('SQL_LONGVARCHAR', -1);
define ('SQL_DECIMAL', 3);
define ('SQL_NUMERIC', 2);
define ('SQL_BIT', -7);
define ('SQL_TINYINT', -6);
define ('SQL_SMALLINT', 5);
define ('SQL_INTEGER', 4);
define ('SQL_BIGINT', -5);
define ('SQL_REAL', 7);
define ('SQL_FLOAT', 6);
define ('SQL_DOUBLE', 8);
define ('SQL_BINARY', -2);
define ('SQL_VARBINARY', -3);
define ('SQL_LONGVARBINARY', -4);
define ('SQL_DATE', 9);
define ('SQL_TIME', 10);
define ('SQL_TIMESTAMP', 11);

// End of odbc v.1.0
?>
