<?php

// Start of SQLite v.2.0-dev

/**
 * @link http://www.php.net/manual/ja/class.sqlitedatabase.php
 */
class SQLiteDatabase  {

	/**
	 * @param filename
	 * @param mode[optional]
	 * @param error_message[optional]
	 */
	final public function __construct ($filename, $mode, &$error_message) {}

	/**
	 * @param query
	 * @param result_type[optional]
	 * @param error_message[optional]
	 */
	public function query ($query, $result_type, &$error_message) {}

	/**
	 * @param query
	 * @param error_message[optional]
	 */
	public function queryExec ($query, &$error_message) {}

	/**
	 * @param query
	 * @param result_type[optional]
	 * @param decode_binary[optional]
	 */
	public function arrayQuery ($query, $result_type, $decode_binary) {}

	/**
	 * @param query
	 * @param first_row_only[optional]
	 * @param decode_binary[optional]
	 */
	public function singleQuery ($query, $first_row_only, $decode_binary) {}

	/**
	 * @param query
	 * @param result_type[optional]
	 * @param error_message[optional]
	 */
	public function unbufferedQuery ($query, $result_type, &$error_message) {}

	public function lastInsertRowid () {}

	public function changes () {}

	/**
	 * @param funcname
	 * @param step_func
	 * @param finalize_func
	 * @param num_args[optional]
	 */
	public function createAggregate ($funcname, $step_func, $finalize_func, $num_args) {}

	/**
	 * @param funcname
	 * @param callback
	 * @param num_args[optional]
	 */
	public function createFunction ($funcname, $callback, $num_args) {}

	/**
	 * @param ms
	 */
	public function busyTimeout ($ms) {}

	public function lastError () {}

	/**
	 * @param table_name
	 * @param result_type[optional]
	 */
	public function fetchColumnTypes ($table_name, $result_type) {}

}

/**
 * @link http://www.php.net/manual/ja/class.sqliteresult.php
 */
final class SQLiteResult implements Iterator, Traversable, Countable {

	/**
	 * @param result_type[optional]
	 * @param decode_binary[optional]
	 */
	public function fetch ($result_type, $decode_binary) {}

	/**
	 * @param class_name[optional]
	 * @param ctor_params[optional]
	 * @param decode_binary[optional]
	 */
	public function fetchObject ($class_name, $ctor_params, $decode_binary) {}

	/**
	 * @param decode_binary[optional]
	 */
	public function fetchSingle ($decode_binary) {}

	/**
	 * @param result_type[optional]
	 * @param decode_binary[optional]
	 */
	public function fetchAll ($result_type, $decode_binary) {}

	/**
	 * @param index_or_name
	 * @param decode_binary[optional]
	 */
	public function column ($index_or_name, $decode_binary) {}

	public function numFields () {}

	/**
	 * @param field_index
	 */
	public function fieldName ($field_index) {}

	/**
	 * @param result_type[optional]
	 * @param decode_binary[optional]
	 */
	public function current ($result_type, $decode_binary) {}

	public function key () {}

	public function next () {}

	public function valid () {}

	public function rewind () {}

	public function count () {}

	public function prev () {}

	public function hasPrev () {}

	public function numRows () {}

	/**
	 * @param row
	 */
	public function seek ($row) {}

}

/**
 * @link http://www.php.net/manual/ja/class.sqliteunbuffered.php
 */
final class SQLiteUnbuffered  {

	/**
	 * @param result_type[optional]
	 * @param decode_binary[optional]
	 */
	public function fetch ($result_type, $decode_binary) {}

	/**
	 * @param class_name[optional]
	 * @param ctor_params[optional]
	 * @param decode_binary[optional]
	 */
	public function fetchObject ($class_name, $ctor_params, $decode_binary) {}

	/**
	 * @param decode_binary[optional]
	 */
	public function fetchSingle ($decode_binary) {}

	/**
	 * @param result_type[optional]
	 * @param decode_binary[optional]
	 */
	public function fetchAll ($result_type, $decode_binary) {}

	/**
	 * @param index_or_name
	 * @param decode_binary[optional]
	 */
	public function column ($index_or_name, $decode_binary) {}

	public function numFields () {}

	/**
	 * @param field_index
	 */
	public function fieldName ($field_index) {}

	/**
	 * @param result_type[optional]
	 * @param decode_binary[optional]
	 */
	public function current ($result_type, $decode_binary) {}

	public function next () {}

	public function valid () {}

}

final class SQLiteException extends RuntimeException  {
	protected $message;
	protected $code;
	protected $file;
	protected $line;


	final private function __clone () {}

	/**
	 * @param message[optional]
	 * @param code[optional]
	 * @param previous[optional]
	 */
	public function __construct ($message, $code, $previous) {}

	final public function getMessage () {}

	final public function getCode () {}

	final public function getFile () {}

	final public function getLine () {}

	final public function getTrace () {}

	final public function getPrevious () {}

	final public function getTraceAsString () {}

	public function __toString () {}

}

/**
 * SQLiteデータベースをオープンする。データベースが存在しない場合は作
   成する
 * @link http://www.php.net/manual/ja/function.sqlite-open.php
 * @param filename string <p>
 * SQLite データベースのファイル名。もしこのファイルが存在しない場合、
 * SQLite はファイルを生成しようとします。
 * データを挿入したり、データベーススキーマを変更、
 * もしくはデータベースが存在しない場合にデータベースを生成する場合、
 * PHP はファイルに対する書き込み権限を持っている必要があります。
 * </p>
 * @param mode int[optional] <p>
 * ファイルのモード。読み込み専用モードでデータベースをオープンするために
 * 使用することを目的としています。現在、このパラメータは SQLite
 * ライブラリに無視されます。このモードのデフォルト値は、
 * 8 進数値 0666 で、これは推奨される値です。
 * </p>
 * @param error_message string[optional] <p>
 * 参照として渡され、エラーが発生した場合に
 * データベースがオープンできなかった原因を説明する
 * 記述的なエラーメッセージを保持するために設定されます。
 * </p>
 * @return resource 成功時にリソース (データベースハンドル)、失敗時に FALSE を返します。
 */
function sqlite_open ($filename, $mode = null, &$error_message = null) {}

/**
 * SQLiteデータベースへの持続的ハンドルをオープンする。存在しない場合
   には、データベースを作成する
 * @link http://www.php.net/manual/ja/function.sqlite-popen.php
 * @param filename string <p>
 * SQLite データベースのファイル名。もしこのファイルが存在しない場合、
 * SQLite はファイルを生成しようとします。
 * データを挿入したり、データベーススキーマを変更、
 * もしくはデータベースが存在しない場合にデータベースを生成する場合、
 * PHP はファイルに対する書き込み権限を持っている必要があります。
 * </p>
 * @param mode int[optional] <p>
 * ファイルのモード。読み込み専用モードでデータベースをオープンするために
 * 使用することを目的としています。現在、このパラメータは SQLite
 * ライブラリに無視されます。このモードのデフォルト値は、
 * 8 進数値 0666 で、これは推奨される値です。
 * </p>
 * @param error_message string[optional] <p>
 * 参照として渡され、エラーが発生した場合に
 * データベースがオープンできなかった原因を説明する
 * 記述的なエラーメッセージを保持するために設定されます。
 * </p>
 * @return resource 成功時にリソース (データベースハンドル)、失敗時に FALSE を返します。
 */
function sqlite_popen ($filename, $mode = null, &$error_message = null) {}

/**
 * オープンされたSQLiteデータベースを閉じる
 * @link http://www.php.net/manual/ja/function.sqlite-close.php
 * @param dbhandle resource <p>
 * SQLite データベースリソース。手続きに従って、
 * sqlite_open から返されます。
 * </p>
 * @return void 値を返しません。
 */
function sqlite_close ($dbhandle) {}

/**
 * 指定したデータベースに対してクエリを実行し、結果ハンドル
  を返す
 * @link http://www.php.net/manual/ja/function.sqlite-query.php
 * @param dbhandle resource <p>
 * SQLite データベースリソース。手続きに従って、
 * sqlite_open から返されます。
 * このパラメータは、
 * オブジェクト指向言語型メソッドを使用する場合は不要です。
 * </p>
 * @param query string <p>
 * 実行するクエリ
 * </p>
 * <p>
 * クエリ内のデータは 適切にエスケープ
 * する必要があります。
 * </p>
 * @param result_type int[optional] オプションの result_type
 * パラメータには定数を指定でき、返される配列の添字を定義します。
 * SQLITE_ASSOC を用いると、連想配列の添字(名前フィールド)のみが
 * 返されます。一方、SQLITE_NUM は、
 * 数値の添字(フィールド番号)のみを返します。SQLITE_BOTH は、
 * 連想配列の添字と数値の添字の両方を返します。
 * SQLITE_BOTH がこの関数のデフォルトです。</p>
 * @param error_msg string[optional] <p>
 * もしエラーが発生した場合、ここに保存されます。SQL 構文のエラーは
 * sqlite_last_error 関数で取得することが
 * できないため、このパラメータが特に重要となります。
 * </p>
 * @return resource この関数は結果ハンドルを返します。失敗した場合に FALSE を返します。
 * レコードを返すクエリの場合、結果ハンドルは
 * sqlite_fetch_array や
 * sqlite_seek のような関数で使用することができます。
 * </p>
 * <p>
 * クエリの型によらず、この関数はクエリが失敗した場合にFALSE を返し
 * ます。
 * </p>
 * <p>
 * sqlite_query は、バッファリングされ、シーク可
 * 能な結果ハンドルを返します。これは、レコードにランダムにアクセスす
 * る必要がある小さなクエリの場合に有用です。バッファリングされた結果
 * ハンドルは、結果全体を保持するためのメモリを確保し、結果が取得され
 * るまでは値を返しません。
 * データに連続的にアクセスしたい場合、かわりにより高性能な
 * sqlite_unbuffered_query を使用することが
 * 推奨されます。
 */
function sqlite_query ($dbhandle, $query, $result_type = null, &$error_msg = null) {}

/**
 * 与えられたデータベースに対して結果を伴わないクエリを実行する
 * @link http://www.php.net/manual/ja/function.sqlite-exec.php
 * @param dbhandle resource <p>
 * SQLite データベースリソース。手続きに従って、
 * sqlite_open から返されます。
 * このパラメータは、
 * オブジェクト指向言語型メソッドを使用する場合は不要です。
 * </p>
 * @param query string <p>
 * 実行するクエリを指定します。
 * </p>
 * <p>
 * クエリ内のデータは 適切にエスケープ
 * する必要があります。
 * </p>
 * @param error_msg string[optional] <p>
 * エラーが発生した場合、指定された変数に詰め込まれます。
 * SQL 文法エラーは sqlite_last_error
 * 関数では取得できないので、これは特に重要です。
 * </p>
 * @return bool この関数はブール型の結果を返します。
 * 成功時は TRUE、失敗時は FALSE を返します。
 * もしレコードを返すクエリを実行する必要がある場合は
 * sqlite_query を参照ください。
 * </p>
 * SQLITE_ASSOC および SQLITE_BOTH で
 * 返されるカラム名は、設定オプション
 * sqlite.assoc_case の値に基づき、
 * 大文字小文字が変換されます。
 */
function sqlite_exec ($dbhandle, $query, &$error_msg = null) {}

/**
 * 指定したデータベースに対してクエリを実行し、配列を返す
 * @link http://www.php.net/manual/ja/function.sqlite-array-query.php
 * @param dbhandle resource <p>
 * SQLite データベースリソース。手続きに従って、
 * sqlite_open から返されます。
 * このパラメータは、
 * オブジェクト指向言語型メソッドを使用する場合は不要です。
 * </p>
 * @param query string <p>
 * 実行するクエリ
 * </p>
 * <p>
 * クエリ内のデータは 適切にエスケープ
 * する必要があります。
 * </p>
 * @param result_type int[optional] オプションの result_type
 * パラメータには定数を指定でき、返される配列の添字を定義します。
 * SQLITE_ASSOC を用いると、連想配列の添字(名前フィールド)のみが
 * 返されます。一方、SQLITE_NUM は、
 * 数値の添字(フィールド番号)のみを返します。SQLITE_BOTH は、
 * 連想配列の添字と数値の添字の両方を返します。
 * SQLITE_BOTH がこの関数のデフォルトです。</p>
 * @param decode_binary bool[optional] decode_binary パラメータが TRUE (デフォルト)に
 * 設定された場合、PHP はバイナリエンコーディングをデコードします。
 * これは、sqlite_escape_string によりエンコードされたデータに
 * 適用されます。sqlite をサポートする他のアプリケーションにより
 * 作成されたデータベースを処理する時以外は、この値をデフォルトのままにしておくべきです。</p>
 * @return array 結果セット全体の配列、その他の場合は FALSE を返します。
 * </p>
 * SQLITE_ASSOC および SQLITE_BOTH で
 * 返されるカラム名は、設定オプション
 * sqlite.assoc_case の値に基づき、
 * 大文字小文字が変換されます。
 */
function sqlite_array_query ($dbhandle, $query, $result_type = null, $decode_binary = null) {}

/**
 * クエリを実行し、単一カラムもしくは先頭レコードの値に対する配列を返す
 * @link http://www.php.net/manual/ja/function.sqlite-single-query.php
 * @param db resource 
 * @param query string 
 * @param first_row_only bool[optional] 
 * @param decode_binary bool[optional] 
 * @return array 
 */
function sqlite_single_query ($db, $query, $first_row_only = null, $decode_binary = null) {}

/**
 * 結果セットから次のレコードを配列として取得する
 * @link http://www.php.net/manual/ja/function.sqlite-fetch-array.php
 * @param result resource <p>
 * SQLite 結果リソース。
 * このパラメータは、
 * オブジェクト指向言語型メソッドを使用する場合は不要です。
 * </p>
 * @param result_type int[optional] オプションの result_type
 * パラメータには定数を指定でき、返される配列の添字を定義します。
 * SQLITE_ASSOC を用いると、連想配列の添字(名前フィールド)のみが
 * 返されます。一方、SQLITE_NUM は、
 * 数値の添字(フィールド番号)のみを返します。SQLITE_BOTH は、
 * 連想配列の添字と数値の添字の両方を返します。
 * SQLITE_BOTH がこの関数のデフォルトです。</p>
 * @param decode_binary bool[optional] decode_binary パラメータが TRUE (デフォルト)に
 * 設定された場合、PHP はバイナリエンコーディングをデコードします。
 * これは、sqlite_escape_string によりエンコードされたデータに
 * 適用されます。sqlite をサポートする他のアプリケーションにより
 * 作成されたデータベースを処理する時以外は、この値をデフォルトのままにしておくべきです。</p>
 * @return array 結果セットの次レコードの配列を返します。
 * 次レコードの位置が最終レコード以降の場合、FALSE を返します。
 * </p>
 * SQLITE_ASSOC および SQLITE_BOTH で
 * 返されるカラム名は、設定オプション
 * sqlite.assoc_case の値に基づき、
 * 大文字小文字が変換されます。
 */
function sqlite_fetch_array ($result, $result_type = null, $decode_binary = null) {}

/**
 * 結果セットから次のレコードをオブジェクトとして取得する
 * @link http://www.php.net/manual/ja/function.sqlite-fetch-object.php
 * @param result resource 
 * @param class_name string[optional] 
 * @param ctor_params array[optional] 
 * @param decode_binary bool[optional] 
 * @return object 
 */
function sqlite_fetch_object ($result, $class_name = null, array $ctor_params = null, $decode_binary = null) {}

/**
 * 結果セットの最初のカラムを文字列として取得する
 * @link http://www.php.net/manual/ja/function.sqlite-fetch-single.php
 * @param result resource <p>
 * SQLite 結果リソース。
 * このパラメータは、
 * オブジェクト指向言語型メソッドを使用する場合は不要です。
 * </p>
 * @param decode_binary bool[optional] decode_binary パラメータが TRUE (デフォルト)に
 * 設定された場合、PHP はバイナリエンコーディングをデコードします。
 * これは、sqlite_escape_string によりエンコードされたデータに
 * 適用されます。sqlite をサポートする他のアプリケーションにより
 * 作成されたデータベースを処理する時以外は、この値をデフォルトのままにしておくべきです。</p>
 * @return string 最初のカラムの値を文字列で返します。
 */
function sqlite_fetch_single ($result, $decode_binary = null) {}

/**
 * <function>sqlite_fetch_single</function> のエイリアス
 * @link http://www.php.net/manual/ja/function.sqlite-fetch-string.php
 * @param result
 * @param decode_binary[optional]
 */
function sqlite_fetch_string ($result, $decode_binary) {}

/**
 * 結果セットから全てのレコードを配列の配列として取得する
 * @link http://www.php.net/manual/ja/function.sqlite-fetch-all.php
 * @param result resource <p>
 * SQLite 結果リソース。
 * このパラメータは、
 * オブジェクト指向言語型メソッドを使用する場合は不要です。
 * </p>
 * @param result_type int[optional] オプションの result_type
 * パラメータには定数を指定でき、返される配列の添字を定義します。
 * SQLITE_ASSOC を用いると、連想配列の添字(名前フィールド)のみが
 * 返されます。一方、SQLITE_NUM は、
 * 数値の添字(フィールド番号)のみを返します。SQLITE_BOTH は、
 * 連想配列の添字と数値の添字の両方を返します。
 * SQLITE_BOTH がこの関数のデフォルトです。</p>
 * @param decode_binary bool[optional] decode_binary パラメータが TRUE (デフォルト)に
 * 設定された場合、PHP はバイナリエンコーディングをデコードします。
 * これは、sqlite_escape_string によりエンコードされたデータに
 * 適用されます。sqlite をサポートする他のアプリケーションにより
 * 作成されたデータベースを処理する時以外は、この値をデフォルトのままにしておくべきです。</p>
 * @return array 結果セットからのカレントレコードの配列を返します。
 * sqlite_query の直後にコールされた場合、
 * 全ての行を返します。sqlite_fetch_array
 * の後にコールされた場合、残りの行を返します。
 * 結果セットに行が残っていない場合、空の配列を返します。
 * </p>
 * SQLITE_ASSOC および SQLITE_BOTH で
 * 返されるカラム名は、設定オプション
 * sqlite.assoc_case の値に基づき、
 * 大文字小文字が変換されます。
 */
function sqlite_fetch_all ($result, $result_type = null, $decode_binary = null) {}

/**
 * 結果セットからカレントのレコードを配列として取得する
 * @link http://www.php.net/manual/ja/function.sqlite-current.php
 * @param result resource <p>
 * SQLite 結果リソース。
 * このパラメータは、
 * オブジェクト指向言語型メソッドを使用する場合は不要です。
 * </p>
 * @param result_type int[optional] オプションの result_type
 * パラメータには定数を指定でき、返される配列の添字を定義します。
 * SQLITE_ASSOC を用いると、連想配列の添字(名前フィールド)のみが
 * 返されます。一方、SQLITE_NUM は、
 * 数値の添字(フィールド番号)のみを返します。SQLITE_BOTH は、
 * 連想配列の添字と数値の添字の両方を返します。
 * SQLITE_BOTH がこの関数のデフォルトです。</p>
 * @param decode_binary bool[optional] decode_binary パラメータが TRUE (デフォルト)に
 * 設定された場合、PHP はバイナリエンコーディングをデコードします。
 * これは、sqlite_escape_string によりエンコードされたデータに
 * 適用されます。sqlite をサポートする他のアプリケーションにより
 * 作成されたデータベースを処理する時以外は、この値をデフォルトのままにしておくべきです。</p>
 * @return array 結果セットからカレントレコードの配列を返します。
 * 現在の位置が最終レコード以降の場合、
 * FALSE を返します。
 * </p>
 * SQLITE_ASSOC および SQLITE_BOTH で
 * 返されるカラム名は、設定オプション
 * sqlite.assoc_case の値に基づき、
 * 大文字小文字が変換されます。
 */
function sqlite_current ($result, $result_type = null, $decode_binary = null) {}

/**
 * カレントの結果セットのレコードからカラムを1列取得する
 * @link http://www.php.net/manual/ja/function.sqlite-column.php
 * @param result resource <p>
 * SQLite 結果リソース。
 * このパラメータは、
 * オブジェクト指向言語型メソッドを使用する場合は不要です。
 * </p>
 * @param index_or_name mixed <p>
 * 取得するカラムインデックス、もしくは名前
 * </p>
 * @param decode_binary bool[optional] decode_binary パラメータが TRUE (デフォルト)に
 * 設定された場合、PHP はバイナリエンコーディングをデコードします。
 * これは、sqlite_escape_string によりエンコードされたデータに
 * 適用されます。sqlite をサポートする他のアプリケーションにより
 * 作成されたデータベースを処理する時以外は、この値をデフォルトのままにしておくべきです。</p>
 * @return mixed カラムの値を返します。
 */
function sqlite_column ($result, $index_or_name, $decode_binary = null) {}

/**
 * リンクされているSQLiteライブラリのバージョンを返す
 * @link http://www.php.net/manual/ja/function.sqlite-libversion.php
 * @return string ライブラリのバージョンを文字列で返します。
 */
function sqlite_libversion () {}

/**
 * リンクされているSQLiteライブラリのエンコーディングを返す
 * @link http://www.php.net/manual/ja/function.sqlite-libencoding.php
 * @return string ライブラリのエンコーディングを返します。
 */
function sqlite_libencoding () {}

/**
 * 直近のSQLステートメントにより変更されたレコード数を返す
 * @link http://www.php.net/manual/ja/function.sqlite-changes.php
 * @param dbhandle resource <p>
 * SQLite データベースリソース。手続きに従って、
 * sqlite_open から返されます。
 * このパラメータは、
 * オブジェクト指向言語型メソッドを使用する場合は不要です。
 * </p>
 * @return int 変更された行数を返します。
 */
function sqlite_changes ($dbhandle) {}

/**
 * 直近に挿入されたレコードのrowidを返す
 * @link http://www.php.net/manual/ja/function.sqlite-last-insert-rowid.php
 * @param dbhandle resource <p>
 * SQLite データベースリソース。手続きに従って、
 * sqlite_open から返されます。
 * このパラメータは、
 * オブジェクト指向言語型メソッドを使用する場合は不要です。
 * </p>
 * @return int 行 ID を整数値で返します。
 */
function sqlite_last_insert_rowid ($dbhandle) {}

/**
 * 結果セットのレコード数を返す
 * @link http://www.php.net/manual/ja/function.sqlite-num-rows.php
 * @param result resource <p>
 * SQLite 結果リソース。
 * このパラメータは、
 * オブジェクト指向言語型メソッドを使用する場合は不要です。
 * </p>
 * <p>この関数は、
 * バッファなしの結果ハンドルで使用することはできません。</p>
 * @return int 行数を整数値で返します。
 */
function sqlite_num_rows ($result) {}

/**
 * 結果セットのフィールド数を返す
 * @link http://www.php.net/manual/ja/function.sqlite-num-fields.php
 * @param result resource <p>
 * SQLite 結果リソース。
 * このパラメータは、
 * オブジェクト指向言語型メソッドを使用する場合は不要です。
 * </p>
 * @return int フィールド数を整数値で返します。
 */
function sqlite_num_fields ($result) {}

/**
 * 特定のフィールドの名前を返す
 * @link http://www.php.net/manual/ja/function.sqlite-field-name.php
 * @param result resource <p>
 * SQLite 結果リソース。
 * このパラメータは、
 * オブジェクト指向言語型メソッドを使用する場合は不要です。
 * </p>
 * @param field_index int <p>
 * 結果セットにおけるオリジナルのカラム番号
 * </p>
 * @return string 与えられたオリジナルのカラム番号での SQLite
 * 結果セット中のフィールド名を返します。エラーの場合は、FALSE を返します。
 * </p>
 * SQLITE_ASSOC および SQLITE_BOTH で
 * 返されるカラム名は、設定オプション
 * sqlite.assoc_case の値に基づき、
 * 大文字小文字が変換されます。
 */
function sqlite_field_name ($result, $field_index) {}

/**
 * 特定のレコード番号へシークする
 * @link http://www.php.net/manual/ja/function.sqlite-seek.php
 * @param result resource <p>
 * SQLite 結果リソース。
 * このパラメータは、
 * オブジェクト指向言語型メソッドを使用する場合は不要です。
 * </p>
 * <p>この関数は、
 * バッファなしの結果ハンドルで使用することはできません。</p>
 * @param rownum int <p>
 * シークするオリジナルのレコード番号。
 * レコード番号は 0 から始まります (0 が先頭レコード) 。
 * </p>
 * <p>この関数は、
 * バッファなしの結果ハンドルで使用することはできません。</p>
 * @return bool レコードが存在しない場合は FALSE、それ以外の場合に TRUE を返します。
 */
function sqlite_seek ($result, $rownum) {}

/**
 * 先頭レコード番号へシークする
 * @link http://www.php.net/manual/ja/function.sqlite-rewind.php
 * @param result resource <p>
 * SQLite 結果リソース。
 * このパラメータは、
 * オブジェクト指向言語型メソッドを使用する場合は不要です。
 * </p>
 * <p>この関数は、
 * バッファなしの結果ハンドルで使用することはできません。</p>
 * @return bool 結果セットにレコードがもうない場合は、FALSE、
 * そうでない場合は TRUE を返します。
 */
function sqlite_rewind ($result) {}

/**
 * 次のレコード番号へシークする
 * @link http://www.php.net/manual/ja/function.sqlite-next.php
 * @param result resource <p>
 * SQLite 結果リソース。
 * このパラメータは、
 * オブジェクト指向言語型メソッドを使用する場合は不要です。
 * </p>
 * @return bool 成功時は TRUE、もしレコードがない場合は FALSE を返します。
 */
function sqlite_next ($result) {}

/**
 * 結果セットの前のレコード番号へシークする
 * @link http://www.php.net/manual/ja/function.sqlite-prev.php
 * @param result resource <p>
 * SQLite 結果リソース。
 * このパラメータは、
 * オブジェクト指向言語型メソッドを使用する場合は不要です。
 * </p>
 * <p>この関数は、
 * バッファなしの結果ハンドルで使用することはできません。</p>
 * @return bool 成功時は TRUE、もしレコードがない場合は FALSE を返します。
 */
function sqlite_prev ($result) {}

/**
 * まだレコードが残っているかどうかを返す
 * @link http://www.php.net/manual/ja/function.sqlite-valid.php
 * @param result resource <p>
 * SQLite 結果リソース。
 * このパラメータは、
 * オブジェクト指向言語型メソッドを使用する場合は不要です。
 * </p>
 * <p>この関数は、
 * バッファなしの結果ハンドルで使用することはできません。</p>
 * @return bool 結果ハンドル result にレコードが残っている場合
 * TRUE、そうでない場合は FALSE を返します。
 */
function sqlite_valid ($result) {}

/**
 * まだレコードがあるかないかを返す
 * @link http://www.php.net/manual/ja/function.sqlite-has-more.php
 * @param result resource <p>
 * SQLite 結果リソース
 * </p>
 * @return bool result ハンドルにまだレコードがある場合 TRUE
 * を返します。そうでない場合 FALSE を返します。
 */
function sqlite_has_more ($result) {}

/**
 * 前のレコードがあるかどうかを返す
 * @link http://www.php.net/manual/ja/function.sqlite-has-prev.php
 * @param result resource <p>
 * SQLite 結果リソース。
 * このパラメータは、
 * オブジェクト指向言語型メソッドを使用する場合は不要です。
 * </p>
 * <p>この関数は、
 * バッファなしの結果ハンドルで使用することはできません。</p>
 * @return bool 結果ハンドル result に前のレコードがある場合 TRUE、
 * そうでない場合 FALSE を返します。
 */
function sqlite_has_prev ($result) {}

/**
 * クエリパラメータ用に文字列をエスケープする
 * @link http://www.php.net/manual/ja/function.sqlite-escape-string.php
 * @param item string <p>
 * クォートしたい文字列。
 * </p>
 * <p>
 * itemがNUL文字を含む場合、
 * または、16進表現の0x01で始まる場合、
 * PHPはバイナリデータを安全に保存/取得するためのバイナリエンコーディ
 * ングを適用します。
 * </p>
 * @return string SQLite の SQL 文で使用できる形式にエスケープした文字列を返します。
 */
function sqlite_escape_string ($item) {}

/**
 * ビジータイムアウト時間を設定またはビジーハンドラを無効にする
 * @link http://www.php.net/manual/ja/function.sqlite-busy-timeout.php
 * @param dbhandle resource <p>
 * SQLite データベースリソース。手続きに従って、
 * sqlite_open から返されます。
 * このパラメータは、
 * オブジェクト指向言語型メソッドを使用する場合は不要です。
 * </p>
 * @param milliseconds int <p>
 * ミリ秒での数。
 * milliseconds が 0の場合、
 * ビジーハンドラは無効となり、他のプロセス/スレッドが更新用にデータベー
 * スをロックしている際に、sqliteはSQLITE_BUSYを
 * 直ちに返します。
 * </p>
 * <p>
 * PHPはデフォルトでデータベースがオープンされる際のビジータイムアウト
 * を 60 秒に設定しています。
 * </p>
 * <p>
 * 1 秒は 1000 ミリ秒です。
 * </p>
 * @return void 値を返しません。
 */
function sqlite_busy_timeout ($dbhandle, $milliseconds) {}

/**
 * データベースに関する直近のエラーコードを返す
 * @link http://www.php.net/manual/ja/function.sqlite-last-error.php
 * @param dbhandle resource <p>
 * SQLite データベースリソース。手続きに従って、
 * sqlite_open から返されます。
 * このパラメータは、
 * オブジェクト指向言語型メソッドを使用する場合は不要です。
 * </p>
 * @return int エラーコード、あるいはエラーが発生していない場合に 0 を返します。
 */
function sqlite_last_error ($dbhandle) {}

/**
 * エラーコードの説明を返す
 * @link http://www.php.net/manual/ja/function.sqlite-error-string.php
 * @param error_code int <p>
 * 使用するエラーコード。これは
 * sqlite_last_error
 * から返されたものです。
 * </p>
 * @return string error_code に対応する可読形式の説明を文字列で返します。
 */
function sqlite_error_string ($error_code) {}

/**
 * 事前取得していないクエリを実行し、全てのデータをバッファリングする
 * @link http://www.php.net/manual/ja/function.sqlite-unbuffered-query.php
 * @param dbhandle resource <p>
 * SQLite データベースリソース。手続きに従って、
 * sqlite_open から返されます。
 * このパラメータは、
 * オブジェクト指向言語型メソッドを使用する場合は不要です。
 * </p>
 * @param query string <p>
 * 実行するクエリ
 * </p>
 * <p>
 * クエリ内のデータは 適切にエスケープ
 * する必要があります。
 * </p>
 * @param result_type int[optional] オプションの result_type
 * パラメータには定数を指定でき、返される配列の添字を定義します。
 * SQLITE_ASSOC を用いると、連想配列の添字(名前フィールド)のみが
 * 返されます。一方、SQLITE_NUM は、
 * 数値の添字(フィールド番号)のみを返します。SQLITE_BOTH は、
 * 連想配列の添字と数値の添字の両方を返します。
 * SQLITE_BOTH がこの関数のデフォルトです。</p>
 * @param error_msg string[optional] <p>
 * もしエラーが発生した場合、ここに保存されます。SQL 構文のエラーは
 * sqlite_last_error 関数で取得することが
 * できないため、このパラメータが特に重要となります。
 * </p>
 * @return resource 結果セットを返します。失敗した場合に FALSE を返します。
 * </p>
 * <p>
 * sqlite_unbuffered_query は、
 * 各レコードを順番に読み込む場合にのみ利用可能な
 * シーケンシャルで前進のみ可能な結果セットを返します。
 */
function sqlite_unbuffered_query ($dbhandle, $query, $result_type = null, &$error_msg = null) {}

/**
 * SQLステートメントで使用する集約UDFを登録する
 * @link http://www.php.net/manual/ja/function.sqlite-create-aggregate.php
 * @param dbhandle resource <p>
 * SQLite データベースリソース。手続きに従って、
 * sqlite_open から返されます。
 * このパラメータは、
 * オブジェクト指向言語型メソッドを使用する場合は不要です。
 * </p>
 * @param function_name string <p>
 * SQL ステートメントで使用される関数名
 * </p>
 * @param step_func callable <p>
 * 結果セットの各レコードに対してコールされるコールバック関数。
 * この関数のパラメータは &amp;$context, $value, ... です。
 * </p>
 * @param finalize_func callable <p>
 * 各レコードからの "段階的な" データを集約するためのコールバック関数。
 * この関数のパラメータは &amp;$context で、
 * 集約の最終的な結果を返さなければなりません。
 * </p>
 * @param num_args int[optional] <p>
 * 見積もられた引数の数をコールバック関数が受け入れる場合に
 * SQLite パーサへ渡すヒント
 * </p>
 * @return void 値を返しません。
 */
function sqlite_create_aggregate ($dbhandle, $function_name, $step_func, $finalize_func, $num_args = null) {}

/**
 * SQLステートメントで使用するために"通常の"ユーザー定義関数を登録する
 * @link http://www.php.net/manual/ja/function.sqlite-create-function.php
 * @param dbhandle resource <p>
 * SQLite データベースリソース。手続きに従って、
 * sqlite_open から返されます。
 * このパラメータは、
 * オブジェクト指向言語型メソッドを使用する場合は不要です。
 * </p>
 * @param function_name string <p>
 * SQL ステートメントで使用する関数名
 * </p>
 * @param callback callable <p>
 * 定義された SQL 関数を処理するためのコールバック関数
 * </p>
 * コールバック関数は SQLite で有効な型
 * (例えば スカラー型)
 * を返す必要があります
 * @param num_args int[optional] <p>
 * コールバック関数が規定の引数の数を受け入れるかどうかを決定するため
 * SQLite パーサに渡すヒント
 * </p>
 * @return void 値を返しません。
 */
function sqlite_create_function ($dbhandle, $function_name, $callback, $num_args = null) {}

/**
 * SQLite データベースをオープンし、SQLiteDatabse オブジェクトを返す
 * @link http://www.php.net/manual/ja/function.sqlite-factory.php
 * @param filename string <p>
 * SQLite データベースのファイル名
 * </p>
 * @param mode int[optional] <p>
 * ファイルのモード。読み込み専用モードでデータベースをオープンするために
 * 使用することを目的としています。現在、このパラメータは SQLite
 * ライブラリに無視されます。このモードのデフォルト値は、
 * 8 進数値 0666 で、これは推奨される値です。
 * </p>
 * @param error_message string[optional] <p>
 * 参照として渡され、エラーが発生した場合に
 * データベースがオープンできなかった原因を説明する
 * 記述的なエラーメッセージを保持するために設定されます。
 * </p>
 * @return SQLiteDatabase 成功時に SQLiteDatabase オブジェクト、失敗時に NULL を返します。
 */
function sqlite_factory ($filename, $mode = null, &$error_message = null) {}

/**
 * UDFから返す前にバイナリデータをエンコードする
 * @link http://www.php.net/manual/ja/function.sqlite-udf-encode-binary.php
 * @param data string <p>
 * エンコードしたい文字列。
 * </p>
 * @return string エンコードされた文字列を返します。
 */
function sqlite_udf_encode_binary ($data) {}

/**
 * <acronym>UDF</acronym>にパラメータとして渡されたバイナリデータをデコードする
 * @link http://www.php.net/manual/ja/function.sqlite-udf-decode-binary.php
 * @param data string <p>
 * デコード対象となる、エンコードされたデータ。これは
 * sqlite_udf_encode_binary あるいは
 * sqlite_escape_string で作成したものです。
 * </p>
 * @return string デコードされた文字列を返します。
 */
function sqlite_udf_decode_binary ($data) {}

/**
 * 特定のテーブルからカラム型の配列を返す
 * @link http://www.php.net/manual/ja/function.sqlite-fetch-column-types.php
 * @param table_name string <p>
 * 問い合わせるテーブル名
 * </p>
 * @param dbhandle resource <p>
 * SQLite データベースリソース。手続きに従って、
 * sqlite_open から返されます。
 * このパラメータは、
 * オブジェクト指向言語型メソッドを使用する場合は不要です。
 * </p>
 * @param result_type int[optional] <p>
 * オプションパラメータ result_type
 * は定数を受け付け、
 * 返される配列をどの様にインデックス付けするかを決定します。
 * SQLITE_ASSOC
 * を使用すると連想インデックス (名前付けられたフィールド) のみを返し、
 * SQLITE_NUM の場合は数値インデックス
 * (順序を表すフィールド番号) のみを返します。
 * SQLITE_ASSOC がこの関数のデフォルトです。
 * </p>
 * @return array カラムのデータ型の配列を返します。エラー時は FALSE を返します。
 * </p>
 * SQLITE_ASSOC および SQLITE_BOTH で
 * 返されるカラム名は、設定オプション
 * sqlite.assoc_case の値に基づき、
 * 大文字小文字が変換されます。
 */
function sqlite_fetch_column_types ($table_name, $dbhandle, $result_type = null) {}


/**
 * カラムは、数値インデックスとフィールド名による配列インデックスを
 * 共に有する配列に返されます。
 * @link http://www.php.net/manual/ja/sqlite.constants.php
 */
define ('SQLITE_BOTH', 3);

/**
 * カラムは、フィールドへの数値インデックスを有する配列に返されます。
 * このインデックスは 0 から始まり、結果の先頭フィールドとなります。
 * @link http://www.php.net/manual/ja/sqlite.constants.php
 */
define ('SQLITE_NUM', 2);

/**
 * カラムは、フィールド名を配列インデックスとする配列に返されます。
 * @link http://www.php.net/manual/ja/sqlite.constants.php
 */
define ('SQLITE_ASSOC', 1);

/**
 * 成功しました
 * @link http://www.php.net/manual/ja/sqlite.constants.php
 */
define ('SQLITE_OK', 0);

/**
 * SQL エラーあるいはデータベースが存在しません
 * @link http://www.php.net/manual/ja/sqlite.constants.php
 */
define ('SQLITE_ERROR', 1);

/**
 * SQLiteの内部ロジックエラーです
 * @link http://www.php.net/manual/ja/sqlite.constants.php
 */
define ('SQLITE_INTERNAL', 2);

/**
 * アクセス権限がありません
 * @link http://www.php.net/manual/ja/sqlite.constants.php
 */
define ('SQLITE_PERM', 3);

/**
 * コールバックルーチンが中断を要求しました
 * @link http://www.php.net/manual/ja/sqlite.constants.php
 */
define ('SQLITE_ABORT', 4);

/**
 * データベースファイルがロックされています
 * @link http://www.php.net/manual/ja/sqlite.constants.php
 */
define ('SQLITE_BUSY', 5);

/**
 * データベース内のテーブルがロックされています
 * @link http://www.php.net/manual/ja/sqlite.constants.php
 */
define ('SQLITE_LOCKED', 6);

/**
 * メモリの割り当てに失敗しました
 * @link http://www.php.net/manual/ja/sqlite.constants.php
 */
define ('SQLITE_NOMEM', 7);

/**
 * 読み込み専用データベースに書き込もうとしました
 * @link http://www.php.net/manual/ja/sqlite.constants.php
 */
define ('SQLITE_READONLY', 8);

/**
 * 処理が内部的に終了しました
 * @link http://www.php.net/manual/ja/sqlite.constants.php
 */
define ('SQLITE_INTERRUPT', 9);

/**
 * ディスク I/O エラーが発生しました
 * @link http://www.php.net/manual/ja/sqlite.constants.php
 */
define ('SQLITE_IOERR', 10);

/**
 * データベースのディスクイメージが不正です
 * @link http://www.php.net/manual/ja/sqlite.constants.php
 */
define ('SQLITE_CORRUPT', 11);

/**
 * (内部的な) テーブルもしくはレコードが存在しません
 * @link http://www.php.net/manual/ja/sqlite.constants.php
 */
define ('SQLITE_NOTFOUND', 12);

/**
 * データベースが一杯のため挿入に失敗しました
 * @link http://www.php.net/manual/ja/sqlite.constants.php
 */
define ('SQLITE_FULL', 13);

/**
 * データベースファイルをオープンできません
 * @link http://www.php.net/manual/ja/sqlite.constants.php
 */
define ('SQLITE_CANTOPEN', 14);

/**
 * データベースロックプロトコルエラーです
 * @link http://www.php.net/manual/ja/sqlite.constants.php
 */
define ('SQLITE_PROTOCOL', 15);

/**
 * (内部的な) データベーステーブルが空です
 * @link http://www.php.net/manual/ja/sqlite.constants.php
 */
define ('SQLITE_EMPTY', 16);

/**
 * データベーススキーマが変更されました
 * @link http://www.php.net/manual/ja/sqlite.constants.php
 */
define ('SQLITE_SCHEMA', 17);

/**
 * テーブルの 1 行に対するデータが多すぎます
 * @link http://www.php.net/manual/ja/sqlite.constants.php
 */
define ('SQLITE_TOOBIG', 18);

/**
 * 制約違反のため中止しました
 * @link http://www.php.net/manual/ja/sqlite.constants.php
 */
define ('SQLITE_CONSTRAINT', 19);

/**
 * データ型が一致しません
 * @link http://www.php.net/manual/ja/sqlite.constants.php
 */
define ('SQLITE_MISMATCH', 20);

/**
 * ライブラリが不正確に使用されました
 * @link http://www.php.net/manual/ja/sqlite.constants.php
 */
define ('SQLITE_MISUSE', 21);

/**
 * OS 機能の使用はホスト上でサポートされていません
 * @link http://www.php.net/manual/ja/sqlite.constants.php
 */
define ('SQLITE_NOLFS', 22);

/**
 * 認証に失敗しました
 * @link http://www.php.net/manual/ja/sqlite.constants.php
 */
define ('SQLITE_AUTH', 23);

/**
 * データベースファイルではないファイルをオープンしました
 * @link http://www.php.net/manual/ja/sqlite.constants.php
 */
define ('SQLITE_NOTADB', 26);

/**
 * データベースのフォーマットエラー
 * @link http://www.php.net/manual/ja/sqlite.constants.php
 */
define ('SQLITE_FORMAT', 24);

/**
 * 内部プロセスが他の行を準備しました
 * @link http://www.php.net/manual/ja/sqlite.constants.php
 */
define ('SQLITE_ROW', 100);

/**
 * 内部プロセスが実行を完了しました
 * @link http://www.php.net/manual/ja/sqlite.constants.php
 */
define ('SQLITE_DONE', 101);

// End of SQLite v.2.0-dev
?>
