/*
 *  QtUSBRH - USBRH + Qt4  alucky4416@users.sourceforge.jp
 *
 *     USBRH:Strawberry Linux co.ltd. http://strawberry-linux.com/
 *     libusb:libusb project  http://libusb.sourceforge.net/
 *
 *    Special Thanks: USBRH on *BSD http://www.nk-home.net/~aoyama/usbrh/
 *                    USBRH on Linux/libusb Mar.14 2007 http://d.hatena.ne.jp/Briareos/
 *
 *  This program is FREESOFTWARE, by the GPLv2.
 */

#include <QString>
#include <QDebug>

//#include <string.h>
#include "usbrh.h"

// ---------------------------------------------------------------------------------------

double usbrh::convert_temp(int in)
{
    double tmp;

    tmp = d1 + (d2 * in);

    return (tmp);
}

double usbrh::convert_humidity(int in)
{
    double tmp;

    tmp = c1 + (c2 * in) + (c3 * (in * in));

    return ((t1 - 25) * (t1 + (t2 * in)) + tmp);
}

struct usb_device* usbrh::searchdevice(unsigned int vendor, unsigned int product, int num)
{
    struct usb_bus *bus;
    struct usb_device *dev;
    int count;

    count = 0;

//    qDebug() << QString("vendor = 0x%1, product = 0x%2").arg(vendor, 4, 16, QChar('0')).arg(product, 4, 16, QChar('0'));
    for (bus = usb_get_busses(); bus; bus = bus->next) {
        for (dev = bus->devices; dev; dev = dev->next) {
//            qDebug() << QString("vendor = 0x%1, product = 0x%2").arg(dev->descriptor.idVendor, 4, 16, QChar('0')).arg(dev->descriptor.idProduct, 4, 16, QChar('0'));
            if ((dev->descriptor.idVendor == (unsigned short)vendor) && (dev->descriptor.idProduct == (unsigned short)product)) {
                count++;
                if (count==num) {
                    return (dev);
                }
            }
        }
    }

    return((struct usb_device *)NULL);
}

struct usb_device* usbrh::listdevice(unsigned int vendor, unsigned int product)
{
    struct usb_bus *bus;
    struct usb_device *dev;
    int count;

    count=0;
    // puts("listing:USBRH");

    for (bus = usb_get_busses(); bus; bus = bus->next) {
        for (dev = bus->devices; dev; dev = dev->next) {
            if (dev->descriptor.idVendor == vendor &&
                dev->descriptor.idProduct == product){
                count++;
                // printf("%d: bus=%s device=%s\n", count, bus->dirname, dev->filename);
            }
        }
    }
    // printf("%d device(s) found.\n", count);

    return((struct usb_device *)NULL);
}


// ---------------------------------------------------------------------------------------
usbrh::usbrh()
{
    // Initalize
    gDevice    = (struct usb_device *)NULL;
    gDevHandle = (usb_dev_handle *)NULL;

}
usbrh::~usbrh()
{
    // Finalize
    this->close();

}

int usbrh::open()
{
    int rc = 0;

    usb_init();
    usb_find_busses();
    usb_find_devices();

    // if ((dev = searchdevice(USBRH_VENDOR, USBRH_PRODUCT, DeviceNum)) == (struct usb_device *)NULL) {
    if ((gDevice = searchdevice(USBRH_VENDOR, USBRH_PRODUCT, 1)) == (struct usb_device *)NULL) {
        // puts("USBRH not found");
        rc = 1; // exit(1);
        return rc;
    }

    gDevHandle = usb_open(gDevice);
    if(gDevHandle == NULL){
        // puts("usb_open error");
        rc = 2; // exit(2);
        return rc;
    }

    return rc;
}

int usbrh::config()
{
    int rc = 0;

    if (gDevHandle == (usb_dev_handle *)NULL) return 1;
    if (gDevice == (struct usb_device *)NULL) return 1;

    if ((rc = usb_set_configuration(gDevHandle, gDevice->config->bConfigurationValue)) < 0) {
#ifndef __LIBUSB_WIN32__
        if ((rc = usb_detach_kernel_driver_np(gDevHandle, gDevice->config->interface->altsetting->bInterfaceNumber)) < 0) {
            // puts("usb_detach_kernel_driver_np error");
            this->close(); // usb_close(dh);
            rc = 3; //exit(3);
            return rc;
        } else {
            if((rc =usb_set_configuration(gDevHandle, gDevice->config->bConfigurationValue)) < 0) {
#endif
                //printf("usb_set_configuration error: %s\n", usb_strerror());
                usb_close(gDevHandle);
                gDevHandle = NULL;
                rc = 3;// exit(3);
                return rc;
#ifndef __LIBUSB_WIN32__
            }
        }
#endif
    }

    if ((rc =usb_claim_interface(gDevHandle, gDevice->config->interface->altsetting->bInterfaceNumber)) < 0) {
        //puts("usb_claim_interface error");
#ifndef __LIBUSB_WIN32__
        if ((rc = usb_detach_kernel_driver_np(gDevHandle, gDevice->config->interface->altsetting->bInterfaceNumber)) <0) {
            // puts("usb_detach_kernel_driver_np error");
            usb_close(gDevHandle);
            gDevHandle = NULL;
            rc = 4; // exit(4);
        } else {
            if((rc =usb_claim_interface(gDevHandle, gDevice->config->interface->altsetting->bInterfaceNumber)) < 0){
#endif
                //puts("usb_claim_interface error");
                usb_close(gDevHandle);
                gDevHandle = NULL;
                rc = 4; // exit(4);
                return rc;
#ifndef __LIBUSB_WIN32__
            }
        }
#endif
    }

    return rc;
}

int usbrh::get_tempr_humid(double *tempr, double *humid)
{
    int rc = 0;
    int iTemperature, iHumidity;
    char buff[512];

    if (gDevHandle == (usb_dev_handle *)NULL) return 1;

    // SET_REPORT
    // http://www.ghz.cc/~clepple/libHID/doc/html/libusb_8c-source.html
    memset(buff, 0, sizeof(buff));
    rc = usb_control_msg(gDevHandle, USB_ENDPOINT_OUT + USB_TYPE_CLASS + USB_RECIP_INTERFACE,
                         0x09, 0x02<<8, 0, buff, 7, 5000);
    if (rc < 0) {
        qDebug() << QString("usb_control_msg error : ")  << QString(usb_strerror());
    }
    //sleep(1);

    // Read data from device
    memset(buff, 0, sizeof(buff));
    int dev_endpoint = 0x01; // device EndPoint
#ifdef __LIBUSB_WIN32__
    dev_endpoint = 0x81;
#endif
    rc = usb_bulk_read(gDevHandle, dev_endpoint, buff, 7, 5000);
    if (rc < 0) {
        qDebug() << QString("usb_bulk_read error : ") << QString(usb_strerror());
        iTemperature = -99.0;
        iHumidity = -99.0;
    } else {
        iTemperature = buff[2] << 8 | (buff[3] & 0xff);
        iHumidity = buff[0] << 8 | (buff[1] & 0xff);
    }

    *tempr = convert_temp(iTemperature);
    *humid = convert_humidity(iHumidity);

    return rc;
}

void usbrh::close()
{
    int rc = 0;
    if (gDevHandle) {
        if ((rc = usb_release_interface(gDevHandle, gDevice->config->interface->altsetting->bInterfaceNumber)) < 0) {
            //puts("usb_release_interface error");
            //usb_close(gDevHandle);
            //exit(5);
            ;
        }
        usb_close(gDevHandle);
    }

    gDevice    = (struct usb_device *)NULL;
    gDevHandle = (usb_dev_handle *)NULL;
}

