//------------------------------------------------------------------------------
//  TOPPERS/ASP Windows Debug Environment
//  Copyright (C) 2010-2011 Cores Co., Ltd. Japan
//------------------------------------------------------------------------------
// $Id: core_support.cpp 118 2013-02-12 13:05:51Z nagasima $
#include "StdAfx.h"
#include "WinKernel.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

// hsqnmJ[l
extern CKernel *g_Kernel;

volatile bool faultmask;
volatile bool primask;
volatile uint32_t basepri;
volatile uint32_t control;
volatile uint32_t ipsr;

/*
 *  X^[gAbv[`iZbgpj
 */
void _start(void)
{
}

/*
 *  ^XNfBXpb`
 */
void dispatch(void)
{
	g_Kernel->Dispatch();
}

/*
 *  CPUOGg
 *
 *  ݃GgƏ̓e͓CO̎ނقȂ邽߁C
 *  ĂD
 */
void core_exc_entry(void)
{
}

/*
 *  ݃Gg
 */
void core_int_entry(void)
{
}

/*
 *  SVCnh
 */
void svc_handler(void)
{
}

/*
 *  ݂̃ReLXĝĂăfBXpb`
 */
void exit_and_dispatch(void)
{
	TCB *Task = get_tcb_self(TSK_SELF);
	t_unlock_cpu();
	g_Kernel->ReleaseCPUContext((CCPUContext *)Task->tskctxb.cpu_context);
}

/*
 *  J[l̏Ǐďo
 *
 *  X^bN^XNReLXgpɐ؂ւD
 *  
 */
void call_exit_kernel(void)
{
	g_Kernel->Terminate();
}

/*
 *  ^XNN
 *
 */ 
void start_r(void)
{
	lock_flag = false;
	basepri = 0;
}

/*
 *  FAULTMASK̃Zbg
 */
void set_faultmask(void)
{
	faultmask = true;
}

/*
 *  FAULTMASK̃NA
 */
void clear_faultmask(void)
{
	faultmask = false;
}

/*
 *  PRIMASK̃Zbg
 */
void set_primask(void)
{
	primask = true;
}

/*
 *  PRIMASK̃NA
 */
void clear_primask(void)
{
	primask = false;
}

/*
 *  BASEPRĨZbg
 */
void set_basepri(uint32_t val)
{
	if(val == IIPM_LOCK){
		if(!g_Kernel->InKernelMode()){
			g_Kernel->LockCPU();
			basepri = val;
		}
	}
	else{
		if(!g_Kernel->InKernelMode()){
			basepri = val;
			g_Kernel->UnlockCPU();
		}
	}
}

/*
 *  BASEPRI̎擾
 */
uint32_t get_basepri(void)
{
	return(basepri);
}

/*
 *  CONTROL̃Zbg
 */
void set_control(uint32_t val)
{
	control = val;
}

/*
 *  CONTROL̎擾
 */
uint32_t get_control(void)
{
	if(g_Kernel->InKernelMode())
		control &= ~CONTROL_PSP;
	else
		control |= CONTROL_PSP;
	return(control);
}

/*
 *  Xe[^XWX^iCPSRǰݒl̓Ǐo
 */
uint32_t get_ipsr(void)
{
	return(ipsr);
}

/*
 *  NMIׂĂ݂̊̋֎~
 */
bool_t TOPPERS_disint(void)
{
	bool val = faultmask;

	if (!val) {
		g_Kernel->LockCPU();
		faultmask = true;
	}

	return val;
}

void TOPPERS_enaint(bool_t locked)
{
	if (!locked) {
		faultmask = false;
		g_Kernel->UnlockCPU();
	}
}

void x_define_inh(uint_t inhno, FP int_entry)
{
	g_Kernel->DefineInterruptHandler(inhno, int_entry);
}

extern "C" void Throw()
{
	throw 1;
}

extern "C" SYSUTM trace_get_tim_utime_arch(void)
{
	__int64 now, frequency, quotient, modulus;
	g_Kernel->GetSystemTime(&now, &frequency);
	// lĂ
	quotient = now / frequency;
	modulus = now % frequency;
	// (1000000 * now) / frequency vZ
	return 1000000 * quotient + (1000000 * modulus) / frequency;
}

