/*
 *  TLV - Trace Log Visualizer
 *
 *  Copyright (C) 2008-2010 by Nagoya Univ., JAPAN
 *
 *  上記著作権者は，以下の(1)〜(4)の条件を満たす場合に限り，本ソフトウェ
 *  ア（本ソフトウェアを改変したものを含む．以下同じ）を使用・複製・改
 *  変・再配布（以下，利用と呼ぶ）することを無償で許諾する．
 *  (1) 本ソフトウェアをソースコードの形で利用する場合には，上記の著作
 *      権表示，この利用条件および下記の無保証規定が，そのままの形でソー
 *      スコード中に含まれていること．
 *  (2) 本ソフトウェアを，ライブラリ形式など，他のソフトウェア開発に使
 *      用できる形で再配布する場合には，再配布に伴うドキュメント（利用
 *      者マニュアルなど）に，上記の著作権表示，この利用条件および下記
 *      の無保証規定を掲載すること．
 *  (3) 本ソフトウェアを，機器に組み込むなど，他のソフトウェア開発に使
 *      用できない形で再配布する場合には，次のいずれかの条件を満たすこ
 *      と．
 *    (a) 再配布に伴うドキュメント（利用者マニュアルなど）に，上記の著
 *        作権表示，この利用条件および下記の無保証規定を掲載すること．
 *    (b) 再配布の形態を，別に定める方法によって，TOPPERSプロジェクトに
 *        報告すること．
 *  (4) 本ソフトウェアの利用により直接的または間接的に生じるいかなる損
 *      害からも，上記著作権者およびTOPPERSプロジェクトを免責すること．
 *      また，本ソフトウェアのユーザまたはエンドユーザからのいかなる理
 *      由に基づく請求からも，上記著作権者およびTOPPERSプロジェクトを
 *      免責すること．
 *
 *  本ソフトウェアは，無保証で提供されているものである．上記著作権者お
 *  よびTOPPERSプロジェクトは，本ソフトウェアに関して，特定の使用目的
 *  に対する適合性も含めて，いかなる保証も行わない．また，本ソフトウェ
 *  アの利用により直接的または間接的に生じたいかなる損害に関しても，そ
 *  の責任を負わない．
 *
 *  @(#) $Id$
 */
using System;
using System.Collections.Generic;
using System.Text;
using NU.OJL.MPRTOS.TLV.Base;

namespace NU.OJL.MPRTOS.TLV.Core
{
	public class EventShapes
	{
		public Dictionary<string, List<EventShape>> List { get { return _list; } set { _list = value; } }
		private Dictionary<string, List<EventShape>> _list = new Dictionary<string, List<EventShape>>();

		public IEnumerable<EventShape> GetShapes(TraceLogVisualizerData data, Time from, Time to)
		{
			if (data != null)
			{
				//foreach (EventShape esp in this.OrderBy(l => l.From).Where(l =>
				//    data.SettingData.VisualizeRuleExplorerSetting.VisualizeRuleVisibility.ContainsKey(l.Event.GetVisualizeRuleName(), l.Event.Name)
				//    && data.SettingData.VisualizeRuleExplorerSetting.VisualizeRuleVisibility.GetValue(l.Event.GetVisualizeRuleName(), l.Event.Name)
				//    && l.From < to
				//    && l.To > from))
				//{
				//    yield return esp;
				//}

				foreach (KeyValuePair<string, List<EventShape>> kvp in _list)
				{
					string key1 = kvp.Key.Split(':')[0];
					string key2 = kvp.Key.Split(':')[1];

					if (data.SettingData.VisualizeRuleExplorerSetting.VisualizeRuleVisibility.ContainsKey(key1, key2)
						&& data.SettingData.VisualizeRuleExplorerSetting.VisualizeRuleVisibility.GetValue(key1, key2)
					)
					{
						foreach (EventShape es in Where<EventShape>(kvp.Value, delegate(EventShape l) { return l.From < to; }))
						{
							if (es.To > from)
								yield return es;
						}
					}
				}
			}
		}

		public void Add(EventShape eventShape)
		{
			string p = eventShape.Event.GetVisualizeRuleName() + ":" + eventShape.Event.Name;
			if (!_list.ContainsKey(p))
				_list.Add(p, new List<EventShape>());
			//            eventShape.Event = null; 
			_list[p].Add(eventShape);
		}

		public void Optimize()
		{
			Dictionary<string, List<EventShape>> list = new Dictionary<string, List<EventShape>>();
			foreach (KeyValuePair<string, List<EventShape>> kvp in _list)
			{
				list.Add(kvp.Key, OrderBy<EventShape, Time>(kvp.Value, delegate(EventShape l) { return l.From; }));
			}
			_list = list;
		}

		public void Clear()
		{
			_list.Clear();
		}

		private static IEnumerable<T> Where<T>(IEnumerable<T> objs, Func<T, bool> p)
		{
			List<T> result = new List<T>();
			foreach (T obj in objs)
			{
				if (p(obj))
					result.Add(obj);
			}
			return result;
		}

		private static List<T> OrderBy<T, K>(List<T> objs, Func<T, K> p)
		{
			List<T> result = new List<T>(objs);
			IComparer<K> comparer = Comparer<K>.Default;
			result.Sort(delegate(T t1, T t2) { return comparer.Compare(p(t1), p(t2)); });
			return result;
		}
	}
}
