/*
 *  TOPPERS/ASP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Advanced Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2005,2006 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  L쌠҂́Cȉ(1)`(4)̏𖞂ꍇɌC{\tgEF
 *  Ai{\tgEFAς̂܂ށDȉjgpEE
 *  ρEĔzziȉCpƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 *      ܂C{\tgEFÃ[U܂̓Gh[ÛȂ闝
 *      RɊÂCL쌠҂TOPPERSvWFNg
 *      Ɛӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̎gpړI
 *  ɑ΂K܂߂āCȂۏ؂sȂD܂C{\tgEF
 *  A̗pɂ蒼ړI܂͊ԐړIɐȂ鑹QɊւĂC
 *  ̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: alarm.h 1 2010-03-29 04:33:11Z nagasima $
 */

/*
 *		A[nh@\
 */

#ifndef TOPPERS_ALARM_H
#define TOPPERS_ALARM_H

#include "time_event.h"

/*
 *  A[nhubN
 */
typedef struct alarm_handler_initialization_block {
	ATR			almatr;			/* A[nh */
	intptr_t	exinf;			/* A[nh̊g */
	ALMHDR		almhdr;			/* A[nh̋NԒn */
} ALMINIB;

/*
 *  A[nhǗubN
 */
typedef struct alarm_handler_control_block {
	const ALMINIB *p_alminib;	/* ubNւ̃|C^ */
	bool_t		almsta;			/* A[nh̓ */
	TMEVTB		tmevtb;			/* ^CCxgubN */
} ALMCB;

/*
 *  A[nhID̍őlikernel_cfg.cj
 */
extern const ID	tmax_almid;

/*
 *  A[nhubÑGAikernel_cfg.cj
 */
extern const ALMINIB	alminib_table[];

/*
 *  A[nhǗubÑGAikernel_cfg.cj
 */
extern ALMCB	almcb_table[];

/*
 *  A[nh@\̏
 */
extern void	initialize_alarm(void);

/*
 *  A[nhN[`
 */
extern void	call_almhdr(ALMCB *p_almcb);

#endif /* TOPPERS_ALARM_H */
