/*
 *  TOPPERS/ASP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Advanced Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2004-2010 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  L쌠҂́Cȉ(1)`(4)̏𖞂ꍇɌC{\tgEF
 *  Ai{\tgEFAς̂܂ށDȉjgpEE
 *  ρEĔzziȉCpƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 *      ܂C{\tgEFÃ[U܂̓Gh[ÛȂ闝
 *      RɊÂCL쌠҂TOPPERSvWFNg
 *      Ɛӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̎gpړI
 *  ɑ΂K܂߂āCȂۏ؂sȂD܂C{\tgEF
 *  A̗pɂ蒼ړI܂͊ԐړIɐȂ鑹QɊւĂC
 *  ̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: kernel.h 93 2012-03-03 05:14:29Z nagasima $
 */

/*
 *		TOPPERS/ASPJ[l Wwb_t@C
 *
 *  TOPPERS/ASPJ[lT|[gT[rXR[̐錾ƁCKvȃf[
 *  ^^C萔C}N̒`܂ރwb_t@CD
 *
 *  AZũ\[Xt@C炱̃t@CCN[h鎞
 *  ́CTOPPERS_MACRO_ONLY`ĂDɂC}N`ȊO
 *  悤ɂȂĂD
 *
 *  ̃t@CCN[hOɃCN[hĂׂt@C
 *  ͂ȂD
 */

#ifndef TOPPERS_KERNEL_H
#define TOPPERS_KERNEL_H

#ifdef __cplusplus
extern "C" {
#endif

/*
 *	TOPPERSʂ̃f[^^E萔E}N
 */
#include <t_stddef.h>

/*
 *  ^[Qbgˑ
 */
#include "target_kernel.h"

#ifndef TOPPERS_MACRO_ONLY

/*
 *  f[^^̒`
 */

/*
 *  rbgp^[IuWFNgԍ̌^`
 */
typedef	uint_t		TEXPTN;		/* ^XNOṽrbgp^[ */
typedef	uint_t		FLGPTN;		/* CxgtÕrbgp^[ */
typedef	uint_t		INTNO;		/* ݔԍ */
typedef	uint_t		INHNO;		/* ݃nhԍ */
typedef	uint_t		EXCNO;		/* CPUOnhԍ */

/*
 *  Pʂ̌^`
 */
typedef void	(*TASK)(intptr_t exinf);
typedef void	(*TEXRTN)(TEXPTN texptn, intptr_t exinf);
typedef void	(*CYCHDR)(intptr_t exinf);
typedef void	(*ALMHDR)(intptr_t exinf);
typedef void	(*ISR)(intptr_t exinf);
typedef void	(*INTHDR)(void);
typedef void	(*EXCHDR)(void *p_excinf);
typedef void	(*INIRTN)(intptr_t exinf);
typedef void	(*TERRTN)(intptr_t exinf);

/*
 *  ̈mۂ̂߂̌^`
 */
#ifndef TOPPERS_STK_T
#define TOPPERS_STK_T	intptr_t
#endif /* TOPPERS_STK_T */
typedef	TOPPERS_STK_T	STK_T;	/* X^bN̈mۂ邽߂̌^ */

#ifndef TOPPERS_MPF_T
#define TOPPERS_MPF_T	intptr_t
#endif /* TOPPERS_MPF_T */
typedef	TOPPERS_MPF_T	MPF_T;	/* Œ蒷v[̈mۂ邽߂̌^ */

/*
 *  bZ[Wwb_̌^`
 */
typedef	struct t_msg {			/* [{bNX̃bZ[Wwb_ */
	struct t_msg	*pk_next;
} T_MSG;

typedef	struct t_msg_pri {		/* DxtbZ[Wwb_ */
	T_MSG	msgque;				/* bZ[Wwb_ */
	PRI		msgpri;				/* bZ[WDx */
} T_MSG_PRI;

/*
 *  pPbg`̒`
 */
typedef struct t_rtsk {
	STAT	tskstat;	/* ^XN */
	PRI		tskpri;		/* ^XŇݗDx */
	PRI		tskbpri;	/* ^XÑx[XDx */
	STAT	tskwait;	/* ҂v */
	ID		wobjid;		/* ҂Ώۂ̃IuWFNgID */
	TMO		lefttmo;	/* ^CAEg܂ł̎ */
	uint_t	actcnt;		/* NvL[CO */
	uint_t	wupcnt;		/* NvL[CO */
} T_RTSK;

typedef struct t_rtex {
	STAT	texstat;	/* ^XNȌ */
	TEXPTN	pndptn;		/* ۗOv */
} T_RTEX;

typedef struct t_rsem {
	ID		wtskid;		/* Z}tH̑҂s̐擪̃^XNIDԍ */
	uint_t	semcnt;		/* Z}tȞ݂̎ */
} T_RSEM;

typedef struct t_rflg {
	ID		wtskid;		/* CxgtȎ҂s̐擪̃^XNIDԍ */
	FLGPTN	flgptn;		/* CxgtǑ݂̃rbgp^[ */
} T_RFLG;

typedef struct t_rdtq {
	ID		stskid;		/* f[^L[̑M҂s̐擪̃^XNIDԍ */
	ID		rtskid;		/* f[^L[̎M҂s̐擪̃^XNIDԍ */
	uint_t	sdtqcnt;	/* f[^L[Ǘ̈Ɋi[Ăf[^̐ */
} T_RDTQ;

typedef struct t_rpdq {
	ID		stskid;		/* Dxf[^L[̑M҂s̐擪̃^XN
						   IDԍ */
	ID		rtskid;		/* Dxf[^L[̎M҂s̐擪̃^XN
						   IDԍ */
	uint_t	spdqcnt;	/* Dxf[^L[Ǘ̈Ɋi[Ăf[
						   ^̐ */
} T_RPDQ;

typedef struct t_rmbx {
	ID		wtskid;		/* [{bNX̑҂s̐擪̃^XNIDԍ */
	T_MSG	*pk_msg;	/* bZ[WL[̐擪ɂȂꂽbZ[W
						   ̐擪Ԓn */
} T_RMBX;

typedef struct t_rmpf {
	ID		wtskid;		/* Œ蒷v[̑҂s̐擪̃^XN
						   IDԍ */
	uint_t	fblkcnt;	/* Œ蒷v[̈̋󂫃̈Ɋ
						   t邱ƂłŒ蒷ubN̐ */
} T_RMPF;

typedef struct t_rmpl {
	ID		wtskid;			/* ϒv[̑҂s̐擪̃^XNIDԍ */
	uint_t	fmplsz;			/* ϒv[̋󂫗̈̍vTCYioCgj */
	uint_t	fblksz;			/* Ɋl\ȍő僁ubNTCYioCgj */
} T_RMPL;

typedef struct t_rcyc {
	STAT	cycstat;	/* nh̓ */
	RELTIM	lefttim;	/* ɎnhN鎞܂ł̑Ύ */
} T_RCYC;

typedef struct t_ralm {
	STAT	almstat;	/* A[nh̓ */
	RELTIM	lefttim;	/* A[nhN鎞܂ł̑Ύ */
} T_RALM;

/*
 *  T[rXR[̐錾
 */

/*
 *  ^XNǗ@\
 */
extern ER		act_tsk(ID tskid) throw();
extern ER		iact_tsk(ID tskid) throw();
extern ER_UINT	can_act(ID tskid) throw();
extern ER		ext_tsk(void) throw();
extern ER		ter_tsk(ID tskid) throw();
extern ER		chg_pri(ID tskid, PRI tskpri) throw();
extern ER		get_pri(ID tskid, PRI *p_tskpri) throw();
extern ER		get_inf(intptr_t *p_exinf) throw();
extern ER		ref_tsk(ID tskid, T_RTSK *pk_rtsk) throw();

/*
 *  ^XNt@\
 */
extern ER		slp_tsk(void) throw();
extern ER		tslp_tsk(TMO tmout) throw();
extern ER		wup_tsk(ID tskid) throw();
extern ER		iwup_tsk(ID tskid) throw();
extern ER_UINT	can_wup(ID tskid) throw();
extern ER		rel_wai(ID tskid) throw();
extern ER		irel_wai(ID tskid) throw();
extern ER		sus_tsk(ID tskid) throw();
extern ER		rsm_tsk(ID tskid) throw();
extern ER		dly_tsk(RELTIM dlytim) throw();

/*
 *  ^XNO@\
 */
extern ER		ras_tex(ID tskid, TEXPTN rasptn) throw();
extern ER		iras_tex(ID tskid, TEXPTN rasptn) throw();
extern ER		dis_tex(void) throw();
extern ER		ena_tex(void) throw();
extern bool_t	sns_tex(void) throw();
extern ER		ref_tex(ID tskid, T_RTEX *pk_rtex) throw();

/*
 *  EʐM@\
 */
extern ER		sig_sem(ID semid) throw();
extern ER		isig_sem(ID semid) throw();
extern ER		wai_sem(ID semid) throw();
extern ER		pol_sem(ID semid) throw();
extern ER		twai_sem(ID semid, TMO tmout) throw();
extern ER		ini_sem(ID semid) throw();
extern ER		ref_sem(ID semid, T_RSEM *pk_rsem) throw();

extern ER		set_flg(ID flgid, FLGPTN setptn) throw();
extern ER		iset_flg(ID flgid, FLGPTN setptn) throw();
extern ER		clr_flg(ID flgid, FLGPTN clrptn) throw();
extern ER		wai_flg(ID flgid, FLGPTN waiptn,
						MODE wfmode, FLGPTN *p_flgptn) throw();
extern ER		pol_flg(ID flgid, FLGPTN waiptn,
						MODE wfmode, FLGPTN *p_flgptn) throw();
extern ER		twai_flg(ID flgid, FLGPTN waiptn,
						MODE wfmode, FLGPTN *p_flgptn, TMO tmout) throw();
extern ER		ini_flg(ID flgid) throw();
extern ER		ref_flg(ID flgid, T_RFLG *pk_rflg) throw();

extern ER		snd_dtq(ID dtqid, intptr_t data) throw();
extern ER		psnd_dtq(ID dtqid, intptr_t data) throw();
extern ER		ipsnd_dtq(ID dtqid, intptr_t data) throw();
extern ER		tsnd_dtq(ID dtqid, intptr_t data, TMO tmout) throw();
extern ER		fsnd_dtq(ID dtqid, intptr_t data) throw();
extern ER		ifsnd_dtq(ID dtqid, intptr_t data) throw();
extern ER		rcv_dtq(ID dtqid, intptr_t *p_data) throw();
extern ER		prcv_dtq(ID dtqid, intptr_t *p_data) throw();
extern ER		trcv_dtq(ID dtqid, intptr_t *p_data, TMO tmout) throw();
extern ER		ini_dtq(ID dtqid) throw();
extern ER		ref_dtq(ID dtqid, T_RDTQ *pk_rdtq) throw();

extern ER		snd_pdq(ID pdqid, intptr_t data, PRI datapri) throw();
extern ER		psnd_pdq(ID pdqid, intptr_t data, PRI datapri) throw();
extern ER		ipsnd_pdq(ID pdqid, intptr_t data, PRI datapri) throw();
extern ER		tsnd_pdq(ID pdqid, intptr_t data,
										PRI datapri, TMO tmout) throw();
extern ER		rcv_pdq(ID pdqid, intptr_t *p_data, PRI *p_datapri) throw();
extern ER		prcv_pdq(ID pdqid, intptr_t *p_data, PRI *p_datapri) throw();
extern ER		trcv_pdq(ID pdqid, intptr_t *p_data,
										PRI *p_datapri, TMO tmout) throw();
extern ER		ini_pdq(ID pdqid) throw();
extern ER		ref_pdq(ID pdqid, T_RPDQ *pk_rpdq) throw();

extern ER		snd_mbx(ID mbxid, T_MSG *pk_msg) throw();
extern ER		rcv_mbx(ID mbxid, T_MSG **ppk_msg) throw();
extern ER		prcv_mbx(ID mbxid, T_MSG **ppk_msg) throw();
extern ER		trcv_mbx(ID mbxid, T_MSG **ppk_msg, TMO tmout) throw();
extern ER		ini_mbx(ID mbxid) throw();
extern ER		ref_mbx(ID mbxid, T_RMBX *pk_rmbx) throw();

/*
 *  v[Ǘ@\
 */
extern ER		get_mpf(ID mpfid, void **p_blk) throw();
extern ER		pget_mpf(ID mpfid, void **p_blk) throw();
extern ER		tget_mpf(ID mpfid, void **p_blk, TMO tmout) throw();
extern ER		rel_mpf(ID mpfid, void *blk) throw();
extern ER		ini_mpf(ID mpfid) throw();
extern ER		ref_mpf(ID mpfid, T_RMPF *pk_rmpf) throw();

extern ER		get_mpl(ID mplid, uint_t blksz, void **p_blk) throw();
extern ER		pget_mpl(ID mplid, uint_t blksz, void **p_blk) throw();
extern ER		tget_mpl(ID mplid, uint_t blksz, void **p_blk, TMO tmout) throw();
extern ER		rel_mpl(ID mplid, void *blk) throw();
extern ER		ref_mpl(ID mplid, T_RMPL *pk_rmpl) throw();

/*
 *  ԊǗ@\
 */
extern ER		get_tim(SYSTIM *p_systim) throw();
extern ER		get_utm(SYSUTM *p_sysutm) throw();

extern ER		sta_cyc(ID cycid) throw();
extern ER		stp_cyc(ID cycid) throw();
extern ER		ref_cyc(ID cycid, T_RCYC *pk_rcyc) throw();

extern ER		sta_alm(ID almid, RELTIM almtim) throw();
extern ER		ista_alm(ID almid, RELTIM almtim) throw();
extern ER		stp_alm(ID almid) throw();
extern ER		istp_alm(ID almid) throw();
extern ER		ref_alm(ID almid, T_RALM *pk_ralm) throw();

/*
 *  VXeԊǗ@\
 */
extern ER		rot_rdq(PRI tskpri) throw();
extern ER		irot_rdq(PRI tskpri) throw();
extern ER		get_tid(ID *p_tskid) throw();
extern ER		iget_tid(ID *p_tskid) throw();
extern ER		loc_cpu(void) throw();
extern ER		iloc_cpu(void) throw();
extern ER		unl_cpu(void) throw();
extern ER		iunl_cpu(void) throw();
extern ER		dis_dsp(void) throw();
extern ER		ena_dsp(void) throw();
extern bool_t	sns_ctx(void) throw();
extern bool_t	sns_loc(void) throw();
extern bool_t	sns_dsp(void) throw();
extern bool_t	sns_dpn(void) throw();
extern bool_t	sns_ker(void) throw();
extern ER		ext_ker(void) throw();

/*
 *  ݊Ǘ@\
 */
extern ER		dis_int(INTNO intno) throw();
extern ER		ena_int(INTNO intno) throw();
extern ER		chg_ipm(PRI intpri) throw();
extern ER		get_ipm(PRI *p_intpri) throw();

/*
 *  CPUOǗ@\
 */
extern bool_t	xsns_dpn(void *p_excinf) throw();
extern bool_t	xsns_xpn(void *p_excinf) throw();

#endif /* TOPPERS_MACRO_ONLY */

/*
 *  IuWFNg̒`
 */
#define TA_ACT			UINT_C(0x02)	/* ^XNNꂽԂŐ */

#define TA_TPRI			UINT_C(0x01)	/* ^XN̑҂sDx */
#define TA_MPRI			UINT_C(0x02)	/* bZ[WL[Dx */

#define TA_WMUL			UINT_C(0x02)	/* ̑҂^XN */
#define TA_CLR			UINT_C(0x04)	/* CxgtÕNAw */

#define TA_STA			UINT_C(0x02)	/* nh𓮍ԂŐ */

#define TA_NONKERNEL	UINT_C(0x02)	/* J[lǗO̊ */

#define TA_ENAINT		UINT_C(0x01)	/* ݗv֎~tONA */
#define TA_EDGE			UINT_C(0x02)	/* GbWgK */

/*
 *  T[rXR[̓샂[h̒`
 */
#define TWF_ORW			UINT_C(0x01)	/* CxgtOOR҂ */
#define TWF_ANDW		UINT_C(0x02)	/* CxgtOAND҂ */

/*
 *  IuWFNg̏Ԃ̒`
 */
#define TTS_RUN			UINT_C(0x01)	/* s */
#define TTS_RDY			UINT_C(0x02)	/* s\ */
#define TTS_WAI			UINT_C(0x04)	/* ҂ */
#define TTS_SUS			UINT_C(0x08)	/* ҂ */
#define TTS_WAS			UINT_C(0x0c)	/* d҂ */
#define TTS_DMT			UINT_C(0x10)	/* x~ */

#define TTW_SLP			UINT_C(0x0001)	/* N҂ */
#define TTW_DLY			UINT_C(0x0002)	/* Ԍoߑ҂ */
#define TTW_SEM			UINT_C(0x0004)	/* Z}tH̎l҂ */
#define TTW_FLG			UINT_C(0x0008)	/* CxgtO҂ */
#define TTW_SDTQ		UINT_C(0x0010)	/* f[^L[ւ̑M҂ */
#define TTW_RDTQ		UINT_C(0x0020)	/* f[^L[̎M҂ */
#define TTW_SPDQ		UINT_C(0x0100)	/* Dxf[^L[ւ̑M҂ */
#define TTW_RPDQ		UINT_C(0x0200)	/* Dxf[^L[̎M҂ */
#define TTW_MBX			UINT_C(0x0040)	/* [{bNX̎M҂ */
#define TTW_MPF			UINT_C(0x2000)	/* Œ蒷ubN̊l҂ */
#define TTW_MPL			UINT_C(0x4000)	/* ϒubN̊l҂ */

#define TTEX_ENA		UINT_C(0x01)	/* ^XNO */
#define TTEX_DIS		UINT_C(0x02)	/* ^XNO֎~ */

#define TCYC_STP		UINT_C(0x01)	/* nh삵ĂȂ */
#define TCYC_STA		UINT_C(0x02)	/* nh삵Ă */

#define TALM_STP		UINT_C(0x01)	/* A[nh삵ĂȂ */
#define TALM_STA		UINT_C(0x02)	/* A[nh삵Ă */

/*
 *  ̑̒萔̒`
 */
#define TSK_SELF		0			/* ^XNw */
#define TSK_NONE		0			/* Y^XNȂ */

#define TPRI_SELF		0			/* ^XÑx[XDx */
#define TPRI_INI		0			/* ^XN̋NDx */

#define TIPM_ENAALL		0			/* ݗDx}XNS */

/*
 *  \萔ƃ}N
 */

/*
 *  T|[g@\
 */
#ifdef TOPPERS_TARGET_SUPPORT_DIS_INT
#define TOPPERS_SUPPORT_DIS_INT			/* dis_intT|[gĂ */
#endif /* TOPPERS_TARGET_SUPPORT_DIS_INT */

#ifdef TOPPERS_TARGET_SUPPORT_ENA_INT
#define TOPPERS_SUPPORT_ENA_INT			/* ena_intT|[gĂ */
#endif /* TOPPERS_TARGET_SUPPORT_ENA_INT */

#ifdef TOPPERS_TARGET_SUPPORT_GET_UTM
#define TOPPERS_SUPPORT_GET_UTM			/* get_utmT|[gĂ */
#endif /* TOPPERS_TARGET_SUPPORT_GET_UTM */

/*
 *  Dx͈̔
 */
#define TMIN_TPRI		1			/* ^XNDx̍ŏliōlj*/
#define TMAX_TPRI		16			/* ^XNDx̍őliŒlj*/
#define TMIN_DPRI		1			/* f[^Dx̍ŏliōlj*/
#define TMAX_DPRI		16			/* f[^Dx̍őliŒlj*/
#define TMIN_MPRI		1			/* bZ[WDx̍ŏliōlj*/
#define TMAX_MPRI		16			/* bZ[WDx̍őliŒlj*/
#define TMIN_ISRPRI		1			/* ݃T[rX[`Dx̍ŏl */
#define TMAX_ISRPRI		16			/* ݃T[rX[`Dx̍ől */

/*
 *  o[W
 */
#define TKERNEL_MAKER	UINT_C(0x0118)	/* J[l̃[J[R[h */
#define TKERNEL_PRID	UINT_C(0x0007)	/* J[l̎ʔԍ */
#define TKERNEL_SPVER	UINT_C(0xf513)	/* J[ldl̃o[Wԍ */
#define TKERNEL_PRVER	UINT_C(0x1070)	/* J[l̃o[Wԍ */

/*
 *  L[CO񐔂̍ől
 */
#define TMAX_ACTCNT		UINT_C(1)		/* NvL[CO̍ől */
#define TMAX_WUPCNT		UINT_C(1)		/* NvL[CO̍ől */

/*
 *  rbgp^[̃rbg
 */
#ifndef TBIT_TEXPTN					/* ^XNOṽrbg */
#define TBIT_TEXPTN		(sizeof(TEXPTN) * CHAR_BIT)
#endif /* TBIT_TEXPTN */

#ifndef TBIT_FLGPTN					/* CxgtÕrbg */
#define TBIT_FLGPTN		(sizeof(FLGPTN) * CHAR_BIT)
#endif /* TBIT_FLGPTN */

/*
 *  ̈mۂ̂߂̃}N
 *
 *  ȉTOPPERS_COUNT_SZTOPPERS_ROUND_SZ̒`́Cunit2̋Џł
 *  邱Ƃ肵ĂD
 */
#ifndef TOPPERS_COUNT_SZ
#define TOPPERS_COUNT_SZ(sz, unit)	(((sz) + (unit) - 1) / (unit))
#endif /* TOPPERS_COUNT_SZ */
#ifndef TOPPERS_ROUND_SZ
#define TOPPERS_ROUND_SZ(sz, unit)	(((sz) + (unit) - 1) & ~((unit) - 1))
#endif /* TOPPERS_ROUND_SZ */

#define COUNT_STK_T(sz)		TOPPERS_COUNT_SZ(sz, sizeof(STK_T))
#define ROUND_STK_T(sz)		TOPPERS_ROUND_SZ(sz, sizeof(STK_T))

#define COUNT_MPF_T(blksz)	TOPPERS_COUNT_SZ(blksz, sizeof(MPF_T))
#define ROUND_MPF_T(blksz)	TOPPERS_ROUND_SZ(blksz, sizeof(MPF_T))

/*
 *  ̑̍\萔
 */
#define TMAX_MAXSEM		UINT_MAX	/* Z}tH̍ő厑̍ől */

#ifdef __cplusplus
}
#endif

#endif /* TOPPERS_KERNEL_H */
