/*
 *  TINET (TCP/IP Protocol Stack)
 * 
 *  Copyright (C) 2001-2009 by Dep. of Computer Science and Engineering
 *                   Tomakomai National College of Technology, JAPAN
 *
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́C̏𖞂ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 *
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: nd6_rtr.c,v 1.5 2009/12/24 05:48:16 abe Exp abe $
 */

/*	$FreeBSD: src/sys/netinet6/nd6_rtr.c,v 1.11 2002/04/19 04:46:23 suz Exp $	*/
/*	$KAME: nd6_rtr.c,v 1.111 2001/04/27 01:37:15 jinmei Exp $	*/

/*
 * Copyright (C) 1995, 1996, 1997, and 1998 WIDE Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the project nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include <string.h>

#ifdef TARGET_KERNEL_ASP

#include <kernel.h>
#include <sil.h>
#include <t_syslog.h>
#include "kernel_cfg.h"

#endif	/* of #ifdef TARGET_KERNEL_ASP */

#ifdef TARGET_KERNEL_JSP

#include <s_services.h>
#include <t_services.h>
#include "kernel_id.h"

#endif	/* of #ifdef TARGET_KERNEL_JSP */

#include <tinet_defs.h>
#include <tinet_config.h>

#include <net/if.h>
#include <net/if_ppp.h>
#include <net/if_loop.h>
#include <net/ethernet.h>
#include <net/if_arp.h>
#include <net/ppp_ipcp.h>
#include <net/net.h>
#include <net/net_var.h>
#include <net/net_buf.h>
#include <net/net_timer.h>
#include <net/net_count.h>

#include <netinet/in.h>
#include <netinet/in_var.h>
#include <netinet6/in6.h>
#include <netinet6/in6_var.h>
#include <netinet6/nd6.h>
#include <netinet6/in6_ifattach.h>
#include <netinet/ip6.h>
#include <netinet/icmp6.h>
#include <netinet6/ip6_var.h>

#include <net/if6_var.h>

/*
 *  O֐̒`
 */

extern const char *itron_strerror (ER ercd);

#ifdef SUPPORT_INET6

#if NUM_ND6_DEF_RTR_ENTRY > 0

/*
 *  Sϐ
 */

SYSTIM	nd6_base_reachable_time		= ND6_DEF_REACHABLE_TIME;	/* [^ʒmꂽl		*/
SYSTIM	nd6_reachable_time		= ND6_DEF_REACHABLE_TIME;	/* [^ʒmꂽl̕␳l	*/
SYSTIM	nd6_recalc_reachtm_interval	= ND6_RECALC_REACHTM_INTERVAL;	/* B\Ԃ̗LԍČvZԊu	*/
SYSTIM	nd6_retrans_time		= ND6_DEF_RETRANS_TIME;		/* ߗגT̑MԊu			*/
uint8_t	ip6_defhlim			= IPV6_DEFHLIM;			/* zbv~bg̋Kl		*/

/*
 *  Ǐϐ
 */

/*
 *  vtBbNXEXg
 */

static T_ND6_PREFIX nd6_prefix[NUM_ND6_PREFIX_ENTRY];

/*
 *  fBtHg[^EXg
 */

static T_DEF_ROUTER	nd6_def_router[NUM_ND6_DEF_RTR_ENTRY];
static uint_t		def_router_count = 0;				/* Xgɂ郋[^ */

/*
 *  make_mask -- }bvp̃}XN𐶐B
 */

static uint_t
make_mask (int_t index)
{
	uint_t	mask;
	int_t	ix;

	/* }XN𐶐B*/
	mask = 1;
	for (ix = index; ix -- > 0; )
		mask <<= 1;

	return mask;
}

/*
 *  find_pfxlist_reachable_router --
 *      w肵vtBbNXʒm[^Nɑ݂邩`FbNB
 */

static T_DEF_ROUTER *
find_pfxlist_reachable_router (T_ND6_PREFIX *pr)
{
	T_DEF_ROUTER	*dr = NULL;
	T_LLINFO_ND6	*ln;
	uint_t		mask;
	int_t		ix;

	mask = 1;
	for (ix = 0; ix < def_router_count; ix ++) {
		if ((pr->routermap & mask) != 0) {
			if ((ln = nd6_lookup(&nd6_def_router[ix].addr, false)) != NULL &&
			    ND6_IS_LLINFO_PROBREACH(ln))
				return dr;
		}
		mask <<= 1;
	}
	return NULL;
}

/*
 *  pfxlist_onlink_check -- vtBbNXEXg̃INԂ`FbNB
 *
 *    : ̊֐ĂяoƂ́ASEM_ND6_DEFRTRLIST ŁA
 *          bNĂĂяoƁB
 */

static void
pfxlist_onlink_check (void)
{
	T_IFNET		*ifp = IF_GET_IFNET();
	T_ND6_PREFIX	*pr = NULL;
	T_IN6_IFADDR	*ia;
	ER		error;
	int_t		ix;

	for (ix = NUM_ND6_PREFIX_ENTRY; ix -- > 0; ) {
		pr = &nd6_prefix[ix];
		if ((pr->flags & ND6_PREFIX_FLAG_ONLINK) != 0 &&
		    find_pfxlist_reachable_router(pr))
			break;
	}

	if (ix >= 0) {
		/*
		 *  INԂ̃vtBbNXŒ݂Ƃ̏B
		 *  evtBbNX̃INԂAʒmĂ[^
		 *  Ԃɏ]Đݒ肷B
		 */

		
		for (ix = NUM_ND6_PREFIX_ENTRY; ix -- > 0; ) {
			pr = &nd6_prefix[ix];

			if ((pr->flags & ND6_PREFIX_FLAG_ONLINK) == 0)
				continue;

			if ((pr->flags & ND6_PREFIX_STATE_DETACHED) == 0 &&
			    find_pfxlist_reachable_router(pr) == NULL)
				pr->flags |= ND6_PREFIX_STATE_DETACHED;

			if ((pr->flags & ND6_PREFIX_STATE_DETACHED) != 0 &&
			    find_pfxlist_reachable_router(pr) != NULL)
				pr->flags &= ~ND6_PREFIX_STATE_DETACHED;
		}
	}
	else {
		/*
		 *  ǂ̃vtBbNXINł͂ȂA
		 *  fBtHg[^݂ȂƂ̏B
		 *  ׂẴvtBbNXgp\Ԃɐݒ肷B
		 */

		
		for (ix = NUM_ND6_PREFIX_ENTRY; ix -- > 0; ) {
			pr = &nd6_prefix[ix];

			if ((pr->flags & ND6_PREFIX_FLAG_ONLINK) == 0)
				continue;

			if ((pr->flags & ND6_PREFIX_STATE_DETACHED) != 0)
				pr->flags &= ~ND6_PREFIX_STATE_DETACHED;
		}
	}

	/*
	 *  evtBbNXɁAʒmĂ[^̏Ԃ
	 *  IN̏ԂvȂ΁AINԂXVB
	 */
	for (ix = NUM_ND6_PREFIX_ENTRY; ix -- > 0; ) {
		pr = &nd6_prefix[ix];

		if ((pr->flags & ND6_PREFIX_FLAG_ONLINK) == 0)
			continue;

		if ((pr->flags & ND6_PREFIX_STATE_DETACHED) != 0 &&
		    (pr->flags & ND6_PREFIX_STATE_ONLINK  ) != 0) {
			if ((error = nd6_prefix_offlink(pr)) != E_OK)
				syslog(LOG_ERROR, "[ND6 RTR] prefix offlink failed: %s", itron_strerror(error));
		}

		if ((pr->flags & ND6_PREFIX_STATE_DETACHED) == 0 &&
		    (pr->flags & ND6_PREFIX_STATE_ONLINK  ) == 0 &&
		    (pr->flags & ND6_PREFIX_FLAG_ONLINK   ) == 0) {
			if ((error = nd6_prefix_onlink(pr)) != E_OK)
				syslog(LOG_ERROR, "[ND6 RTR] prefix onlink failed: %s", itron_strerror(error));
		}
	}

	/*
	 *  NɃvtBbNXʒmĂ郋[^
	 *  ȂƂ 1 䑶݂邩mFB
	 */
	for (ix = NUM_IN6_IFADDR_ENTRY; ix -- > 0; ) {
		ia = &ifp->in_ifaddrs[ix];
		if ((ia->flags & (IN6_IFF_DEFINED | IN6_IFF_AUTOCONF)) != 0 &&
		     ia->prefix_index != ND6_PREFIX_IX_INVALID) {
			pr = &nd6_prefix[ia->prefix_index];
			if (find_pfxlist_reachable_router(pr) != NULL)
				break;
		}
	}

	if (ix >= 0) {
		/*
		 *  NɃvtBbNXʒmĂ郋[^
		 *  ȂƂ 1 䑶݂鎞̏B
		 */
		for (ix = NUM_IN6_IFADDR_ENTRY; ix -- > 0; ) {
			ia = &ifp->in_ifaddrs[ix];
			if ((ia->flags & (IN6_IFF_DEFINED | IN6_IFF_AUTOCONF)) != 0 &&
			     ia->prefix_index != ND6_PREFIX_IX_INVALID) {
				pr = &nd6_prefix[ia->prefix_index];
				if (find_pfxlist_reachable_router(pr) != NULL)
					ia->flags &= ~IN6_IFF_DETACHED;
				else
					ia->flags |= IN6_IFF_DETACHED;
			}
		}
	}
	else {
		/*
		 *  NɃvtBbNXʒmĂ郋[^
		 *  1 䑶݂Ȃ͑SẴAhX𗘗pł悤ɂB
		 */
		for (ix = NUM_IN6_IFADDR_ENTRY; ix -- > 0; ) {
			ia = &ifp->in_ifaddrs[ix];
			if ((ia->flags & (IN6_IFF_DEFINED | IN6_IFF_AUTOCONF)) != 0)
				ia->flags &= ~IN6_IFF_DETACHED;
		}
	}
}

/*
 *  pfxrtr_add -- vtBbNXGgƃfBtHg[^EGgNB
 *
 *    : ̊֐ĂяoƂ́ASEM_ND6_DEFRTRLIST ŁA
 *          bNĂĂяoƁB
 */

static void
pfxrtr_add (int_t prefix_index, int_t rtr_index)
{
	/*  vtBbNXGgƃfBtHg[^EGgNB*/
	nd6_prefix[prefix_index].routermap |= make_mask(rtr_index);
	nd6_def_router[rtr_index].plistmap |= make_mask(prefix_index);

	pfxlist_onlink_check();
}

/*
 *  nd6_pfxrtr_lookup -- vtBbNXGg烋[^TB
 */

static uint_t
pfxrtr_lookup (const T_ND6_PREFIX *pr, int_t rtr_index)
{
	return (pr->routermap & make_mask(rtr_index)) == 0 ? IN6_RTR_IX_UNREACH : rtr_index;
}

/*
 *  defrouter_select -- DfBtHgE[^IȂB
 *
 *    : ̊֐ĂяoƂ́ASEM_ND6_DEFRTRLIST ŁA
 *          bNĂĂяoƁB
 */

static void
defrouter_select (void)
{
	T_DEF_ROUTER	*dr = NULL, router;
	T_LLINFO_ND6	*ln;
	int_t		ix, tix;

	for (ix = 0; ix < def_router_count; ix ++) {
		dr = &nd6_def_router[ix];
		if ((ln = nd6_lookup(&dr->addr, false)) != NULL && ND6_IS_LLINFO_PROBREACH(ln)) {
		
			/* I[^擪ɈڂB*/
			router = *dr;
			for (tix = ix; tix > 0; tix --)
				nd6_def_router[tix] = nd6_def_router[tix - 1];
			nd6_def_router[0] = router;
			break;
		}
	}
}

/*
 *  defrtrlist_update -- fBtHg[^EXgXVB
 *
 *  	߂ĺA[^̃CfbNXB
 *      Al -1 ȂAvtBbNXEXg͍XVȂB
 */

static int_t
defrtrlist_update (T_IN6_ADDR *src, uint32_t lifetime, uint8_t flags)
{
	T_DEF_ROUTER	*dr, *fdr = NULL;
	SYSTIM		now;
	int_t		ix;

	syscall(get_tim(&now));
	syscall(wai_sem(SEM_ND6_DEFRTRLIST));

	/* o^ςׂB*/
	if ((fdr = nd6_defrtrlist_lookup(src)) != NULL) {
		/* o^ς݂̏ꍇ̏ */
		if (lifetime == 0) {
			nd6_defrtrlist_del(fdr);
			syscall(sig_sem(SEM_ND6_DEFRTRLIST));
			return -1;
		}
		else {
			fdr->lifetime = lifetime * SYSTIM_HZ;		/* lifetime ̒Pʂ͕b */
			fdr->flags    = flags;
			fdr->expire   = now + fdr->lifetime;
			syscall(sig_sem(SEM_ND6_DEFRTRLIST));
			return fdr - nd6_def_router;
		}
	}
	else if (lifetime == 0) {
		syscall(sig_sem(SEM_ND6_DEFRTRLIST));
		return -1;
	}

	if (fdr == NULL && def_router_count < NUM_ND6_DEF_RTR_ENTRY) {
		/*
		 *  def_router_count < NUM_ND6_DEF_RTR_ENTRY ł΁A
		 *  nd6_def_router[def_router_count]; 󂫃Gg
		 */
		fdr = &nd6_def_router[def_router_count];
	}

	/* 󂫃GgȂ΁ALԂZGg폜B*/
	if (fdr == NULL) {
		T_DEF_ROUTER	*sdr = NULL;
		int32_t		diff, sdiff = 0xffffffff;

		for (ix = def_router_count; ix -- > 0; ) {
			dr = &nd6_def_router[ix];
			diff = (int32_t)(dr->expire - now);
			if (diff <= 0) {	/* dr->expire <= now */
				/* ɁALԂ߂ĂB*/
				sdr = dr;
				break;
			}
			else if (diff < sdiff)
				sdr = dr;
		}
		if (sdr != NULL) {
			fdr = sdr;
			nd6_defrtrlist_del(fdr);
		}
	}

	/* eoɒlݒ肷B*/
	fdr->plistmap = 0;
	fdr->addr     = *src;
	fdr->lifetime = lifetime * SYSTIM_HZ;		/* lifetime ̒Pʂ͕b */
	fdr->flags    = flags;
	fdr->expire   = now + fdr->lifetime;
	fdr->state    = ND6_DEF_RTR_BUSY;
	def_router_count ++;

	/*
	 *  fBtHg[^Ƃēo^邪A
	 *  ɃfBtHg[^ΑIȂȂB
	 */
	if (fdr - nd6_def_router != 0)
		defrouter_select();

	syscall(sig_sem(SEM_ND6_DEFRTRLIST));
	return fdr - nd6_def_router;
}

/*
 *  in6_ifadd -- C^tF[XɃAhXǉB
 */

static ER
in6_ifadd (T_ND6_PREFIX *pr, T_IN6_IFADDR *ia, int_t router_index)
{
	T_IFNET		*ifp = IF_GET_IFNET();
	T_IN6_ADDR	mask, addr;
	T_IN6_IFADDR	*lla;
	int_t		ix;

	lla = &ifp->in_ifaddrs[IPV6_IFADDR_IX_LINKLOCAL];

	/*
	 *  N[JAhXo^łΉȂB
	 */
	if ((lla->flags & IN6_IFF_DEFINED) == 0)
		return E_OBJ;

	/*
	 *  [^ʒmꂽvtBbNXA
	 *  N[JAhX̃vtBbNX
	 *  قȂĂ΃G[
	 */
	if (lla->prefix_len != pr->prefix_len)
		return E_PAR;

	/* vtBbNX}XN𐶐B*/
	in6_plen2pmask(&mask, pr->prefix_len);

	/* AhX𐶐B*/
	for (ix = 0; ix < 4; ix ++)
		addr.s6_addr32[ix] = (pr->prefix.s6_addr32[ix] &  mask.s6_addr32[ix])
		                   | ( lla->addr.s6_addr32[ix] & ~mask.s6_addr32[ix]);

	/* tOB*/
	ia->flags = 0;

	return in6_update_ifa(ifp, ia, &addr,
	                      pr->prefix_len, pr->vltime, pr->pltime,
	                      router_index, pr - nd6_prefix, IN6_IFF_AUTOCONF);
}

/*
 *  nd6_prefix_lookup -- vtBbNXTB
 */

static T_ND6_PREFIX *
nd6_prefix_lookup (const T_IN6_ADDR *prefix, uint_t plen)
{
	T_ND6_PREFIX	*pr;
	int_t		ix;

	for (ix = NUM_ND6_PREFIX_ENTRY; ix -- > 0; ) {
		pr = &nd6_prefix[ix];
		if ((pr->flags & ND6_PREFIX_STATE_BUSY) &&
		     pr->prefix_len == plen && IN6_ARE_ADDR_EQUAL(&pr->prefix, prefix))
			return pr;
	}

	return NULL;
}

/*
 *  prelist_remove -- vtBbNXXgvtBbNX폜B
 *
 *    : ̊֐ĂяoƂ́ASEM_ND6_DEFRTRLIST ŁA
 *          bNĂĂяoƁB
 */

static void
prelist_remove (T_ND6_PREFIX *pr)
{
	ER	error = E_OK;
	uint_t	mask;
	int_t	rix;

	/* LԐ؂ɂB*/
	pr->vltime = 0;
	pr->pltime = 0;

	if ((pr->flags & ND6_PREFIX_STATE_ONLINK) != 0 &&
	    (error = nd6_prefix_offlink(pr)) != E_OK) {
		syslog(LOG_ERROR, "[ND6 RTR] prefix remove failed: %s", itron_strerror(error));
		return;
	}

	/*  vtBbNXGgƃfBtHg[^EGg̃NB*/
	pr->routermap = 0;
	mask = make_mask(pr - nd6_prefix);
	for (rix = def_router_count; rix --; )
		nd6_def_router[rix].plistmap &= ~mask;

	/* vtBbNX𖳌ɂB*/
	pr->flags &= ~ND6_PREFIX_STATE_BUSY;

	pfxlist_onlink_check();
}

/*
 *  nd6_prefix_onlink -- vtBbNXINɐݒ肵AAhXgp\ɂB
 *
 *    : ̊֐ĂяoƂ́ASEM_ND6_DEFRTRLIST ŁA
 *          bNĂĂяoƁB
 */

ER
nd6_prefix_onlink (T_ND6_PREFIX *pr)
{
	T_IFNET		*ifp = IF_GET_IFNET();
	T_IN6_IFADDR	*lla, *ia = NULL;
	int_t		ix;

	/* ɃINԂɂȂĂꍇ̓G[B*/
	if ((pr->flags & ND6_PREFIX_STATE_ONLINK) != 0)
		return E_OBJ;

	/* N[JAhXo^łΉȂB*/
	lla = &ifp->in_ifaddrs[IPV6_IFADDR_IX_LINKLOCAL];
	if ((lla->flags & IN6_IFF_DEFINED) == 0)
		return E_OK;

	/*
	 *  w肳ꂽvtBbNX蓖ĂĂC^tF[X
	 *  AhXTB
	 */
	for (ix = NUM_IN6_IFADDR_ENTRY; ix --; ) {
		ia = &ifp->in_ifaddrs[ix];
		if (ia->prefix_index == (pr - nd6_prefix))
			break;
	}

	if (ix >= 0) {

		/* AhXgp\ɂB*/
		ia->flags &= ~IN6_IFF_DETACHED;

		/* vtBbNXINɐݒ肷B*/
		pr->flags |= ND6_PREFIX_STATE_ONLINK;
	}

	return E_OK;
}

/*
 *  nd6_prefix_offlink -- vtBbNXItNɐݒ肵AAhXgpsɂB
 *
 *    : ̊֐ĂяoƂ́ASEM_ND6_DEFRTRLIST ŁA
 *          bNĂĂяoƁB
 */

ER
nd6_prefix_offlink (T_ND6_PREFIX *pr)
{
	T_IFNET		*ifp = IF_GET_IFNET();
	T_IN6_IFADDR	*ia = NULL;
	int_t		ix;

	/* ɃItNԂɂȂĂꍇ̓G[B*/
	if ((pr->flags & ND6_PREFIX_STATE_ONLINK) == 0)
		return E_OBJ;

	/*
	 *  w肳ꂽvtBbNX蓖ĂĂC^tF[X
	 *  AhXTB
	 */
	for (ix = NUM_IN6_IFADDR_ENTRY; ix --; ) {
		ia = &ifp->in_ifaddrs[ix];
		if (ia->prefix_index == (pr - nd6_prefix))
			break;
	}

	if (ix >= 0) {

		/* AhXgpsɂB*/
		ia->flags |= IN6_IFF_DETACHED;

		/* vtBbNXItNɐݒ肷B*/
		pr->flags &= ~ND6_PREFIX_STATE_ONLINK;
	}

	return E_OK;
}

/*
 *  in6_init_prefix_ltimes -- vtBbNX̗LԂݒ肷B
 */

static ER
in6_init_prefix_ltimes (T_ND6_PREFIX *pr)
{
	SYSTIM		now;

	/* LԂLԂ蒷Ƃ̓G[ */
	if (pr->pltime > pr->vltime)
		return E_PAR;

	syscall(get_tim(&now));
	now /= SYSTIM_HZ;

	if (pr->pltime == ND6_INFINITE_LIFETIME)
		pr->preferred = 0;
	else
		pr->preferred = pr->pltime + now;

	if (pr->vltime == ND6_INFINITE_LIFETIME)
		pr->expire = 0;
	else
		pr->expire = pr->vltime + now;

	return E_OK;
}

/*
 *  nd6_prelist_add -- vtBbNXXgɃvtBbNXǉB
 *
 *    : ̊֐ĂяoƂ́ASEM_ND6_DEFRTRLIST ŁA
 *          bNĂĂяoƁB
 */

static T_ND6_PREFIX *
nd6_prelist_add (T_ND_OPT_PREFIX_INFO *pi, int_t rtr_index)
{
	T_ND6_PREFIX	*pr = NULL;
	int_t		ix;
	ER		error;

	/* vtBbNXXg󂫂̃vtBbNXGgTB*/
	for (ix = NUM_ND6_PREFIX_ENTRY; ix --; ) {
		pr = &nd6_prefix[ix];
		if ((pr->flags & ND6_PREFIX_STATE_BUSY) == 0)
			break;
	}

	/* vtBbNXXgɋ󂫂Ȃ΃G[ */
	if (ix < 0)
		return NULL;

	pr->flags |= ND6_PREFIX_STATE_BUSY;

	/* vtBbNXǉB*/
	pr->prefix     = pi->prefix;
	pr->prefix_len = pi->prefix_len;

	/* tOݒ肷B*/
	if ((pi->flags & ND_OPT_PI_FLAG_ONLINK) != 0)
		pr->flags |= ND6_PREFIX_FLAG_ONLINK;
	if ((pi->flags & ND_OPT_PI_FLAG_AUTO) != 0)
		pr->flags |= ND6_PREFIX_FLAG_AUTO;

	/* vtBbNX̗LԂݒ肷B*/
	pr->vltime = ntohl(pi->valid);
	pr->pltime = ntohl(pi->preferred);
	in6_init_prefix_ltimes(pr);

	if ((pr->flags & ND6_PREFIX_FLAG_ONLINK) != 0) {
		if ((error = nd6_prefix_onlink(pr)) != E_OK)
			return NULL;
	}

	/* [^}bvB*/
	pr->routermap = 0;

	/* [^ǉB*/
	pfxrtr_add(pr - nd6_prefix, rtr_index);

	return pr;
}

/*
 *  prelist_update -- vtBbNXEXgXVB
 */

static void
prelist_update (T_ND_OPT_PREFIX_INFO *pi, uint_t router_index)
{
	T_IFNET		*ifp = IF_GET_IFNET();
	T_ND6_PREFIX	*pr;
	T_IN6_IFADDR	*ia = NULL;
	int_t		ix, ifidlen;

	syscall(wai_sem(SEM_ND6_DEFRTRLIST));
	if ((pr = nd6_prefix_lookup(&pi->prefix, pi->prefix_len)) != NULL) {
		/*
		 *  o^ς݂̏ꍇ́AvtBbNXXgXVB
		 */

		/*
		 *  tO̍XV̒:
		 *    on-link rbg autonomous rbg
		 *    1  0 ɕύXĂ͂ȂȂB
		 */

		if ((pi->flags & ND_OPT_PI_FLAG_ONLINK) != 0)
			pr->flags |= ND6_PREFIX_FLAG_ONLINK;
		if ((pi->flags & ND_OPT_PI_FLAG_AUTO) != 0)
			pr->flags |= ND6_PREFIX_FLAG_AUTO;

		if ((pi->flags & ND_OPT_PI_FLAG_ONLINK) != 0) {
			/*
			 *  ʒmꂽvtBbNXIN̎́A
			 *  LԂXVB
			 */
			pr->vltime = ntohl(pi->valid);
			pr->pltime = ntohl(pi->preferred);
			in6_init_prefix_ltimes(pr);
		}

		if ((pi->flags & ND_OPT_PI_FLAG_ONLINK  ) != 0 &&
		    (pr->flags & ND6_PREFIX_STATE_ONLINK) == 0) {
			/*
			 *  ItÑvtBbNXINɂȂ̏sB
			 */
			if (nd6_prefix_onlink(pr) != E_OK) {
				syscall(sig_sem(SEM_ND6_DEFRTRLIST));
				syslog(LOG_ERROR, "[ND6 RTR] prefix update failed.");
				return;
			}
		}

		if (router_index != IN6_RTR_IX_UNREACH && pfxrtr_lookup(pr, router_index) == IN6_RTR_IX_UNREACH)
			pfxrtr_add(pr - nd6_prefix, router_index);
	}
	else {	/* o^̏ꍇ */

		/* L 0 ̃vtBbNX͒ǉȂB*/
		if (pi->valid == 0) {
			syscall(sig_sem(SEM_ND6_DEFRTRLIST));
			return;
		}

		/* ItNŃAhXݒɎgpȂΒǉȂB*/
		if ((pi->flags & (ND_OPT_PI_FLAG_ONLINK | ND_OPT_PI_FLAG_AUTO)) !=
		                 (ND_OPT_PI_FLAG_ONLINK | ND_OPT_PI_FLAG_AUTO)) {
			syscall(sig_sem(SEM_ND6_DEFRTRLIST));
			return;
		}

		/* vtBbNXǉB*/
		if ((pr = nd6_prelist_add(pi, router_index)) == NULL) {
			syslog(LOG_ERROR, "[ND6 RTR] prefix add failed.");
			syscall(sig_sem(SEM_ND6_DEFRTRLIST));
			return;
		}

		if ((pr->flags & ND6_PREFIX_FLAG_ONLINK) == 0) {
			/*
			 *  ItNEvtBbNX̏ꍇ́ALԂ 0 ɐݒ肷B
			 *  ƂŗL؂ƂȂAXg폜B
			 */
			pr->vltime = 0;
			pr->pltime = 0;
			in6_init_prefix_ltimes(pr);
		}
	}

	/*
	 *  Xe[gXEAhXݒsB
	 */
	if ((pr->flags & ND6_PREFIX_FLAG_AUTO) == 0) {
		syscall(sig_sem(SEM_ND6_DEFRTRLIST));
		return;
	}

	/*
	 *  ʒmꂽvtBbNX蓖ĂĂC^tF[X
	 *  AhXTB
	 */
	for (ix = NUM_IN6_IFADDR_ENTRY; ix --; ) {
		ia = &ifp->in_ifaddrs[ix];
		if ((ia->flags & IN6_IFF_DEFINED) != 0 &&
		    ia->prefix_len == pr->prefix_len &&
		    in6_are_prefix_equal(&ia->addr, &pr->prefix, pr->prefix_len))
			break;
	}

	if (ix >= 0) {	/* o^ς݂̂Ƃ */
		if ((ia->flags & IN6_IFF_AUTOCONF) == 0) {
			/*
			 *  Xe[gXEAhXݒɂ
			 *  ݒ肳ĂȂ΍XVȂB
			 */
			;
		}
		else if (ia->flags & IN6_IFF_TENTATIVE) {
			/*
			 *  doȂXVȂB
			 */
			;
		}
		else {
			T_IN6_ADDR	mask, addr;
			T_IN6_IFADDR	*lla;
			uint32_t		vltime;
			SYSTIM		now;
			int_t		ix;

			/* LԂݒ肷B*/
			syscall(get_tim(&now));

			if (ia->lifetime.vltime == ND6_INFINITE_LIFETIME)
				vltime = ND6_INFINITE_LIFETIME;
			else if (IFA6_IS_INVALID(ia, now))
				vltime = 0;
			else
				vltime = ia->lifetime.expire - now / SYSTIM_HZ;

			if (pr->vltime > (2 * 60 * 60) || pr->vltime > vltime) {
				/*
				 *  lifetime.expireApi->valid (L) 
				 *  pi->preferred (L) ̒Pʂ [s]B
				 *  ʒmꂽLԂ 2 ԈȏォA݂̎c莞Ԃ
				 *  ΁AVLԂɂ́AʒmꂽLԂݒ肷B
				 */
				vltime = pr->vltime;
			}
			else if (vltime <= (2 * 60 * 60))
				;
			else {
				/*
				 *  IPsec ͖̂߁A2 Ԃݒ肷B
				 */
				vltime = 2 * 60 * 60;
			}

			lla = &ifp->in_ifaddrs[IPV6_IFADDR_IX_LINKLOCAL];

			/* vtBbNX}XN𐶐B*/
			in6_plen2pmask(&mask, pr->prefix_len);

			/* AhX𐶐B*/
			for (ix = 0; ix < 4; ix ++)
				addr.s6_addr32[ix] = (pr->prefix.s6_addr32[ix] &  mask.s6_addr32[ix])
				                   | ( lla->addr.s6_addr32[ix] & ~mask.s6_addr32[ix]);

			in6_update_ifa(ifp, ia, &addr, pr->prefix_len, vltime,
			               pr->pltime, router_index, pr - nd6_prefix,
			               IN6_IFF_AUTOCONF | IN6_IFF_NODAD);
		}
	}

	else { /* o^̂Ƃ */

		/*
		 *  vtBbNX`FbNB
		 *  AvtBbNXƃC^tF[X ID ̍v
		 *  128 rbgɈvȂ́AvtBbNX𖳎B
		 */
		if ((ifidlen = in6_if2idlen(ifp)) < 0)
			syslog(LOG_ERROR, "[ND6 RTR] IFID undefined.");
		else if (ifidlen + pr->prefix_len != 128)
			syslog(LOG_NOTICE, "[ND6 RTR] invalid prefix len: %d.", pr->prefix_len);
		else {

			for (ix = NUM_IN6_IFADDR_ENTRY; ix --; ) {
				ia = &ifp->in_ifaddrs[ix];
				if ((ia->flags & IN6_IFF_DEFINED) == 0) {
					in6_ifadd(pr, ia, router_index);
					pfxlist_onlink_check();
					break;
				}
			}

			if (ix < 0)
				syslog(LOG_ERROR, "[ND6 RTR] prefix update failed.");
		}
	}
	syscall(sig_sem(SEM_ND6_DEFRTRLIST));
}

/*
 *  nd6_prelist_timer -- vtBbNXEXg̊Ǘ^C}[
 */

void
nd6_prelist_timer (void)
{
	T_ND6_PREFIX	*pr;
	SYSTIM		now;
	int_t		ix;

	syscall(get_tim(&now));
	now /= SYSTIM_HZ;		/* LԂ̒Pʂ [s] */

	syscall(wai_sem(SEM_ND6_DEFRTRLIST));
	for (ix = NUM_ND6_PREFIX_ENTRY; ix -- > 0; ) {
		pr = &nd6_prefix[ix];
		if ((pr->flags & ND6_PREFIX_STATE_BUSY) != 0 && (int32_t)(pr->expire - now) <= 0)
		                                                       /* pr->expire <= now */
			prelist_remove(pr);
	}
	syscall(sig_sem(SEM_ND6_DEFRTRLIST));
}

/*
 *  nd6_rs_output -- [^vo͂B
 */

static void
nd6_rs_output (void)
{
	T_ROUTER_SOLICIT_HDR	*rsh;
	T_NET_BUF		*output;
	T_IN6_IFADDR		*ifa;
	T_IN6_ADDR		*saddr;
	uint16_t		len;

	NET_COUNT_ICMP6(net_count_nd6[NC_ND6_RS_OUT_PACKETS], 1);

	/*
	 *  MAhXɂ́AN[JAhXݒ肷邪A
	 *  ܂ݒ肳ꂢȂ΁Awݒ肷B
	 */
	if ((ifa = in6ifa_ifpwithix(IF_GET_IFNET(), IPV6_IFADDR_IX_LINKLOCAL)) != NULL && !IFA6_IS_NOTREADY(ifa))
		saddr = &ifa->addr;
	else
		saddr = &in6_addr_unspecified;

	len = (ROUTER_SOLICIT_HDR_SIZE + 7) >> 3 << 3;

	/* lbg[Nobt@lAIPv6 wb_ݒ肷B*/
	if (in6_get_datagram(&output, len, 0, &in6_addr_linklocal_allrouters,
	                     saddr, IPPROTO_ICMPV6,
	                     IPV6_MAXHLIM, NBA_SEARCH_ASCENT, TMO_ND6_RS_OUTPUT) != E_OK)
		return;

 	/* [^vwb_ݒ肷B*/
 	rsh = GET_ROUTER_SOLICIT_HDR(output, IF_IP6_ROUTER_SOLICIT_HDR_OFFSET);
 	rsh->hdr.type       = ND_ROUTER_SOLICIT;
 	rsh->hdr.code       = 0;
 	rsh->nd_rs_reserved = 0;

	/* `FbNTvZB*/
	rsh->hdr.sum = 0;
	rsh->hdr.sum = in6_cksum(output, IPPROTO_ICMPV6, (uint8_t*)rsh - output->buf, len);

	/* MB*/
	NET_COUNT_ICMP6(net_count_nd6[NC_ICMP6_OUT_OCTETS],
	               output->len - GET_IF_IP6_HDR_SIZE(output));
	NET_COUNT_ICMP6(net_count_nd6[NC_ICMP6_OUT_PACKETS], 1);
	NET_COUNT_MIB(icmp6_ifstat.ipv6IfIcmpOutMsgs, 1);
	NET_COUNT_MIB(icmp6_ifstat.ipv6IfIcmpOutRouterSolicits, 1);
	ip6_output(output, IPV6_OUT_SET_HOP_LIMIT(IPV6_OUT_FLG_HOP_LIMIT, IPV6_MAXHLIM), TMO_ND6_RS_OUTPUT);
}

/*
 *  nd6_defrtrlist_lookup -- fBtHg[^EXgTB
 */

T_DEF_ROUTER *
nd6_defrtrlist_lookup (T_IN6_ADDR *src)
{
	T_DEF_ROUTER	*dr = NULL;
	int_t		ix;

	for (ix = def_router_count; ix -- > 0; ) {
		dr = &nd6_def_router[ix];
		if (IN6_ARE_ADDR_EQUAL(&dr->addr, src)) {
			return dr;
		}
	}
	return NULL;
}

/*
 *  nd6_router_lookup -- [^̃AhXԂB
 *
 */

T_IN6_ADDR *
nd6_router_lookup (void)
{
	if (def_router_count > 0)
		return &nd6_def_router[0].addr;
	else
		return NULL;
}

/*
 *  nd6_defrtrlist_del -- fBtHg[^EXg烋[^폜B
 *
 *    : ̊֐ĂяoƂ́ASEM_ND6_DEFRTRLIST ŁA
 *          bNĂĂяoƁB
 */

void
nd6_defrtrlist_del (T_DEF_ROUTER *dr)
{
	T_IFNET		*ifp = IF_GET_IFNET();
	T_IN6_IFADDR	*ia;
	T_ND6_PREFIX	*pr;
	uint_t		mask;
	int_t		ix, rix, pix, rtrix = dr - nd6_def_router;

	if ((ia = in6ifa_ifpwithrtrix(ifp, rtrix)) != NULL) {
		/*
		 *  lbg[NC^tF[X̃vtBbNXʒm
		 *  [^𓞒Bs\ɂB
		 */
		ia->router_index = IN6_RTR_IX_UNREACH;
	}

	/* vtBbNXXg烋[^폜B*/
	mask = make_mask(rtrix);
	for (pix = NUM_ND6_PREFIX_ENTRY; pix --; )
		nd6_prefix[pix].routermap &= ~mask;

	/* 폜[^ȍ~Oɋl߂B*/
	for (rix = rtrix + 1; rix < def_router_count; rix ++)
		nd6_def_router[rix - 1] = nd6_def_router[rix];

	/* vtBbNXXg̃[^XVB*/
	if (dr != nd6_def_router) {

		/* }XN𐶐B*/
		mask = 1;
		for (ix = rtrix - 1; ix -- > 0; )
			mask = (mask << 1) | 1;

		for (pix = NUM_ND6_PREFIX_ENTRY; pix --; ) {
			pr = &nd6_prefix[pix];
			pr->routermap = (pr->routermap & mask) | (((pr->routermap & ~mask) >> 1) & ~mask);
		}
	}
	def_router_count --;

	/* vtBbNX̃INԂmFB*/
	pfxlist_onlink_check();

	/*
	 *  폜郋[^DfBtHg[^̏ꍇ́A
	 *  DfBtHg[^IȂB
	 */
	if (rtrix == 0)
		defrouter_select();
}

/*
 *  nd6_defrtrlist_timer -- fBtHg[^EXg̊Ǘ^C}[
 */

void
nd6_defrtrlist_timer (void)
{
	T_DEF_ROUTER	*dr;
	SYSTIM		now;
	int_t		ix;

	syscall(get_tim(&now));

	syscall(wai_sem(SEM_ND6_DEFRTRLIST));
	for (ix = def_router_count; ix -- > 0; ) {
		dr = &nd6_def_router[ix];
		if ((int32_t)(dr->expire - now) <= 0) {
		           /* dr->expire <= now */
			nd6_defrtrlist_del(dr);
		}
	}
	syscall(sig_sem(SEM_ND6_DEFRTRLIST));
}

/*
 *  nd6_get_drl -- fBtHg[^EXglB
 */

const T_DEF_ROUTER *
nd6_get_drl (uint_t *count)
{
	*count = def_router_count;
	return nd6_def_router;
}

/*
 *  nd6_get_prl -- vtBbNXEXglB
 */

const T_ND6_PREFIX *
nd6_get_prl (void)
{
	return nd6_prefix;
}

#endif	/* of #if NUM_ND6_DEF_RTR_ENTRY > 0 */

/*
 *  nd6_ra_input -- [^ʒm̓͏B
 */

void
nd6_ra_input (T_NET_BUF *input, uint_t off)
{
#if NUM_ND6_DEF_RTR_ENTRY > 0

	T_IFNET			*ifp = IF_GET_IFNET();
	T_IP6_HDR		*ip6h;
	T_ROUTER_ADVERT_HDR	*rah;
	T_ND_OPT_HDR		*opth;
	SYSTIM			now;
	int_t			rix;
	uint_t			lladdr_len = 0;
	uint32_t		advrea;
	uint8_t			*lladdr = NULL;
	uint8_t			nd_opt_off[ND_OPT_OFF_ARRAY_SIZE];

	NET_COUNT_ICMP6(net_count_nd6[NC_ND6_RA_IN_PACKETS], 1);

	ip6h = GET_IP6_HDR(input);

	/*
	 *  wb_̃`FbNAȉ̏ꍇ͔jB
	 *    Ezbv~bg IPV6_MAXHLIM (255) ȊO
	 *    Ewb_Z
	 *    En_AhXAN[Jł͂Ȃ (RFC2461)
	 */
	if (ip6h->hlim != IPV6_MAXHLIM                ||
	    input->len - off < ROUTER_ADVERT_HDR_SIZE ||
	    !IN6_IS_ADDR_LINKLOCAL(&ip6h->src))
		goto err_ret;

	rah  = GET_ROUTER_ADVERT_HDR(input, off);

	/* ߗגTIvṼItZbgL^B*/
	if (nd6_options(nd_opt_off, input->buf + (off + ROUTER_ADVERT_HDR_SIZE),
	                            input->len - (off + ROUTER_ADVERT_HDR_SIZE)) != E_OK)
		goto err_ret;
	/*
	 *  B\Ԃ̗LԂ̍XV

	 */
	if (rah->reachable) {
		advrea = ntohl(rah->reachable) * SYSTIM_HZ / 1000;	/* rah->reachable ̒Pʂ ms */
		if (advrea <= ND6_MAX_REACHABLE_TIME &&
		    advrea != nd6_base_reachable_time) {
			syscall(get_tim(&now));
			nd6_recalc_reachtm_interval
				= now + ND6_RECALC_REACHTM_INTERVAL;
			nd6_base_reachable_time	= advrea;
			nd6_reachable_time
				= ND6_CALC_REACH_TIME(nd6_base_reachable_time);
		}
	}

	/* ߗגT̑MԊu̍XV */
	if (rah->retransmit) {
		nd6_retrans_time = ntohl(rah->retransmit) * SYSTIM_HZ / 1000;
									/* rah->retransmit ̒Pʂ ms */
	}

	/* zbv~bg̋Kl̍XV */
	if (rah->nd_ra_current_hoplimit) {
		ip6_defhlim = rah->nd_ra_current_hoplimit;
	}

	/* fBtHg[^Xg̍XV */
	rix = defrtrlist_update(&ip6h->src,
	                       ntohs(rah->nd_ra_router_lifetime),
	                       rah->nd_ra_flags);		/* rah->nd_ra_router_lifetime ̒Pʂ͕b */

	/* vtBbNXXg̍XV */
	if (nd_opt_off[ND_OPT_OFF_ARRAY_IX(ND_OPT_PREFIX_INFO_COUNT)]) {
		T_ND_OPT_PREFIX_INFO	*pi;
		uint_t			pi_off, pi_count;

		pi_count = nd_opt_off[ND_OPT_OFF_ARRAY_IX(ND_OPT_PREFIX_INFO_COUNT)];
		pi_off   = off + ROUTER_ADVERT_HDR_SIZE
		               + nd_opt_off[ND_OPT_OFF_ARRAY_IX(ND_OPT_PREFIX_INFORMATION)] - 8;
	 	/* : IvVItZbgzɂ́AItZbg + 8 ݒ肳ĂB*/
		while (pi_count -- > 0) {
			pi = (T_ND_OPT_PREFIX_INFO*)(input->buf + pi_off);
			if (pi->type != ND_OPT_PREFIX_INFORMATION)
				/* IvV^CvvtBbNXłȂΉȂB*/
				;
			else if (pi->len != 4)
			    	/* vtBbNX̒ 32 (8~4) łȂΕs */
				syslog(LOG_NOTICE, "[ND6 RTR] prefix opt len: %d.", pi->len);
			else if (pi->prefix_len > 128)
				/* vtBbNX 128 rbgȉ */
				syslog(LOG_NOTICE, "[ND6 RTR] prefix len: %d.", pi->prefix_len);
			else if (IN6_IS_ADDR_MULTICAST(&pi->prefix) ||
			         IN6_IS_ADDR_LINKLOCAL(&pi->prefix))
				/* }`LXgƃN[J͕s */
				syslog(LOG_NOTICE, "[ND6 RTR] invalid addr: %s from %s.",
				                   ipv62str(NULL, &pi->prefix), ipv62str(NULL, &ip6h->src));
#if 0	/* FreeBSD 6.3 ō폜ĂB*/
			else if (IN6_IS_ADDR_AGGREGATE_UNICAST(&pi->prefix) &&		
			         (pi->prefix_len != 64)                       )
				/* W\jLXgŁAvtBbNX 64 rbgȊO͕s */
				syslog(LOG_NOTICE, "[ND6 RTR] invalid prefix len for global: %d.", pi->prefix_len);
#endif
			else if (ntohl(pi->preferred) > ntohl(pi->valid))
				/* LԂLԂ蒷Εs */
				syslog(LOG_NOTICE, "[ND6 RTR] preferred(%d) > valid time(%d).", ntohl(pi->preferred), ntohl(pi->valid));
			else {
				syslog(LOG_NOTICE, "[ND6 RTR] update prefix: %s from %s.",
				                   ipv62str(NULL, &pi->prefix), ipv62str(NULL, &ip6h->src));
				if (rix >= 0) {
					/*
					 *  defrtrlist_update ̖߂ĺA[^̃CfbNXB
					 *  Al -1 ȂAvtBbNXEXg͍XVȂB
					 */
					prelist_update(pi, rix);	/* vtBbNXEXgXVB*/
				}
			}
			pi_off += pi->len << 3;		/* IvV̒Pʂ 8 oCg */
		}
	}

	/* MTU ̍XV */
	if (nd_opt_off[ND_OPT_OFF_ARRAY_IX(ND_OPT_MTU)]) {
		T_ND_OPT_MTU_HDR	*optmtuh;
		uint32_t			mtu;

		optmtuh = (T_ND_OPT_MTU_HDR *)((uint8_t *)(input->buf + off + ROUTER_ADVERT_HDR_SIZE) +
		                               nd_opt_off[ND_OPT_OFF_ARRAY_IX(ND_OPT_MTU)] - 8);

		/*
		 *  l̃`FbN
		 *
		 *    IvV: 1
		 *    \:         0
		 */
		if (optmtuh->len != 1 || optmtuh->reserved != 0)
			goto err_ret;

		/* MTU  IPv6 MMTUi1280 INebgjȉȂ疳B*/
		mtu = ntohl(optmtuh->mtu);
		if (mtu >= IPV6_MMTU) {
			if (mtu <= (linkmtu > IF_MTU ? linkmtu : IF_MTU))
				linkmtu = mtu;
		}
	}

	/*
	 *  [^̎n_NAhXߗ׃LbVɓo^B
	 */
	if (nd_opt_off[ND_OPT_OFF_ARRAY_IX(ND_OPT_SOURCE_LINKADDR)]) {
		opth = (T_ND_OPT_HDR *)((uint8_t *)(input->buf + off + ROUTER_ADVERT_HDR_SIZE) +
		                        nd_opt_off[ND_OPT_OFF_ARRAY_IX(ND_OPT_SOURCE_LINKADDR)] - 8);
	 	/* : IvVItZbgzɂ́AItZbg + 8 ݒ肳ĂB*/
		lladdr     = (uint8_t *)(opth + 1);
		lladdr_len = (opth->len << 3);
	}

	/*
	 *  lbg[NC^tF[X̃AhXvȂ΃G[
	 */
	if (lladdr && lladdr_len != ((sizeof(T_IF_ADDR) + sizeof(T_ND_OPT_HDR) + 7) & ~7))
		goto err_ret;

	/* ߗ׃LbVɓo^B*/
	nd6_cache_lladdr(ifp, &ip6h->src, (T_IF_ADDR *)lladdr, ND_ROUTER_ADVERT, 0);

	/*
	 *  [^̎n_NAhXߗ׃LbVɓo^̂ŁA
	 *  INԂω\邽߁A`FbNB
	 */
	pfxlist_onlink_check();

	syscall(rel_net_buf(input));
	return;

err_ret:
	NET_COUNT_ICMP6(net_count_nd6[NC_ICMP6_IN_ERR_PACKETS], 1);
	syscall(rel_net_buf(input));

#else	/* of #if NUM_ND6_DEF_RTR_ENTRY > 0 */

	/*
	 *  [^ʒmMȂꍇ́AjďIB
	 */
	NET_COUNT_ICMP6(net_count_nd6[NC_ND6_RA_IN_PACKETS], 1);
	syscall(rel_net_buf(input));

#endif	/* of #if NUM_ND6_DEF_RTR_ENTRY > 0 */
}

#if NUM_ND6_RTR_SOL_RETRY > 0

/*
 *  nd6_rtrsol_ctl -- [^vo͂̐
 */

void
nd6_rtrsol_ctl (void)
{
	T_IN6_IFADDR	*ifa;
	int_t		try;

	/* N[JAhX̃AhX𓾂B*/
	if ((ifa = in6ifa_ifpwithix(IF_GET_IFNET(), IPV6_IFADDR_IX_LINKLOCAL)) == NULL)
		return;

	/* N[JAhX̏doI҂B*/
	do {
		/* N[JAhX̏doI҂Ԃݒ肷B*/
		syscall(dly_tsk(net_rand() % TMO_ND6_RTR_SOL_DELAY));

		/* ҂ĂԂɏdoꂽIB*/
		if (ifa->flags & IN6_IFF_DUPLICATED)
			return;

	} while (!((ifa->flags & IN6_IFF_DEFINED) && (ifa->flags & IN6_IFF_TENTATIVE) == 0));

	for (try = 0; try < NUM_ND6_RTR_SOL_RETRY; try ++) {

		/* fBtHg[^EXgɃGgΏI */
		if (def_router_count > 0)
			return;

		/* [^vo͂B*/
		nd6_rs_output();

		/* o͂ 2 ڈȍ~̒xԂݒ肷B*/
		syscall(dly_tsk(TMO_ND6_RTR_SOL_INTERVAL));
	}
}

#endif	/* of #if NUM_ND6_RTR_SOL_RETRY > 0 */

/*
 *  nd6_onlink_prefix_lookup -- vtBbNXTB
 */

T_ND6_PREFIX *
nd6_onlink_prefix_lookup (T_IN6_ADDR *dst)
{
	SYSTIM		now;
	T_ND6_PREFIX	*pr;
	int_t		ix;

	syscall(get_tim(&now));
	now /= SYSTIM_HZ;

	/* Lԓ̃vtBbNXTB*/
	for (ix = NUM_ND6_PREFIX_ENTRY; ix -- > 0; ) {
		pr = &nd6_prefix[ix];
		if ((pr->flags & ND6_PREFIX_STATE_BUSY)  &&
		    (pr->flags & ND6_PREFIX_FLAG_ONLINK) &&
		    in6_are_prefix_equal(dst, &pr->prefix, pr->prefix_len) &&
		    (int32_t)(pr->preferred - now) > 0) {
		           /* pr->preferred > now */
			return pr;
		}
	}

	/* Lԓ̃vtBbNXTB*/
	for (ix = NUM_ND6_PREFIX_ENTRY; ix -- > 0; ) {
		pr = &nd6_prefix[ix];
		if ((pr->flags & ND6_PREFIX_STATE_BUSY)  &&
		    (pr->flags & ND6_PREFIX_FLAG_ONLINK) &&
		    in6_are_prefix_equal(dst, &pr->prefix, pr->prefix_len) &&
		    (int32_t)(pr->expire - now) > 0) {
		           /* pr->expire > now */
			return pr;
		}
	}

	return NULL;
}

#endif /* of #ifdef SUPPORT_INET6 */
