/*
 *  TINET (TCP/IP Protocol Stack)
 * 
 *  Copyright (C) 2001-2009 by Dep. of Computer Science and Engineering
 *                   Tomakomai National College of Technology, JAPAN
 *
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́C̏𖞂ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 *
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: tcp.h,v 1.5 2009/12/24 05:47:21 abe Exp abe $
 */

/*
 * Copyright (c) 1982, 1986, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)tcp.h	8.1 (Berkeley) 6/10/93
 * $FreeBSD: src/sys/netinet/tcp.h,v 1.10.2.1 1999/08/29 16:29:52 peter Exp $
 */
 
#ifndef _TCP_H_
#define _TCP_H_

/*
 *  TCP wb_ARFC 793 Q
 */

typedef struct t_tcp_hdr {
	uint16_t	sport;		/* M|[gԍ			*/
	uint16_t	dport;		/* |[gԍ			*/

	uint32_t	seq;		/* SEQ ԍ				*/

	uint32_t	ack;		/* ACK ԍ				*/

	uint8_t		doff;		/* f[^ItZbg(4rbg)	*/
	uint8_t		flags;		/* tO(6rbg)			*/
	uint16_t	win;		/* EBhTCY			*/

	uint16_t	sum;		/* `FbNT				*/
	uint16_t	urp;		/* ً}|C^				*/
} T_TCP_HDR;

#define TCP_HDR_SIZE			(sizeof(T_TCP_HDR))

/*
 *  TCP wb_\̃oANZX}N
 */

#define TCP_MAKE_DATA_OFF(o)	((uint8_t)(((uint8_t)(o) << 2) & 0xf0))
#define TCP_DATA_OFF(o)		(((uint8_t)(o) & UINT_C(0xf0)) >> 2)
#define TCP_HDR_LEN(o)		(TCP_DATA_OFF(o))

/*
 *  TCP wb_̃tOtB[h̒l̒`
 */

#define TCP_FLG_FIN		UINT_C(0x01)	/* FIN:	ŏI			*/
#define TCP_FLG_SYN		UINT_C(0x02)	/* SYN:				*/
#define TCP_FLG_RST		UINT_C(0x04)	/* RST:	RlNṼZbg	*/
#define TCP_FLG_PUSH		UINT_C(0x08)	/* PUSH:vbV@\		*/
#define TCP_FLG_ACK		UINT_C(0x10)	/* ACK:	m艞		*/
#define TCP_FLG_URG		UINT_C(0x20)	/* URG:	ً}		*/

/*
 *  TCP IvV̒`
 */

/* IvV̌^ */

#define TCP_OPT_EOL		UINT_C(0)	/* ŏI				*/
#define TCP_OPT_NOP		UINT_C(1)	/* Ȃ			*/
#define TCP_OPT_MAXSEG		UINT_C(2)	/* őZOg		*/
#define TCP_OPT_WINDOW		UINT_C(3)	/* EBhXP[O		*/
#define TCP_OPT_SACK_PERM	UINT_C(4)	/* I ACK 		*/
#define TCP_OPT_SACK		UINT_C(5)	/* I ACK			*/
#define TCP_OPT_TIMESTAMP	UINT_C(8)	/* ^CX^v		*/
#define TCP_OPT_CC		UINT_C(11)	/* ڑJEg			*/
#define TCP_OPT_CCNEW		UINT_C(12)	/* ڑJEg			*/
#define TCP_OPT_CCECHO		UINT_C(13)	/* ڑJEg			*/

/* IvV̒ */

#define TCP_OPT_LEN_MAXSEG	4		/* őZOg		*/
#define TCP_OPT_LEN_WINDOW	3		/* EBhXP[O		*/
#define TCP_OPT_LEN_SACK_PERM	4		/* I ACK 		*/
#define TCP_OPT_LEN_SACK	5		/* I ACK			*/
#define TCP_OPT_LEN_TIMESTAMP	10		/* ^CX^v		*/
#define TCP_OPT_LEN_CC		6		/* ڑJEg			*/
#define TCP_OPT_LEN_CCNEW	6		/* ڑJEg			*/
#define TCP_OPT_LEN_CCECHO	6		/* ڑJEg			*/

/*
 *  TCP őZOgTCY
 */

/*
 *  IPv4  TCP őZOgTCY
 *  IP4_MSS  576 ŁAW IPv4 wb_ (20) 
 *  TCP wb_ (20) l 536 ł邪A512 WƂB
 */

#define TCP_MSS			UINT_C(512)

/*
 *  IPv6  TCP őZOgTCY
 *  IPV6_MMTU  1280 ŁAW IPv6 wb_ (40) 
 *  TCP wb_ (20) l 1220 ł邪A1024 WƂB
 */

#define TCP6_MSS		UINT_C(1024)

/*
 *  TCP ŏZOgTCY
 *
 *  256iŏN MTUj- 40 = 216
 */

#define TCP_MINMSS		UINT_C(216)

/*
 *  TCP őEBhETCY
 */

#define MAX_TCP_WIN_SIZE	UINT_C(65535)

#endif	/* of #ifndef _TCP_H_ */
