/*
 *  TINET (TCP/IP Protocol Stack)
 * 
 *  Copyright (C) 2001-2009 by Dep. of Computer Science and Engineering
 *                   Tomakomai National College of Technology, JAPAN
 *
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́C̏𖞂ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 *
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: wwws.h,v 1.5 2009/12/24 05:44:56 abe Exp abe $
 */

#ifndef _WWWS_H_
#define _WWWS_H_

/* 
 *  WWW T[o
 */

#include <tinet_defs.h>

#include <net/if.h>
#include <net/if_ppp.h>
#include <net/if_loop.h>
#include <net/ethernet.h>

#include <netinet6/in6.h>
#include <netinet/ip.h>
#include <netinet/ip6.h>
#include <netinet/tcp.h>

#ifdef TOPPERS_S810_CLG3_85
#define	WWW_SRV_STACK_SIZE		768		/* ^XÑX^bNTCY	*/
#else	/* of #ifdef TOPPERS_S810_CLG3_85 */
#define	WWW_SRV_STACK_SIZE		1024		/* ^XÑX^bNTCY	*/
#endif	/* of #ifdef TOPPERS_S810_CLG3_85 */
#define WWW_SRV_MAIN_PRIORITY		5		/* ^XN̗Dx		*/

/*
 *  TCP MEChobt@TCY
 */

#if defined(NUM_MPF_NET_BUF_IF_PDU) && NUM_MPF_NET_BUF_IF_PDU > 0

#define WWW_SRV_SWBUF_SIZE	((IF_MTU-(IP_HDR_SIZE+TCP_HDR_SIZE))*1)

#else	/* of #if defined(NUM_MPF_NET_BUF_IF_PDU) && NUM_MPF_NET_BUF_IF_PDU > 0 */

#if defined(SUPPORT_INET4)
#define WWW_SRV_SWBUF_SIZE	(TCP_MSS)
#endif

#if defined(SUPPORT_INET6)
#define WWW_SRV_SWBUF_SIZE	(TCP6_MSS)
#endif

#endif	/* of #if defined(NUM_MPF_NET_BUF_IF_PDU) && NUM_MPF_NET_BUF_IF_PDU > 0 */

#if defined(SUPPORT_INET4)
#define WWW_SRV_RWBUF_SIZE	(TCP_MSS)
#endif

#if defined(SUPPORT_INET6)
#define WWW_SRV_RWBUF_SIZE	(TCP6_MSS)
#endif

#define WWW_RBUFF_SIZE		(WWW_SRV_RWBUF_SIZE)
#define WWW_LINE_SIZE		80
#define WWW_NUM_FIELDS		4

#ifndef _MACRO_ONLY

typedef struct line {
	uint8_t		len;
	uint8_t		num;
	uint8_t		off[WWW_NUM_FIELDS];
	char		buf[WWW_LINE_SIZE + 1];
} T_WWW_LINE;

#ifdef USE_COPYSAVE_API

typedef struct www_buffer {
	char		*buf;
	uint16_t	len;
	uint16_t	index;
} T_WWW_BUFFER;

#else	/* of #ifdef USE_COPYSAVE_API */

typedef struct www_buffer {
	uint16_t	len;
	uint16_t	index;
	char		buf[WWW_RBUFF_SIZE];
} T_WWW_BUFFER;

#endif	/* of #ifdef USE_COPYSAVE_API */

typedef struct www_rwbuf {
	T_WWW_BUFFER	sbuf;
	T_WWW_BUFFER	rbuf;
	char		unget;
} T_WWW_RWBUF;

/* ^XN */

extern void	www_srv_task (intptr_t exinf);

/*
 *  TCP Mobt@
 */

extern uint8_t www_srv_swbuf[NUM_WWW_SRV_TASKS][WWW_SRV_SWBUF_SIZE];
extern uint8_t www_srv_rwbuf[NUM_WWW_SRV_TASKS][WWW_SRV_RWBUF_SIZE];

#endif	/* of #ifndef _MACRO_ONLY */

#endif	/* of #ifndef _WWWS_H_ */
