/*
 *  TINET (TCP/IP Protocol Stack)
 * 
 *  Copyright (C) 2001-2009 by Dep. of Computer Science and Engineering
 *                   Tomakomai National College of Technology, JAPAN
 *
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́C̏𖞂ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 *
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: net_buf.h,v 1.5 2009/12/24 05:42:40 abe Exp abe $
 */

#ifndef _NET_BUF_H_
#define _NET_BUF_H_

/*
 *  lbg[Nobt@
 *
 *    4 INebgŃACKv̂vZbTlāA
 *    IF wb_TCY 4 INebgEłȂ̏ꍇA
 *    IP wb_ȍ~ 4 INebgEɒB
 */

#ifndef CPU_NET_ALIGN
#error "CPU_NET_ALIGN expected."
#endif

/*
 *  ev[g
 */

struct t_net_buf {
	uint16_t	len;	/* f[^̒		*/
	uint8_t		idix;	/* mpfid ̃CfbNX	*/
	uint8_t		flags;	/* tO		*/
#ifdef IF_ETHER_NIC_NET_BUF_ALIGN
	uint8_t		nalign[IF_ETHER_NIC_NET_BUF_ALIGN];
#endif
#if CPU_NET_ALIGN == 4 && IF_HDR_ALIGN != 4
	uint8_t		halign[4 - IF_HDR_ALIGN];
#endif
	uint8_t		buf[4];	/* obt@{		*/
};

#ifndef T_NET_BUF_DEFINED

typedef struct t_net_buf T_NET_BUF;

#define T_NET_BUF_DEFINED

#endif	/* of #ifndef T_NET_BUF_DEFINED */
/*
 *  64 INebg
 */

typedef struct t_net_buf_64 {
	uint16_t	len;	/* f[^̒		*/
	uint8_t		idix;	/* mpfid ̃CfbNX	*/
	uint8_t		flags;	/* tO		*/
#ifdef IF_ETHER_NIC_NET_BUF_ALIGN
	uint8_t		nalign[IF_ETHER_NIC_NET_BUF_ALIGN];
#endif
#if CPU_NET_ALIGN == 4 && IF_HDR_ALIGN != 4
	uint8_t		halign[4 - IF_HDR_ALIGN];
#endif
	uint8_t		buf[64]; /* obt@{	*/
} T_NET_BUF_64;

/*
 *  128 INebg
 */

typedef struct t_net_buf_128 {
	uint16_t	len;	/* f[^̒		*/
	uint8_t		idix;	/* mpfid ̃CfbNX	*/
	uint8_t		flags;	/* tO		*/
#ifdef IF_ETHER_NIC_NET_BUF_ALIGN
	uint8_t		nalign[IF_ETHER_NIC_NET_BUF_ALIGN];
#endif
#if CPU_NET_ALIGN == 4 && IF_HDR_ALIGN != 4
	uint8_t		halign[4 - IF_HDR_ALIGN];
#endif
	uint8_t		buf[128]; /* obt@{	*/
} T_NET_BUF_128;

/*
 *  256 INebg
 */

typedef struct t_net_buf_256 {
	uint16_t	len;	/* f[^̒		*/
	uint8_t		idix;	/* mpfid ̃CfbNX	*/
	uint8_t		flags;	/* tO		*/
#ifdef IF_ETHER_NIC_NET_BUF_ALIGN
	uint8_t		nalign[IF_ETHER_NIC_NET_BUF_ALIGN];
#endif
#if CPU_NET_ALIGN == 4 && IF_HDR_ALIGN != 4
	uint8_t		halign[4 - IF_HDR_ALIGN];
#endif
	uint8_t		buf[256]; /* obt@{	*/
} T_NET_BUF_256;

/*
 *  512 INebg
 */

typedef struct t_net_buf_512 {
	uint16_t	len;	/* f[^̒		*/
	uint8_t		idix;	/* mpfid ̃CfbNX	*/
	uint8_t		flags;	/* tO		*/
#ifdef IF_ETHER_NIC_NET_BUF_ALIGN
	uint8_t		nalign[IF_ETHER_NIC_NET_BUF_ALIGN];
#endif
#if CPU_NET_ALIGN == 4 && IF_HDR_ALIGN != 4
	uint8_t		halign[4 - IF_HDR_ALIGN];
#endif
	uint8_t		buf[512];/* obt@{	*/
} T_NET_BUF_512;

/*
 *  1024 INebg
 */

typedef struct t_net_buf_1024 {
	uint16_t	len;	/* f[^̒		*/
	uint8_t		idix;	/* mpfid ̃CfbNX	*/
	uint8_t		flags;	/* tO		*/
#ifdef IF_ETHER_NIC_NET_BUF_ALIGN
	uint8_t		nalign[IF_ETHER_NIC_NET_BUF_ALIGN];
#endif
#if CPU_NET_ALIGN == 4 && IF_HDR_ALIGN != 4
	uint8_t		halign[4 - IF_HDR_ALIGN];
#endif
	uint8_t		buf[1024]; /* obt@{	*/
} T_NET_BUF_1024;

/*
 *  lbg[NC^tF[X̍ő PDU TCY
 */

typedef struct t_net_buf_if_pdu {
	uint16_t	len;	/* f[^̒		*/
	uint8_t		idix;	/* mpfid ̃CfbNX	*/
	uint8_t		flags;	/* tO		*/
#ifdef IF_ETHER_NIC_NET_BUF_ALIGN
	uint8_t		nalign[IF_ETHER_NIC_NET_BUF_ALIGN];
#endif
#if CPU_NET_ALIGN == 4 && IF_HDR_ALIGN != 4
	uint8_t		halign[4 - IF_HDR_ALIGN];
#endif
	uint8_t		buf[IF_PDU_SIZE];
				/* obt@{		*/
#if defined(IF_PDU_HDR_PADDING)
	uint8_t		padding[IF_PDU_HDR_PADDING];
#endif				/* wb_̗]		*/
} T_NET_BUF_IF_PDU;

/*
 *  lbg[Nobt@\
 */

typedef struct t_net_buf_entry {

	uint16_t	index;
	uint_t		size;

#if NET_COUNT_ENABLE & PROTO_FLG_NET_BUF

	ulong_t		prepares;
	ulong_t		requests;
	ulong_t		allocs;
	ulong_t		errors;

#endif	/* of #if NET_COUNT_ENABLE & PROTO_FLG_NET_BUF */

} T_NET_BUF_ENTRY;

/*
 *  lbg[Nobt@EtO	
 */

/*
 *  lbg[NC^tF[Xo͌Ƀlbg[Nobt@JȂB
 *  : o͌ɂ̃tO̓NAB
 */
#define NB_FLG_NOREL_IFOUT	UINT_C(0x80)

/*
 *  ESP ptO
 */
#define NB_FLG_DECRYPED		UINT_C(0x40)

/*
 *  lbg[Nobt@l
 */

/* T */

#define NBA_SEARCH_ASCENT	UINT_C(0x1000)	/* 傫ȃTCY̕ɒTB	*/
#define NBA_SEARCH_DESCENT	UINT_C(0x2000)	/* ȃTCY̕ɒTB	*/
#define NBA_RESERVE_TCP		UINT_C(0x4000)	/* TCP pɃlbg[Nobt@\񂷂B*/
#define NBA_ID_MASK		UINT_C(0x0fff)	/* ʐM[_ ID nꍇ̃}XNl	*/

/*
 *  ֐V~[V}N
 */

#define get_net_buf(b,l)	tget_net_buf((b),(l),TMO_FEVR)

/*
 *  ֐
 */

extern ER tget_net_buf_ex (T_NET_BUF **blk, uint_t minlen, uint_t maxlen, ATR nbatr, TMO tmout);
extern ER tget_net_buf (T_NET_BUF **blk, uint_t len, TMO tmout);
extern ER rel_net_buf (T_NET_BUF *blk);
extern ER rus_net_buf (T_NET_BUF *blk);
extern ER_UINT net_buf_siz (T_NET_BUF *blk);
extern uint_t net_buf_max_siz (void);
extern const T_NET_BUF_ENTRY *nbuf_get_tbl (void);
extern uint_t nbuf_get_tbl_size (void);

#endif	/* of #ifndef _NET_BUF_H_ */
