/*
 *  TOPPERS/ASP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Advanced Standard Profile Kernel  
 * 
 *  Copyright (C) 2010 by Meika Sugimoto
 * 
 *  L쌠҂́Cȉ(1)`(4)̏𖞂ꍇɌC{\tgEF
 *  Ai{\tgEFAς̂܂ށDȉjgpEE
 *  ρEĔzziȉCpƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 *      ܂C{\tgEFÃ[U܂̓Gh[ÛȂ闝
 *      RɊÂCL쌠҂TOPPERSvWFNg
 *      Ɛӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̎gpړI
 *  ɑ΂K܂߂āCȂۏ؂sȂD܂C{\tgEF
 *  A̗pɂ蒼ړI܂͊ԐړIɐȂ鑹QɊւĂC
 *  ̐ӔC𕉂ȂD
 * 
 */

#include "kernel_impl.h"
#include "target_timer.h"
#include "time_event.h"

/*
 *	J[l^C}̏
 *
 *	TMMgpD
 */
void target_timer_initialize(intptr_t exinf)
{
	/* ^C}~C^C}ݗṽNA */
	clr_bit(7 , TM0CTL0);
	x_clear_int(INTNO_TIMER);
	
	/* NbN̐ݒC20MHẑ4=5MHzɂ */
	sil_wrb_mem((uint8_t *)TM0CTL0 , 2u);
	/* RyAl̐ݒ50000JEg1msecC */
	sil_wrh_mem((uint16_t *)TM0CMP0 , TIMER_CLOCK - 1);
	
	/* ^C}Jn */
	set_bit(7 , TM0CTL0);

	/* CPUA^CNbNݒ */
#ifndef INPUT_SUB_CLOCK /* TuNbN32,768HzȂꍇ */
	/* PWRFA^CEJE^~
	 * CKSFfBRG𓮍NbNƂđI */
	sil_wrb_mem((uint8_t *)RC1CC0, 0x40);
#else
	/* PWRFA^CEJE^~
	 * CKSFfXT𓮍NbNƂđI */
	sil_wrb_mem((uint8_t *)RC1CC0, 0x00);
#endif
	/* PWRFA^CEJE^싖 */
	sil_wrb_mem((uint8_t *)RC1CC0, sil_reb_mem((uint8_t *)RC1CC0) | 0x80);
	/* AMPMF24Ԑ\ */
	sil_wrb_mem((uint8_t *)RC1CC1, 0x08);
	/* C^[o荞݂𔭐Ȃ */
	sil_wrb_mem((uint8_t *)RC1CC3, 0x00);
	/* ␳Ȃ */
	sil_wrb_mem((uint8_t *)RC1SUBU, 0x00);
	/* RTCEFJE^싖 */
	sil_wrb_mem((uint8_t *)RC1CC1, sil_reb_mem((uint8_t *)RC1CC1) | 0x80);
}

void target_timer_terminate(intptr_t exinf)
{
	/* ^C}~C^C}ݗṽNAƊ݋֎~ */
	clr_bit(7 , TM0CTL0);
	x_disable_int(INTNO_TIMER);
	x_clear_int(INTNO_TIMER);
}

/*
 *  ^C}݃nh
 */
void
target_timer_handler(void)
{
	i_begin_int(INTNO_TIMER);
	signal_time();					/* ^CeBbN̋ */
	i_end_int(INTNO_TIMER);
}

