/*
 *  TOPPERS/ASP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Advanced Standard Profile Kernel
 * 
 *  Copyright (C) 2010-2011 by Meika Sugimoto
 * 
 *  L쌠҂́Cȉ(1)`(4)̏𖞂ꍇɌC{\tgEF
 *  Ai{\tgEFAς̂܂ށDȉjgpEE
 *  ρEĔzziȉCpƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 *      ܂C{\tgEFÃ[U܂̓Gh[ÛȂ闝
 *      RɊÂCL쌠҂TOPPERSvWFNg
 *      Ɛӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̎gpړI
 *  ɑ΂K܂߂āCȂۏ؂sȂD܂C{\tgEF
 *  A̗pɂ蒼ړI܂͊ԐړIɐȂ鑹QɊւĂC
 *  ̐ӔC𕉂ȂD
 * 
 */

/*
 *		kernel.h̃vZbTˑiV850pj
 *
 *  ̃CN[ht@ĆCtarget_kernel.hi܂́CCN
 *  [ht@Cĵ݂CN[hD̃t@C
 *  ڃCN[hĂ͂ȂȂD
 */

#ifndef TOPPERS_PRC_KERNEL_H
#define TOPPERS_PRC_KERNEL_H

/*
 *  vZbT`ŃT|[g@\
 */
#define TOPPERS_TARGET_SUPPORT_DIS_INT		/* dis_intT|[g */
#define TOPPERS_TARGET_SUPPORT_ENA_INT		/* ena_intT|[g */
#define TOPPERS_TARGET_SUPPORT_GET_UTM		/* get_utmT|[g */

/*
 *  J[lǗ̊ݗDx͈̔
 *
 *  TMIN_INTPRI̒`ύX邱ƂŁCǂ̃xݗDx
 *  ̂J[lǗO݂̊Ƃ邩ύXłD
 *
 */
#ifndef TMIN_INTPRI
#define TMIN_INTPRI		(-7)		/* ݗDx̍ŏliōlj*/
#endif /* TMIN_INTPRI */

#define TMAX_INTPRI		(0)		/* ݗDx̍őliŒlj*/

/*
 *	Ȏ݂
 */
#define TA_POSEDGE		(TA_EDGE)
#define TA_NEGEDGE		UINT_C(0x00000004)
#define TA_BOTHEDGE		UINT_C(0x00000008)

/*
 *  T|[g@\̒`
 */
#define TOPPERS_SUPPORT_DIS_INT			/* dis_intT|[g */
#define TOPPERS_SUPPORT_ENA_INT			/* ena_intT|[g */

/*
 *  T|[gIuWFNg`
 */

#define TARGET_INTATR       ((TA_POSEDGE | TA_NEGEDGE | TA_BOTHEDGE) | TA_NONKERNEL)
#define TARGET_INHATR       (TA_NONKERNEL)
#define TARGET_TSKATR       (0)
#define TARGET_ISRATR       (TA_NONKERNEL)
#define TARGET_EXCATR       (0)
#define TARGET_MIN_STKSZ    (64)
#define CHECK_STKSZ_ALIGN   (4)

/* `FbNe̎w */
#define CHECK_FUNC_NONNULL  (true)
#define CHECK_STACK_NONNULL (true)
#define CHECK_MPF_NONNULL   (true)

#define CHECK_FUNC_ALIGN    (1)
#define CHECK_STACK_ALIGN   (4)
#define CHECK_MPF_ALIGN     (4)
#define CHECK_MB_ALIGN      (4)

#endif /* TOPPERS_PRC_KERNEL_H */
