/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.struts.action;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

import jp.terasoluna.fw.util.PropertyUtil;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.util.MessageResources;
import org.apache.struts.util.MessageResourcesFactory;

/**
 * ƖʁAVXẽbZ[W\[X𐶐NXB
 *
 * <p>
 * Struts̎dlƂāAbZ[W\[X`t@C𗘗pꍇA
 * ̒`̓W[ƂɓƗĂ邽߁AׂẴW[ɋʂ
 * bZ[W\[XꌳIɒ`邱ƂłȂB<br>
 * TERASOLUNAł̓W[ׂĂɋʂȁA
 * ƖʃbZ[WAVXebZ[W𗘗p@񋟂ĂB<br>
 * ̃NX́AVXeit[[Nj̃bZ[W\[XƁA
 * Ɩʂ̃bZ[W\[XێATERASOLUNAt[[N񋟂A
 * ǂ̃bZ[W\[XNXpĂQƂ悤ɂȂĂB<br>
 * </p>
 * <h5></h5>
 * <ol>
 *  <li>TERASOLUNAt[[NŒ񋟂MessageResourceśA
 *      SẴNXVXeAƖʂ̃bZ[W\[X擾
 *      KvB</li>
 *  <li>Ŏ擾ꂽbZ[W\[X͍ۉΉȂB</li>
 * </ol>
 * <h5>Ɩʂ̃bZ[W\[Xݒ</h5>
 * <p>
 * Ɩʂ̃bZ[W\[X́AftHgŋƖʃbZ[W\[X`
 * t@C擾B
 * ƖʃbZ[W\[X`t@C̃ftHg̃t@C
 * application-messages.propertiesɐݒ肳ĂB
 * t@CύXꍇ́A
 * VXeݒvpeBt@Cisystem.propertiesj
 * Ɉȉ̃L[ŐݒsȂB<br>
 * <pre><code>
 * application.messages=sample1-messages
 * </code></pre>
 * application.messagesɑΉ镶́A.propertiest@CłB
 * <b>K.properties͏ċLqB</b><br>
 * </p>
 * <h5>ƖʃbZ[W\[X`t@C̉p</h5>
 * Ɩʂ̃bZ[W͋ƖʃbZ[W\[X`t@C
 * iapplication-messages.propertiesj
 * 邢́AVXeݒvpeBt@Cisystem.propertiesj
 * Œ`t@C̃t@C̒ŁA
 * L̂悤ɃL[iadd.message.file.xj
 * gpĊOt@Cw肷邱ƂɂA
 * bZ[W\[Xǉ邱ƂłB<br>
 * <code><pre>
 * add.message.file.1=app1-message
 * add.message.file.2=app2-message
 * </pre></code>
 * vpeBL[1Ŏn܂ʔԂłArŒʔԂr؂Ăꍇ́A
 * ŊOt@CǂݍݏIƂȂB<br>
 * <h5>VXẽbZ[W\[Xݒ</h5>
 * GlobalMessageResourcesł́A
 * ftHgsystem-message.properties[hA
 * VXẽbZ[W擾ĂB
 * ̃VXebZ[W\[X`t@ĆAύXłȂB
 *
 * @see jp.terasoluna.fw.web.struts.action.DBMessageResourcesFactory
 * @see jp.terasoluna.fw.web.struts.action.DBMessageResources
 * @see jp.terasoluna.fw.web.struts.action.PropertyMessageResourcesExFactory
 * @see jp.terasoluna.fw.web.struts.action.PropertyMessageResourcesEx
 *
 */
public final class GlobalMessageResources extends MessageResources {

    /**
	 * VAo[WID
	 */
	private static final long serialVersionUID = -1224092114113256826L;

	/**
     * ONXB
     */
    @SuppressWarnings("hiding")
	private static Log log
        = LogFactory.getLog(GlobalMessageResources.class);

    /**
     * t[[ÑbZ[WێB
     */
    private Map<String, String> fwMessages = new HashMap<String, String>();

    /**
     * VXeӂƂȂ郁bZ[WێB
     */
    private Map<String, String> globalMessages = new HashMap<String, String>();

    /**
     * t[[NbZ[W\[XB
     */
    private static final String SYSTEM_MESSAGE
        = "system-messages";

    /**
     * ftHg̃AvP[VbZ[W\[XB
     */
    private static final String DEFAULT_APPLICATION_MESSAGE
        = "application-messages";

    /**
     * <code>system.properties</code>ɋLqƖ
     * bZ[W\[XB
     */
    private static final String APPLICATION_CONFIG_KEY
        = "application.messages";

    /**
     * [g̃bZ[Wt@CɋLqAǉpObZ[Wt@CB
     */
    private static final String ADD_MESSAGES_FILE
        = "add.message.file.";

    /**
     * VOgIuWFNgB
     */
    private static GlobalMessageResources globalMessageResources
        = null;

    /**
     * ̃NX̃VOgCX^XԋpB
     *
     * @return GlobalMessageResources ̃NX̃VOgCX^X
     */
    public static GlobalMessageResources getInstance() {
        if (globalMessageResources == null) {
            synchronized (GlobalMessageResources.class) {
                GlobalMessageResources createdResources
                    = new GlobalMessageResources(
                            null, SYSTEM_MESSAGE);
                globalMessageResources = createdResources;
            }
        }
        return globalMessageResources;
    }

    /**
     *  w肳ꂽp[^ɂ
     *  <code>GlobalMessageResources</code> 𐶐B
     *
     * @param factory bZ[W\[Xt@Ng
     * @param config  <code>MessageResource</code> ɑ΂ݒp[^
     */
    private GlobalMessageResources(MessageResourcesFactory factory,
                                   String config) {
        super(factory, config);
        globalInit();
        applicationInit();
    }

    /**
     * vpeBt@CA}bvւ̋lߑւsȂB
     */
    private synchronized void globalInit() {

        // bZ[WNA
        fwMessages.clear();

        // bZ[W\[Xt@C[hB
        Properties prop = PropertyUtil.loadProperties(this.config);
        if (prop == null) {
            // sȂ킸IB
            return;
        }
        Enumeration keyEnum = prop.propertyNames();
        while (keyEnum.hasMoreElements()) {
            Object keyObj = keyEnum.nextElement();
            Object value = prop.get(keyObj);
            if (log.isDebugEnabled()) {
                log.debug(
                    "Saving framework message key [" + keyObj + "]"
                    + "value [" + value + "]");
            }
            fwMessages.put((String) keyObj, (String) value);
        }
    }

    /**
     * ƖʃbZ[W\[Xt@C̃[h
     * bZ[W\[X̎擾sȂB
     */
    private synchronized void applicationInit() {
        String appKey = PropertyUtil.getProperty(APPLICATION_CONFIG_KEY);
        if (appKey == null) {
            // L[ȂꍇAftHg
            // bZ[W\[Xݒ肷B
            appKey = DEFAULT_APPLICATION_MESSAGE;
        }

        // Ɩʂ̃[gvpeB̎擾
        Properties prop = PropertyUtil.loadProperties(appKey);
        if (prop == null) {
            // sȂ킸IB
            return;
        }
        // [g̋ƖʃbZ[WƂĐݒ肳Ă郁bZ[W\[X
        // Mapɓo^B
        Map<String, String> rootAppricationMap = getRootApplicationMap(prop);
        // ǉǂݍ݂sȂbZ[W\[X擾B
        Map<String, String> addApplicationMap =
        	getAddApplicationMap(prop, appKey);
        // }bṽ}[W
        addApplicationMap.putAll(rootAppricationMap);
        globalMessages = addApplicationMap;
    }

    /**
     * Ɩʂ̃[gbZ[Wt@CɋLqꂽbZ[Wꗗ}bv
     * ԋpB݂Ȃꍇ̃}bvԋpB
     *
     * @param prop [g̃vpeBt@C
     * @return [g̃vpeBt@CɋLqꂽbZ[W
     */
    private Map<String, String> getRootApplicationMap(Properties prop) {
        Map<String, String> rootApplicationMap = new HashMap<String, String>();
        // L[ꗗ擾
        Iterator it = prop.keySet().iterator();
        while (it.hasNext()) {
            String key = (String) it.next();
            // L[̂Aadd.message.file.Ŏn܂Ă̂͏OB
            if (key.startsWith(ADD_MESSAGES_FILE)) {
                continue;
            }
            String value = prop.getProperty(key);
            if (log.isDebugEnabled()) {
                log.debug("Saving root-application message key [" + key + "]"
                          + "value [" + value + "]");
            }
            rootApplicationMap.put(key, value);
        }
        return rootApplicationMap;
    }

    /**
     * Ɩʂ̃[gbZ[WAÕbZ[W\[Xt@Cꗗ
     * 擾AbZ[W擾B
     * Ot@C݂Ȃꍇ̃}bvԋpB
     * [g̃t@Cƃ[ht@CvĂꍇ́A
     * iv[vׁAǂݔ΂B
     *
     * @param prop [g̃vpeBt@C
     * @param rootProperty [g̃vpeBt@C
     * @return ÕbZ[W}bv
     */
    private Map<String, String> getAddApplicationMap(Properties prop,
    		String rootProperty) {
        Map<String, String> addApplicationMap = new HashMap<String, String>();
        List<String> fileNameList = new ArrayList<String>();
        for (int i = 1; ; i++) {
            // Ot@C擾
            String fileName = prop.getProperty(ADD_MESSAGES_FILE + i);
            if (fileName == null) {
                // t@C擾łȂꍇ́AI
                break;
            } else if (fileName.equals(rootProperty)) {
                // [g̃t@CƈvĂׁAI
                // (iv[v)
                break;
            }
            fileNameList.add(fileName);
        }

        // 擾ꂽt@CAOt@C[hA
        // }bvɒǉB
        Iterator fileNameIt = fileNameList.iterator();
        while (fileNameIt.hasNext()) {
            String outerFileName = (String) fileNameIt.next();
            Properties outerProp = PropertyUtil.loadProperties(outerFileName);
            // Ot@CK؂łȂƂ͔΂
            if (outerProp == null) {
                if (log.isWarnEnabled()) {
                    log.warn("\"" + outerFileName + "\" is illegal.");
                }
                continue;
            }
            // Ot@C̃L[ꗗ
            Iterator outerFileKeyIt = outerProp.keySet().iterator();
            while (outerFileKeyIt.hasNext()) {
                String outerMessageKey = (String) outerFileKeyIt.next();
                String outerValue = outerProp.getProperty(outerMessageKey);
                if (log.isDebugEnabled()) {
                    log.debug("Saving outer-file-application message key ["
                              + outerMessageKey + "]" + "value [" + outerValue
                              + "]");
                }
                addApplicationMap.put(outerMessageKey, outerValue);
            }
        }
        return addApplicationMap;
    }

    /**
     * bZ[WԋpB
     * bZ[W擾̗D揇ʂ́A
     * <ol>
     *   <li>Ɩʂ̃bZ[W\[X</li>
     *   <li>VXẽbZ[W\[X</li>
     * </ol>
     * ̏ƂȂB
     *
     * @param locale P[IuWFNg
     * @param key bZ[W\[XL[
     * @return bZ[W
     */
    @Override
    public String getMessage(Locale locale, String key) {
        if (key == null) {
            return null;
        }
        // Ɩʂ̃bZ[WA烊^[B
        String globalMsg = globalMessages.get(key);
        if (globalMsg != null) {
            return globalMsg;
        }
        // t[[ÑbZ[WԋpB
        return fwMessages.get(key);
    }
}
