﻿#include "mspell/monster-power-table.h"

/*!
 * @brief 青魔法テーブル
 * @details
 * level,  smana,  %fail,  manedam,  %manefail,  use_stat, name
 */
const monster_power monster_powers[MAX_MONSPELLS] = {
    { 1, 1, 10, 0, 15, A_CON, _("叫ぶ", "shriek") },
    { 10, 4, 35, 89, 40, A_INT, _("何か", "something") },
    { 40, 35, 85, 0, 40, A_INT, _("魔力消去", "dispel-magic") },
    { 35, 30, 80, 800, 70, A_STR, _("ロケット", "rocket") },
    { 5, 1, 20, 18, 15, A_DEX, _("射撃", "arrow") },
    { 10, 4, 35, 89, 40, A_INT, _("何か", "arrows") },
    { 10, 4, 35, 89, 40, A_INT, _("何か", "missile") },
    { 10, 4, 35, 89, 40, A_INT, _("何か", "missiles") },
    { 20, 15, 55, 1600, 95, A_CON, _("酸のブレス", "breath acid") },
    { 20, 15, 55, 1600, 95, A_CON, _("電撃のブレス", "breath lightning") },
    { 20, 15, 55, 1600, 95, A_CON, _("炎のブレス", "breath fire") },
    { 20, 15, 55, 1600, 95, A_CON, _("冷気のブレス", "breath cold") },
    { 20, 15, 55, 800, 95, A_CON, _("毒のブレス", "breath poison") },
    { 20, 15, 70, 550, 95, A_CON, _("地獄のブレス", "breath nether") },
    { 20, 16, 70, 400, 95, A_CON, _("閃光のブレス", "breath light") },
    { 20, 16, 70, 400, 95, A_CON, _("暗黒のブレス", "breath dark") },
    { 20, 20, 70, 450, 95, A_CON, _("混乱のブレス", "breath confusion") },
    { 20, 20, 70, 450, 95, A_CON, _("轟音のブレス", "breath sound") },
    { 20, 20, 70, 600, 95, A_CON, _("カオスのブレス", "breath chaos") },
    { 20, 16, 70, 500, 95, A_CON, _("劣化のブレス", "breath disenchantment") },
    { 30, 25, 80, 250, 95, A_CON, _("因果混乱のブレス", "breath nexus") },
    { 35, 18, 80, 150, 95, A_CON, _("時間逆転のブレス", "breath time") },
    { 30, 25, 80, 200, 95, A_CON, _("遅鈍のブレス", "breath inertia") },
    { 30, 28, 90, 200, 95, A_CON, _("重力のブレス", "breath gravity") },
    { 20, 15, 70, 500, 95, A_CON, _("破片のブレス", "breath shards") },
    { 35, 15, 80, 150, 95, A_CON, _("プラズマのブレス", "breath plasma") },
    { 30, 18, 70, 200, 95, A_CON, _("フォースのブレス", "breath force") },
    { 30, 28, 80, 250, 95, A_CON, _("魔力のブレス", "breath mana") },
    { 25, 20, 95, 320, 80, A_INT, _("放射能球", "nuke ball") },
    { 25, 15, 70, 800, 95, A_CON, _("放射性廃棄物のブレス", "breath nuke") },
    { 30, 32, 85, 400, 80, A_INT, _("純ログルス", "raw Logrus") },
    { 35, 40, 95, 150, 95, A_CON, _("分解のブレス", "breath disintegrate") },
    { 18, 13, 55, 630, 80, A_INT, _("アシッド・ボール", "acid ball") },
    { 14, 10, 45, 316, 60, A_INT, _("サンダー・ボール", "lightning ball") },
    { 20, 14, 60, 720, 80, A_INT, _("ファイア・ボール", "fire ball") },
    { 15, 11, 50, 320, 60, A_INT, _("アイス・ボール", "frost ball") },
    { 5, 3, 40, 48, 20, A_INT, _("悪臭雲", "stinking cloud") },
    { 25, 18, 70, 350, 80, A_INT, _("地獄球", "nether ball") },
    { 30, 22, 75, 350, 80, A_INT, _("ウォーター・ボール", "water ball") },
    { 44, 45, 85, 550, 95, A_INT, _("魔力の嵐", "mana storm") },
    { 40, 42, 90, 550, 95, A_INT, _("暗黒の嵐", "darkness storm") },
    { 10, 5, 50, 0, 25, A_INT, _("魔力吸収", "drain mana") },
    { 25, 10, 60, 0, 30, A_INT, _("精神攻撃", "mind blast") },
    { 30, 14, 65, 0, 30, A_INT, _("脳攻撃", "brain smash") },
    { 3, 1, 25, 24, 20, A_INT, _("軽傷", "cause light wounds") },
    { 12, 2, 35, 64, 25, A_INT, _("重傷", "cause serious wounds") },
    { 22, 6, 50, 150, 30, A_INT, _("致命傷", "cause critical wounds") },
    { 32, 10, 70, 225, 35, A_INT, _("秘孔を突く", "cause mortal wounds") },
    { 13, 7, 40, 178, 40, A_INT, _("アシッド・ボルト", "acid bolt") },
    { 10, 5, 35, 130, 35, A_INT, _("サンダー・ボルト", "lightning bolt") },
    { 15, 9, 50, 210, 45, A_INT, _("ファイア・ボルト", "fire bolt") },
    { 12, 6, 35, 162, 40, A_INT, _("アイス・ボルト", "frost bolt") },
    { 40, 42, 90, 550, 95, A_INT, _("スター・バースト", "starburst") },
    { 25, 17, 60, 255, 60, A_INT, _("地獄の矢", "nether bolt") },
    { 25, 20, 65, 250, 60, A_INT, _("ウォーター・ボルト", "water bolt") },
    { 25, 24, 90, 400, 80, A_INT, _("魔力の矢", "mana bolt") },
    { 25, 20, 80, 216, 60, A_INT, _("プラズマ・ボルト", "plasma bolt") },
    { 25, 16, 60, 186, 60, A_INT, _("極寒の矢", "ice bolt") },
    { 3, 1, 25, 12, 20, A_INT, _("マジック・ミサイル", "magic missile") },
    { 5, 3, 35, 0, 20, A_INT, _("恐慌", "scare") },
    { 10, 5, 40, 0, 20, A_INT, _("盲目", "blind") },
    { 10, 5, 40, 0, 20, A_INT, _("パニック・モンスター", "confuse") },
    { 10, 5, 40, 0, 20, A_INT, _("スロウ・モンスター", "slow") },
    { 10, 5, 40, 0, 20, A_INT, _("スリープ・モンスター", "sleep") },
    { 20, 10, 70, 0, 40, A_INT, _("スピード", "speed") },
    { 45, 120, 95, 0, 60, A_INT, _("破滅の手", "the Hand of Doom") },
    { 20, 15, 70, 0, 20, A_WIS, _("体力回復", "heal-self") },
    { 45, 65, 80, 0, 60, A_INT, _("無傷の球", "make invulnerable") },
    { 5, 1, 30, 0, 20, A_INT, _("ショート・テレポート", "blink-self") },
    { 15, 8, 40, 0, 30, A_INT, _("テレポート", "teleport-self") },
    { 40, 999, 99, 0, 80, A_INT, _("ザ・ワールド", "The world") },
    { 1, 0, 0, 0, 15, A_INT, _("何か", "something") },
    { 15, 8, 50, 0, 30, A_INT, _("引きよせる", "teleport to") },
    { 20, 13, 80, 0, 30, A_INT, _("テレポート・アウェイ", "teleport away") },
    { 30, 40, 95, 0, 40, A_INT, _("テレポート・レベル", "teleport level") },
    { 35, 30, 80, 350, 70, A_INT, _("光の剣", "psycho-spear") },
    { 5, 1, 20, 0, 15, A_INT, _("暗闇", "create darkness") },
    { 5, 1, 20, 0, 15, A_DEX, _("トラップ創造", "create traps") },
    { 15, 3, 40, 0, 30, A_INT, _("記憶喪失", "cause amnesia") },
    { 30, 30, 70, 0, 40, A_INT, _("死者復活", "raise dead") },
    { 40, 70, 85, 0, 45, A_INT, _("援軍を呼ぶ", "summon aid") },
    { 45, 90, 90, 0, 50, A_INT, _("サイバーデーモンの召喚", "summon Cyberdemons") },
    { 25, 20, 65, 0, 30, A_INT, _("モンスターの召喚", "summon a monster") },
    { 35, 30, 75, 0, 40, A_INT, _("複数のモンスターの召喚", "summon monsters") },
    { 25, 25, 65, 0, 25, A_INT, _("アリの召喚", "summon ants") },
    { 25, 20, 60, 0, 25, A_INT, _("蜘蛛の召喚", "summon spiders") },
    { 35, 26, 75, 0, 40, A_INT, _("ハウンドの召喚", "summon hounds") },
    { 30, 23, 70, 0, 35, A_INT, _("ヒドラの召喚", "summon hydras") },
    { 40, 50, 85, 0, 40, A_INT, _("天使の召喚", "summon an angel") },
    { 35, 50, 80, 0, 35, A_INT, _("デーモンの召喚", "summon a daemon") },
    { 30, 30, 75, 0, 35, A_INT, _("アンデッドの召喚", "summon an undead") },
    { 39, 70, 80, 0, 40, A_INT, _("ドラゴンの召喚", "summon a dragon") },
    { 43, 85, 85, 0, 45, A_INT, _("上級アンデッドの召喚", "summon Greater Undead") },
    { 46, 90, 85, 0, 45, A_INT, _("古代ドラゴンの召喚", "summon Ancient Dragon") },
    { 48, 120, 90, 0, 50, A_INT, _("アンバーの王族の召喚", "summon Lords of Amber") },
    { 50, 150, 95, 0, 50, A_INT, _("ユニークモンスターの召喚", "summon Unique Monsters") },
};

/*!
 * @brief モンスター魔法名テーブル
 */
const concptr monster_powers_short[MAX_MONSPELLS] = {
    _("叫ぶ", "Shriek"),
    _("何か", "Something"),
    _("魔力消去", "Dispel-magic"),
    _("ロケット", "Rocket"),
    _("射撃", "Arrow"),
    _("何か", "Arrows"),
    _("何か", "Missile"),
    _("何か", "Missiles"),
    _("酸", "Acid"),
    _("電撃", "Lightning"),
    _("火炎", "Fire"),
    _("冷気", "Cold"),
    _("毒", "Poison"),
    _("地獄", "Nether"),
    _("閃光", "Light"),
    _("暗黒", "Dark"),
    _("混乱", "Confusion"),
    _("轟音", "Sound"),
    _("カオス", "Chaos"),
    _("劣化", "Disenchantment"),
    _("因果混乱", "Nexus"),
    _("時間逆転", "Time"),
    _("遅鈍", "Inertia"),
    _("重力", "Gravity"),
    _("破片", "Shards"),
    _("プラズマ", "Plasma"),
    _("フォース", "Force"),
    _("魔力", "Mana"),
    _("放射能球", "Nuke"),
    _("放射性廃棄物", "Nuke"),
    _("純ログルス", "Logrus"),
    _("分解", "Disintergrate"),

    _("酸", "Acid"),
    _("電撃", "Lightning"),
    _("火炎", "Fire"),
    _("冷気", "Frost"),
    _("悪臭雲", "Stinking Cloud"),
    _("地獄球", "Nether"),
    _("ウォーター", "Water"),
    _("魔力の嵐", "Mana storm"),
    _("暗黒の嵐", "Darkness storm"),
    _("魔力吸収", "Drain mana"),
    _("精神攻撃", "Mind blast"),
    _("脳攻撃", "Brain smash"),
    _("軽傷", "Cause Light Wound"),
    _("重傷", "Cause Serious Wound"),
    _("致命傷", "Cause Critical Wound"),
    _("秘孔を突く", "Cause Mortal Wound"),
    _("酸", "Acid"),
    _("電撃", "Lightning"),
    _("火炎", "Fire"),
    _("冷気", "Frost"),
    _("スターバースト", "Starburst"),
    _("地獄の矢", "Nether"),
    _("ウォーター", "Water"),
    _("魔力の矢", "Mana"),
    _("プラズマ", "Plasma"),
    _("極寒", "Ice"),
    _("マジックミサイル", "Magic missile"),
    _("恐慌", "Scare"),
    _("盲目", "Blind"),
    _("混乱", "Confuse"),
    _("減速", "Slow"),
    _("睡眠", "Sleep"),

    _("加速", "Speed"),
    _("破滅の手", "Hand of doom"),
    _("体力回復", "Heal-self"),
    _("無傷の球", "Invulnerable"),
    _("ショートテレポート", "Blink"),
    _("テレポート", "Teleport"),
    _("時を止める", "The world"),
    _("何か", "Something"),
    _("引きよせる", "Teleport to"),
    _("テレポートアウェイ", "Teleport away"),
    _("テレポートレベル", "Teleport level"),
    _("光の剣", "Psycho-spear"),
    _("暗闇", "Create darkness"),
    _("トラップ創造", "Create traps"),
    _("記憶喪失", "Amnesia"),
    _("死者復活", "Raise dead"),
    _("援軍", "Aid"),
    _("サイバーデーモン", "Cyberdeamons"),
    _("モンスター", "A monster"),
    _("複数のモンスター", "Monsters"),
    _("蟻", "Ants"),
    _("蜘蛛", "Spiders"),
    _("ハウンド", "Hounds"),
    _("ヒドラ", "Hydras"),
    _("天使", "Angel"),
    _("悪魔", "Daemon"),
    _("アンデッド", "Undead"),
    _("ドラゴン", "Dragon"),
    _("上級アンデッド", "Greater Undead"),
    _("古代ドラゴン", "Ancient Dragon"),
    _("アンバーの王族", "Lords of Amber"),
    _("ユニーク", "Unique monsters"),
};
