package hayashi.yuu.tools;

import hayashi.yuu.tools.mail.SendMail;
import java.io.UnsupportedEncodingException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;

import javax.mail.MessagingException;

/**
 * 標準のメール送信。
 * ただし、メール送信指示を与えるだけで、メール送信タスクは別スレッドで動作する。
 * @author hayashi
 *
 */
public class SpeedMail extends SendMail implements Callable<Object>
{
	@SuppressWarnings("unchecked")
	public static void main(String[] args) {
		FutureTask task;
		SpeedMail mail;
		try {
			mail = new SpeedMail("sendmail.properties");
		}
		catch (Exception e1) {
			e1.printStackTrace();
			return;
		}
		
		try {
			task = new FutureTask(mail);
		}
		catch (Exception fe) {
			System.out.println(fe.toString());
			return;
		}

		new Thread(task).start();

		//----------------------------------------------------------------------
		// 送信完了を待つ
		// SpeedMailを利用するなら以下の処理は要らないはず
		//----------------
		try {
			task.get();
		}
		catch (InterruptedException e) {
			e.printStackTrace();
		}
		catch (ExecutionException e) {
			e.printStackTrace();
		}
	}
	
	public SpeedMail(String propFileName) throws Exception {
		super(propFileName);
	}
	
	public Object call() throws MessagingException, UnsupportedEncodingException {
		send();
		return null;
	}
}
