package hayashi.yuu.register;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import jp.co.areaweb.tools.csv.CsvRecord;

public class CollectData
{
	public Calendar date = Calendar.getInstance();
	public String address = null;
	public String name = null;
	public String data = "";
	public static Calendar baseDate = null;
	public static String[] columnNames = {"日時", "カードID", "送信先アドレス","なまえ"};

    static final String DATETIME_PATTERN = "yyyy/MM/dd'-'HH:mm:ss";
	static SimpleDateFormat dateTimePattern = new SimpleDateFormat(DATETIME_PATTERN);

	/**
	 * コンストラクタ：　データコレクタで取得したデータ
	 * @param datetime
	 * @param data
	 * @param address
	 * @param name
	 */
	public CollectData(Date datetime, String data, String address, String name) {
		date.setTime(datetime);
		if (date.get(Calendar.YEAR) < 2000) {
			if (baseDate != null) {
				date.set(baseDate.get(Calendar.YEAR), baseDate.get(Calendar.MONTH), baseDate.get(Calendar.DAY_OF_MONTH));
			}
		}
		else {
			CollectData.baseDate = Calendar.getInstance();
			CollectData.baseDate.set(date.get(Calendar.YEAR), date.get(Calendar.MONTH), date.get(Calendar.DAY_OF_MONTH));
		}
		this.data = data;
		if (address == null) {
			this.address = getAddress(data);
		}
		else {
			this.address = address;
		}
		if (name == null) {
			this.name = getName(data);
		}
		else {
			this.name = name;
		}
	}

	public CollectData(Date datetime, String data) {
		this(datetime, data, null, null);
	}

	/**
	 * 収集データをXML形式にして表現する。
	 * @return	XMLレコード
	 */
	public Element getXmlElement(Document document) {
		Element point = document.createElement("point");
		point.setAttribute("id", this.data);
		point.setAttribute("datetime", dateTimePattern.format(this.date.getTime()));

		Element addrEle = document.createElement("address");
		addrEle.appendChild(document.createTextNode(this.address));
		point.appendChild(addrEle);

		Element nameEle = document.createElement("name");
		nameEle.appendChild(document.createTextNode(this.name));
		point.appendChild(nameEle);

		return  point;
	}


	/**
	 * [javax.swing.table.DefaultTableModel]用のレコード形式を取得する。
	 * @return
	 */
	public String[] getRecordStrs() {
		String[] strs = new String[4];
		strs[0] = dateTimePattern.format(this.date.getTime());
		strs[1] = this.data;
		strs[2] = this.address;
		strs[3] = this.name;
		return strs;
	}
	
	/**
	 * カードIDを取得する
	 * @return	カードID(IDm) - 16文字の１６進表記　'01010310DA09D027'
	 */
	public long getId() {
		return Long.parseLong(this.data, 16);
	}

	public String getAddress(String dataStr) {
		if (CardRegister.taglistFile == null) {
			return "";
		}
		for (Iterator<CsvRecord> i = CardRegister.taglistFile.iterator(); i.hasNext(); ) {
			CsvRecord record = i.next();
			String idStr = (String)record.get(0);	// ID
			if (idStr.equals(dataStr)) {
				return (String)record.get(1);	// ID
			}
		}
		return "";
	}

	public String getName(String dataStr) {
		if (CardRegister.taglistFile == null) {
			return "";
		}
		for (Iterator<CsvRecord> i = CardRegister.taglistFile.iterator(); i.hasNext(); ) {
			CsvRecord record = i.next();
			String idStr = (String)record.get(0);	// ID
			if (idStr.equals(dataStr)) {
				try {
					String ret = (String)record.get(2);	// ID
					return ret;	// ID
				}
				catch (IndexOutOfBoundsException ioobe) {
					return "";
				}
			}
		}
		return "";
	}
}
