#!/usr/bin/perl
# Sanshi : Web Application Security Chekcer  
# Ver. 0.01
# Created Date: 2002/12/18
# Created By ikepyon
#use 5.005;
package Sanshi;

use vars qw/$CONFIG_FILE %CONF @SIGNATURE $TEST_SESSION_ID $PATTERN_COUNTER %request %read_data %result/;
use vars qw(@ISA);

use IO::Socket;
use strict;
use Net::Server;
use LW;

require "./sanshi.conf";

# Initialize
&signature();

# use port 8080 as default
my $port = $CONF{"PORT"} || 8080;
@ISA = qw(Net::Server);

# Test Session Initialize
LW::http_init_request(\%request);

# Server routine 
Sanshi->run(port=>$port);
exit;

##
## Signature Get
##
sub signature {
 # Signature read
  open (IN,$CONF{"SIGNATURE"}) || die "Signature File not exists.\n";
  while (<IN>) {
    chop;
    s/^\#.*//;
    if ($_ ne "") {
      s/ /\+/g;
      s/=/%3d/g;
      push(@SIGNATURE,$_);
      my $tmp_signature = $_;

    ## XSS Pattern
     # < -> %3c
     # > -> %3e
     # ; -> %3b
      s/\</\%3c/g;
      s/\>/\%3e/g;
      push(@SIGNATURE,$_) if ($_ ne $tmp_signature);
 
    ## SQL Pattern
      $_ = $tmp_signature;
     # ; -> %3b
      s/\;/\%3b/g;
      push(@SIGNATURE,$_) if ($_ ne $tmp_signature);

    ## Execute Pattern
      $_ = $tmp_signature;
     # | -> %7c
      s/\|/\%7c/g;
      push(@SIGNATURE,$_) if ($_ ne $tmp_signature); 
    } 
  }
  close (IN);
}

##
## Server Access Routine
##
sub process_request{
 # find out who connected
  my @message;

  my $leng = 0;
  while ($_=<STDIN>) {
    if (/Content-Length/i) {
       $leng = $_; 
       $leng=~ s/Content-Length: //i;
    } 
    last if (/^[\r\n]/);
    push (@message,$_);
  }

  my $data;
  push (@message,$_);
  if ($leng) {
    read(STDIN,$data,$leng);
    push (@message,$data);
  }

 # Data Analyze
  &read_data_analyze(@message);

 # request data check
  if ($read_data{"method"} eq "GET" && $read_data{"query_strings"} eq "") {
    # get data
    &http_get();
    return ;
  }

 # Session Begin
#  print STDOUT "Content-Type: text/html\n\n";
  &begin_session();

  print STDOUT "<A HREF=".$CONF{"LINK_HEADER"}."/$TEST_SESSION_ID/>Result</A><BR>\n";
  print STDOUT "start:";

 # Access Web application
  &web_app_test();
  
  undef @message;
  &end_session();
}

###
### http GET method
###
sub http_get() {
  my ($host,$port) = &host_get($read_data{"get_string"},$read_data{"host"}); 
  my @tmp;

  $request{'whisker'}->{'host'} = $host;
  $request{'whisker'}->{'port'} = $port;
  $request{'whisker'}->{'method'} = $read_data{"method"};
  $request{'whisker'}->{'uri'} = $read_data{"get_string"};

 # SSL check
  if ($read_data{"get_string"} =~ /^http:/) {
    $request{'whisker'}->{'ssl'} = 0;
  } elsif ($read_data{"get_string"} =~ /^https:/) {
    $request{'whisker'}->{'ssl'} = 1;
  }

 # Header edit
  foreach (keys %read_data) {
    if ($_ ne "query_strings") {
      push(@tmp , $_.": ".$read_data{$_});
    }
  }
  push (@tmp,"\n");
  $request{'whisker'}->{'raw_header_data'} = join("\n",@tmp);
  undef(@tmp);

 # connection setting
  delete $result{'whisker'}->{'data'};
  LW::http_reset;
  LW::http_fixup_request(\%request);
  $request{'whisker'}->{'uri_orig'} = $request{'whisker'}->{'uri'};

 # connection
  LW::http_do_request(\%request,\%result);

  print $result{'whisker'}->{'data'};
}
 

###
### Begin Session
###
sub begin_session {
  my $sessionid;
  do {
    $sessionid = time().rand(1);
  } while(!mkdir($CONF{"DATA_DIRECTORY"}."/".$sessionid,0777)); 
     
  $TEST_SESSION_ID = $sessionid;
  chdir($CONF{"DATA_DIRECTORY"}."/".$sessionid);
  open (OUT,">index.html");
  $PATTERN_COUNTER = 0;
  
  print OUT "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">\n";
  print OUT "<html>\n<head>\n<title>$TEST_SESSION_ID</title>\n</head>\n<body>\n";
} 

###
### End Session
###
sub end_session {
  print OUT "</body>\n</html>\n";

  close(OUT);
  close CLIENT;
  undef %read_data;
  undef %request;
  print STDOUT ":end\n";
}

###
### Request Data Analyze
###

sub read_data_analyze{
  my @get_data = @_;
  my $tmpdata;
  my @tmp;
  my $name;
  my $value;
  
 # data analyze
  # Request Line
  $tmpdata = shift (@get_data);
  chop ($tmpdata);
  @tmp = split(/ /,$tmpdata);
  
  # Get Method
  $read_data{"method"} = shift (@tmp);

  # Get Param
  ($read_data{"get_string"},$read_data{"query_strings"})
      = split(/\?/,$tmp[0],2);

 # Request Header
  while ($tmpdata = shift(@get_data)) {
    if ($tmpdata !~ /^[\r\n]/) {
      $tmpdata =~ s/[\r\n]//g;
      ($name,$value) = split (/: /,$tmpdata,2);
      $name =~ tr /A-Z/a-z/;
      $name = "Cookie" if ($name eq "cookie");
      $read_data{$name} = $value;
    } elsif (($tmpdata = shift(@get_data)) !~ /^[\r\n]/ && $tmpdata ne "") {
      $read_data{"query_strings"} = 
        join("&",($tmpdata,$read_data{"query_strings"}));
    }
  } 
}

###
### param get
###
sub param_get {
  my ($pattern,$data) = @_;
  my @tmp;
  my %param;

  @tmp = split(/$pattern/,$data);

  foreach (@tmp) {
    my ($name,$value) = split (/=/,$_,2);
    $param{$name} = $value;
  }
  return %param;
}

##
## Host get
##
sub host_get {
  my ($get_string,$get_host) = @_;
  my ($host,$port);

  if ($get_host ne "") {
    $get_string = $get_host;
  } elsif ($get_string =~ /^(http:|https:)/) {
    $get_string =~ s/^(http:|https:)\/\///;
    $get_string =~ s/\/.*//;
  }
  my($host,$port) = split(/:/,$get_string);
  $port = 80 if ($port eq "");
  return ($host,$port);
}
    
###
### Web Application Test
###
sub web_app_test {
  my $host,$port;
  my %param;
  my %cookie;
  my $get_data;
  my @tmp;
  my %send_cookie;
  my %send_param;
  my $data;
  my $cookie;
  my $sig;

 # Connection Host get
  my($host,$port) = &host_get($read_data{"get_string"},$read_data{"host"});
   
 # Param get
  %param = &param_get("&",$read_data{"query_strings"});

 # Cookie get
  %cookie = &param_get("; ",$read_data{"Cookie"});

 # test main routine
  $request{'whisker'}->{'host'} = $host;
  $request{'whisker'}->{'port'} = $port;
  $request{'whisker'}->{'method'} = $read_data{"method"};

 # SSL check
  if ($read_data{"get_string"} =~ /^http:/) {
    $request{'whisker'}->{'ssl'} = 0;
  } elsif ($read_data{"get_string"} =~ /^https:/) {
    $request{'whisker'}->{'ssl'} = 1;
  }

  foreach (keys %read_data) {
    if ($_ ne "get_string" && $_ ne "query_strings" &&
#         $_ ne "Cookie" && $_ ne "HTTP_VER" && $_ ne "method" &&
         $_ ne "Cookie" && $_ ne "method" &&
          !(/^Content-Length$/i) && !(/^Accept-Encoding$/i)) {
      push(@tmp , $_.": ".$read_data{$_} );
    }
  } 
  $data = join("\n",@tmp);
  undef(@tmp);

# cookie check
  $request{'whisker'}->{'data'} = $read_data{"query_strings"};
  foreach my $cookie_key (keys %cookie) {
    foreach $sig (@SIGNATURE) {
      %send_cookie = %cookie;
      $send_cookie{$cookie_key} = $sig;
      my @tmp_cookie;
      foreach (keys %send_cookie) {
        push(@tmp_cookie,$_."=".$send_cookie{$_});
      }
      $cookie = join ("; ",@tmp_cookie);
      undef(@tmp_cookie);
      $request{'whisker'}->{'raw_header_data'} = $data."\nCookie: ".$cookie."\n";
       
   # cookie exploit check
      &check_web_app($cookie_key."=".$sig,"");
    }
  }

# query string check
  $request{'whisker'}->{'raw_header_data'} = $data."\n";
  if ($read_data{"Cookie"} ne "") {
    $request{'whisker'}->{'raw_header_data'} .= "Cookie: ".$read_data{"Cookie"}."\n";
  }
  foreach my $query_key (keys %param) {
    foreach $sig (@SIGNATURE) {
      %send_param = %param;
      $send_param{$query_key} = $sig;
      my @tmp_param;
      foreach (keys %send_param) {
        push(@tmp_param,$_."=".$send_param{$_});
      }
      $request{'whisker'}->{'data'} = join ("&",@tmp_param);
      undef (@tmp_param);
      
   # param exploit check
      &check_web_app("",$query_key."=".$sig);
    }
  } 
}

##
## sanitizing
##
sub sanitize {
  my ($input) = @_;
  $input =~ s/&/&amp;/g;
  $input =~ s/</&lt;/g;
  $input =~ s/>/&gt;/g;
  $input =~ s/"/&quot;/g;
  $input =~ s/'/&#39;/g;

  return $input;
}

##
## Web Application Check Module
##
sub check_web_app {
  my ($cookie,$param) = @_;

 # uri setting
  $request{'whisker'}->{'uri'} = $read_data{"get_string"};
  $request{'whisker'}->{'uri'} .= "?".$request{'whisker'}->{'data'} if ($request{'whisker'}->{'method'} eq "GET");

 # sanitize
  $param = &sanitize($param);
  $cookie = &sanitize($cookie);
  my $uri = &sanitize($request{'whisker'}->{'uri'});

 # first setting
  LW::http_reset;
  delete $result{'whisker'}->{'data'};
  $PATTERN_COUNTER++;
  mkdir ("./$PATTERN_COUNTER/",0777);
  open (RESULT,">./$PATTERN_COUNTER/index.html");

  print OUT "<p><A HREF='./$PATTERN_COUNTER/index.html'>";
  print OUT "URL: ".$uri."<br>\n";
  print OUT "Parameter: $param<br>\n";
  print OUT "Cookie: $cookie<br>\n</a></p>\n";
  
 # connection setting
  delete $request{'Content-Length'};
  LW::http_fixup_request(\%request);
  $request{'whisker'}->{'uri_orig'} = $request{'whisker'}->{'uri'};

 # connection
  LW::http_do_request(\%request,\%result);

  print RESULT $result{'whisker'}->{'data'};
  print STDOUT "-";

  close (RESULT);
}
