#!/bin/sh

PROG=samma
TMPFILE=testmail
HOMEDIR=`pwd`
CONFDIR=/usr/local/etc/samma
PORT=25
HOST=localhost
RCPTDBTXT=${CONFDIR}/rcptdb.txt
RCPTDB=${CONFDIR}/rcpt.db
SENDDBTXT=${CONFDIR}/senderdb.txt
SENDDB=${CONFDIR}/sender.db
DBTYPE=hash
TMPLFILE=${CONFDIR}/samma.tmpl
TMPDIR=${HOMEDIR}/tmp/policytest/attach
TMPDIR2=${HOMEDIR}/tmp/policytest/source
PARSEMAIL=${HOMEDIR}/parsemail
XENCHEADER="X-SaMMA-Enc"
ADDRPASS1="address"
DOMPASS1="domain"
SUBPASS1="sub"

set_sender()
{
    # set sender
    case $1 in
        [1-7])
            SENDER="send0$1@send$1.designet.co.jp"
            SUSER="send0$1"
        ;;
        *)
            echo "not found SENDER($1)"
            #exit
        ;;
        esac
}

set_rcpt()
{
    # set rcpt
    case $1 in
        0)
            TMPRCPT=""
            TMPRUSER=""
        ;;
        [1-6])
            TMPRCPT="rcpt0$1@rcpt$1.designet.co.jp"
            TMPRUSER="rcpt0$1"
	;;
        [7-9])
            TMPRCPT="rcpt0$1@sub.rcpt$1.designet.co.jp"
            TMPRUSER="rcpt0$1"
        ;;
        10)
            TMPRCPT="rcpt10@rcpt10.designet.co.jp"
            TMPRUSER="rcpt10"
        ;;
        *)
            echo "not found RCPT($1)"
            #exit
        ;;
        esac
}

make_mail()
{
    cat header > ${TMPFILE}

    if [ $1 -eq 0 ] && [ $2 -eq 0 ] && [ $3 -eq 0 ];
    then
        echo "" >> ${TMPFILE}
        cat body >> ${TMPFILE}
    else
        cat multiheader >> ${TMPFILE}
        echo "" >> ${TMPFILE}
        cat multibody >> ${TMPFILE}
    fi

    set_file $1
    set_file $2
    set_file $3

    if [ $1 -eq 0 -a $2 -eq 0 -a $3 -eq 0 ];
    then
        echo "." >> ${TMPFILE}
    else
        cat multifooter >> ${TMPFILE}
        echo "." >> ${TMPFILE}
    fi
}

set_file()
{
    # set attach file
    case $1 in
        0)
        ;;
        1)
            cat ${HOMEDIR}/PMSG/test1.txt >> ${TMPFILE}
        ;;
        2)
            cat ${HOMEDIR}/PMSG/test2.txt >> ${TMPFILE}
        ;;
        *)
            echo "not found FILE($1)"
	    #exit
        ;;
        esac
}

sender_check_mail()
{
    case $1 in
        0)
            /bin/ls /home/$2/Maildir/new/* > /dev/null 2>&1
            if [ $? -eq 0 ];
            then
                echo "sender check error"
            fi
        ;;
        1)
            /bin/ls /home/$2/Maildir/new/* > /dev/null 2>&1
            if [ $? -ne 0 ];
            then
                echo "sender check error"
            fi
            ONETIMEPASS=`/bin/grep PassWord: /home/$2/Maildir/new/* | cut -d " " -f 2`
        ;;
        *)
            echo "not found SENDER RETCODE($1)"
            #exit
        ;;
        esac
}

rcpt_check_mail()
{
    case $1 in
        0)
            /bin/ls /home/$2/Maildir/new/* > /dev/null 2>&1
            if [ $? -eq 0 ];
            then
                echo "rcpt check error(1)"
            fi
        ;;
        1)
            check_enc_mail $2 ${ADDRPASS1} $3 $4 $5
        ;;
        2)
            check_enc_mail $2 ${DOMPASS1} $3 $4 $5
        ;;
        3)
            check_enc_mail $2 ${SUBPASS1} $3 $4 $5
        ;;
        4)
            check_enc_mail $2 ${ONETIMEPASS} $3 $4 $5
        ;;
        5)
            /bin/ls /home/$2/Maildir/new/* > /dev/null 2>&1
            if [ $? -ne 0 ];
            then
                echo "rcpt check error(1)"
            fi
        ;;
        *)
            echo "not found RCPT RETCODE($1)"
            #exit
        ;;
        esac
}

check_enc_mail()
{
    MAILPATH=`/bin/ls /home/$1/Maildir/new/*` 2>&1
    if [ $? -ne 0 ];
    then
        echo "rcpt check error(1: mail error)"
    fi

    /bin/grep ${XENCHEADER} ${MAILPATH} > /dev/null 2>&1
    if [ $? -ne 0 ];
    then
        echo "rcpt check error(2: header error)"
    fi

    ${PARSEMAIL} ${MAILPATH} ${TMPDIR} > /dev/null 2>&1
    ATTACHFILE=`/bin/ls ${TMPDIR}/*` 2>&1
    if [ $? -ne 0 ];
    then
        echo "rcpt check error(2: attach file error)"
    fi

    /usr/bin/unzip -P $2 -d ${TMPDIR2} ${ATTACHFILE} > /dev/null 2>&1
    #/usr/bin/unzip -P $2 -d ${TMPDIR2} ${ATTACHFILE} > /dev/null 
    if [ $? -ne 0 ];
    then
	echo "/usr/bin/unzip -P $2 -d ${TMPDIR2} ${ATTACHFILE} > /dev/null 2>&1"
        echo "rcpt check error(3: zip error)"
    fi

    ATTNUM=`/bin/ls ${TMPDIR2} | wc -l` 2>&1
    if [ $3 -ne 0 ];
    then
        TMPNUM=1
    fi
    if [ $4 -ne 0 ];
    then
        TMPNUM=`expr ${TMPNUM} + 1` 2>&1
    fi
    if [ $5 -ne 0 ];
    then
        TMPNUM=`expr ${TMPNUM} + 1` 2>&1
    fi
    if [ ${ATTNUM} -ne ${TMPNUM} ];
    then
        echo "rcpt check error(3: attac file num error)"
    fi

    check_file $3
    check_file $4
    check_file $5

    /bin/rm -f ${TMPDIR}/*
    /bin/rm -f ${TMPDIR2}/*
}

check_file()
{
    FILE1=${HOMEDIR}/ORG/test1.txt
    FILE2=${HOMEDIR}/ORG/test2.txt
    case $1 in
        0)
        ;;
        1)
            /usr/bin/diff ${FILE1} ${TMPDIR2}/test1.txt > /dev/null 2>&1
            if [ $? -ne 0 ];
            then
                /usr/bin/diff ${FILE1} ${TMPDIR2}/test1\(1\).txt > /dev/null 2>&1
                if [ $? -ne 0 ];
                then
                    /usr/bin/diff ${FILE1} ${TMPDIR2}/test1\(2\).txt > /dev/null 2>&1
                    if [ $? -ne 0 ];
                    then
            		/usr/bin/diff ${FILE1} ${TMPDIR2}/test1\(3\).txt > /dev/null 2>&1
            		if [ $? -ne 0 ];
            		then
			    echo "check file error"
            		fi
		    fi
		fi
	    fi
        ;;
        2)
            /usr/bin/diff ${FILE2} ${TMPDIR2}/test2.txt > /dev/null 2>&1
            if [ $? -ne 0 ];
            then
                /usr/bin/diff ${FILE2} ${TMPDIR2}/test2\(1\).txt > /dev/null 2>&1
                if [ $? -ne 0 ];
                then
                    /usr/bin/diff ${FILE2} ${TMPDIR2}/test2\(2\).txt > /dev/null 2>&1
                    if [ $? -ne 0 ];
                    then
            		/usr/bin/diff ${FILE2} ${TMPDIR2}/test2\(3\).txt > /dev/null 2>&1
            		if [ $? -ne 0 ];
            		then
			    echo "check file error"
            		fi
		    fi
		fi
	    fi
        ;;
        *)
            echo "not found FILE($1)"
            #exit
        ;;
        esac
}

##########################################################################
# init
##########################################################################
if [ `/usr/bin/id -u` -ne 0 ];
then
    echo "Please execute by \"root\" user."
    exit
fi

if [ $# -ne 1 ];
then
    echo "usage: policy.sh [pattern file]"
    exit
fi

if [ ! -f $1 ];
then
    echo "invalid pattern file"
    exit
fi

# 桼Ѱ
/bin/grep send01 /etc/passwd > /dev/null 2>&1
if [ $? -ne 0 ];
then
    /usr/sbin/useradd send01
fi

/bin/grep send02 /etc/passwd > /dev/null 2>&1
if [ $? -ne 0 ];
then
    /usr/sbin/useradd send02
fi

/bin/grep send03 /etc/passwd > /dev/null 2>&1
if [ $? -ne 0 ];
then
    /usr/sbin/useradd send03
fi

/bin/grep send04 /etc/passwd > /dev/null 2>&1
if [ $? -ne 0 ];
then
    /usr/sbin/useradd send04
fi

/bin/grep send05 /etc/passwd > /dev/null 2>&1
if [ $? -ne 0 ];
then
    /usr/sbin/useradd send05
fi


/bin/grep send06 /etc/passwd > /dev/null 2>&1
if [ $? -ne 0 ];
then
    /usr/sbin/useradd send06
fi

/bin/grep send07 /etc/passwd > /dev/null 2>&1
if [ $? -ne 0 ];
then
    /usr/sbin/useradd send07
fi

/bin/grep rcpt01: /etc/passwd > /dev/null 2>&1
if [ $? -ne 0 ];
then
    /usr/sbin/useradd rcpt01
fi

/bin/grep rcpt02: /etc/passwd > /dev/null 2>&1
if [ $? -ne 0 ];
then
    /usr/sbin/useradd rcpt02
fi

/bin/grep rcpt03: /etc/passwd > /dev/null 2>&1
if [ $? -ne 0 ];
then
    /usr/sbin/useradd rcpt03
fi

/bin/grep rcpt04: /etc/passwd > /dev/null 2>&1
if [ $? -ne 0 ];
then
    /usr/sbin/useradd rcpt04
fi

/bin/grep rcpt05: /etc/passwd > /dev/null 2>&1
if [ $? -ne 0 ];
then
    /usr/sbin/useradd rcpt05
fi

/bin/grep rcpt06: /etc/passwd > /dev/null 2>&1
if [ $? -ne 0 ];
then
    /usr/sbin/useradd rcpt06
fi

/bin/grep rcpt07: /etc/passwd > /dev/null 2>&1
if [ $? -ne 0 ];
then
    /usr/sbin/useradd rcpt07
fi

/bin/grep rcpt08: /etc/passwd > /dev/null 2>&1
if [ $? -ne 0 ];
then
    /usr/sbin/useradd rcpt08
fi

/bin/grep rcpt09: /etc/passwd > /dev/null 2>&1
if [ $? -ne 0 ];
then
    /usr/sbin/useradd rcpt09
fi

/bin/grep rcpt10: /etc/passwd > /dev/null 2>&1
if [ $? -ne 0 ];
then
    /usr/sbin/useradd rcpt10
fi

echo "send01@send1.designet.co.jp" > ${SENDDBTXT}
echo "!send02@send2.designet.co.jp" >> ${SENDDBTXT}
echo "@send3.designet.co.jp" >> ${SENDDBTXT}
echo "!@send4.designet.co.jp" >> ${SENDDBTXT}
echo "send5.designet.co.jp" >> ${SENDDBTXT}
echo "!send6.designet.co.jp" >> ${SENDDBTXT}
if [ -f ${SENDDB} ];
then
    /bin/mv ${SENDDB} ${SENDDB}.bak
fi
/usr/sbin/makemap -e ${DBTYPE} ${SENDDB} < ${SENDDBTXT}
if [ $? -ne 0 ];
then
    echo "make sender db faild"
    exit 1
fi

echo "rcpt01@rcpt1.designet.co.jp address" > ${RCPTDBTXT}
echo "rcpt02@rcpt2.designet.co.jp" >> ${RCPTDBTXT}
echo "!rcpt03@rcpt3.designet.co.jp" >> ${RCPTDBTXT}
echo "@rcpt4.designet.co.jp domain" >> ${RCPTDBTXT}
echo "@rcpt5.designet.co.jp" >> ${RCPTDBTXT}
echo "!@rcpt6.designet.co.jp" >> ${RCPTDBTXT}
echo "rcpt7.designet.co.jp sub" >> ${RCPTDBTXT}
echo "rcpt8.designet.co.jp" >> ${RCPTDBTXT}
echo "!rcpt9.designet.co.jp" >> ${RCPTDBTXT}
if [ -f ${RCPTDB} ];
then
    /bin/mv ${RCPTDB} ${RCPTDB}.bak
fi
/usr/sbin/makemap -e ${DBTYPE} ${RCPTDB} < ${RCPTDBTXT}
if [ $? -ne 0 ];
then
    echo "make rcpt db faild"
    exit 1
fi

if [ -f ${TMPLFILE} ];
then
    mv ${TMPLFILE} ${TMPLFILE}.bak
fi
echo "PassWord: <@@PASSWORD@@>" > ${TMPLFILE}
./reload.expect > /dev/null 2>&1
sleep 1

if [ ! -d ${TMPDIR} ];
then
    /bin/mkdir -p ${TMPDIR}
fi
if [ ! -d ${TMPDIR2} ];
then
    /bin/mkdir -p ${TMPDIR2}
fi

##########################################################################
# main
##########################################################################
cat $1 | while read P S R1 R2 R3 F1 F2 F3 RS RR1 RR2 RR3
do
    echo $P $S $R1 $R2 $R3 $F1 $F2 $F3 $RS $RR1 $RR2 $RR3

    # set sender and recipient
    set_sender ${S}
    set_rcpt ${R1}
    RCPT1=${TMPRCPT}
    RUSER1=${TMPRUSER}
    set_rcpt ${R2}
    RCPT2=${TMPRCPT}
    RUSER2=${TMPRUSER}
    set_rcpt ${R3}
    RCPT3=${TMPRCPT}
    RUSER3=${TMPRUSER}

    # make mail
    make_mail ${F1} ${F2} ${F3} 

    # set mail
    cp ${TMPFILE} ${HOMEDIR}/virus.txt

    # remove mail
    /bin/rm -f /home/*/Maildir/new/*
    # remove attach file
    /bin/rm -rf ${TMPDIR}/*
    /bin/rm -rf ${TMPDIR2}/*

    # send mail
    ${HOMEDIR}/rlytest -f ${SENDER} -p ${PORT} ${HOST} ${RCPT1} ${RCPT2} ${RCPT3} > /dev/null 2>&1
    #echo "${HOMEDIR}/rlytest -f ${SENDER} -p ${PORT} ${HOST} ${RCPT1} ${RCPT2} ${RCPT3}"
    #${HOMEDIR}/rlytest -f ${SENDER} -p ${PORT} ${HOST} ${RCPT1} ${RCPT2} ${RCPT3}
    if [ $? -ne 0 ];
    then
        echo "send mail error"
    fi

    sleep 3

    ######################################################################
    # check
    ######################################################################
    sender_check_mail $RS $SUSER
    rcpt_check_mail $RR1 $RUSER1 ${F1} ${F2} ${F3}
    rcpt_check_mail $RR2 $RUSER2 ${F1} ${F2} ${F3}
    rcpt_check_mail $RR3 $RUSER3 ${F1} ${F2} ${F3} 
done

######################################################################
# shutdown
######################################################################
/bin/mv ${TMPLFILE}.bak ${TMPLFILE}
PID=`ps -eo pid,comm | grep ${PROG} | awk '{print $1}'`
#/bin/kill ${PID}
/bin/mv ${RCPTDB}.bak ${RCPTDB}
/bin/mv ${SENDDB}.bak ${SENDDB}
/bin/rm -rf ${TMPDIR}
/bin/rm -rf ${TMPDIR2}
