<?php
/**
 * Research Artisan Lite: Website Access Analyzer
 * Copyright (C) 2009 Research Artisan Project
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * @copyright Copyright (C) 2009 Research Artisan Project
 * @license GNU General Public License (see license.txt)
 * @author ossi
 */
class ResearchHelper extends BaseHelper {

  public function __construct(RaRequest $request, RaSession $session, RaMessage $message, RaResult $result=null, $controller, $action) {
    parent::__construct($request, $session, $message, $result, $controller, $action);
  }
  
  public function getTextData() {
    return $this->result->get('textData');
  }

  public function getRemoteAddrResult() {
    $rtn = '';
    $remoteAddr = $this->result->get('remoteAddr');
    if (is_array($remoteAddr)) {
      foreach($remoteAddr as $v) {
        $rtn = $v;
        break;
      }
    } 
    return $rtn;
  }

  public function getRemoteHostResult() {
    $rtn = '';
    $remoteHost = $this->result->get('remoteHost');
    if (is_array($remoteHost)) {
      foreach($remoteHost as $v) {
        $rtn = $v;
        break;
      }
    } 
    return $rtn;
  }

  public function getDomainResult() {
    $rtn = '';
    $domain = $this->result->get('domain');
    if (is_array($domain)) {
      foreach($domain as $v) {
        $rtn = $v;
        break;
      }
    } 
    return $rtn;
  }

  public function getEngine() {
    return $this->request->get('engine');
  }

  public function getBrowser() {
    return $this->request->get('browser');
  }

  public function getBrowserImage($browser, $default=false) {
    return isset(Config::$browserImageLists[$browser]) ? Config::IMAGE_DIR_BROWSER. Config::$browserImageLists[$browser] : ($default ? 'spacer.png' : null);
  }

  public function getOsImage($os, $default=false) {
    return isset(Config::$osImageLists[$os]) ? Config::IMAGE_DIR_OS. Config::$osImageLists[$os] : ($default ? 'spacer.png' : null);
  }

  public function getHostImage($host, $default=false) {
    if (Track::checkUrl($host)) {
      $urls = parse_url($host);
      $host = $urls['host'];
    }
    $domain = Track::getDomain($host);
    if (substr_count($domain, '.') > 0) list($host,$trash) = explode('.', $domain);
    return isset(Config::$hostImageLists[$host]) ? Config::IMAGE_DIR_HOST. Config::$hostImageLists[$host] : ($default ? 'spacer.png' : null);
  }

  public function getCountryImage($country, $default=false) {
    return in_array($country, Config::$countryTopLevelDomains) ? Config::IMAGE_DIR_COUNTRY. array_search($country, Config::$countryTopLevelDomains). '.png' : ($default ? 'spacer.png' : null);
  }

  public function getPrefImage($pref, $default=false) {
    return in_array($pref, Config::$prefs) ? Config::IMAGE_DIR_PREF.  array_search($pref, Config::$prefs). '.png' : ($default ? 'spacer.png' : null);
  }

  public function getEvenClass($i) {
    return (($i + 1) % 2 == 0) ? '_even' : '';
  }

  public function uniqueCount() {
    print $this->getFormatNumber($this->result->get('uniqueCount'));
  }

  public function totalCount() {
    print $this->getFormatNumber($this->result->get('totalCount'));
  }

  public function uniqueAverage() {
    print round($this->result->get('uniqueCount') / $this->_getLastDay());
  }

  public function totalAverage() {
    print round($this->result->get('totalCount') / $this->_getLastDay());
  }

  public function clickLinkCount() {
    print $this->getFormatNumber($this->result->get('clickLinkCount'));
  }

  public function clickBtnCount() {
    print $this->getFormatNumber($this->result->get('clickBtnCount'));
  }

  public function clickAdsenseCount() {
    print $this->getFormatNumber($this->result->get('clickAdsenseCount'));
  }

  public function engine() {
    print $this->getEngine();
  }

  public function browser() {
    print $this->getBrowser();
  }

  public function remoteAddr() {
    print $this->getRemoteAddrResult();
  }

  public function remoteHost() {
    print $this->getRemoteHostResult();
  }

  public function pageTag($pageCount) {
    $count = null;
    if ($pageCount == self::PAGE_COUNT_UNIQUE) $count = $this->result->get('uniqueCount');
    if ($pageCount == self::PAGE_COUNT_ALL) $count = $this->result->get('totalCount')
                                                     + $this->result->get('clickLinkCount')
                                                     + $this->result->get('clickBtnCount')
                                                     + $this->result->get('clickAdsenseCount');

    parent::pageTag($count);
  }

  public function timePageTag() {
    $html = '<div class="page">';
    if ($this->request->get('select') == 0) {
      $html .= '<a href="'. $this->getIndexUrl('research', 'time_detail', '&amp;select=1'). '">1時のアクセス詳細&#8811;</a>';
    } else if ($this->request->get('select') == 23) {
      $html .= '<a href="'. $this->getIndexUrl('research', 'time_detail', '&amp;select=22'). '">&#8810;22時のアクセス詳細</a>';
    } else {
      $html .= '<a href="'. $this->getIndexUrl('research', 'time_detail', '&amp;select=' . ($this->request->get('select') - 1)) . '">&#8810;' . ($this->request->get('select') - 1) . '時のアクセス詳細</a>';
      $html .= '<a href="'. $this->getIndexUrl('research', 'time_detail', '&amp;select=' . ($this->request->get('select') + 1)) . '">' . ($this->request->get('select') + 1) . '時のアクセス詳細&#8811;</a>';
    }
    $html .= '</div>';
    print $html;
  }

  public function resultTag() {
    $summaryData = $this->result->get('summaryData');
    $totalCount = $this->result->get('totalCount');
    $siteData = $this->session->get('siteData');
    $action = $this->action;
    $page = !is_null($this->request->get('page')) ? $this->request->get('page') : 1;

    $html = '';

    $i = 0;
    $pageCount = 1;
    foreach ($summaryData as $key => $value) {
      if ($pageCount >= $siteData['dispview'] * ($page - 1) + 1 && $pageCount <= $siteData['dispview'] * $page) {
        $html .= '<tr>';
        switch ($action) {
          case 'brow':
            $dispBrowImg = $this->getBrowserImage($key);
            if (is_null($dispBrowImg)) {
              $html .= '<td class="tdcol1' . $this->getEvenClass($i) . '"><a href="'.$this->getIndexUrl('research', $action. '_ver', '&amp;select=' . $this->urlEncode($key)) . '">' . $this->substrMax($this->escapeHtml($key), Config::MAX_DISP_LENGTH) . '</a></td>';
            } else {
              $html .= '<td class="tdcol1' . $this->getEvenClass($i) . '"><span class="favi"><img class="img" alt="' . $key . '" src="./images/' . $dispBrowImg . '" title="' . $key . '" /></span><a href="'.$this->getIndexUrl('research', $action . '_ver', '&amp;select=' . $this->urlEncode($key)) . '">' . $this->substrMax($this->escapeHtml($key), Config::MAX_DISP_LENGTH) . '</a></td>';
            }
            break;
          case 'brow_ver':
            $html .= '<td class="tdcol1' . $this->getEvenClass($i) . '"><a href="'. $this->getIndexUrl('research', 'brow_user', '&amp;select=' . $this->urlEncode($key). '&amp;browser='. $this->getSelect()) . '" title="' . $key . '">' . $this->substrMax($this->escapeHtml($key), Config::MAX_DISP_LENGTH). '</a></td>';
            break;
          case 'os':
            $dispOsImg = $this->getOsImage($key);
            if (is_null($dispOsImg)) {
              $html .= '<td class="tdcol1' . $this->getEvenClass($i) . '"><a href="'. $this->getIndexUrl('research', $action . '_user', '&amp;select=' . $this->urlEncode($key)) . '">' . $this->substrMax($this->escapeHtml($key), Config::MAX_DISP_LENGTH) . '</a></td>';
            } else {
              $html .= '<td class="tdcol1' . $this->getEvenClass($i) . '"><span class="favi"><img class="img" alt="' . $key . '" src="./images/' . $dispOsImg . '" title="' . $key . '" /></span><a href="'. $this->getIndexUrl('research', $action . '_user', '&amp;select=' . $this->urlEncode($key)) . '">' . $this->substrMax($this->escapeHtml($key), Config::MAX_DISP_LENGTH) . '</a></td>';
            }
            break;
          case 'host':
          case 'referer':
            $dispHostImg = $this->getHostImage($key);
            if (is_null($dispHostImg)) {
              $html .= '<td class="tdcol1' . $this->getEvenClass($i) . '"><a href="'. $this->getIndexUrl('research', $action . '_user', '&amp;select=' . $this->urlEncode($key)) . '">' . $this->substrMax($this->escapeHtml($key), Config::MAX_DISP_LENGTH) . '</a></td>';
            } else {
              $html .= '<td class="tdcol1' . $this->getEvenClass($i) . '"><span class="favi"><img class="img" alt="' . $key . '" src="./images/' . $dispHostImg . '" title="' . $key . '" /></span><a href="'. $this->getIndexUrl('research', $action . '_user', '&amp;select=' . $this->urlEncode($key)) . '">' . $this->substrMax($this->escapeHtml($key), Config::MAX_DISP_LENGTH) . '</a></td>';
            }
            break;
          case 'engine':
            $dispHostImg = $this->getHostImage($key);
            if (is_null($dispHostImg)) {
              $html .= '<td class="tdcol1' . $this->getEvenClass($i) . '"><a href="'. $this->getIndexUrl('research', $action . '_key', '&amp;select=' . $this->urlEncode($key)) . '">' . $this->substrMax($this->escapeHtml($key), Config::MAX_DISP_LENGTH) . '</a></td>';
            } else {
              $html .= '<td class="tdcol1' . $this->getEvenClass($i) . '"><span class="favi"><img class="img" alt="' . $key . '" src="./images/' . $dispHostImg . '" title="' . $key . '" /></span><a href="'. $this->getIndexUrl('research', $action . '_key', '&amp;select=' . $this->urlEncode($key)) . '">' . $this->substrMax($this->escapeHtml($key), Config::MAX_DISP_LENGTH) . '</a></td>';
            }
            break;
          case 'engine_key':
            $html .= '<td class="tdcol1' . $this->getEvenClass($i) . '"><a href="'. $this->getIndexUrl('research', 'engine_user', '&amp;select=' . $this->urlEncode($key). '&amp;engine='. $this->getSelect()) . '" title="' . $key . '">' . $this->substrMax($this->escapeHtml($key), Config::MAX_DISP_LENGTH). '</a></td>';
            break;
          case 'domain':
          case 'jpdomain':
            $html .= '<td class="tdcol1' . $this->getEvenClass($i) . '"><a href="'. $this->getIndexUrl('research', $action . '_user', '&amp;select=' . $this->urlEncode($key)) . '" title="' . $key . '">' . $this->substrMax($this->getDomain($key), Config::MAX_DISP_LENGTH). '</a>'. $this->getDomainEdit($key). '</td>';
            break;
          case 'word':
            $html .= '<td class="tdcol1' . $this->getEvenClass($i) . '"><a href="'. $this->getJumpUrl(Config::SEARCH_URL. $key). '" title="' . $key . '">' . $this->substrMax($this->escapeHtml($key), Config::MAX_DISP_LENGTH). '</a></td>';
            break;
          case 'rank':
          case 'pagein':
          case 'pageout':
          case 'adsensepagerank':
          case 'btnrank':
          case 'clickrank':
            $html .= '<td class="tdcol1' . $this->getEvenClass($i) . '"><a href="'. $this->getIndexUrl('research', $action . '_user', '&amp;select=' . $this->urlEncode($key)) . '" title="' . $key . '">' . $this->substrMax($this->getTitle($this->escapeHtml($key)), Config::MAX_DISP_LENGTH). '</a></td>';
            break;
          case 'country':
            $dispCountryImg = $this->getCountryImage($key);
            if (is_null($dispCountryImg)) {
              $html .= '<td class="tdcol1' . $this->getEvenClass($i) . '"><a href="'.$this->getIndexUrl('research', $action. '_user', '&amp;select=' . $this->urlEncode($key)) . '">' . $this->substrMax($this->escapeHtml($key), Config::MAX_DISP_LENGTH) . '</a></td>';
            } else {
              $html .= '<td class="tdcol1' . $this->getEvenClass($i) . '"><span class="favi_nosize"><img class="img" alt="' . $key . '" src="./images/' . $dispCountryImg . '" title="' . $key . '" /></span><a href="'.$this->getIndexUrl('research', $action . '_user', '&amp;select=' . $this->urlEncode($key)) . '">' . $this->substrMax($this->escapeHtml($key), Config::MAX_DISP_LENGTH) . '</a></td>';
            }
            break;
          case 'pref':
            $dispPrefImg = $this->getPrefImage($key);
            if (is_null($dispPrefImg)) {
              $html .= '<td class="tdcol1' . $this->getEvenClass($i) . '"><a href="'.$this->getIndexUrl('research', $action. '_user', '&amp;select=' . $this->urlEncode($key)) . '">' . $this->substrMax($this->escapeHtml($key), Config::MAX_DISP_LENGTH) . '</a></td>';
            } else {
	              $html .= '<td class="tdcol1' . $this->getEvenClass($i) . '"><span class="favi"><img class="img" alt="' . $key . '" src="./images/' . $dispPrefImg . '" title="' . $key . '" /></span><a href="'.$this->getIndexUrl('research', $action . '_user', '&amp;select=' . $this->urlEncode($key)) . '">' . $this->substrMax($this->escapeHtml($key), Config::MAX_DISP_LENGTH) . '</a></td>';
            }
            break;
          default:
            $html .= '<td class="tdcol1' . $this->getEvenClass($i) . '"><a href="'. $this->getIndexUrl('research', $action . '_user', '&amp;select=' . $this->urlEncode($key)) . '" title="' . $key . '">' . $this->substrMax($this->escapeHtml($key), Config::MAX_DISP_LENGTH). '</a></td>';
            break;
        }
        $html .= '<td class="tdcol2' . $this->getEvenClass($i) . '"><span class="totalcolor">' . $this->getFormatNumber($value) . '</span></td>';
        $html .= '<td class="tdcol3' . $this->getEvenClass($i) . '">' . round($value * 100 / $totalCount, 2) . '%</td>';
        $html .= '<td class="tdcol4' . $this->getEvenClass($i) . '"><img alt="' . $value . '" title="' . $value . '" width="' . round($value * 100 / $totalCount, 0) . '%" height="25" src="./images/count.png" /></td>';
        $html .= '</tr>';
        if ($i == $siteData['dispview']) {
          break;
        }
        ++$i;
      }
      ++$pageCount;
    }
    print $html;
  }

  public function resultUserTag() {
    $summaryData = $this->result->get('summaryData');
    $totalCount = $this->result->get('totalCount');
    $remoteAddr = $this->result->get('remoteAddr');
    $remoteHost = $this->result->get('remoteHost');
    $domain = $this->result->get('domain');
    $os = $this->result->get('os');
    $browser = $this->result->get('browser');
    $siteData = $this->session->get('siteData');
    $page = !is_null($this->request->get('page')) ? $this->request->get('page') : 1;

    $html = '';

    $i=0;
    $pageCount=1;
    foreach ($summaryData as $key => $value) {
      if ($pageCount >= $siteData['dispview'] * ($page - 1) + 1 && $pageCount <= $siteData['dispview'] * $page) {

        $dispOs = $os[$key];
        $dispOsImg = $this->getOsImage($dispOs, true);
        $dispBrow = $browser[$key];
        $dispBrowImg = $this->getBrowserImage($dispBrow, true);

        $html .= '<tr>';
        $html .= '<td class="tdcol1_1'. $this->getEvenClass($i). '">';
        $html .= '<a href="'. $this->getIndexUrl('research', 'uid_detail', '&amp;select='. $this->urlEncode($key)). '" title="'. $key. '">'. $this->getAlias($key). '</a>';
        $html .= '<div class="osbrow">';
        $html .= '<span class="favi"><img src="./images/'. $dispOsImg. '" alt="'. $dispOs. '" title="'. $dispOs. '" /></span>';
        $html .= '<span class="favi"><img src="./images/'. $dispBrowImg. '" alt="'. $dispBrow. '" title="'. $dispBrow. '" /></span>';
        $html .= '<span class="alias"><a href="'. $this->getIndexUrl('admin', 'aliasedit', '&amp;select='. $this->urlEncode($key)). '">訪問者名設定</a></span>';
        $html .= '</div>';
        $html .= '</td>';
        $html .= '<td class="tdcol1_2'. $this->getEvenClass($i). '">';
        $html .= '<p>';
        foreach ($remoteAddr as $k => $v) {
          if ($key . $v == $k) {
            $html .= '<a href="'. $this->getIndexUrl('research', 'ip_user', '&amp;select='. $this->urlEncode($v)). '" title="'. $v. '">'. $v. '</a><br />';
          }
        }
        $html .= '</p>';
        $html .= '<p>';
        foreach ($domain as $k => $v) {
          if ($key . $v == $k) {
            $html .= '<a href="'. $this->getIndexUrl('research', 'domain_user', '&amp;select='. $this->urlEncode($v)). '" title="'. $v. '">'. $this->getDomain($v). '</a><br />';
          }
        }
        $html .= '</p>';
        $html .= '</td>';
        $html .= '<td class="tdcol2'. $this->getEvenClass($i). '"><span class="totalcolor">'. $this->getFormatNumber($value). '</span></td>';
        $html .= '<td class="tdcol3'. $this->getEvenClass($i). '">'. round($value * 100 / $totalCount, 2). '%</td>';
        $html .= '<td class="tdcol4'. $this->getEvenClass($i). '"><img alt="'. $value. '" title="'. $value. '" width="'. round($value * 100 / $totalCount, 0). '%" height="25" src="./images/count.png" /></td>';
        $html .= '</tr>';
        if ($i == $siteData['dispview']) {
          break;
        }
        ++$i;
      }
      ++$pageCount;
    }

    print $html;
  }

  public function resultTimeTag() {
    $uniqueData = $this->result->get('uniqueData');
    $totalData = $this->result->get('totalData');

    if (count($totalData)>0) {
      $max = $totalData;
      rsort($max);
      $maxValue = $max[0];
    } else {
      $maxValue = 0;
    }

    $html = '';

    $html .= '<tr>';
    for ($i = 0; $i <= 23; $i++) {
      if (isset($uniqueData[$i]) && $maxValue > 0) {
        $newHeight = round(($uniqueData[$i] * 50) / $maxValue * 5);
        $newHeightAlt = $this->getFormatNumber($uniqueData[$i]);
        $newPng = './images/newcount.png';
      } else {
        $newHeight = 250;
        $newHeightAlt = '';
        $newPng = './images/spacer.png';
      }
      if (isset($totalData[$i]) && $maxValue > 0) {
        $timeHeight = round(($totalData[$i] * 50) / $maxValue * 5);
        $timeHeightAlt = $this->getFormatNumber($totalData[$i]);
        $timePng = './images/timecount.png';
      } else {
        $timeHeight = 250;
        $timeHeightAlt = '';
        $timePng = './images/spacer.png';
      }
      $html .= '<td class="tdtime" align="center" valign="bottom">';
      $html .= '<img width="15" height="'. $newHeight. '" alt="'. $newHeightAlt. '" title="'. $newHeightAlt. '" src="'. $newPng. '" />';
      $html .= '<img width="15" height="'. $timeHeight. '" alt="'. $timeHeightAlt. '" title="'. $timeHeightAlt. '" src="'. $timePng. '" /></td>';
    }
    $html .= '</tr>';
    $html .= '<tr>';
    for ($i = 0; $i <= 23; $i++) {
      if (isset($uniqueData[$i])) {
        $newCount = $this->getFormatNumber($uniqueData[$i]);
      } else {
        $newCount = 0;
      }
      if (isset($totalData[$i])) {
        $timeCount = $this->getFormatNumber($totalData[$i]);
      } else {
        $timeCount = 0;
      }
      $clsNameUniq = 'uniqcolor';
      $clsNameTotal = 'totalcolor';
      if (strlen($newCount) > Config::STANDARD_DIGIT) $clsNameUniq = 'uniqcolor_small';
      if (strlen($timeCount) > Config::STANDARD_DIGIT) $clsNameTotal = 'totalcolor_small';
      $html .= '<td class="num"><div class="'. $clsNameUniq. '">'. $newCount. '</div>';
      $html .= '<div class="'. $clsNameTotal. '">'. $timeCount. '</div></td>';
    }
    $html .= '</tr>';
    $html .= '<tr>';
    for ($i = 0; $i <= 23; $i++) {
      if (isset($totalData[$i])) {
        $html .= '<td class="tdtimestr"><a href="'. $this->getIndexUrl('research', 'time_detail', '&amp;select='. $i). '" title="'. $i. '">'. $i. '</a></td>';
      } else {
        $html .= '<td class="tdtimestr">'. $i. '</td>';
      }
    }
    $html .= '</tr>';
    print $html;
  }

  public function resultTimeDetailTag() {
    $summaryData = $this->result->get('summaryData');
    $selectPage = $this->session->get('selectPage');
    $siteData = $this->session->get('siteData');
    $page = !is_null($this->request->get('page')) ? $this->request->get('page') : 1;

    $html = '';

    $i=0;
    $pageCount=1;
    foreach ($summaryData as $key => $value) {

      if ($pageCount >= $siteData['dispview'] * ($page - 1) + 1 && $pageCount <= $siteData['dispview'] * $page) {

        $accessTime = '<div class="detail">' . $value['yyyy'] . '/' . $value['mm'] .  '/' . $value['dd'] . '</div><div class="detail">' . $value['hh'] . ':' . $value['mi'] .  ':' . $value['ss'] . '</div>';
        $dispTitle = $this->substrMax($this->escapeHtml($this->getTitle($value['title'])), Config::MAX_DISP_LENGTH);
        $dispRefererTitle = $this->substrMax($this->escapeHtml($this->getTitle($value['referer_title'])), Config::MAX_DISP_LENGTH);
  
        if ($value['newflg'] == Config::ON && is_null($selectPage)) {
          $newTag = '<div class="detail"><img alt="New!!" title="New!!" src="./images/new.png" /></div>';
        } else {
          $newTag = '';
        }
  
        if ($dispRefererTitle == Config::FROM_NO_SCRIPT || $dispRefererTitle == Config::NO_DATA || $dispRefererTitle == Config::FROM_BOOKMARK) {
          $dispReferer = $dispRefererTitle;
        } else {
          $dispHostImg = $this->getHostImage($value['engine']);
          if (is_null($dispHostImg)) {
            $dispReferer = '<a href="' . ''. $this->getJumpUrl($value['http_referer']) . '" title="' . $this->escapeHtml($value['http_referer']) . '">' . $dispRefererTitle . '</a>';
          } else {
            $dispReferer = '<span class="favi"><img alt="' . $dispHostImg . '" title="' . $dispHostImg . '" src="./images/' . $dispHostImg . '" /></span>' . '<a href="' . ''. $this->getJumpUrl($value['http_referer']) . '" title="' . $this->escapeHtml($value['http_referer']) . '">' . $dispRefererTitle . '</a>';
          }
        }

        if ($value['logtype'] == Config::CLICK_LINK) {
          $rankAction = 'clickrank';
          $arrowTag = '<img alt="&rarr;Link Click!!" title="&rarr;Link Click!!" src="./images/arrowlinkclick.png" />';
        } else if ($value['logtype'] == Config::CLICK_BTN) {
          $rankAction = 'btnrank';
          $arrowTag = '<img alt="&rarr;Button Click!!" title="&rarr;Button Click!!" src="./images/arrowbtnclick.png" />';
        } else if ($value['logtype'] == Config::CLICK_ADSENSE) {
          $rankAction = 'adsenserank';
          $arrowTag = '<img alt="&rarr;AdSense Click!!" title="&rarr;AdSense Click!!" src="./images/arrowadsclick.png" />';
        } else {
          $rankAction = 'rank';
          $arrowTag = '<img alt="&rarr;" title="&rarr;" src="./images/arrow.png" />';
        }

        $dispRequest = '<a href="'. $this->getIndexUrl('research', $rankAction . '_user', '&amp;select=' . $this->urlEncode($value['url'])) . '" title="' . $this->escapeHtml($value['title']) . '">' . $dispTitle . '</a>';

        $dispBrow = $value['browser'];
        $dispBrowImg = $this->getBrowserImage($dispBrow, true);
        $dispOs = $value['os'];
        $dispOsImg = $this->getOsImage($dispOs, true);
        $dispPrefImg = $this->getPrefImage($value['pref']);

        $html .= '<tr>';
        $html .= '<td rowspan="5" class="tddetailleft'. $this->getEvenClass($i). '">'. $newTag. $accessTime. '</td>';
        $html .= '<td class="tddetailright'. $this->getEvenClass($i). '">';
        $html .= '<a href="'. $this->getIndexUrl('research', 'uid_detail', '&amp;select='. $this->urlEncode($value['uid'])). '" title="'. $value['uid']. '">'. $this->getAlias($value['uid']). '</a>';
        $html .= '<div class="osbrow">';
        $html .= '<span class="favi"><img src="./images/'. $dispOsImg. '" alt="'. $dispOs. '" title="'. $dispOs. '" /></span>';
        $html .= '<span class="favi"><img src="./images/'. $dispBrowImg. '" alt="'. $dispBrow. '" title="'. $dispBrow. '" /></span>';
        $html .= '<span class="alias"><a href="'. $this->getIndexUrl('admin', 'aliasedit', '&amp;select='. $this->urlEncode($value['uid'])). '">訪問者名設定</a></span>';
        $html .= '</div>';
        $html .= '</td>';
        $html .= '</tr>';
        $html .= '<tr>';
        $html .= '<td class="tddetailright'. $this->getEvenClass($i). '">';
        $html .= '<p>';
        if (!is_null($dispPrefImg)) $html .= '<span class="favi" ><img src="./images/'. $dispPrefImg. '" alt="'. $value['pref']. '" title="'. $value['pref']. '" /></span>';
        $html .= '<a href="'. $this->getIndexUrl('research', 'pref_user', '&amp;select='. $this->urlEncode($value['pref'])). '" title="'. $value['pref']. '">'. $value['pref']. '</a>';
        $html .= '</p>';
        $html .= '<p><a href="'. $this->getIndexUrl('research', 'ip_user', '&amp;select='. $this->urlEncode($value['remote_addr'])). '" title="'. $value['remote_addr']. '">'. $value['remote_addr']. '</a></p>';
        $html .= '<p><a href="'. $this->getIndexUrl('research', 'remotehost_user', '&amp;select='. $this->urlEncode($value['remote_host'])). '" title="'. $value['remote_host']. '">'. $value['remote_host']. '</a></p>';
        $html .= '<p><a href="'. $this->getIndexUrl('research', 'domain_user', '&amp;select='. $this->urlEncode($value['domain'])). '" title="'. $value['domain']. '">'. $this->getDomain($value['domain']). '</a></p>'. $this->getDomainEdit($value['domain']);
        $html .= '</td>';
        $html .= '</tr>';
        $html .= '<tr>';
        $html .= '<td class="tddetailright'. $this->getEvenClass($i). '">';
        $html .= '<span class="property"><a href="'. $this->getIndexUrl('research', 'screenwh_user', '&amp;select='. $this->urlEncode($value['screenwh'])). '" title="'. $value['screenwh']. '">'. $value['screenwh']. '</a></span>';
        $html .= '<span class="property"><a href="'. $this->getIndexUrl('research', 'screencol_user', '&amp;select='. $this->urlEncode($value['screencol'])). '" title="'. $value['screencol']. '">'. $value['screencol']. '</a></span>';
        $html .= '<span class="property"><a href="'. $this->getIndexUrl('research', 'jsck_user', '&amp;select='. $this->urlEncode($value['jsck'])). '" title="'. $value['jsck']. '">'. $value['jsck']. '</a></span>';
        $html .= '</td>';
        $html .= '</tr>';
        $html .= '<tr>';
        $html .= '<td class="tddetailright'. $this->getEvenClass($i). '"><div class="agent">'. $this->escapeHtml($value['http_user_agent']). '</div></td>';
        $html .= '</tr>';
        $html .= '<tr>';
        $html .= '<td class="tddetailright'. $this->getEvenClass($i). '"><div class="detail">'. $dispReferer. '</div><div class="detail">'. $arrowTag. '<span class="requesturi">'. $dispRequest. '</span></div></td>';
        $html .= '</tr>';
        if ($i == $siteData['dispview']) {
          break;
        }
        ++$i;
      }
      ++$pageCount;
    }

    print $html;
  }

  public function resultWeekTag() {
    $uniqueData = $this->result->get('uniqueData');
    $totalData = $this->result->get('totalData');

    if (count($totalData)>0) {
      $max = $totalData;
      rsort($max);
      $maxValue = $max[0];
    } else {
      $maxValue = 0;
    }

    $html = '';

    $html .= '<tr>';
    for ($i = 0; $i <= 6; $i++) {
      if (isset($uniqueData[$i]) && $maxValue > 0) {
        $newHeight = round(($uniqueData[$i] * 50) / $maxValue * 5);
        $newHeightAlt = $this->getFormatNumber($uniqueData[$i]);
        $newPng = './images/newcount.png';
      } else {
        $newHeight = 250;
        $newHeightAlt = '';
        $newPng = './images/spacer.png';
      }
      if (isset($totalData[$i]) && $maxValue > 0) {
        $timeHeight = round(($totalData[$i] * 50) / $maxValue * 5);
        $timeHeightAlt = $this->getFormatNumber($totalData[$i]);
        $timePng = './images/timecount.png';
      } else {
        $timeHeight = 250;
        $timeHeightAlt = '';
        $timePng = './images/spacer.png';
      }
      $html .= '<td class="tdweek" align="center" valign="bottom">';
      $html .= '<img width="51" height="'. $newHeight. '" alt="'. $newHeightAlt. '" title="'. $newHeightAlt. '" src="'. $newPng. '" />';
      $html .= '<img width="51" height="'. $timeHeight. '" alt="'. $timeHeightAlt. '" title="'. $timeHeightAlt. '" src="'. $timePng. '" /></td>';
    }
    $html .= '</tr>';
    $html .= '<tr>';
    for ($i = 0; $i <= 6; $i++) {
      if (isset($uniqueData[$i])) {
        $newCount = $this->getFormatNumber($uniqueData[$i]);
      } else {
        $newCount = 0;
      }
      if (isset($totalData[$i])) {
        $timeCount = $this->getFormatNumber($totalData[$i]);
      } else {
        $timeCount = 0;
      }
      $clsNameUniq = 'uniqcolor';
      $clsNameTotal = 'totalcolor';
      if (strlen($newCount) > Config::STANDARD_DIGIT) $clsNameUniq = 'uniqcolor_small';
      if (strlen($timeCount) > Config::STANDARD_DIGIT) $clsNameTotal = 'totalcolor_small';
      $html .= '<td class="num"><div class="'. $clsNameUniq. '">'. $newCount. '</div>';
      $html .= '<div class="'. $clsNameTotal. '">'. $timeCount. '</div></td>';
    }
    $html .= '</tr>';
    $html .= '<tr>';
    for ($i = 0; $i <= 6; $i++) {
      $clsName = 'tdweekstr';
      if ($i == 0) $clsName = 'tdweekstrsun';
      if ($i == 6) $clsName = 'tdweekstrsat';
      $html .= '<td class="'. $clsName. '">'. Calendar::getWeekday($i). '</td>';
    }
    $html .= '</tr>';
    print $html;
  }

  public function resultTermTag() {
    $uniqueData = $this->result->get('uniqueData');
    $totalData = $this->result->get('totalData');
    $yyyy = $this->session->get('yyyyFrom');
    $mm = $this->session->get('mmFrom');

    if (count($totalData)>0) {
      $max = $totalData;
      rsort($max);
      $maxValue = $max[0];
    } else {
      $maxValue = 0;
    }

    $html = '';

    for ($row = 1; $row <= 2; $row++) {
      $html .= '<tr>';
      for ($i = 16 * ($row - 1) + 1; $i <= 16 * $row; $i++) {
        if (isset($uniqueData[$i]) && $maxValue > 0) {
          $newHeight = round(($uniqueData[$i] * 50) / $maxValue * 5);
          $newHeightAlt = $this->getFormatNumber($uniqueData[$i]);
          $newPng = './images/newcount.png';
        } else {
          $newHeight = 250;
          $newHeightAlt = 0;
          $newPng = './images/spacer.png';
        }
        if (isset($totalData[$i]) && $maxValue > 0) {
          $timeHeight = round(($totalData[$i] * 50) / $maxValue * 5);
          $timeHeightAlt = $this->getFormatNumber($totalData[$i]);
          $timePng = './images/timecount.png';
        } else {
          $timeHeight = 250;
          $timeHeightAlt = 0;
          $timePng = './images/spacer.png';
        }
        $html .= '<td class="tdterm" align="center" valign="bottom">';
        $html .= '<img width="22" height="'. $newHeight. '" alt="'. $newHeightAlt. '" title="'. $newHeightAlt. '" src="'. $newPng. '" />';
        $html .= '<img width="22" height="'. $timeHeight. '" alt="'. $timeHeightAlt. '" title="'. $timeHeightAlt. '" src="'. $timePng. '" /></td>';
      }
      $html .= '</tr>';
      $html .= '<tr>';
      for ($i = 16 * ($row - 1) + 1; $i <= 16 * $row; $i++) {
        if (isset($uniqueData[$i])) {
          $newCount = $this->getFormatNumber($uniqueData[$i]);
        } else {
          $newCount = 0;
        }
        if (isset($totalData[$i])) {
          $timeCount = $this->getFormatNumber($totalData[$i]);
        } else {
          $timeCount = 0;
        }
        if (!checkdate($mm, $i, $yyyy)) {
          $newCount = '';
          $timeCount = '';
        }
        $html .= '<td class="num"><div class="uniqcolor">'. $newCount. '</div>';
        $html .= '<div class="totalcolor">'. $timeCount. '</div></td>';
      }
      $html .= '</tr>';
      $html .= '<tr>';
      for ($i = 16 * ($row - 1) + 1; $i <= 16 * $row; $i++) {
        $clsName = 'tdtermstr';
        $dayString = '';
        if (checkdate($mm, $i, $yyyy)) {
          $dayString = $i. '日';
          $weekday = date('w', mktime('0', '0', '0', $mm, $i, $yyyy));
          if ($weekday == 0) $clsName = 'tdtermstrsun';
          if ($weekday == 6) $clsName = 'tdtermstrsat';
        }
        if (isset($totalData[$i])) {
          $html .= '<td class="'. $clsName. '"><a href="'. $this->getIndexUrl('research', 'time', 
                                                                              '&amp;yyyy_from='. $yyyy. 
                                                                              '&amp;mm_from='. $mm. 
                                                                              '&amp;dd_from='. $this->getZeroPadding($i, 1).
                                                                              '&amp;yyyy_to='. $yyyy. 
                                                                              '&amp;mm_to='. $mm. 
                                                                              '&amp;dd_to='. $this->getZeroPadding($i, 1)).'">';
          $html .= $dayString. '</a></td>';
        } else {
          $html .= '<td class="'. $clsName. '">'. $dayString. '</td>';
        }
      }
      $html .= '</tr>';
    }

    print $html;
  }

  public function resultUidTag() {
    $summaryData = $this->result->get('summaryData');
    $totalCount = $this->result->get('totalCount');
    $browser = $this->result->get('browser');
    $os = $this->result->get('os');
    $remoteAddr = $this->result->get('remoteAddr');
    $remoteHost = $this->result->get('remoteHost');
    $domain = $this->result->get('domain');
    $clickLink = $this->result->get('clickLink');
    $clickBtn = $this->result->get('clickBtn');
    $clickAdsense = $this->result->get('clickAdsense');
    $siteData = $this->session->get('siteData');
    $page = !is_null($this->request->get('page')) ? $this->request->get('page') : 1;

    $html = '';

    $i=0;
    $pageCount=1;
    foreach ($summaryData as $key => $value) {
      if ($pageCount >= $siteData['dispview'] * ($page - 1) + 1 && $pageCount <= $siteData['dispview'] * $page) {
        $dispOs = $os[$key];
        $dispOsImg = $this->getOsImage($dispOs, true);
        $dispBrow = $browser[$key];
        $dispBrowImg = $this->getBrowserImage($dispBrow, true);
    
        $html .= '<tr>';
        $html .= '<td class="tdcol1_1'. $this->getEvenClass($i). '">';
        $html .= '<a href="'. $this->getIndexUrl('research', 'uid_detail', '&amp;select='. $this->urlEncode($key)). '" title="'. $key. '">'. $this->getAlias($key). '</a>';
        $html .= '<div class="osbrow">';
        $html .= '<span class="favi"><img src="./images/'. $dispOsImg. '" alt="'. $dispOs. '" title="'. $dispOs. '" /></span>';
        $html .= '<span class="favi"><img src="./images/'. $dispBrowImg. '" alt="'. $dispBrow. '" title="'. $dispBrow. '" /></span>';
        $html .= '<span class="alias"><a href="'. $this->getIndexUrl('admin', 'aliasedit', '&amp;select='. $this->urlEncode($key)). '">訪問者名設定</a></span>';
        $html .= '</div>';
        $html .= '</td>';
        $html .= '<td class="tdcol1_2'. $this->getEvenClass($i). '">';
        $html .= '<p>';
        foreach ($remoteAddr as $k => $v) {
          if ($key . $v == $k) {
            $html .= '<a href="'. $this->getIndexUrl('research', 'ip_user', '&amp;select='. $this->urlEncode($v)). '" title="'. $v. '">'. $v. '</a><br />';
          }
        }
        $html .= '</p>';
        $html .= '<p>';
        foreach ($domain as $k => $v) {
          if ($key . $v == $k) {
            $html .= '<a href="'. $this->getIndexUrl('research', 'domain_user', '&amp;select='. $this->urlEncode($v)). '" title="'. $v. '">'. $this->getDomain($v). '</a><br />';
          }
        }
        $html .= '</p>';
        $html .= '</td>';
        $html .= '<td class="tdcol2'. $this->getEvenClass($i). '">';
        $html .= '<div style="width: 75px; color: #000000; margin: 2px 0 2px 2px; padding: 0;font-size: 100%;">';
        $html .= '<span class="totalcolor">'. $this->getFormatNumber($value). '</span>';
        $html .= '</div>';
        $html .= '<div style="width: 75px; color: #000000; margin: 2px 0 2px 2px; padding: 0; border: 1px #223a70 solid; font-size: 80%;">';
        $html .= '<div style="text-align: left; margin: 0; padding: 2px; color: #ffffff; background-color: #223a70;">クリック数</div>';
        $html .= '<div style="float: left; clear: left; margin: 0 0 0 2px;">リンク</div>';
        $html .= '<div>&nbsp;<span style="color: #ff0000;">'. $this->getFormatNumber($clickLink[$key]). '</span></div>';
        $html .= '<div style="float: left; clear: left; margin: 0 0 0 2px;">ボタン</div>';
        $html .= '<div>&nbsp;<span style="color: #ff0000;">'. $this->getFormatNumber($clickBtn[$key]). '</span></div>';
        $html .= '<div style="float: left; clear: left; margin: 0 0 0 2px;">AdSense</div>';
        $html .= '<div>&nbsp;<span style="color: #ff0000;">'. $this->getFormatNumber($clickAdsense[$key]). '</span></div>';
        $html .= '</div>';
        $html .= '</td>';
        $html .= '<td class="tdcol3'. $this->getEvenClass($i). '">'. round($value * 100 / $totalCount, 2). '%</td>';
        $html .= '<td class="tdcol4'. $this->getEvenClass($i). '"><img alt="'. $value. '" title="'. $value. '" width="'. round($value * 100 / $totalCount, 0). '%" height="25" src="./images/count.png" /></td>';
        $html .= '</tr>';
        if ($i == $siteData['dispview']) {
          break;
        }
        ++$i;
      }
      ++$pageCount;
    }

    print $html;
  }

  public function resultUidDetailHeaderTag() {
    $summaryData = $this->result->get('summaryData');
    $siteData = $this->session->get('siteData');

    $html = '';

    $addr = array();
    $host = array();
    $domain = array();
    $pref = array();
    $country = array();
    $propertySet = false;
    if (count($summaryData) > 0) {
      foreach ($summaryData as $key => $value) {
        if (!isset($addr[$value['remote_addr']])) {
          $addr[$value['remote_addr']] = $value['remote_addr'];
        }
        if (!isset($addr[$value['remote_host']])) {
          $host[$value['remote_host']] = $value['remote_host'];
        }
        if (!isset($domain[$value['domain']])) {
          $domain[$value['domain']] = $value['domain'];
        }
        if (!isset($pref[$value['pref']])) {
          $pref[$value['pref']] = $value['pref'];
        }
        if (!isset($country[$value['country']])) {
          $country[$value['country']] = $value['country'];
        }
        if (!$propertySet) {
          $os = $value['os'];
          $osImg = $this->getOsImage($os, true);
          $brow = $value['browser'];
          $browImg = $this->getBrowserImage($brow, true);
          $screenWh = $value['screenwh'];
          $screenCol = $value['screencol'];
          $jsck = $value['jsck'];
          $propertySet = True;
        }
      }
    }

    $html .= '<tr>';
    $html .= '<td class="label">ID&nbsp;/&nbsp;訪問者名</td>';
    $html .= '<td class="label">:</td>';
    $html .= '<td class="value"><span class="header_value">'. $this->getAlias($this->request->get('select')). '</span>';
    if (count($summaryData) > 0) { 
      $html .= '<span class="favi"><img src="./images/'. $osImg. '" alt="'. $os. '" title="'. $os. '" /></span>';
      $html .= '<span class="favi"><img src="./images/'. $browImg. '" alt="'. $brow. '" title="'. $brow. '" /></span>';
      $html .= '<span class="alias"><a href="'. $this->getIndexUrl('admin', 'aliasedit', '&amp;select='. $this->urlEncode($this->request->get('select'))). '">訪問者名設定</a></span>';
    } 
    $html .= '</td>';
    $html .= '</tr>';
    if (count($summaryData) > 0) { 
      $cnt=0;
      foreach ($country as $key => $value) {
        $html .= '<tr>';
        if ($cnt == 0) { 
          $html .= '<td class="label">国</td>';
        } else { 
          $html .= '<td class="label">&nbsp;</td>';
        } 
        $html .= '<td class="label">:</td>';
        $html .= '<td class="value"><span class="header_value">';
        $html .= $value. '</span>';
        $html .= '<span class="favi_nosize"><img src="./images/'. $this->getCountryImage($value, true). '" alt="'. $value. '" title="'. $value	. '" /></span>';
        $html .= '</td>';
        $html .= '</tr>';
        $cnt++;
      }
      $cnt=0;
      foreach ($pref as $key => $value) {
        $html .= '<tr>';
        if ($cnt == 0) { 
          $html .= '<td class="label">都道府県</td>';
        } else { 
          $html .= '<td class="label">&nbsp;</td>';
        } 
        $html .= '<td class="label">:</td>';
        $html .= '<td class="value"><span class="header_value">';
        $html .= $value. '</span>';
        $html .= '<span class="favi"><img src="./images/'. $this->getPrefImage($value, true). '" alt="'. $value. '" title="'. $value	. '" /></span>';
        $html .= '</td>';
        $html .= '</tr>';
        $cnt++;
      }
      $cnt=0;
      foreach ($addr as $key => $value) {
        $html .= '<tr>';
        if ($cnt == 0) { 
          $html .= '<td class="label">IPアドレス</td>';
        } else {
          $html .= '<td class="label">&nbsp;</td>';
        } 
        $html .= '<td class="label">:</td>';
        $html .= '<td class="value"><span class="header_value">'. $value. '</span></td>';
        $html .= '</tr>';
        $cnt++;
      }
      $cnt=0;
      foreach ($host as $key => $value) {
        $html .= '<tr>';
        if ($cnt == 0) { 
          $html .= '<td class="label">リモートホスト</td>';
        } else { 
          $html .= '<td class="label">&nbsp;</td>';
        } 
        $html .= '<td class="label">:</td>';
        $html .= '<td class="value"><span class="header_value">'. $value. '</span></td>';
        $html .= '</tr>';
        $cnt++;
      }
      $cnt=0;
      foreach ($domain as $key => $value) {
        $html .= '<tr>';
        if ($cnt == 0) { 
          $html .= '<td class="label">ドメイン</td>';
        } else { 
          $html .= '<td class="label">&nbsp;</td>';
        } 
        $html .= '<td class="label">:</td>';
        $html .= '<td class="value"><span class="header_value">'. $this->getDomain($value). $this->getDomainEdit($value, false). '</span></td>';
        $html .= '</tr>';
        $cnt++;
      }
      $html .= '<tr>';
      $html .= '<td class="label">画面解像度</td>';
      $html .= '<td class="label">:</td>';
      $html .= '<td class="value"><span class="header_value">'. $screenWh. '</span></td>';
      $html .= '</tr>';
      $html .= '<tr>';
      $html .= '<td class="label">画面色数</td>';
      $html .= '<td class="label">:</td>';
      $html .= '<td class="value"><span class="header_value">'. $screenCol. '</span></td>';
      $html .= '</tr>';
      $html .= '<tr>';
      $html .= '<td class="label">Javascript/Cookie</td>';
      $html .= '<td class="label">:</td>';
      $html .= '<td class="value"><span class="header_value">'. $jsck. '</span></td>';
      $html .= '</tr>';
    }
    print $html;
  }

  public function resultUidDetailTag() {
    $summaryData = $this->result->get('summaryData');
    $siteData = $this->session->get('siteData');
    $page = !is_null($this->request->get('page')) ? $this->request->get('page') : 1;

    $html = '';

    $i=0;
    $pageCount=1;
    foreach ($summaryData as $key => $value) {

      $nowday = $value['yyyy'] . $value['mm'] . $value['dd'];
      $now = ($value['hh'] * 3600) + ($value['mi'] * 60) + $value['ss'];

      if ($pageCount == 1) {
        $clsName="last";
        $altName="End";
        $pngName="end.png";
        $timeDisp = "";
      } else {
        if ($nowday != $afterday) {
          $clsName="last";
          $altName="End";
          $pngName="end.png";
          $timeDisp = "";
        } else {
          $readtime = $after - $now;
          if ($readtime / 60 < 1) {
            $timeDisp = $readtime . '秒';
          } else {
            if ($readtime / 3600 < 1) {
              if ($readtime % 60 == 0) {
                $timeDisp = $readtime / 60 . '分';
              } else {
                $timeDisp = floor($readtime / 60) . '分' . $readtime % 60 . '秒';
              }
            } else {
              if ($readtime % 3600 == 0) {
                $timeDisp = $readtime / 3600 . '時間';
              } else {
                if (($readtime % 3600) % 60 == 0) {
                  $timeDisp = floor($readtime / 3600) . '時間' . ($readtime % 3600) / 60 . '分';
                } else {
                  $timeDisp = floor($readtime / 3600) . '時間' . floor(($readtime % 3600) / 60) . '分' . ($readtime % 3600) % 60 . '秒';
                }
              }
            }
          }
          if ($readtime >= $siteData['oksecond']) {
            if ($readtime >= $siteData['againsecond']) {
              $clsName="revisit";
              $altName="ReVisit!";
              $pngName="revisit.png";
            } else {
              $clsName="good";
              $altName="Good!!";
              $pngName="good.png";
            }
          } else {
            $clsName="bad";
            $altName="Bad&#133;";
            $pngName="bad.png";
          }
        }
      }
 
      $afterday = $nowday;
      $after = $now;

      if (RaUtil::strLen(trim($this->session->get("selectPage"))) > 0 ) {
        $clsName="";
        $altName="";
        $pngName="spacer.png";
        $timeDisp = "";
      }

      if ($pageCount >= $siteData['dispview'] * ($page - 1) + 1 && $pageCount <= $siteData['dispview'] * $page) {
  
        $accessTime = '<div class="detail">' . $value['yyyy'] . '/' . $value['mm'] .  '/' . $value['dd'] . '</div><div class="detail">' . $value['hh']. ':' . $value['mi'] .  ':' . $value['ss'] . '</div>';
        $dispTitle = $this->substrMax($this->escapeHtml($this->getTitle($value['title'])), Config::MAX_DISP_LENGTH);
        $dispRefererTitle = $this->substrMax($this->escapeHtml($this->getTitle($value['referer_title'])), Config::MAX_DISP_LENGTH);
  
        if ($value['logtype'] == Config::CLICK_LINK) {
          $action = 'clickrank';
          $arrowTag = '<img alt="&rarr;Link Click!!" title="&rarr;Link Click!!" src="./images/arrowlinkclick.png" />';
        } else if ($value['logtype'] == Config::CLICK_BTN) {
          $action = 'btnrank';
          $arrowTag = '<img alt="&rarr;Button Click!!" title="&rarr;Button Click!!" src="./images/arrowbtnclick.png" />';
        } else if ($value['logtype'] == Config::CLICK_ADSENSE) {
          $action = 'adsenserank';
          $arrowTag = '<img alt="&rarr;AdSense Click!!" title="&rarr;AdSense Click!!" src="./images/arrowadsclick.png" />';
        } else {
          $action = 'rank';
          $arrowTag = '<img alt="&rarr;" title="&rarr;" src="./images/arrow.png" />';
        }
        $dispRequest = '<a href="'. $this->getIndexUrl('research', $action . '_user', '&amp;select=' . $this->urlEncode($value['url'])) . '" title="' . $this->escapeHtml($value['title']) . '">' . $dispTitle . '</a>';
  
        if ($dispRefererTitle == Config::FROM_NO_SCRIPT || $dispRefererTitle == Config::NO_DATA || $dispRefererTitle == Config::FROM_BOOKMARK) {
          $dispReferer = $dispRefererTitle;
        } else {
          $dispHostImg = $this->getHostImage($value['engine']);
          if (is_null($dispHostImg)) {
            $dispReferer = '<a href="' . ''. $this->getJumpUrl($value['http_referer']) . '" title="' . $this->escapeHtml($value['http_referer']) . '">' . $dispRefererTitle . '</a>';
          } else {
            $dispReferer = '<span class="favi"><img alt="' . $dispHostImg . '" title="' . $dispHostImg . '" src="./images/' . $dispHostImg . '" /></span>' . '<a href="' . ''. $this->getJumpUrl($value['http_referer']) . '" title="' . $this->escapeHtml($value['http_referer']) . '">' . $dispRefererTitle . '</a>';
          }
        }

        $html .= '<tr>';
        $html .= '<td rowspan="3" class="tddetailleft'. $this->getEvenClass($i). '">'. $accessTime;
        $html .= '<div class="detail"><span class="'. $clsName. '"><img alt="'. $altName. '" title="'. $altName. '" src="./images/'. $pngName. '" /></span></div><div class="detail"><span class="'. $clsName. '">'. $timeDisp. '</span></div>';
        $html .= '</td>';
        $html .= '<td class="tddetailright'. $this->getEvenClass($i). '">';
        $html .= '<p>';
        $dispPrefImg = $this->getPrefImage($value['pref']);
        if (!is_null($dispPrefImg)) $html .= '<span class="favi" ><img src="./images/'. $dispPrefImg. '" alt="'. $value['pref']. '" title="'. $value['pref']. '" /></span>';
        $html .= '<a href="'. $this->getIndexUrl('research', 'pref_user', '&amp;select='. $this->urlEncode($value['pref'])). '" title="'. $value['pref']. '">'. $value['pref']. '</a>';
        $html .= '</p>';
        $html .= '<p><a href="'. $this->getIndexUrl('research', 'ip_user', '&amp;select='. $this->urlEncode($value['remote_addr'])). '" title="'. $value['remote_addr']. '">'. $value['remote_addr']. '</a></p>';
        $html .= '<p><a href="'. $this->getIndexUrl('research', 'remotehost_user', '&amp;select='. $this->urlEncode($value['remote_host'])). '" title="'. $value['remote_host']. '">'. $value['remote_host']. '</a></p>';
        $html .= '<p><a href="'. $this->getIndexUrl('research', 'domain_user', '&amp;select='. $this->urlEncode($value['domain'])). '" title="'. $value['domain']. '">'. $this->getDomain($value['domain']). '</a></p>'. $this->getDomainEdit($value['domain']);
        $html .= '</td>';
        $html .= '</tr>';
        $html .= '<tr>';
        $html .= '<td class="tddetailright'. $this->getEvenClass($i). '"><div class="agent">'. $this->escapeHtml($value['http_user_agent']). '</div></td>';
        $html .= '</tr>';
        $html .= '<tr>';
        $html .= '<td class="tddetailright'. $this->getEvenClass($i). '"><div class="detail">'. $dispReferer. '</div><div class="detail">'. $arrowTag. '<span class="requesturi">'. $dispRequest. '</span></div></td>';
        $html .= '</tr>';
        if ($i == $siteData['dispview']) {
          break;
        }
        ++$i;
      }
      ++$pageCount;
    }

    print $html;
  }

  public function resultIpRemoteHostTag() {
    $summaryData = $this->result->get('summaryData');
    $remoteAddr = $this->result->get('remoteAddr');
    $remoteHost = $this->result->get('remoteHost');
    $domain = $this->result->get('domain');
    $totalCount = $this->result->get('totalCount');
    $siteData = $this->session->get('siteData');
    $action = $this->action;
    $page = !is_null($this->request->get('page')) ? $this->request->get('page') : 1;

    $html = '';

    $i=0;
    $pageCount=1;
    foreach ($summaryData as $key => $value) {
      if ($pageCount >= $siteData['dispview'] * ($page - 1) + 1 && $pageCount <= $siteData['dispview'] * $page) {
        $html .= '<tr>';
        $html .= '<td class="tdcol1'. $this->getEvenClass($i). '">';
        switch ($action) {
          case 'ip':
            $html .= '<p><a href="'. $this->getIndexUrl('research', 'ip_user', '&amp;select='. $this->urlEncode($key)). '" title="'. $key. '">'. $key. '</a></p>';
            $html .= '<p><a href="'. $this->getIndexUrl('research', 'domain_user', '&amp;select='. $this->urlEncode($domain[$key])). '" title="'. $domain[$key]. '">'. $this->getDomain($domain[$key]). '</a></p>';
            break;
          case 'adsenseip':
            $html .= '<p><a href="'. $this->getIndexUrl('research', 'adsenseip_user', '&amp;select='. $this->urlEncode($key)). '" title="'. $key. '">'. $key. '</a></p>';
            $html .= '<p><a href="'. $this->getIndexUrl('research', 'domain_user', '&amp;logtype='. Config::CLICK_ADSENSE. '&amp;select='. $this->urlEncode($domain[$key])). '" title="'. $domain[$key]. '">'. $this->getDomain($domain[$key]). '</a></p>';
            break;
          default:
            $html .= '<p><a href="'. $this->getIndexUrl('research', 'remotehost_user', '&amp;select='. $this->urlEncode($key)). '" title="'. $key. '">'. $key. '</a></p>';
            $html .= '<p><a href="'. $this->getIndexUrl('research', 'domain_user', '&amp;select='. $this->urlEncode($domain[$key])). '" title="'. $domain[$key]. '">'. $this->getDomain($domain[$key]). '</a></p>';
            break;
        }
        $html .= '</td>';
        $html .= '<td class="tdcol2'. $this->getEvenClass($i). '"><span class="totalcolor">'. $this->getFormatNumber($value). '</span></td>';
        $html .= '<td class="tdcol3'. $this->getEvenClass($i). '">'. round($value * 100 / $totalCount, 2). '%</td>';
        $html .= '<td class="tdcol4'. $this->getEvenClass($i). '"><img alt="'. $value. '" title="'. $value. '" width="'. round($value * 100 / $totalCount, 0). '%" height="25" src="./images/count.png" /></td>';
        $html .= '</tr>';
        if ($i == $siteData['dispview']) {
          break;
        }
        ++$i;
      }
      ++$pageCount;
    }

    print $html;
  }

  public function resultIpRemoteHostUserTag() {
    $summaryData = $this->result->get('summaryData');
    $totalCount = $this->result->get('totalCount');
    $browser = $this->result->get('browser');
    $os = $this->result->get('os');
    $remoteAddr = $this->result->get('remoteAddr');
    $remoteHost = $this->result->get('remoteHost');
    $domain = $this->result->get('domain');
    $clickLink = $this->result->get('clickLink');
    $clickBtn = $this->result->get('clickBtn');
    $clickAdsense = $this->result->get('clickAdsense');
    $siteData = $this->session->get('siteData');
    $page = !is_null($this->request->get('page')) ? $this->request->get('page') : 1;

    $html = '';

    $i=0;
    $pageCount=1;
    foreach ($summaryData as $key => $value) {
      if ($pageCount >= $siteData['dispview'] * ($page - 1) + 1 && $pageCount <= $siteData['dispview'] * $page) {
        $dispOs = $os[$key];
        $dispOsImg = $this->getOsImage($dispOs, true);
        $dispBrow = $browser[$key];
        $dispBrowImg = $this->getBrowserImage($dispBrow, true);
    
        $html .= '<tr>';
        $html .= '<td class="tdcol1'. $this->getEvenClass($i). '">';
        $html .= '<a href="'. $this->getIndexUrl('research', 'uid_detail', '&amp;select='. $this->urlEncode($key)). '" title="'. $key. '">'. $this->getAlias($key). '</a>';
        $html .= '<div class="osbrow">';
        $html .= '<span class="favi"><img src="./images/'. $dispOsImg. '" alt="'. $dispOs. '" title="'. $dispOs. '" /></span>';
        $html .= '<span class="favi"><img src="./images/'. $dispBrowImg. '" alt="'. $dispBrow. '" title="'. $dispBrow. '" /></span>';
        $html .= '<span class="alias"><a href="'. $this->getIndexUrl('admin', 'aliasedit', '&amp;select='. $this->urlEncode($key)). '">訪問者名設定</a></span>';
        $html .= '</div>';
        $html .= '</td>';
        $html .= '<td class="tdcol2'. $this->getEvenClass($i). '">';
        $html .= '<div style="width: 75px; color: #000000; margin: 2px 0 2px 2px; padding: 0;font-size: 100%;">';
        $html .= '<span class="totalcolor">'. $this->getFormatNumber($value). '</span>';
        $html .= '</div>';
        $html .= '<div style="width: 75px; color: #000000; margin: 2px 0 2px 2px; padding: 0; border: 1px #223a70 solid; font-size: 80%;">';
        $html .= '<div style="text-align: left; margin: 0; padding: 2px; color: #ffffff; background-color: #223a70;">クリック数</div>';
        $html .= '<div style="float: left; clear: left; margin: 0 0 0 2px;">リンク</div>';
        $html .= '<div>&nbsp;<span style="color: #ff0000;">'. $this->getFormatNumber($clickLink[$key]). '</span></div>';
        $html .= '<div style="float: left; clear: left; margin: 0 0 0 2px;">ボタン</div>';
        $html .= '<div>&nbsp;<span style="color: #ff0000;">'. $this->getFormatNumber($clickBtn[$key]). '</span></div>';
        $html .= '<div style="float: left; clear: left; margin: 0 0 0 2px;">AdSense</div>';
        $html .= '<div>&nbsp;<span style="color: #ff0000;">'. $this->getFormatNumber($clickAdsense[$key]). '</span></div>';
        $html .= '</div>';
        $html .= '</td>';
        $html .= '<td class="tdcol3'. $this->getEvenClass($i). '">'. round($value * 100 / $totalCount, 2). '%</td>';
        $html .= '<td class="tdcol4'. $this->getEvenClass($i). '"><img alt="'. $value. '" title="'. $value. '" width="'. round($value * 100 / $totalCount, 0). '%" height="25" src="./images/count.png" /></td>';
        $html .= '</tr>';
        if ($i == $siteData['dispview']) {
          break;
        }
        ++$i;
      }
      ++$pageCount;
    }

    print $html;
  }

  public function resultKeywordTag() {
    $summaryData = $this->result->get('summaryData');
    $totalCount = $this->result->get('totalCount');
    $keywordEngine = $this->result->get('keywordEngine');
    $siteData = $this->session->get('siteData');
    $page = !is_null($this->request->get('page')) ? $this->request->get('page') : 1;

    $html = '';

    $i=0;
    $pageCount=1;
    foreach ($summaryData as $key => $value) {
      if ($pageCount >= $siteData['dispview'] * ($page - 1) + 1 && $pageCount <= $siteData['dispview'] * $page) {
        $html .= '<tr>';
        $html .= '<td class="tdcol1'. $this->getEvenClass($i). '"><a href="'. $this->getIndexUrl('research', 'key_user', '&amp;select='. $this->urlEncode($key)). '" title="'. $this->escapeHtml($key). '">'. $this->substrMax($this->escapeHtml($key), Config::MAX_DISP_LENGTH). '</a></td>';
        $html .= '<td class="tdcol2'. $this->getEvenClass($i). '">';
        $engine = $keywordEngine[$key]; 
        if (is_array($engine)) {
          arsort($engine, SORT_STRING);
          $html .= '<div style="width: 85px; color: #000000; margin: 1px; padding: 0; border: 1px #223a70 solid; font-size: 80%;">';
          $html .= '<div style="text-align: left; margin: 0; padding: 2px; color: #ffffff; background-color: #223a70;">検索エンジン</div>';
          foreach ($engine as $engineKey => $engineValue) {
            $html .= '<div style="float: left; clear: left; margin: 0 0 0 2px;">'. $this->substrMax($engineKey, 8). '</div>';
            $html .= '<div>&nbsp;<span style="color: #ff0000;">'. $this->getFormatNumber($engineValue). '</span></div>';
            $html .= '<div style="margin: 0; padding: 0;"><img style="vertical-align: middle; margin: 0; float: left;" alt="'. round($engineValue * 100 / $value, 0). '%" width="'. round($engineValue * 40 / $value, 0). '" height="10" src="./images/count.png" />'. round($engineValue * 100 / $value, 0). '%</div>';
          } 
          $html .= '<div style="margin: 0; padding: 0; color: #aaaaaa;">-------------</div>';
          $html .= '<div style="margin: 0; padding: 0;">TOTAL:&nbsp;<span style="color: #ff0000;">'. $this->getFormatNumber($value). '</span></div>';
          $html .= '</div>';
        }
        $html .= '</td>';
        $html .= '<td class="tdcol3'. $this->getEvenClass($i). '">'. round($value * 100 / $totalCount, 2). '%</td>';
        $html .= '<td class="tdcol4'. $this->getEvenClass($i). '"><img alt="'. $value. '" title="'. $value. '" width="'. round($value * 100 / $totalCount, 0). '%" height="25" src="./images/count.png" /></td>';
        $html .=  '</tr>';
        if ($i == $siteData['dispview']) {
          break;
        }
        ++$i;
      }
      ++$pageCount;
    }

    print $html;
  }

  private function _getLastDay() {
    $yyyy = $this->session->get("yyyyFrom");
    $mm = $this->session->get("mmFrom");
    $now = time();
    $day = date('d', $now);
    if (date('m', $now) != $mm) {
      $day = 31;
      while (!checkdate($mm, $day, $yyyy)) $day--;
    }
    return $day;
  }


}
?>
