//-------------------------------------------------
// positlog.js
//
// Copyright (c) 2006 Hidekazu Kubota (Taro Sosui) All right reserved
//  <taro@summer.nifty.jp>
//   http://storybook.jp/ 
//
// This file is part of PositLog.
//
// PositLog is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// PositLog is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
//-------------------------------------------------

//---------------------------
// Globals 
//---------------------------

// z-index
Z_BACKGROUND = 0; // this is the same value as z-index of spritesworld defined in positlog.cgi
Z_GO_TEMP_BACKGROUND = 10;
Z_SPRITE_MIN = 1000;
Z_SPRITE_CREATEMIN = 500000;
Z_SPRITE_MAX = 999999;
Z_GO_TEMP_FOREGROUND = 1000000;
Z_CONTROLPANEL = 2000000; // this is the same value as z-index of controlpanel defined in positlog.css
Z_EDITOR = 3000000; // this is the same value as z-index of editor/password-dialog defined in positlog.css
Z_EDITOR2 = 3000100; // this is the same value as z-index of plugin-dialog/fileuploadframe/trianglecolorselector defined in positlog.css

// view position of sprites world
viewPositionX = 0;
viewPositionY = 0;
setViewPositionFlag = false;

// position of sprites world
worldLeft = 0;
worldTop = 0;
worldHeight = 0;
worldWidth = 0;

// loginid
loginid = "public";

// selected sprite (selected by Mouse)
// temporal selection (dashed frame)
selectedSprite = null;
// fixed selection (solid frame)
fixedID = 0;

// focused sprite (indicated by SpriteID)
// (colored solid frame)
focusedSprite = null;

// sprite under the process of editing
editingSprite = null;

// sprite under the process of saving
savingSprite = null;

// sprite under the process of deleting
deletingSprite = null;

// Is sprite moving?
movingSpriteFlag = false;

// Is sprite scaling?
scalingSpriteFlag = false;

// Is editor moving?
movingEditorFlag = false;

// Is mouse out of world?
mouseOutOfWorld = false;

// original z-index of focused sprite
originalZindexOfFocusedSprite = 0;

// original z-index of selected sprite 
originalZindexOfSelectedSprite = 0;

// original attributes of fixed sprite 
// (attributes are temporally changed when selected)
originalZindexOfSelectedSprite2 = 0;

// original zIndex of ediging sprite
// (attributes are temporally changed when opened)
originalZindexOfEditingSprite = 0;


// previous position of Mouse
prevMouseX = 0;
prevMouseY = 0;

// url : urlPure?urlArgs
urlPure = "";

// Click four times to move foreground sprite to background
// This is a counter
counterForMoveToBackground = 0;

// cgiargs (below) are defined in positlog.cgi
// var pageidValue
// var vpValue
// var idValue
// var edgeValue
// var positlogMode
// var IMAGEFILEPATH
// var CGIFILEPATH
// var DATAFILEPATH
// var attachedSpriteValue
// var superSpriteValue
// var sprite_htmlValue
// var sprite_autobrValue
// var sprite_autolinkValue

// for checking browser
crossBrowser = new chkAjaBrowser();

//------------------------------------
// Get Inner Scrollbar Area
//-------------------------------------
function getInnerWidth()
{
    if(crossBrowser.bw.msie || crossBrowser.bw.msie7)
    {
		return parseInt(document.documentElement.clientWidth);
    }
    else
    {
		var trueWidth = parseInt(document.documentElement.clientWidth);
		if(crossBrowser.bw.safari)
		{
			trueWidth = parseInt(window.innerWidth);
		}
		else if(crossBrowser.bw.opera)
		{
			trueWidth = parseInt(window.innerWidth)-3;
			if(parseInt(window.innerHeight) < parseInt(worldHeight))
			{
				// vertical scroll bar is visible
				trueWidth -= 20;
			}
		}
		
		return trueWidth;
    }
}


function getInnerHeight()
{
    if(crossBrowser.bw.msie || crossBrowser.bw.msie7)
    {
		return parseInt(document.documentElement.clientHeight);
    }
    else
    {
		var trueHeight = parseInt(document.documentElement.clientHeight);
		if(crossBrowser.bw.safari)
		{
			trueHeight = parseInt(window.innerHeight);
		}
		else if(crossBrowser.bw.opera)
		{
			trueHeight = parseInt(window.innerHeight)-3;
			if(parseInt(window.innerWidth) < parseInt(worldWidth))
			{
				// horizontal scroll bar is visible
				trueHeight -= 20;
			}
		}
		
		return trueHeight;
    }
}


//------------------------------------
// Get Mouse Position
//-------------------------------------
function getMouseX(e)
{
    if(crossBrowser.bw.msie || crossBrowser.bw.msie7)
    {
		return parseInt(document.documentElement.scrollLeft) + parseInt(window.event.clientX);
    }
    else
    {
		return parseInt(e.pageX);
    }
}

function getMouseY(e){
    if(crossBrowser.bw.msie || crossBrowser.bw.msie7)
    {
		return parseInt(document.documentElement.scrollTop) + parseInt(window.event.clientY);
    }
    else
    {
		return parseInt(e.pageY);
    }
}

//-------------------------------------
// Parse URL
//-------------------------------------
function parseURL(url)
{
    var urlArray = url.split("?");
    urlPure = urlArray[0];
}


//------------------------------------------------------------
//  style='position:fixed' for IE6 and Opera8
//  (IE7 and Opera9 don't need this function)
//------------------------------------------------------------
function layerFix()
{
    var controlPanelNode = document.getElementById("controlpanel");
    var footerNode = document.getElementById("footer");

    // hide fixed layers for handsome scrolling
    if(!mouseOutOfWorld)
    {
		if(controlPanelNode != null)
		{
			controlPanelNode.style.left = document.documentElement.scrollLeft + "px";
			controlPanelNode.style.top = document.documentElement.scrollTop + "px";
			controlPanelNode.style.display = "block"; 
		}
		
		footerNode.style.left = document.documentElement.scrollLeft + "px";
		footerNode.style.top = (document.documentElement.clientHeight - document.getElementById("footer").offsetHeight + document.documentElement.scrollTop).toString() + "px";
		footerNode.style.display = "block"; 
    }
    else
    {
		if(controlPanelNode != null)
		{
			controlPanelNode.style.display="none";
		}
		footerNode.style.display="none";
    }

    if(parseInt(document.documentElement.scrollTop) > worldHeight + worldTop - document.documentElement.clientHeight)
    {
		document.documentElement.scrollTop = worldHeight + worldTop - document.documentElement.clientHeight;
    }

}


//------------------------------------
// set button events
//------------------------------------
function setButtonEvents(id, mouseoverimg, mouseoutimg, mousedownimg, myfunc)
{
    var btnNode = document.getElementById(id);
    if(btnNode != null && btnNode != undefined)
    {
		btnNode.onmouseover = function(){this.style.backgroundImage = "url('" + IMAGEFILEPATH + mouseoverimg + "')";}
		btnNode.onmouseout = function(){this.style.backgroundImage = "url('" + IMAGEFILEPATH + mouseoutimg + "')";}
		btnNode.onmousedown = function(){this.style.backgroundImage = "url('" + IMAGEFILEPATH + mousedownimg + "')"; eval(myfunc)}
		btnNode.onmouseup = function(){this.style.backgroundImage = "url('" + IMAGEFILEPATH + mouseoutimg + "')";}
    }
}


//------------------------------------
// load image cache
//------------------------------------
function loadImageCache()
{
    for(var i = 0; i < arguments.length; i++)
    {
		var cacheImage = new Image();
		cacheImage.src = IMAGEFILEPATH + arguments[i];
    }
}

//-------------------------------------
// Body onUnLoad()
//-------------------------------------
function bodyUnLoad()
{
    // remove mouse events
    document.onmousedown = null;
    document.onmouseup = null;
    document.onmousemove = null;
    document.onmouseout = null;

    var scrollValue = "";
    if(crossBrowser.bw.safari)
    {
		scrollValue = pageidValue + "," + positlogMode + "," + document.body.scrollLeft + "," + document.body.scrollTop;
    }
    else
    {
		scrollValue = pageidValue + "," + positlogMode + "," + document.documentElement.scrollLeft + "," + document.documentElement.scrollTop;
    }
    var date = new Date();
    setCookie("scroll",scrollValue, CGIFILEPATH, 0);
    setCookie("scrollDate",date.getTime(), CGIFILEPATH, 0);
}

//-------------------------------------
// Body onLoad()
//-------------------------------------
function bodyOnLoad()
{
    // check browser
    //   alert("safari:"+crossBrowser.bw.safari+"\nkonqueror:"+crossBrowser.bw.konqueror+"\nmozes:"+crossBrowser.bw.mozes+"\nopera:"+crossBrowser.bw.opera+"\nmsie7:"+crossBrowser.bw.msie7+"\nmsie:"+crossBrowser.bw.msie);

    var spritesListNode = document.getElementById("spriteslist");
    var spritesList = spritesListNode.childNodes;

    // load image files into browser cache
    if(positlogMode == "EditMode")
    {
		loadImageCache("scaler.gif", "mover.gif", "editor.gif", "close.gif", "save.gif", "top.gif", "bottom.gif", "newspritebtn.gif", "newspritebtn_hl.gif", "newspritebtn_rev.gif",  "newpagebtn.gif", "newpagebtn_hl.gif", "newpagebtn_rev.gif");
    }

    // get region of the world
    var spritesWorldNode = document.getElementById("spritesworld");
    worldLeft = parseInt(spritesWorldNode.style.left.replace(/px/g, ""));
    worldTop = parseInt(spritesWorldNode.style.top.replace(/px/g, ""));
    worldWidth = parseInt(spritesWorldNode.style.width.replace(/px/g, ""));
    worldHeight = parseInt(spritesWorldNode.style.height.replace(/px/g, ""));

    viewPositionX = 0;
    viewPositionY = 0;

    parseURL(location.href);

    // apply order:  edge > id > view position

    if(edgeValue != "")
    {
		// get list of all sprites
		var targetSprite = spritesList[0];
		if(edgeValue == "top" || edgeValue == "bottom")
		{
			var topY = parseInt(targetSprite.style.top.replace(/px/g, ""));
			for (var i=0; i<spritesList.length; i++)
			{
				var tmpSprite = spritesList[i];
				if(tmpSprite.nodeType == 1)
				{
					var tmpTop = parseInt(tmpSprite.style.top.replace(/px/g, ""));
					if(edgeValue == "top" && tmpTop < topY)
					{
						topY = tmpTop;
						targetSprite = tmpSprite;
					}
					else if(edgeValue == "bottom" && tmpTop > topY)
					{
						topY = tmpTop;
						targetSprite = tmpSprite;
					}
				}
			}
		}
		else if(edgeValue == "left" || edgeValue == "right")
		{
			var leftX = parseInt(targetSprite.style.left.replace(/px/g, ""));
			for (var i=0; i<spritesList.length; i++)
			{
				var tmpSprite = spritesList[i];
				if(tmpSprite.nodeType == 1)
				{
					var tmpLeft = parseInt(tmpSprite.style.left.replace(/px/g, ""));
					if(edgeValue == "left" && tmpLeft < leftX)
					{
						leftX = tmpLeft;
						targetSprite = tmpSprite;
					}
					else if(edgeValue == "right" && tmpLeft > leftX)
					{
						leftX = tmpLeft;
						targetSprite = tmpSprite;
					}
				}
			}
		}
		idValue = targetSprite.id;
    }


    if(idValue == "" && vpValue == "")
    {
		var scrollValue = getCookie("scroll");
		var scrollDateValue = getCookie("scrollDate");
		var date = new Date;
		if(scrollValue != undefined
		   && parseInt(date.getTime()) - parseInt(scrollDateValue) < 30000)
		{
			var scrollArray = scrollValue.split(",");
			if(scrollArray[0] == pageidValue && scrollArray[1] == "ViewMode" && positlogMode == "EditMode")
			{
				if(crossBrowser.bw.safari)
				{
					document.body.scrollLeft = scrollArray[2];
					document.body.scrollTop = scrollArray[3];
				}
				else
				{
					document.documentElement.scrollLeft = scrollArray[2];
					document.documentElement.scrollTop = scrollArray[3];
				}
			}
		}
    }
    else if(idValue != "")
    {
		focusedSprite = document.getElementById(idValue);

		if(focusedSprite != "")
		{
			var innerWidth = getInnerWidth();
			if(innerWidth > worldWidth)
			{
				innerWidth = worldWidth;
			}
			var leftOffset = innerWidth/2 - parseInt(focusedSprite.style.width.replace(/px/g, ""))/2;
			
			leftOffset = Math.round(leftOffset);
			
			if(leftOffset < 10)
			{
				leftOffset = 10;
			}
			var topOffset = 10;
			var innerHeight = getInnerHeight() - document.getElementById("footer").offsetHeight;
			if(innerHeight > worldHeight)
			{
				innerHeight = worldHeight;
			}
			if(innerHeight > 200)
			{
				topOffset = 100;
			}

			if(parseInt(focusedSprite.style.left.replace(/px/g, "")) + parseInt(focusedSprite.style.width.replace(/px/g, "")) < worldWidth
			   && parseInt(focusedSprite.style.top.replace(/px/g, "")) + parseInt(focusedSprite.offsetHeight) < worldHeight)
			{
				// Change scroll value if the focused sprite is in the worldArea.
				if(crossBrowser.bw.safari)
				{
					document.body.scrollLeft = parseInt(focusedSprite.style.left.replace(/px/g, "")) - parseInt(leftOffset);
					document.body.scrollTop = parseInt(focusedSprite.style.top.replace(/px/g, "")) - parseInt(topOffset);
				}
				else
				{
					document.documentElement.scrollLeft = parseInt(focusedSprite.style.left.replace(/px/g, "")) - parseInt(leftOffset);
					document.documentElement.scrollTop = parseInt(focusedSprite.style.top.replace(/px/g, "")) - parseInt(topOffset);
				}			

			}
			else
			{
				// Change view position if the focused sprite is not in the worldArea.
				setViewPosition(parseInt(viewPositionX) - parseInt(focusedSprite.style.left.replace(/px/g, ""))+parseInt(leftOffset),parseInt(viewPositionY) - parseInt(focusedSprite.style.top.replace(/px/g, ""))+parseInt(topOffset));

			}

			// show rectangle of focusedSprite
			focusedSprite.style.border = "2px solid #c06060";
			focusedSprite.style.padding = "1px";
			originalZindexOfFocusedSprite = focusedSprite.style.zIndex;
			focusedSprite.style.zIndex = Z_GO_TEMP_FOREGROUND;
		}
    }
    else if(vpValue != "")
    {
		// move to focused viewposition
		vpValue.match(/^(.+),(.+)$/);
		moveX = RegExp.$1;
		moveY = RegExp.$2;
		// to int
		moveX = moveX - 0;
		moveY = moveY - 0;

		setViewPosition(parseInt(viewPositionX) + moveX, parseInt(viewPositionY) + moveY);
    }


    // config control panel
    if(positlogMode == "EditMode")
    {
		var controlPanelNode = document.getElementById("controlpanel");

		// "fixed" does not work well on ie6 and opera8,
		// but works ie7 and opera9
		if(crossBrowser.bw.msie)
		{
			controlPanelNode.style.position = "absolute";
		}
		else
		{
			controlPanelNode.style.position = "fixed";
		}

		setButtonEvents("newspritebtn", "newspritebtn_hl.gif", "newspritebtn.gif", "newspritebtn_rev.gif", "createSprite();");
		setButtonEvents("newpagebtn", "newpagebtn_hl.gif", "newpagebtn.gif", "newpagebtn_rev.gif", "createPage()");

    }

    // set footer position
    var footerNode = document.getElementById("footer");
    if(crossBrowser.bw.msie)
    {
		footerNode.style.position = "absolute";
		window.onscroll = layerFix;
		window.onresize = layerFix;
    }
    else
    {
		footerNode.style.position = "fixed";
    }

    // set events to sprites
    for (var i=0; i<spritesList.length; i++)
    {
		var tmpSprite = spritesList[i];
		if(tmpSprite.nodeType == 1)
		{
			tmpSprite.onmouseover = spriteOnMouseOver;
		}
    }

    // set mouse events
    document.onmousedown = generalOnMouseDown;
    document.onmouseup = generalOnMouseUp;
    document.onmousemove = generalOnMouseMove;
    document.onmouseout = generalOnMouseOut;

    // set current position
    document.getElementById("currentposition").innerHTML = "<a href='"+location.href+"'>" + location.href + "</a>";	

    // set login id
    loginid = getCookie("loginid");

    // set cursor
    if(slideoperationValue == 1){
		if(crossBrowser.bw.mozes || crossBrowser.bw.msie || crossBrowser.bw.msie7)
		{
			var spritesWorldNode = document.getElementById("spritesworld");	    
			spritesWorldNode.style.cursor = "url(" + IMAGEFILEPATH + "hand.cur), default";
		}
    }

}


//-------------------------------------
// Manipulate sprites / view position
//-------------------------------------
function removeIconsFromSprite(spr)
{
    // remove mover
    var tmpMoverElm = document.getElementById("sprite-mover");
    if(tmpMoverElm != undefined && tmpMoverElm != null )
    {
		spr.removeChild(tmpMoverElm);
    }
    // remove scaler
    var tmpScalerElm = document.getElementById("sprite-scaler");
    if(tmpScalerElm != undefined && tmpScalerElm != null)
    {
		spr.removeChild(tmpScalerElm);
    }
    // remove editor Icon
    var tmpEditorIconElm = document.getElementById("sprite-editor");
    if(tmpEditorIconElm != undefined && tmpEditorIconElm != null)
    {
		spr.removeChild(tmpEditorIconElm);
    }
}

function clearSelectedSprite()
{	
    if(selectedSprite != null)
    {
		// reset to original border
		if(positlogMode == "EditMode")
		{
			if(fixedID == 0 || fixedID != selectedSprite.id)
			{
				selectedSprite.style.borderWidth = "0px";
				selectedSprite.style.borderColor = "black";
				selectedSprite.style.borderStyle = "none";
				selectedSprite.style.padding = "3px";
				selectedSprite.style.zIndex = originalZindexOfSelectedSprite;
			}

			if(fixedID == 0 && editingSprite == null)
			{
				removeIconsFromSprite(selectedSprite);
			}
		}

		selectedSprite = null;
    }
}

function clearSelectedFixedSprite()
{	
    if(fixedID != 0)
    {
		var fixedSprite = document.getElementById(fixedID);

		// reset to original border
		if(positlogMode == "EditMode")
		{
			fixedSprite.style.borderWidth = "0px";
			fixedSprite.style.borderColor = "black";
			fixedSprite.style.borderStyle = "none"
			fixedSprite.style.padding = "3px";
			removeIconsFromSprite(fixedSprite);
		}

		// reset z-index
		fixedSprite.style.zIndex = originalZindexOfSelectedSprite2;
		fixedID = 0;
    }
}


function isInScrollbarRegion(e)
{
    if(crossBrowser.bw.msie || crossBrowser.bw.msie7)
    {
		var x = window.event.clientX;
		var y = window.event.clientY;

		var cw = getInnerWidth();
		if(x > cw || x < 1)
		{
			return false;
		}
		var ch = getInnerHeight();

		if(positlogMode == "EditMode")
		{
			ch -= document.getElementById("footer").offsetHeight;
		}

		if(y > ch || y < 1)
		{
			return false;
		}
    }
    else
    {
		var x = e.pageX;
		var y = e.pageY;

		var trueWidth = getInnerWidth();
		
		if(x - parseInt(window.pageXOffset) > trueWidth || x - parseInt(window.pageXOffset) < 1)
        {
			return false;
        }

		var trueHeight = getInnerHeight();

		if(positlogMode == "EditMode")
		{
			trueHeight -= document.getElementById("footer").offsetHeight;
		}

		if(y - parseInt(window.pageYOffset) > trueHeight || y - parseInt(window.pageYOffset) < 1)
        {
			return false;
        }
    }
    
    return true;

}



function generalOnMouseOut(e)
{
    if(!isInScrollbarRegion(e) && !movingSpriteFlag && !movingEditorFlag)
    {
		generalOnMouseUp();
    }
}


function generalOnMouseDown(e)
{
	if(movingSpriteFlag || scalingSpriteFlag)
	{
		return;
	}

	//--------------------
	// check regions
	//--------------------

    // check region of Sprites World
    if(getMouseX(e) < worldLeft || getMouseX(e) > worldLeft+worldWidth
       || getMouseY(e) < worldTop || getMouseY(e) > worldTop+worldHeight)
    {
		return;
	}
    // check inner border of Scrollbar
    if(!isInScrollbarRegion(e))
    {
		return;
    }
    // check region of editor
    if(editingSprite != null)
    {
		var editor = document.getElementById("editor");
		if(getMouseX(e) > parseInt(editor.style.left.replace(/px/g, "")) && getMouseX(e) < parseInt(editor.style.left.replace(/px/g, ""))+editor.offsetWidth
		   && getMouseY(e) > parseInt(editor.style.top.replace(/px/g, "")) && getMouseY(e) < parseInt(editor.style.top.replace(/px/g, ""))+editor.offsetHeight)
		{
			return;
		}
    }

	//-------------------------
	// Process mouse down event
	//-------------------------

    // First, clear focus and return if focused sprite exists.
    if(focusedSprite != null)
    {
		if(selectedSprite == null 
		   || (selectedSprite != null && selectedSprite != focusedSprite))
		{
			focusedSprite.style.borderWidth = "0px";
			focusedSprite.style.borderColor = "black";
			focusedSprite.style.borderStyle = "none";
			focusedSprite.style.padding = "3px";
			focusedSprite.style.zIndex = originalZindexOfFocusedSprite;
			focusedSprite = null;
		}
		else
		{
			return;
		}
    }

	// spoit for picking color
    if(editingSprite != null && selectedSprite != null)
    {
	    var selContents = document.getElementById(selectedSprite.id + "_contents");
	    var selContents = document.getElementById(selectedSprite.id + "_contents");
	    var contents = document.getElementById(editingSprite.id + "_contents");
	    if(frameColorDialogOpen)
	    {
			setColor2Selector(selContents.style.borderTopColor, "#000000");
	    }
	    else if(bgColorDialogOpen)
	    {
			setColor2Selector(selContents.style.backgroundColor, "#ffffff");
	    }
	    else if(foreColorDialogOpen)
	    {
			setColor2Selector(selContents.style.color, "#000000");
	    }
	    return;
    }

	// Fix or clear sprite
    if(fixedID != 0)
    {
		if(selectedSprite != null && selectedSprite.id != fixedID)
		{
			// Fix another sprite
			clearSelectedFixedSprite();
			var tmpSprite = selectedSprite;
			clearSelectedSprite();
			setSelectedSprite(tmpSprite);
			setSelectedFixedSprite(selectedSprite);
		}
		else if(selectedSprite == null){
			// Clear fixed sprite
			clearSelectedFixedSprite();
			return;
		}
    }
	else
	{
		if(selectedSprite != null)
		{
			// Fix new sprite
			setSelectedFixedSprite(selectedSprite);
		}
    }

    // Move fixed sprite to front or back
    if(fixedID != 0 
       && fixedID == selectedSprite.id
       && editingSprite == null
      )
    {
		// Use parseFloat to pase 1e+06 to 1000000 on Safari
		if(parseFloat(selectedSprite.style.zIndex) == Z_GO_TEMP_FOREGROUND)
		{
			if(counterForMoveToBackground >= 4)
			{
				selectedSprite.style.zIndex = Z_GO_TEMP_BACKGROUND;
			}
			else
			{
				counterForMoveToBackground++;
			}
		}
		else if(parseFloat(selectedSprite.style.zIndex) == Z_GO_TEMP_BACKGROUND)
		{
			selectedSprite.style.zIndex = originalZindexOfSelectedSprite2;
			counterForMoveToBackground = 0;
		}
		else
		{
			selectedSprite.style.zIndex = Z_GO_TEMP_FOREGROUND;
			counterForMoveToBackground = 0;
		}
		return;
    }
	else
	{
		counterForMoveToBackground = 0;
	}


	// Move view position of sprites world
    if(slideoperationValue == 1
       && selectedSprite == null)
    {
		setViewPositionFlag = true;
		if(crossBrowser.bw.mozes || crossBrowser.bw.msie || crossBrowser.bw.msie7)
		{
			var spritesWorldNode = document.getElementById("spritesworld");	    
			spritesWorldNode.style.cursor = "url(" + IMAGEFILEPATH + "hand2.cur), default";
		}
    }
}



function generalOnMouseMove(e)
{
    // check border of Sprites World
    // border can be ignored when moving Sprite or ViewPosition
    if(!setViewPositionFlag 
       && !movingSpriteFlag
       && !scalingSpriteFlag
       && !movingEditorFlag
      )
    {
		if((getMouseX(e) < worldLeft || getMouseX(e) > worldLeft+worldWidth
			|| getMouseY(e) < worldTop || getMouseY(e) > worldTop+worldHeight) 
			|| !isInScrollbarRegion(e)
		  )
		{
			mouseOutOfWorld = true;
			return;
		}
    }

    if(mouseOutOfWorld)
    {
		var footerElm = document.getElementById("footer");
		footerElm.style.display = "block";

		if(crossBrowser.bw.msie)
		{
			mouseOutOfWorld = false;
			layerFix();
		}
    }

    mouseOutOfWorld = false;


    if(prevMouseX == 0)
    {
		prevMouseX = getMouseX(e);
    }
    if(prevMouseY == 0)
    {
		prevMouseY = getMouseY(e);
    }
    var moveX = getMouseX(e) - prevMouseX;
    var moveY = getMouseY(e) - prevMouseY;
    
    prevMouseX = getMouseX(e);
    prevMouseY = getMouseY(e);

    if(movingSpriteFlag)
    {
		//----------------------
		// move single Sprite
		//----------------------
		selectedSprite.style.left = (parseInt(selectedSprite.style.left.replace(/px/g, "")) + moveX).toString() + "px";
		selectedSprite.style.top = (parseInt(selectedSprite.style.top.replace(/px/g, "")) + moveY).toString() + "px";

		// document.selection.empty() does not work well in opera
		if(!crossBrowser.bw.opera)
		{
			if(document.selection)
			{
				document.selection.empty();
			}
		}
    }
    else if(movingEditorFlag)
    {
		//----------------------
		// move editor
		//----------------------
		var editorElm = document.getElementById("editor");
		if(editorElm != null)
		{
			editorElm.style.left = (parseInt(editorElm.style.left.replace(/px/g, "")) + moveX).toString() + "px";
			editorElm.style.top = (parseInt(editorElm.style.top.replace(/px/g, "")) + moveY).toString() + "px";
		}
		// document.selection.empty() does not work well in opera
		if(!crossBrowser.bw.opera)
		{
			if (document.selection)
			{
				document.selection.empty();
			}
		}


    }
    else if(scalingSpriteFlag)
    {
		//----------------------
		// scale single Sprite
		//----------------------
		var scalerElm = document.getElementById("sprite-scaler");
		var editorIconElm = document.getElementById("sprite-editor");

		var newWidth = parseInt(selectedSprite.style.width.replace(/px/g, "")) + moveX;

		if(newWidth < 16)
		{
			newWidth = 16;
		}

		selectedSprite.style.width = newWidth + "px";


		// document.selection.empty() does not work well in opera
		if(!crossBrowser.bw.opera)
		{
			if (document.selection)
			{
				document.selection.empty();
			}
			else if (window.getSelection)
			{
				window.getSelection().removeAllRanges(); 
			}
		}

    }
    else if(setViewPositionFlag)
    {
		setViewPosition(parseInt(viewPositionX) + moveX, parseInt(viewPositionY) + moveY);
    }

    // Check whether mouse is on the selected Sprite.
    if(selectedSprite != null 
       && !movingEditorFlag
       && !movingSpriteFlag
       && !scalingSpriteFlag)
    {
		// Onmouseout events are occurred when mouse is on the region.
		// An onmouseout event is occurred when mouse is moved onto another object
		// on the selected object.
		// So, here, check whether mouse is out or not.
		var spriteLeft = parseInt(selectedSprite.style.left.replace(/px/g, "")) + viewPositionX;
		var spriteTop = parseInt(selectedSprite.style.top.replace(/px/g, "")) + viewPositionY;
		var spriteWidth = parseInt(selectedSprite.style.width.replace(/px/g, ""));
		var spriteHeight = parseInt(selectedSprite.offsetHeight);
		var xBorderOffset = 16; // magic number;
		var yBorderOffset = 32; // magic number;

		if((getMouseX(e) < worldLeft+spriteLeft || getMouseX(e) > worldLeft+spriteLeft+spriteWidth+xBorderOffset
			|| getMouseY(e) < worldTop+spriteTop || getMouseY(e) > worldTop+spriteTop+spriteHeight+yBorderOffset))
		{
			clearSelectedSprite();
		}
    }


}


function setViewPosition(posX, posY)
{
    // move view posion (namely, move all Sprites)
    viewPositionX = parseInt(posX);
    viewPositionY = parseInt(posY);
    
    parseURL(location.href);
    newURL = urlPure + "?load=" + pageidValue + "&vp=" + viewPositionX.toString() + "," + viewPositionY.toString();
    document.getElementById("currentposition").innerHTML = "<a href='"+newURL+"'>" + newURL + "</a>";	

    var spritesListNode = document.getElementById("spriteslist");
    spritesListNode.style.left = viewPositionX.toString() + "px";
    spritesListNode.style.top = viewPositionY.toString() + "px";
    var spritesWorldNode = document.getElementById("spritesworld");
    spritesWorldNode.style.backgroundPosition = viewPositionX.toString() + "px" + " " + viewPositionY.toString() + "px";

}


function generalOnMouseUp()
{

    setViewPositionFlag = false;

    var worldElm = document.getElementById("spritesworld");
    if(slideoperationValue == 1)
    {
		if(crossBrowser.bw.mozes || crossBrowser.bw.msie || crossBrowser.bw.msie7)
		{
			var spritesWorldNode = document.getElementById("spritesworld");
			spritesWorldNode.style.cursor = "url(" + IMAGEFILEPATH + "hand.cur), default";
		}
    }

    if(movingSpriteFlag)
    {
		movingSpriteFlag = false;

		saveStyles(selectedSprite);
    }
    else if(movingEditorFlag)
    {
		movingEditorFlag = false;
    }
    else if(scalingSpriteFlag)
    {
		if(crossBrowser.bw.msie)
		{
			// Sprite width is automatically expanded to adjust to the width of inner image on IE6.
			var definedWidth = parseInt(selectedSprite.style.width.replace(/px/g, ""));
			var realWidth = parseInt(selectedSprite.offsetWidth) - 6;
			if(definedWidth < realWidth)
			{
				selectedSprite.style.width = realWidth + "px";
			}
		}

		scalingSpriteFlag = false;

		saveStyles(selectedSprite);
    }
}



function setSelectedSprite(elm)
{
    if(elm == null)
    {
		return;
    }

//	document.getElementById("controlresult").innerHTML = parseFloat(elm.style.zIndex);


    selectedSprite = elm;

    // Changing visible <-> hidden causes the failure of 
    // getting width of srpite. You must use only "hidden" style
    // or only "visible" style
    //	    selectedSprite.style.overflow = "visible";
    originalZindexOfSelectedSprite = selectedSprite.style.zIndex;

    if(positlogMode == "EditMode")
    {
		if((fixedID == 0 || fixedID == selectedSprite.id)
			&& editingSprite == null )
		{
			// add mover
			if(!document.getElementById("sprite-mover")){
				var moverElm = document.createElement("div");
				moverElm.setAttribute("id", "sprite-mover");
				moverElm.onmousedown = moverOnMouseDown;
				selectedSprite.appendChild(moverElm);
			}

			// add scaler
			if(!document.getElementById("sprite-scaler")){
				var scalerElm = document.createElement("div");
				scalerElm.setAttribute("id", "sprite-scaler");
				scalerElm.style.right = "-2px";
				scalerElm.style.bottom = "-2px";
				scalerElm.onmousedown = scalerOnMouseDown;
				selectedSprite.appendChild(scalerElm);
			}
			
			// add editor Icon
			if(!document.getElementById("sprite-editor")){
				var iconElm = document.createElement("div");
				iconElm.setAttribute("id", "sprite-editor");
				iconElm.style.right = "-3px";
				iconElm.style.top = "-3px";
				iconElm.onmousedown = editoriconOnMouseDown;
				if(crossBrowser.bw.mozes || crossBrowser.bw.msie || crossBrowser.bw.msie7)
				{
					iconElm.style.cursor = "url(" + IMAGEFILEPATH + "hand3.cur), default";
				}
				selectedSprite.appendChild(iconElm);
			}
		}

		if(fixedID == 0 || fixedID != selectedSprite.id)
		{
			// show rectangle of selectedSprite
			selectedSprite.style.border = "2px dashed #9090f0";
			selectedSprite.style.padding = "1px";
		}
    }
}


function setSelectedFixedSprite(elm)
{
    fixedID = elm.id;

    var fixedSprite = document.getElementById(fixedID);
    originalZindexOfSelectedSprite2 = originalZindexOfSelectedSprite;
    if(positlogMode == "EditMode")
    {
		fixedSprite.style.border = "2px solid #9090f0";
		fixedSprite.style.padding = "1px";
    }
}

//------------------------------------
// SpriteOnMouseOver
//------------------------------------

function spriteOnMouseOver()
{

    var elm = document.getElementById(this.id);

    if((elm == null && elm == undefined)
		|| mouseOutOfWorld
       || document.getElementById("password-dialog")
       || movingSpriteFlag || scalingSpriteFlag
      )
    {
		return;
    }

    if(selectedSprite != null && selectedSprite != elm)
    {
		clearSelectedSprite();
    }

    if(selectedSprite == null)
    {
		setSelectedSprite(elm);
    }
}


//--------------------------------
// Cookie
//--------------------------------
function getCookie(key)
{
    if(!document.cookie) return undefined;
    var v=document.cookie;
    var ns=v.indexOf(key+"="); if(ns<0) return undefined; ns=ns+key.length+1;
    var ne=v.indexOf(";",ns); if(ne<0) ne=v.length;
    return v.substring(ns,ne);
}
function setCookie(key, val, path, day)
{
    theDay = new Date();
    theDay.setTime(theDay.getTime() + (day * 1000 * 60 * 60 * 24));
    var cs=key+"="+val+";";
    if(path != "")
    {
		cs+=" path="+path+";";
    }
    if(day != 0){
		cs+=" expires="+theDay.toGMTString()+";";
    }
    document.cookie=cs;
}



// extended for msie7
function chkAjaBrowser()
{
  var a,ua = navigator.userAgent;
  this.bw= { 
		safari    : ((a=ua.split('AppleWebKit/')[1])?a.split('.')[0]:0)>=124 ,
		konqueror : ((a=ua.split('Konqueror/')[1])?a.split(';')[0]:0)>=3.3 ,
		mozes     : ((a=ua.split('Gecko/')[1])?a.split(' ')[0]:0) >= 20011128 ,
		opera     : (!!window.opera) && ((typeof XMLHttpRequest)=='function') ,
		msie7     : (!!window.ActiveXObject)?((typeof XMLHttpRequest)=='object'):false,
		msie      : (!!window.ActiveXObject)?(!!createHttpRequest())&&((typeof XMLHttpRequest)!='object'):false
  }
  return (this.bw.safari||this.bw.konqueror||this.bw.mozes||this.bw.opera||this.bw.msie)
}

function createHttpRequest(){if(window.XMLHttpRequest){return new XMLHttpRequest();}else if(window.ActiveXObject){try{return new ActiveXObject('Msxml2.XMLHTTP');}catch(e){try{return new ActiveXObject('Microsoft.XMLHTTP');}catch(e2){return null;}}}else{return null;}}function sendRequest(c,d,p,u,y,t,v,w){var o=createHttpRequest();if(o==null)return null;var t=(!!sendRequest.arguments[5])?t:false;if(t||p.toUpperCase()=='GET')u+='?';if(t)u=u+'t='+(new Date()).getTime();var z=new chkAjaBrowser();var op=z.bw.opera;var s=z.bw.safari;var k=z.bw.konqueror;var m=z.bw.mozes;if(typeof c=='object'){var l=c.onload;var h=c.onbeforsetheader}else{var l=c;var h=null;}if(op||s||m){o.onload=function(){l(o);}}else{o.onreadystatechange=function(){if(o.readyState==4){l(o);}}}d=r(d,u);if(p.toUpperCase()=='GET'){u+=d}o.open(p,u,y,v,w);if(!!h)h(o);x(o);o.send(d);function x(o){var g='application/x-www-form-urlencoded; charset=UTF-8';if(!window.opera){o.setRequestHeader('Content-Type',g);}else{if((typeof o.setRequestHeader)=='function')o.setRequestHeader('Content-Type',g);}return o}function r(d,u){var n=(u.indexOf('?')==-1)?'?dmy':'';if(typeof d=='object'){for(var i in d)n+='&'+encodeURIComponent(i)+'='+encodeURIComponent(d[i]);}else if(typeof d=='string'){if(d=='')return'';var n='';var f=d.split('&');for(var i=1;i<f.length;i++){var q=f[i].split('=');n+='&'+encodeURIComponent(q[0])+'='+encodeURIComponent(q[1]);}}return n;}return o}

