#!/usr/local/bin/perl

# --------------------------------------------------------
#
# fixzindex.cgi:
#      cgi for fixing z-index
#  (tested under perl 5.8.4)
#
# Copyright (c) 2006 Hidekazu Kubota (Taro Sosui) All right reserved
#  <taro@summer.nifty.jp> 
#   http://storybook.jp/
#
# --------------------------------------------------------

# --------------------------------------------------------
# This file is part of PositLog.
#
# PositLog is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# PositLog is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
# --------------------------------------------------------

use strict;
use CGI qw/-debug :standard/;
use Storable qw(lock_retrieve);			# is default library (upper perl 5.8)
use PositLogConfig;

my $CGI = new CGI;
print $CGI->header(-charset => 'utf-8'); # HTTP header

my $command = $CGI->param("command");
if($command eq "fix")
{
    
    opendir( DATADIR, $PositLogConfig::datapath );
    my @PageList = readdir( DATADIR );
    closedir( DATADIR );
    foreach my $pageid  (@PageList)
    {
		if($pageid eq "." || $pageid eq ".." || $pageid eq ".htaccess")
		{
			next;
		}

		my $spritesHash = eval{ Storable::lock_retrieve($PositLogConfig::datapath . $pageid . "/sprites.dat")} or {};
		if($spritesHash eq ""){ print "Cannot read sprites.dat."; exit(0); }
		
		foreach my $sid (keys %$spritesHash)
		{
			my $oldstyle = $spritesHash->{$sid}{"style"};
			$oldstyle =~ /^(.+)(z-index:)(\d+?)(;.*)$/i;

			my $newz = scalar($3) + 500000;
			my $newstyle = $1 . $2 . $newz . $4;

			$spritesHash->{$sid}{"style"} = $newstyle;

		}
		if(!eval{Storable::lock_nstore $spritesHash, $PositLogConfig::datapath . $pageid . "/sprites.dat"}){ print "Cannot write the sprite list."; exit(0); }
    }


    my $HEADER = "<!DOCTYPE html PUBLIC '-//W3C//DTD HTML 4.01 Transitional//EN'\n
   'http://www.w3.org/TR/html4/loose.dtd'>\n
<html lang='ja-JP'>\n
	<head>\n
		<meta http-equiv='Content-Type' content='text/html;charset=UTF-8'>\n
		<title>Fix z-index</title>\n
	</head>\n";
    
    my $BODY = "<body>\n
  <h1>Fix z-index</h1>\n
  <p>Done.</p>
</body>\n";
    my $FOOTER = "</html>";

    print $HEADER . $BODY . $FOOTER;

}
else
{

    my $HEADER = "<!DOCTYPE html PUBLIC '-//W3C//DTD HTML 4.01 Transitional//EN'\n
   'http://www.w3.org/TR/html4/loose.dtd'>\n
<html lang='ja-JP'>\n
	<head>\n
		<meta http-equiv='Content-Type' content='text/html;charset=UTF-8'>\n
		<title>Fix z-index</title>\n
	</head>\n";
    
    my $BODY = "<body>\n
  <h1>Fix z-index</h1>\n
  <form action='fixzindex.cgi' method='post'>\n
    <input type='submit' id='submitbtn' value='Fix!' tabindex='1'>\n
    <input type='hidden' name='command' id='command' value='fix'>\n
  </form>\n
</body>\n";
    my $FOOTER = "</html>";

    print $HEADER . $BODY . $FOOTER;

}
