package jp.oarts.pirka.test.view;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;

import jp.oarts.pirka.core.kernel.FieldMap;
import jp.oarts.pirka.core.kernel.PirkaImage;
import jp.oarts.pirka.core.util.check.CheckAndTeller;
import jp.oarts.pirka.core.util.check.PirkaChecker;
import jp.oarts.pirka.core.util.check.PirkaCheckerLength;
import jp.oarts.pirka.core.util.check.PirkaCheckerString;
import jp.oarts.pirka.core.util.check.PirkaCheckerStringChars;
import jp.oarts.pirka.core.win.PirkaWindow;

public class CtrlTest09 extends PirkaWindow {

	public CtrlTest09() {
		FieldMap field = getFieldMap();
		field.setOfficialFieldName("text01", "01");
		field.setOfficialFieldName("text02", "02");
		field.setOfficialFieldName("text03", "03");
		field.setOfficialFieldName("text04", "04");
		field.setOfficialFieldName("text05", "05");
		field.setOfficialFieldName("text06", "06");
		field.setOfficialFieldName("text07", "07");
		field.setOfficialFieldName("text08", "08");
		field.setOfficialFieldName("text09", "09");
		field.setOfficialFieldName("text10", "10");
		field.setOfficialFieldName("text11", "11");
		field.setOfficialFieldName("text12", "12");

		for (int i = 0; i < 5; i++) {
			FieldMap loopField = createLoopFieldMap("loop1");
			loopField.setOfficialFieldName("text13", "[v13-" + (i + 1));
			loopField.setOfficialFieldName("text14", "[v14-" + (i + 1));
			loopField.setValue("label_text13", "[v13-" + (i + 1));
			loopField.setValue("label_text14", "[v14-" + (i + 1));
			field.addFieldMap("loop1", loopField);
		}
		field.setOfficialFieldName("text15", "15");
		field.setOfficialFieldName("text16", "16");
		field.setOfficialFieldName("text17", "17");
		field.setOfficialFieldName("text18", "18");
		field.setOfficialFieldName("text19", "19");
		field.setOfficialFieldName("text20", "20");
		field.setOfficialFieldName("text21", "21");

		field.setAutoCheck("check2Button", false);
		field.setAutoCheck("returnButton", false);

		addCheck("text01", PirkaChecker.required);
		addCheck("text02", new PirkaCheckerLength(PirkaCheckerLength.JUST, 5, 8));

		addErrorCheckReturner();
		// addErrorChaeckBreak();

		addCheck("text03", PirkaChecker.required, new PirkaCheckerLength(PirkaCheckerLength.RANGE, 2, 4, 6, 8));
		addCheck("text04", new PirkaCheckerString(PirkaCheckerStringChars.NUM), new PirkaCheckerLength(PirkaCheckerLength.JUST, 5));
		addCheck("text05", new PirkaCheckerString(PirkaCheckerStringChars.NUM, PirkaCheckerStringChars.HIGHT_ALPHABET, PirkaCheckerStringChars.LOW_ALPHABET));
		addCheck("text06", new PirkaCheckerString(PirkaCheckerStringChars.HALF));
		addCheck("text07", new PirkaCheckerString(PirkaCheckerStringChars.WIDE));
		addCheck("text08", new PirkaCheckerString(PirkaCheckerStringChars.HALF_KANA));
		addCheck("text09", new PirkaCheckerString(PirkaCheckerStringChars.MAIL));
		addCheck("text10", new PirkaCheckerString(PirkaCheckerStringChars.PATH_WIN));
		addCheck("text11", new PirkaCheckerString(new PirkaCheckerStringChars("")));
		addCheck("text12", "ƃXy[XȊO͂ł܂", new PirkaCheckerString(PirkaCheckerStringChars.NUM, PirkaCheckerStringChars.SPACE, PirkaCheckerStringChars.WIDE_SPAC));
		addCheck("text13", new PirkaCheckerString(PirkaCheckerStringChars.NUM));
		addCheck("text14", new PirkaCheckerString(PirkaCheckerStringChars.HIGHT_ALPHABET, PirkaCheckerStringChars.LOW_ALPHABET));
		addCheck(new ToUpper());
		addCheck("text16", PirkaChecker.intValue);
		addCheck("text17", PirkaChecker.longValue);
		addCheck("text18", PirkaChecker.numeric);
		addCheck("text19", PirkaChecker.date);
		addCheck("text20", PirkaChecker.time);
		addCheck("text21", PirkaChecker.datetime);
		addCheck("text22", new PirkaCheckerString(PirkaCheckerStringChars.WIDE_HIRAGANA));
		addCheck("text23", new PirkaCheckerString(PirkaCheckerStringChars.WIDE_KATAKANA));

		addErrorCheckReturner();
		// addErrorChaeckBreak();
	}

	public void onPre() {
		FieldMap field = getFieldMap();

		field.setValue("msg", ""); // OŃbZ[WNA
	}

	public PirkaWindow check1Button() {
		FieldMap field = getFieldMap();

		field.setValue("msg", "`FbN{^̃Cxgɓ܂");

		return new CtrlTest09_1();
	}

	public PirkaWindow check2Button() {
		FieldMap field = getFieldMap();

		field.setValue("msg", "蓮`FbN{^̃Cxgɓ܂");

		check();
		field.setValue("msg", "蓮`FbN{^̃`FbN͏I܂");

		return new CtrlTest09_1();
	}

	public PirkaWindow returnButton() {
		return null;
	}

	class ToUpper extends CheckAndTeller {
		public boolean check() {
			FieldMap field = getFieldMap();

			String value = field.getValueString("text15");
			field.setValue("text15", value.toUpperCase());

			if (value.indexOf('0') >= 0) {
				addError("15", "0͂Ă܂");
				field.setError("text15", true);
				return false;
			}
			return true;
		}

	}

}
