/*
 * Decompiled with CFR 0.152.
 */
package jp.oarts.pirka.core.ctrl.proc.def;

import java.util.List;
import java.util.Map;
import jp.oarts.pirka.core.ajax.AjaxScript;
import jp.oarts.pirka.core.analyzer.html.HtmlTools;
import jp.oarts.pirka.core.app.EntryPointIF;
import jp.oarts.pirka.core.ctrl.proc.CtrlProcesser;
import jp.oarts.pirka.core.err.ErrorMessageManagerIF;
import jp.oarts.pirka.core.err.ErrorMessageStocker;
import jp.oarts.pirka.core.general.HtmlCtrlParts;
import jp.oarts.pirka.core.general.HtmlParts;
import jp.oarts.pirka.core.general.WindowBaseData;
import jp.oarts.pirka.core.kernel.PirkaThreadMap;
import jp.oarts.pirka.core.util.field.FieldItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptProcesser
extends CtrlProcesser {
    private static final String COMMON_AJAX_SCRIPT_KEY = "COMMON_AJAX_SCRIPT_KEY";
    private String commonAjaxScript = "\tfunction createHttpRequest(){\n\t\tif(window.ActiveXObject){\n\t\t\ttry{\n\t\t\t\treturn new ActiveXObject(\"Msxml2.XNLHTTP\")\n\t\t\t}catch(e){\n\t\t\t\ttry{\n\t\t\t\t\treturn new ActiveXObject(\"Microsoft.XMLHTTP\")\n\t\t\t\t}catch(e2){\n\t\t\t\t\treturn null\n\t\t\t\t}\n\t\t\t}\n\t\t}else if(window.XMLHttpRequest){\n\t\t\treturn new XMLHttpRequest()\n\t\t}else{\n\t\t\treturn null;\n\t\t}\n\t}\n\n\tfunction escapeUnicode(str) {\n\t\treturn str.replace(/[^ -~]|[\\s@?/&%+\\\\]/g, function(m) {\n\t\t\tvar cd = m.charCodeAt(0);\n\t\t\t\treturn '\\\\u' + ((cd < 0x10)? '000' :\n\t\t\t\t\t\t\t\t(cd < 0x100)? '00' :\n\t\t\t\t\t\t\t\t(cd < 0x1000)? '0' : '') + cd.toString(16);\n\t\t});\n\t}\n\n";

    @Override
    public boolean isUseChild() {
        return true;
    }

    @Override
    public boolean isLoop() {
        return false;
    }

    @Override
    public boolean isSwitch() {
        return false;
    }

    @Override
    public boolean isInputCtrl() {
        return false;
    }

    @Override
    public boolean isActionCtrl() {
        return false;
    }

    @Override
    public boolean isGroupItem() {
        return false;
    }

    @Override
    public boolean isCheckCtrl() {
        return false;
    }

    @Override
    public boolean isFormatCtrl() {
        return false;
    }

    @Override
    public void setValue(Object data, FieldItem fieldItem) {
        if (data == null || !(data instanceof String)) {
            throw new RuntimeException("\u6307\u5b9a\u3055\u308c\u305f\u5024\u306f\u30bb\u30c3\u30c8\u3067\u304d\u307e\u305b\u3093 String\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u3092\u30bb\u30c3\u30c8\u3057\u3066\u304f\u3060\u3055\u3044");
        }
        fieldItem.setValue((String)data);
    }

    @Override
    public void analyzeInitValue(HtmlCtrlParts ctrl, List<HtmlParts> list) {
        ctrl.setDefaultValue(HtmlTools.toSimpleString(list));
        ctrl.setWebSafe(false);
    }

    @Override
    public String makeStartTag(HtmlCtrlParts ctrl, String loopSuffix, String value, boolean checked, WindowBaseData windowBaseData, ErrorMessageManagerIF errorMessageManager, ErrorMessageStocker errorMessageStocker, boolean errorFlag, Map<String, Object> workMap) {
        EntryPointIF entryPoint = PirkaThreadMap.getEntryPointObjct();
        StringBuilder sb = new StringBuilder();
        sb.append('<');
        sb.append(ctrl.getTagName());
        sb.append(this.createOptionString(ctrl.getTypeOption(), String.valueOf(ctrl.getName()) + loopSuffix, loopSuffix, null, ctrl.isSuffix(), ctrl.getOptionMap()));
        sb.append(">");
        if (ctrl.getAjaxScript() == null) {
            sb.append(value);
        } else {
            AjaxScript ajaxScript = ctrl.getAjaxScript();
            sb.append("\n\t<!--\n");
            if (!workMap.containsKey(COMMON_AJAX_SCRIPT_KEY)) {
                workMap.put(COMMON_AJAX_SCRIPT_KEY, COMMON_AJAX_SCRIPT_KEY);
                sb.append(this.commonAjaxScript);
            }
            sb.append("\tfunction ");
            sb.append(ctrl.getName());
            sb.append("(asyncFlag, data){\n");
            sb.append(ajaxScript.getPreScript());
            sb.append("\t\tvar sendData=\"");
            sb.append("__PIRKA__");
            sb.append('=');
            sb.append("__PIRKA__AJAX__");
            sb.append('&');
            sb.append("__PIRKA__AJAX__");
            sb.append('=');
            sb.append(ctrl.getName());
            sb.append('&');
            sb.append("__PIRKA__INS__");
            sb.append('=');
            sb.append(windowBaseData.getInstanceNo());
            sb.append('&');
            sb.append("__PIRKA__SNO__");
            sb.append('=');
            sb.append("\"+");
            sb.append("escapeUnicode(\"");
            sb.append(windowBaseData.getSerialNo());
            sb.append("\");\n");
            sb.append("\t\tfor(var key in data){\n");
            sb.append("\t\t\tsendData = sendData + \"&\" + escapeUnicode(key) + \"=\" + escapeUnicode(data[key]);\n");
            sb.append("\t\t}\n");
            sb.append("\t\tvar httpobj= createHttpRequest();\n");
            sb.append("\t\thttpobj.open(\"POST\", \"");
            sb.append(entryPoint.getUrlAlias());
            sb.append("\", ");
            sb.append("asyncFlag");
            sb.append(");\n");
            sb.append("\t\thttpobj.setRequestHeader(\"Content-Type\" , \"application/x-www-form-urlencoded\");\n");
            sb.append("\t\thttpobj.onreadystatechange=function(){\n");
            sb.append("\t\t\tif(httpobj.readyState==4){\n");
            sb.append("\t\t\t\tif(httpobj.status == 200){\n");
            sb.append("\t\t\tvar response = eval('(' + httpobj.responseText + ')');\n");
            sb.append(ajaxScript.getResScript());
            sb.append("\t\t\t\t}else{\n");
            sb.append(ajaxScript.getErrScript());
            sb.append("\t\t\t}\n");
            sb.append("\t\t\t}\n");
            sb.append("\t\t};\n");
            sb.append("\t\thttpobj.send(sendData);\n");
            sb.append("\t}\n");
            sb.append("\t// -->\n");
        }
        return sb.toString();
    }
}

