/*
 * Decompiled with CFR 0.152.
 */
package jp.oarts.pirka.core.analyzer.html;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.TreeMap;
import jp.oarts.pirka.core.analyzer.html.HtmlSplitAnalyzer;
import jp.oarts.pirka.core.analyzer.html.HtmlTools;
import jp.oarts.pirka.core.general.HtmlParts;
import jp.oarts.pirka.core.general.HtmlPartsType;
import jp.oarts.pirka.core.kernel.PirkaThreadMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlIncludeAnalyzer
implements Serializable {
    private static final long serialVersionUID = -663258848497282089L;
    private static final String INCLUDE_START_STRING = "<!--#include";
    private static final String INCLUDE_END_STRING = "-->";
    private static final String DIR_STRING = "dir";
    private static final String PACKEGE_STRING = "packege";
    private static final String FILE_STRING = "file";
    private static final String HTML_FILE_SAFIX = ".html";

    public static String include(File file) throws IOException {
        HtmlIncludeAnalyzer myObject = new HtmlIncludeAnalyzer();
        return myObject.includeMain(file);
    }

    public static String include(String resourceName) throws IOException {
        HtmlIncludeAnalyzer myObject = new HtmlIncludeAnalyzer();
        return myObject.includeMain(resourceName);
    }

    private String includeMain(File file) throws IOException {
        return this.includeMain(new HtmlRealFile(file));
    }

    private String includeMain(String file) throws IOException {
        return this.includeMain(new HtmlResourceFile(file));
    }

    private String includeMain(HtmlFile htmlFile) throws IOException {
        Stack<HtmlFile> stack = new Stack<HtmlFile>();
        stack.push(htmlFile);
        StringBuilder sb = new StringBuilder();
        this.includeMain(sb, htmlFile, stack, true);
        return sb.toString();
    }

    private void includeMain(StringBuilder sb, HtmlFile file, Stack<HtmlFile> stack, boolean fullIncludeFlag) throws IOException {
        int index = 0;
        int indexNext = 0;
        String htmlStr = file.toFileImage();
        if (!fullIncludeFlag) {
            htmlStr = this.getBody(htmlStr);
        }
        while ((index = htmlStr.indexOf(INCLUDE_START_STRING, indexNext)) >= 0) {
            int indexCommentEnd;
            if (index > indexNext) {
                sb.append(htmlStr.substring(indexNext, index));
                indexNext = index;
            }
            if ((indexCommentEnd = htmlStr.indexOf(INCLUDE_END_STRING, index)) < 0) break;
            String comment = htmlStr.substring(indexNext, indexCommentEnd);
            indexNext = indexCommentEnd + INCLUDE_END_STRING.length();
            TreeMap<String, String> map = HtmlTools.getOptionMap(comment);
            String dir = (String)map.get(DIR_STRING);
            String packageName = (String)map.get(PACKEGE_STRING);
            String fileName = (String)map.get(FILE_STRING);
            if (dir == null || dir.length() <= 0 || packageName == null || packageName.length() <= 0 || fileName == null || fileName.length() <= 0) {
                throw new RuntimeException("HTML\u30d5\u30a1\u30a4\u30eb\u4e2d\u306e\u30a4\u30f3\u30af\u30eb\u30fc\u30c9\u306e\u66f8\u5f0f\u306b\u3042\u3084\u307e\u308a\u304c\u3042\u308a\u307e\u3059 " + comment);
            }
            HtmlFilePath filePath = new HtmlFilePath(dir, packageName, fileName);
            HtmlFile includeFile = file.createHtmlFile(filePath);
            if (stack.contains(includeFile)) {
                sb.append(comment);
                sb.append(INCLUDE_END_STRING);
                continue;
            }
            stack.push(includeFile);
            if (fileName != null && fileName.length() > HTML_FILE_SAFIX.length() && HTML_FILE_SAFIX.equalsIgnoreCase(fileName.substring(fileName.length() - HTML_FILE_SAFIX.length()))) {
                this.includeMain(sb, includeFile, stack, false);
            } else {
                this.includeMain(sb, includeFile, stack, true);
            }
            stack.pop();
        }
        if (indexNext < htmlStr.length()) {
            sb.append(htmlStr.substring(indexNext));
        }
    }

    protected String getBody(String htmlStr) throws IOException {
        StringReader r = null;
        try {
            List<HtmlParts> chaildList;
            r = new StringReader(htmlStr);
            ArrayList<HtmlParts> htmlPartsList = HtmlSplitAnalyzer.getHtmlParts(r);
            HtmlParts bodyParts = this.searchTag(htmlPartsList, "body");
            if (bodyParts != null && (chaildList = bodyParts.getChild()) != null) {
                String string = HtmlTools.makeHtmlString(chaildList);
                return string;
            }
            return "";
        }
        finally {
            if (r != null) {
                ((Reader)r).close();
            }
        }
    }

    protected HtmlParts searchTag(List<HtmlParts> htmlPartsList, String tagName) {
        tagName = tagName.toLowerCase();
        for (HtmlParts parts : htmlPartsList) {
            HtmlParts seachParts;
            if (parts.getType() != HtmlPartsType.TAG) continue;
            if (tagName.equalsIgnoreCase(parts.getTagName())) {
                return parts;
            }
            List<HtmlParts> chaildList = parts.getChild();
            if (chaildList == null || (seachParts = this.searchTag(chaildList, tagName)) == null) continue;
            return seachParts;
        }
        return null;
    }

    public int indexIgnoreCaseOf(String targetString, String searchString, int fromIndex) {
        if (targetString == null || targetString.equals("")) {
            return -1;
        }
        if (searchString == null || searchString.equals("")) {
            return -1;
        }
        if (targetString.length() - searchString.length() < 0) {
            return -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        searchString = searchString.toLowerCase();
        int len = targetString.length() - searchString.length();
        int index = fromIndex;
        while (index <= len) {
            if (Character.toLowerCase(targetString.charAt(index)) == searchString.charAt(0) && HtmlIncludeAnalyzer.loop(targetString, searchString, index)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    private static boolean loop(String targetString, String searchString, int index) {
        int j = 1;
        while (j < searchString.length()) {
            if (Character.toLowerCase(targetString.charAt(index + j)) != searchString.charAt(j)) {
                return false;
            }
            ++j;
        }
        return true;
    }

    public static void main(String[] args) {
        try {
            System.out.println("--- HTML\u30d5\u30a1\u30a4\u30eb\u30c6\u30b9\u30c8---------------------------");
            System.out.println(HtmlIncludeAnalyzer.include(new File("E:/Job/oa/make/pirka/test/include/test1.html")));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    class HtmlFilePath {
        public String dir;
        public String pakageName;
        public String fileNmae;

        public HtmlFilePath(String dir, String pakageName, String fileNmae) {
            this.dir = dir;
            this.pakageName = pakageName;
            this.fileNmae = fileNmae;
        }
    }

    static interface HtmlFile {
        public String toFileImage() throws IOException;

        public HtmlFile createHtmlFile(HtmlFilePath var1) throws IOException;
    }

    class HtmlRealFile
    implements HtmlFile {
        private File file;

        public HtmlRealFile(File file) throws IOException {
            this.file = file.getCanonicalFile();
        }

        public String toFileImage() throws IOException {
            byte[] buffer = new byte[4096];
            BufferedInputStream bis = null;
            ByteArrayOutputStream baos = null;
            try {
                int length;
                bis = new BufferedInputStream(new FileInputStream(this.file));
                baos = new ByteArrayOutputStream();
                while ((length = bis.read(buffer)) > 0) {
                    baos.write(buffer, 0, length);
                }
                baos.flush();
                String string = new String(baos.toByteArray());
                return string;
            }
            finally {
                if (baos != null) {
                    baos.close();
                }
                if (bis != null) {
                    bis.close();
                }
            }
        }

        public HtmlFile createHtmlFile(HtmlFilePath htmlFilePath) throws IOException {
            File newDir = new File(htmlFilePath.dir);
            File baseDir = null;
            baseDir = newDir.isAbsolute() ? newDir : new File(this.file.getParentFile(), htmlFilePath.dir);
            return new HtmlRealFile(new File(baseDir, htmlFilePath.fileNmae));
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof HtmlRealFile)) {
                return false;
            }
            return this.file.equals(((HtmlRealFile)object).file);
        }
    }

    class HtmlResourceFile
    implements HtmlFile {
        private String file;
        static /* synthetic */ Class class$0;

        public HtmlResourceFile(String file) {
            this.file = file;
        }

        public String toFileImage() throws IOException {
            byte[] buffer = new byte[4096];
            BufferedInputStream bis = null;
            ByteArrayOutputStream baos = null;
            try {
                int length;
                URL url = HtmlIncludeAnalyzer.class.getResource(this.file);
                if (url == null) {
                    throw new IOException("\u30ea\u30bd\u30fc\u30b9\u30d5\u30a1\u30a4\u30eb\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093 file=" + this.file);
                }
                bis = new BufferedInputStream(url.openStream());
                baos = new ByteArrayOutputStream();
                while ((length = bis.read(buffer)) > 0) {
                    baos.write(buffer, 0, length);
                }
                baos.flush();
                String string = new String(baos.toByteArray(), PirkaThreadMap.getEntryPointObjct().getResourceHtmlFileCharset());
                return string;
            }
            finally {
                if (baos != null) {
                    baos.close();
                }
                if (bis != null) {
                    bis.close();
                }
            }
        }

        public HtmlFile createHtmlFile(HtmlFilePath htmlFilePath) {
            return new HtmlResourceFile(htmlFilePath.fileNmae);
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof HtmlResourceFile)) {
                return false;
            }
            return this.file.equals(((HtmlResourceFile)object).file);
        }
    }
}

