package pencilbox.shikaku;

import java.util.LinkedList;
import java.util.List;

import javax.swing.event.UndoableEditEvent;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.util.ArrayUtil;


/**
 * ulpɐ؂vՖʃNX
 */
public class Board extends BoardBase {
	
	static final int UNDECIDED_NUMBER = -1;
	
	private int[][] number;
	private Square[][] square;
	private List<Square> squareList;

	protected void setup() {
		super.setup();
		number = new int[rows()][cols()];
		square = new Square[rows()][cols()];
		squareList = new LinkedList<Square>();
	}

	public void clearBoard() {
		super.clearBoard();
		squareList.clear();
		ArrayUtil.initArrayObject2(square, null);
	}

	/**
	 * @return the number
	 */
	int[][] getNumber() {
		return number;
	}

	public void initBoard() {
		initSquares();
	}

	/**
	 * Ֆʏ̗̈̏s
	 */
	public void initSquares() {
		for (Square sq : squareList) {
			initSquare1(sq);
		}
	}
	/**
	 * lpɐݒ肵C}XɎlpݒ肷
	 * @param sq ǉlp
	 */
	public void initSquare1(Square sq) {
		int n = 0;
		for (int r = sq.r0(); r <= sq.r1(); r++ ) {
			for (int c = sq.c0(); c <= sq.c1(); c++) {
				if (isNumber(r,c)) {
					if (n != 0)
						n = Square.MULTIPLE_NUMBER;
					else
						n = number[r][c];
				}
				square[r][c] = sq;
			}
		}
		sq.setNumber(n);
	}

	public void clearSquare1(Square sq) {
		for (int r = sq.r0(); r <= sq.r1(); r++ ) {
			for (int c = sq.c0(); c <= sq.c1(); c++) {
				square[r][c] = null;
			}
		}
	}
	
	/**
	 * @return Returns the squareList.
	 */
	List<Square> getSquareList() {
		return squareList;
	}

	/**
	 * }X̐擾
	 * @param r sW
	 * @param c W
	 * @return }X̐
	 */
	public int getNumber(int r, int c) {
		return number[r][c];
	}

	public int getNumber(Address pos) {
		return getNumber(pos.r(), pos.c());
	}
	/**
	 * }Xɐݒ肷
	 * @param r sW
	 * @param c W
	 * @param n ݒ肷鐔
	 */
	public void setNumber(int r, int c, int n) {
		number[r][c] = n;
	}

	public void setNumber(Address pos, int n) {
		setNumber(pos.r(), pos.c(), n);
	}
	/**
	 * ̃}Xɐ邩
	 * @param r sW
	 * @param c W
	 * @return@̃}Xɐ true
	 */
	public boolean isNumber(int r, int c) {
		return number[r][c] > 0 || number[r][c] == UNDECIDED_NUMBER;
	}
	/**
	 * ̃}X̑ Square Ԃ
	 * @param r sW
	 * @param c W
	 * @return@̃}X̑ Square
	 */
	public Square getSquare(int r, int c) {
		return square[r][c];
	}

	public void setSquare(int r, int c, Square s) {
		square[r][c] = s;
	}

	public Square getSquare(Address pos) {
		return square[pos.r()][pos.c()];
	}

	/**
	 * ̃}Xꂩ̎lpɊ܂܂Ă邩ǂ
	 * @param r sW
	 * @param c W
	 * @return ܂܂Ă true
	 */
	public boolean isCovered(int r, int c) {
		return square[r][c] != null;
	}

	/**
	 * lpǉCύXƂɂłɂ鑼̎lpƏdȂꍇC̎lpB
	 * @param sq ǉ,ύXlp
	 * @param org ύXꍇ̂Ƃ̎lp
	 */
	void removeOverlappedSquares(Square sq, Square org) {
		for (int r = sq.r0(); r <= sq.r1(); r++ ) {
			for (int c = sq.c0(); c <= sq.c1(); c++) {
				Square s = getSquare(r, c);
				if (s != null && s != org) {
					removeSquareA(s);
				}
			}
		}
	}
	
	/**
	 * lpǉ
	 * AhDXi[ɒʒm
	 * @param sq
	 */
	public void addSquareA(Square sq) {
		fireUndoableEditUpdate(new UndoableEditEvent(this, new Step(sq.r0(), sq.c0(), sq.r1(), sq.c1(), Step.ADDED)));
		addSquare(sq);
	}

	/**
	 * lpύX
	 * AhDXi[ɒʒm
	 * @param sq
	 * @param newSq
	 */
	public void changeSquareA(Square sq, Square newSq) {
		int rOld = -1;
		int cOld= -1;
		int rNew = -1;
		int cNew= -1;
		if (sq.r0() == newSq.r0()) {
			rOld = sq.r1();
			rNew = newSq.r1();
		} else if (sq.r1() == newSq.r0()) {
			rOld = sq.r0();
			rNew = newSq.r1();
		} else if (sq.r0() == newSq.r1()) {
			rOld = sq.r1();
			rNew = newSq.r0();
		} else if (sq.r1() == newSq.r1()) {
			rOld = sq.r0();
			rNew = newSq.r0();
		}
		if (sq.c0() == newSq.c0()) {
			cOld = sq.c1();
			cNew = newSq.c1();
		} else if (sq.c1() == newSq.c0()) {
			cOld = sq.c0();
			cNew = newSq.c1();
		} else if (sq.c0() == newSq.c1()) {
			cOld = sq.c1();
			cNew = newSq.c0();
		} else if (sq.c1() == newSq.c1()) {
			cOld = sq.c0();
			cNew = newSq.c0();
		}
		fireUndoableEditUpdate(new UndoableEditEvent(this, new Step(rOld, cOld, rNew, cNew, Step.CHANGED)));
		changeSquare(sq, newSq);
	}

	/**
	 * lp
	 * AhDXi[ɒʒm
	 * @param sq lp
	 */
	public void removeSquareA(Square sq) {
		fireUndoableEditUpdate(new UndoableEditEvent(this, new Step(sq.r0(), sq.c0(), sq.r1(), sq.c1(), Step.REMOVED)));
		removeSquare(sq);
	}
	
	/**
	 * lpǉ
	 * @param sq ǉlp
	 */
	public void addSquare(Square sq) {
		initSquare1(sq);
		squareList.add(sq);
	}

	/**
	 * Ww肵Ďlp쐬Ēǉ
	 * @param r0
	 * @param c0
	 * @param r1
	 * @param c1
	 */
	public void addSquare(int r0, int c0, int r1, int c1) {
		Square sq = new Square(r0, c0, r1, c1);
		addSquare(sq);
	}

	/**
	 * lp1̒_Œ肵܂܁C1̒_ύXB
	 * @param rOld
	 * @param cOld
	 * @param rNew
	 * @param cNew
	 */
	public void changeSquare(int rOld, int cOld, int rNew, int cNew) {
		Square sq = getSquare(rOld, cOld);
		clearSquare1(sq);
		sq.changeCorner(rOld, cOld, rNew, cNew);
		initSquare1(sq);
	}
	
	/**
	 * lpύX
	 * @param sq ύXlp
	 * @param newSq ύX̎lp̌`
	 */
	public void changeSquare(Square sq, Square newSq) {
		clearSquare1(sq);
		sq.set(newSq.r0(), newSq.c0(), newSq.r1(), newSq.c1());
		initSquare1(sq);
	}

	/**
	 * lp
	 * @param sq lp
	 */
	public void removeSquare(Square sq) {
		clearSquare1(sq);
		squareList.remove(sq);
	}

	/**
	 * lp
	 * @param r0
	 * @param c0
	 */
	public void removeSquare(int r0, int c0) {
		Square sq = getSquare(r0, c0);
		removeSquare(sq);
	}

	public int checkAnswerCode() {
		int errorCode = 0;
		int nNumber = 0;
		for (Square sq : squareList) {
			int n = sq.getNumber();
			if (n == Square.MULTIPLE_NUMBER) {
				errorCode |= 1; 
			} else if (n == Square.NO_NUMBER) {
				errorCode |= 2; 
			} else if (n == UNDECIDED_NUMBER) {
				;
			} else if (n < sq.getSquareSize()) {
				errorCode |= 4; 
			} else if (n > sq.getSquareSize()) {
				errorCode |= 8; 
			}
		}
		for (int r=0; r<rows(); r++) {
			for (int c=0; c<cols(); c++) {
				if (isNumber(r,c))
					nNumber ++;
					if (square[r][c] == null)
						errorCode |= 16; 
			}
		}
		if (nNumber==0)
			errorCode = 32; 
		return errorCode;
	}

	public String checkAnswerString() {
		int result = checkAnswerCode();
		if (result == 0)
			return COMPLETE_MESSAGE;
		if (result == 32)
			return "ՏɐЂƂȂ\n";
		StringBuffer message = new StringBuffer();
		if ((result & 1) == 1)
			message.append("̐܂ގlp\n");
		if ((result & 2) == 2)
			message.append("܂܂Ȃlp\n");
		if ((result & 4) == 4)
			message.append("ʐς𒴂lp\n");
		if ((result & 8) == 8)
			message.append("ʐςɖȂlp\n");
		if ((result & 16) == 16)
			message.append("lpɊ܂܂Ȃ}X\n");
		return message.toString();
	}
	
	/**
	 * P̑\NX
	 * UNDO, REDO ł̕ҏW̒PʂƂȂ
	 */
	class Step extends AbstractUndoableEdit {
		
		static final int ADDED = 1;
		static final int REMOVED = 0;
		static final int CHANGED = 2;
		
		private int r0;
		private int c0;
		private int r1;
		private int c1;
		private int operation;

		/**
		 * RXgN^
		 * @param sq ꂽ̈
		 * @param operation ̎ށFǉꂽ̂Cꂽ̂
		 */
		public Step(int r0, int c0, int r1, int c1, int operation) {
			super();
			this.r0 = r0;
			this.c0 = c0;
			this.r1 = r1;
			this.c1 = c1;
			this.operation = operation;
		}
		
		public void undo() throws CannotUndoException {
			super.undo();
			if (operation==ADDED) {
				removeSquare(r0, c0);
			} else if (operation==REMOVED) {
				addSquare(r0, c0, r1, c1);
			} else if (operation==CHANGED) {
				changeSquare(r1, c1, r0, c0);
			}
		}

		public void redo() throws CannotRedoException {
			super.redo();
			if (operation==ADDED) {
				addSquare(r0, c0, r1, c1);
			} else if (operation==REMOVED) {
				removeSquare(r0, c0);
			} else if (operation==CHANGED) {
				changeSquare(r0, c0, r1, c1);
			}
		}
	}

}