package pencilbox.kakuro;

import pencilbox.common.core.Direction;

/**
 * \rbgp^[ŕ\qg@\
 */
public class DigitPatternHint {

	private Board board;
	private int[][] horizPattern;
	private int[][] vertPattern;

	/**
	 * ̃}XɔzuĒڂ̃[ᔽɂȂȂ̃rbgp^[ԂB
	 * @param r@}X̍sW
	 * @param c }X̗W
	 * @return \ȃrbgp^[ԂB̃}Xǃ}Xł邩܂̓^eR̗Ƃa`ĂȂꍇ͒l 1 ԂB
	 */
	int getPattern(int r, int c) {
		int pat = horizPattern[r][c] & vertPattern[r][c];
		// ς̍ŉʃrbg 1 ł΃^eRƂ`ƂƂȂ̂ŁC\Ȃ߂ 1 ԂB
		// ^eRƂ`̏ꍇ 1`9@܂łׂĉ\Ƃhbg\ꍇ͈ȉ2s폜B
		if ((pat & 1) == 1)
			return 1;
		return pat;
	}
	
	void setupHint(Board board) {
		this.board = board;
		int rows = board.rows();
		int cols = board.cols();
		horizPattern = new int[rows][cols];
		vertPattern = new int[rows][cols];
	}

	/**
	 * ̍W̐ύXꂽƂɁC̃}X܂ރ^eRČvZ
	 * @param r
	 * @param c
	 */
	void updatePattern(int r, int c) {
		updatePattern(r, c, Direction.HORIZ);
		updatePattern(r, c, Direction.VERT);
	}
	
	/**
	 * W̃}X܂ރR܂̓^ẽ[h̔zu\p^[߂B
	 * @param r
	 * @param c
	 * @param dir
	 */
	void updatePattern(int r, int c, int dir) {
		int pattern = 0;
		int headPosition = board.getWordHead(r, c, dir);//̃}X܂ސ̘a}X̗W
		int wordSum = board.getWordSum(r, c, dir); // ̘a
		int wordSize = board.getWordSize(r, c, dir); //@}X
		int currentSum = 0;// ςݐ̘a
		int currentSize = 0; // ςݐ̐
		int usedDigit = 0;// gpςݐ̃p^[
		if (wordSum == 0) { // a`ĂȂ΂ׂĉ\
			pattern = HintTbl.D_ALL + 1;
		} else if (wordSize > 9) {
			pattern = 0;
		} else {
			for (int i = 0; i < wordSize; i++) {
				int n = 0;
				if (dir == Direction.HORIZ)
					n = board.getNumber(r, headPosition+1+i);
				else if (dir == Direction.VERT)
					n = board.getNumber(headPosition+1+i, c);
				if (n > 0) {
					currentSize++;
					currentSum += n; // aɉZ
					usedDigit |= (1 << n);//gpĂ鐔
				}
			}
			if (currentSize == wordSize) { // ׂČ܂Ă
				pattern = 0;
			} else {
				pattern = HintTbl.getRemainingDigit(wordSum - currentSum, wordSize - currentSize, usedDigit);
			}
		}
		for (int i = 0; i < wordSize; i++) {
			if (dir == Direction.HORIZ)
				horizPattern[r][headPosition+1+i] = pattern;
			else if (dir == Direction.VERT)
				vertPattern[headPosition+1+i][c] = pattern;
		}
	}

	/**
	 * ՖʑŜ̉\p^[ČvZ
	 */
	void initHint() {
		// SČvẐŁAS\Ƃ
		for (int r = 0; r < board.rows(); r++) {
			for (int c = 0; c < board.cols(); c++) {
				vertPattern[r][c] = HintTbl.D_ALL + 1;
				horizPattern[r][c] = HintTbl.D_ALL + 1;
			}
		}
		for (int r = 0; r < board.rows(); r++) {
			for (int c = 0; c < board.cols(); c++) {
				if (board.isWall(r, c)) {
					if (!board.isWall(r, c+1))
						if (board.getSumH(r,c) > 0) {
							updatePattern(r, c+1, Direction.HORIZ);
						}
					if (!board.isWall(r+1, c))
						if (board.getSumV(r,c) > 0) {
							updatePattern(r+1, c, Direction.VERT);
						}
				}
			}
		}
	}
}
