package pencilbox.common.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;

import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JColorChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

import pencilbox.common.factory.Constants;

/**
 * ʃj[NX
 */
public class MenuBase {

	private JMenu fileMenu;
	private JMenu editMenu;
	private JMenu viewMenu;
	private JMenu helpMenu;
	
	private JMenuItem newBoardItem;
	private JMenuItem openItem;
	private JMenuItem closeAndOpenItem;
	private JMenuItem saveItem;
	private JMenuItem duplicateItem;
	private JMenuItem changeBoardSizeItem;
	private JMenuItem exportProblemDataStringItem;
	private JMenuItem saveImageItem;
	private JMenuItem copyImageItem;
	private JMenuItem printItem;
	private JMenuItem propertyItem;
	private JMenuItem closeItem;
	private JMenuItem quitItem;
	private JMenuItem aboutItem;
	private JMenuItem clearItem;
	private JMenuItem trimAnswerItem;
	private JMenuItem symmetricPlacementItem;
	private JMenuItem undoItem;
	private JMenuItem redoItem;
//	private JMenuItem undoAllItem;
//	private JMenuItem redoAllItem;
	private JMenuItem palybackItem;
	private JMenuItem checkAnswerItem;
	private JMenuItem immediateAnswerCheckItem;
	private JMenuItem cellSizeItem;
	private JMenuItem indexItem;
	private JMenuItem gridStyleItem;
	private JMenuItem renewColorItem;
	private JMenuItem cursorItem;
	private ButtonGroup modeGroup;
	private JMenuItem problemEditModeItem;
	private JMenuItem answerModeItem;
	private JMenuItem regionEditModeItem;
	private JMenuItem loadPreferencesItem;
	private JMenuItem storePreferencesItem;

	private JMenu colorMenu;
	private JMenu rotationMenu;
	private JMenu markStyleMenu;
	private ButtonGroup markStyleGroup;
	
	private JMenuItem backgroundColorItem;
	private JMenuItem gridColorItem;

	private Frame frame;
	private MenuCommand command;
	private PanelBase panel;

	/**
	 * MenuNX̏ŁCMenuCX^XɎgp
	 * @param command ֘AtMenuCommand
	 * @param frame ֘AtFrame
	 * @param panel ֘AtPanel
	 */
	public void setup(MenuCommand command, Frame frame, PanelBase panel) {
		this.frame = frame;
		this.command = command;
		this.panel = panel;
		buildCommonMenu();
		setAccelerators();
	}

	/**
	 * @return Returns the panel.
	 */
	protected PanelBase getPanelBase() {
		return panel;
	}

	protected EventHandlerManager getEventHandlerManager() {
		return command.getEventHandlerManager();
	}

	/**
	 * ʃj[쐬B
	 */
	protected void buildCommonMenu() {
		buildFileMenu();
		buildEditMenu();
		buildViewMenu();
		buildHelpMenu();

		buildColorMenuIcon();

		JMenuBar jMenuBar = frame.getJMenuBar();
		jMenuBar.add(fileMenu);
		jMenuBar.add(editMenu);
		jMenuBar.add(viewMenu);
		jMenuBar.add(helpMenu);
	}

	/**
	 * [t@C]j[쐬
	 */
	protected void buildFileMenu() {
		fileMenu = makeJMenu("t@C(F)", 'F');
		fileMenu.add(newBoardItem = makeCommandMenuItem("VK쐬(N)...", 'N'));
		fileMenu.add(openItem = makeCommandMenuItem("J(O)...", 'O'));
		fileMenu.add(closeAndOpenItem = makeCommandMenuItem("ĊJ(L)...", 'L'));
		fileMenu.add(saveItem = makeCommandMenuItem("ۑ(S)...", 'S'));
		fileMenu.addSeparator();
		fileMenu.add(duplicateItem = makeCommandMenuItem("(D)", 'D'));
		fileMenu.add(rotationMenu = makeJMenu("]E](R)", 'R'));
		fileMenu.add(changeBoardSizeItem = makeCommandMenuItem("ՖʃTCYύX(Z)", 'Z'));
		buildRotationMenu();
		fileMenu.addSeparator();
		fileMenu.add(exportProblemDataStringItem = makeCommandMenuItem("f[^o(E)...", 'E'));
		fileMenu.add(saveImageItem = makeCommandMenuItem("摜ۑ(G)...", 'G'));
		fileMenu.add(copyImageItem = makeCommandMenuItem("摜Rs[(M)", 'M'));
		fileMenu.add(printItem = makeCommandMenuItem("(P)...", 'P'));
		fileMenu.addSeparator();
		fileMenu.add(loadPreferencesItem = makeCommandMenuItem("ݒǍ(F)...", 'F'));
		fileMenu.add(storePreferencesItem = makeCommandMenuItem("ݒۑ(T)...",'T'));
		fileMenu.addSeparator();
		fileMenu.add(propertyItem = makeCommandMenuItem("vpeB(I)", 'I'));
		fileMenu.addSeparator();
		fileMenu.add(closeItem = makeCommandMenuItem("(C)", 'C'));
		fileMenu.add(quitItem = makeCommandMenuItem("I(Q)", 'Q'));
	}

	/**
	 * [ҏW]j[쐬
	 */
	protected void buildEditMenu() {
		editMenu = makeJMenu("ҏW(E)", 'E');
		editMenu.add(answerModeItem = makeCommandRadioButtonMenuItem("𓚃[h(A)", 'A'));
		editMenu.add(problemEditModeItem = makeCommandRadioButtonMenuItem("̓[h(E)", 'E'));
		editMenu.add(regionEditModeItem = makeCommandRadioButtonMenuItem("̈ҏW[h(G)", 'G'));
		editMenu.addSeparator();
		editMenu.add(clearItem = makeCommandMenuItem("𓚏(C)", 'C'));
		if (trimAnswerItem != null) 
			editMenu.add(trimAnswerItem);  // ("⏕L(T)", 'T')
		if (symmetricPlacementItem != null) {
			editMenu.addSeparator();
			editMenu.add(symmetricPlacementItem); // ("Ώ̔zu(S)", 'S')
		}
		editMenu.addSeparator();
		editMenu.add(undoItem = makeCommandMenuItem("ɖ߂(U)", 'U'));
		editMenu.add(redoItem = makeCommandMenuItem("蒼(R)", 'R'));
		// editMenu.add(undoAllItem = makeCommandMenuItem("ŏ܂Ŗ߂(F)", 'F'));
		// editMenu.add(redoAllItem = makeCommandMenuItem("Ō܂Ői߂(L)", 'L'));
		editMenu.add(palybackItem = makeCommandMenuItem("Đ(P)", 'P'));
		editMenu.addSeparator();
		editMenu.add(checkAnswerItem = makeCommandMenuItem("𔻒(H)", 'H'));
		editMenu.add(immediateAnswerCheckItem = makeCheckBoxCommandMenuItem("𔻒(M)", 'M', false));

		modeGroup = new ButtonGroup();
		modeGroup.add(answerModeItem);
		modeGroup.add(problemEditModeItem);
		modeGroup.add(regionEditModeItem);
		editMenu.addMenuListener(new EditMenuListener());
	}

	/**
	 * [\]j[쐬
	 */
	protected void buildViewMenu() {
		viewMenu = makeJMenu("\(V)", 'V');
		viewMenu.add(colorMenu = makeJMenu("F̐ݒ(L)", 'L'));
		backgroundColorItem = addColorMenuItem("wi");
		gridColorItem = addColorMenuItem("r");
		viewMenu.add(cellSizeItem = makeCommandMenuItem("\TCY(S)...", 'S'));
		viewMenu.add(indexItem = makeCheckBoxCommandMenuItem("sԍ\(I)", 'I', false));
		viewMenu.add(gridStyleItem = makeCheckBoxCommandMenuItem("r\(G)", 'G', true));
		if (markStyleMenu != null)
			viewMenu.add(markStyleMenu);
		if (cursorItem != null)
			viewMenu.add(cursorItem);  // ("J[\(C)", 'C')
		viewMenu.addSeparator();
		viewMenu.addMenuListener(new ViewMenuListener());
	}

	/**
	 * J[j[̃ACRݒ肵܂
	 */
	protected void buildColorMenuIcon() {
		int count = colorMenu.getMenuComponentCount();
		for (int i = 0; i < count; ++i) {
			Component component = colorMenu.getMenuComponent(i);
			
			if (component instanceof JMenuItem) {
				JMenuItem item = (JMenuItem)component;
				Color color = getColor(item);
				if (color != null) {
					setColorIcon(item, color);
				}
			}
		}
	}
	
	/**
	 * j[ɃJ[ACRݒ肵܂
	 * 
	 * @param item j[
	 * @param color J[
	 */
	protected void setColorIcon(JMenuItem item, Color color) {

		Icon icon = item.getIcon();
		
		if (icon != null && icon instanceof ColorIcon && ((ColorIcon)icon).getColor().equals(color)) {
			return;
		}
		
		item.setIcon(new ColorIcon(color, Color.BLACK, item.getFont().getSize(), item.getFont().getSize()));
	}

	/**
	 * [wv]j[쐬
	 */
	protected void buildHelpMenu() {
		helpMenu = makeJMenu("wv(H)", 'H');
		helpMenu.add(aboutItem = makeCommandMenuItem(Constants.TITLE + "ɂ(A)", 'A'));
	}

	/**
	 * []E]]j[쐬
	 */
	protected void buildRotationMenu() {
		makeRotationItem("90](1)", '1', "1");
		makeRotationItem("180](2)", '2', "2");
		makeRotationItem("E90](3)", '3', "3");
		makeRotationItem("c(4)", '4', "4");
		makeRotationItem("E](5)", '5', "5");
		makeRotationItem("180]+c(6)", '6', "6");
		makeRotationItem("㉺](7)", '7', "7");
	}
	/**
	 * []E]]j[쐬
	 * iJbNpj
	 */
	protected void buildRotationMenu2() {
		makeRotationItem("c(4)", '4', "4");
	}

	/**
	 * }XmLX^Cj[쐬B
	 */
	protected void buildMarkStyleMenu(String text, char mnemonic, int[] styles) {
		markStyleMenu = makeJMenu(text, mnemonic);
		markStyleGroup = new ButtonGroup();
		for (int i = 1; i <= styles.length; i++) {
			switch (styles[i-1]) {
			case 0:
				makeMarkStyleItem(i + " \", (char)('0'+i), "0");
				break;
			case 1:
				makeMarkStyleItem(i + " ", (char)('0'+i), "1");
				break;
			case 2:
				makeMarkStyleItem(i+ " ", (char)('0'+i), "2");
				break;
			case 3:
				makeMarkStyleItem(i+ " ", (char)('0'+i), "3");
				break;
			case 4:
				makeMarkStyleItem(i + " ~", (char)('0'+i), "4");
				break;
			case 5:
				makeMarkStyleItem(i + " hԂ", (char)('0'+i), "5");
				break;
			}
		}
	}

	protected void addNoPaintMarkStyleMenu() {
		buildMarkStyleMenu("hȂ(N)", 'N', new int[] {1, 2, 3, 4, 5});
	}

	/**
	 * [ҏW]j[Xi[NX
	 */
	protected class EditMenuListener implements MenuListener {
		/*
		 * ҏWj[J^C~OŁC KvɉăAhDChDj[L^ɂ
		 * ̓[h'/'L[ɂCj[pɕύXł̂ŁCj[JƂɌ݂̏Ԃ𒲂ׂčXVB
		 */
		public void menuSelected(MenuEvent evt) {
			undoItem.setEnabled(command.canUndo());
			redoItem.setEnabled(command.canRedo());
			// undoAllItem.setEnabled(command.canUndo());
			// redoAllItem.setEnabled(command.canRedo());
			palybackItem.setEnabled(command.canUndo() || command.canRedo());

			int m = getPanelBase().getEditMode();
			if (m == PanelBase.ANSWER_INPUT_MODE) {
				answerModeItem.setSelected(true);
			} else if (m == PanelBase.PROBLEM_INPUT_MODE) {
				problemEditModeItem.setSelected(true);
			} else if (m == PanelBase.REGION_EDIT_MODE) {
				regionEditModeItem.setSelected(true);
			}
		}

		/*
		 * j[炷ׂėLɖ߂
		 */
		public void menuDeselected(MenuEvent evt) {
			undoItem.setEnabled(true);
			redoItem.setEnabled(true);
			// undoAllItem.setEnabled(true);
			// redoAllItem.setEnabled(true);
			palybackItem.setEnabled(true);
		}

		public void menuCanceled(MenuEvent evt) {
		}
	}

	/**
	 * V[gJbgL[̈ꊇݒ
	 */
	private void setAccelerators() {
		newBoardItem.setAccelerator(
				KeyStroke.getKeyStroke('N',	InputEvent.CTRL_MASK));
		openItem.setAccelerator(
				KeyStroke.getKeyStroke('O', InputEvent.CTRL_MASK));
		closeAndOpenItem.setAccelerator(
				KeyStroke.getKeyStroke('O', InputEvent.CTRL_MASK | InputEvent.SHIFT_MASK));
		saveItem.setAccelerator(
				KeyStroke.getKeyStroke('S', InputEvent.CTRL_MASK));
		closeItem.setAccelerator(
				KeyStroke.getKeyStroke('W', InputEvent.CTRL_MASK));
		undoItem.setAccelerator(
				KeyStroke.getKeyStroke('Z', InputEvent.CTRL_MASK));
		redoItem.setAccelerator(
				KeyStroke.getKeyStroke('Y', InputEvent.CTRL_MASK));
		answerModeItem.setAccelerator(
				KeyStroke.getKeyStroke(KeyEvent.VK_F2, 0));
		problemEditModeItem.setAccelerator(
				KeyStroke.getKeyStroke(KeyEvent.VK_F3, 0));
		regionEditModeItem.setAccelerator(
				KeyStroke.getKeyStroke(KeyEvent.VK_F4, 0));
		if (renewColorItem != null)
			renewColorItem.setAccelerator(
					KeyStroke.getKeyStroke(KeyEvent.VK_F6, 0));
	}

	/**
	 * [\]j[Xi[NX
	 */
	protected class ViewMenuListener implements MenuListener {

		public void menuSelected(MenuEvent evt) {
		}

		public void menuDeselected(MenuEvent evt) {
		}

		public void menuCanceled(MenuEvent evt) {
		}
	}

	/*
	 * ނ̃pYɕsKp̃j[̍폜sB
	 */
	/**
	 * [ՖʃTCYύX]j[ڂ폜B
	 */
	protected void removeChangeBoardSizeMenuItem() {
		fileMenu.remove(changeBoardSizeItem);
	}
	/*
	 * ނ̃pYɋʂȃj[̍쐬݂̂sB
	 * 쐬ڂ̓j[쐬ɒǉB
	 */
	/**
	 * [⏕L]j[ڂ쐬B
	 */
	protected void addTrimAnswerMenuItem() {
		trimAnswerItem = makeCommandMenuItem("⏕L(T)", 'T');
	}
	/**
	 * [Ώ̔zu]j[ڂ쐬B
	 */
	protected void addSymmetricPlacementMenuItem() {
		symmetricPlacementItem = makeCheckBoxCommandMenuItem("Ώ̔zu(S)", 'S', false);
	}
	/**
	 * [J[\]j[ڂ쐬B
	 */
	protected void addCursorMenuItem() {
		cursorItem = makeCheckBoxCommandMenuItem("J[\(C)", 'C', panel.isCursorMode());
	}
	/**
	 * [F̍XV]j[ڂ쐬C[F̐ݒ]j[ɒǉB
	 */
	protected void addRenewColorMenuItem() {
		renewColorItem = makeCommandMenuItem("F̍XV(U)", 'U');
		colorMenu.add(renewColorItem);
	}

	/**
	 * w肵j[ڂ[\]j[ɒǉB
	 * @param item ǉ郁j[
	 */
	protected void addToViewMenu(JMenuItem item) {
		viewMenu.add(item);
	}

	/**
	 * u]E]vj[̃Tuj[ڂ쐬CO[vɒǉB
	 * ]ԍp[^Ƃăj[ڂ action command ɐݒ肷B
	 * @param text j[\
	 * @param mnemonic
	 * @param n ݒ肷]ԍ
	 * @return 쐬j[
	 */
	protected JMenuItem makeRotationItem(String text, char mnemonic, String n) {
		JMenuItem rotationItem = new JMenuItem(text, mnemonic);
		rotationItem.addActionListener(rotationCommandAction);
		rotationItem.setActionCommand(n);
		rotationMenu.add(rotationItem);
		return rotationItem;
	}

	/**
	 * ]R}hB 
	 * j[ڂ action command ]ԍǂݎĎsB
	 */
	private ActionListener rotationCommandAction = new ActionListener() {
		public void actionPerformed(ActionEvent e) {
			JMenuItem target = (JMenuItem) e.getSource();
			command.rotateBoard(Integer.parseInt(target.getActionCommand()));
			panel.repaint();
		}
	};

	/**
	 * u}XmLX^CIṽTuj[ڂ쐬CO[vɒǉB
	 * @param text j[\
	 * @param n X^Cԍ
	 * @return 쐬j[
	 */
	protected JRadioButtonMenuItem makeMarkStyleItem(String text, char mnemonic, String n) {
		JRadioButtonMenuItem markStyleItem = new JRadioButtonMenuItem(text);
		markStyleItem.setMnemonic(mnemonic);
		markStyleItem.addActionListener(markStyleAction);
		markStyleItem.setActionCommand(n);
		markStyleGroup.add(markStyleItem);
		markStyleMenu.add(markStyleItem);
		return markStyleItem;
	}
	
	private ActionListener markStyleAction = new ActionListener() {
		public void actionPerformed(ActionEvent e) {
			JMenuItem target = (JMenuItem) e.getSource();
			panel.setMarkStyle(Integer.parseInt(target.getActionCommand()));
			panel.repaint();
		}
	};
	
	/**
	 * FIj[쐬p⏕\bh
	 * j[ڂ쐬āC[F̑I]j[ɒǉB
	 * @param text j[\
	 * @return 쐬FIpj[
	 */
	protected JMenuItem addColorMenuItem(final String text) {
		JMenuItem item = new JMenuItem(text);
		item.addActionListener(changeColorAction);
		colorMenu.add(item);
		return item;
	}

	/**
	 * FݒR}hB 
	 */
	private ActionListener changeColorAction = new ActionListener() {
		public void actionPerformed(ActionEvent e) {
			JMenuItem item = (JMenuItem) e.getSource();
			// ǂ̃j[ڂIꂽɂāCǂ̐FύX邩̏Ō肷B
			Color color = JColorChooser.showDialog(panel, e.getActionCommand(), getColor(item));
			if (color != null) {
				setColor(item, color);
				setColorIcon(item, color);
			}
			panel.repaint();
		}
	};

	/**
	 * j[ڂɑΉF擾 g͊eTuNXƂɎB
	 * @param target Iꂽj[
	 * @return 擾F
	 */
	public Color getColor(JMenuItem target) {
		if (target == backgroundColorItem)
			return getPanelBase().getBackgroundColor();
		else if (target == gridColorItem)
			return getPanelBase().getGridColor();
		else
			return null;
	}

	/**
	 * j[ڂɑΉF擾 g͊eTuNXƂɎB
	 * @param target Iꂽj[
	 * @param color ݒ肷F
	 */
	public void setColor(JMenuItem target, Color color) {
		if (target == backgroundColorItem)
			getPanelBase().setBackgroundColor(color);
		else if (target == gridColorItem)
			getPanelBase().setGridColor(color);
	}

	/**
	 * j[sR}hB 
	 */
	private ActionListener commandAction = new ActionListener() {
		public void actionPerformed(ActionEvent e) {
			executeCommand((JMenuItem) e.getSource());
		}
	};

	/**
	 * ǂ̃j[IꂽׂāCΉR}hNB
	 * sCPanelĕ`悷B
	 * @param target Iꂽj[
	 */
	public void executeCommand(JMenuItem target) {
		if (target == newBoardItem)
			command.newBoard();
		else if (target == openItem)
			command.open();
		else if (target == closeAndOpenItem)
			command.closeAndOpen();
		else if (target == saveItem)
			command.save();
		else if (target == duplicateItem)
			command.duplicate();
		else if (target == changeBoardSizeItem)
			command.changeBoardSize();
		else if (target == exportProblemDataStringItem)
			command.exportProblemDataString();
		else if (target == saveImageItem)
			command.saveImage();
		else if (target == copyImageItem)
			command.copyImage();
		else if (target == printItem)
			command.print();
		else if (target == loadPreferencesItem) {
			command.loadPreferences();
			this.updateCurrentMenuSelection();
		}
		else if (target == storePreferencesItem)
			command.storePreferences();
		else if (target == propertyItem)
			command.property();
		else if (target == closeItem)
			command.close();
		else if (target == quitItem)
			command.quit();
		else if (target == aboutItem)
			command.about();
		else if (target == clearItem)
			command.clear();
		else if (target == trimAnswerItem)
			command.trimAnswer();
		else if (target == symmetricPlacementItem)
			command.setSymmetricPlacementMode(target.isSelected());
		else if (target == undoItem)
			command.undo();
		else if (target == redoItem)
			command.redo();
//		else if (target == undoAllItem)
//			command.undoAll();
//		else if (target == redoAllItem)
//			command.redoAll();
		else if (target == palybackItem)
			command.playback();
		else if (target == checkAnswerItem)
			command.checkAnswer();
		else if (target == immediateAnswerCheckItem)
			command.setImmediateAnswerCheckMode(target.isSelected());
		else if (target == renewColorItem)
			command.renewColor();
		else if (target == cursorItem)
			command.setCursorMode(target.isSelected());
		else if (target == answerModeItem)
			command.setEditMode(PanelBase.ANSWER_INPUT_MODE);
		else if (target == problemEditModeItem)
			command.setEditMode(PanelBase.PROBLEM_INPUT_MODE);
		else if (target == regionEditModeItem)
			command.setEditMode(PanelBase.REGION_EDIT_MODE);
		else if (target == indexItem)
			command.setIndexMode(target.isSelected());
		else if (target == gridStyleItem)
			command.setGridStyle(target.isSelected());
		else if (target == cellSizeItem)
			command.cellSize();
		else
			executeCommand2(target);
		panel.repaint();
	}
	/**
	 * ǂ̃j[IꂽׂāCΉR}hNB
	 * eTuNXŃI[o[ChB
	 * @param target Iꂽj[
	 */
	public void executeCommand2(JMenuItem target) {
	}

	/**
	 * CommandActionj[ڂ쐬
	 * @param title j[ڕ\eLXg
	 * @param mnumonic V[gJbg
	 * @return 쐬j[
	 */
	protected JMenuItem makeCommandMenuItem(String title, char mnumonic) {
		JMenuItem item = makeJMenuItem(title, mnumonic);
		item.addActionListener(commandAction);
		return item;
	}

	/**
	 * CommandActionWI{^j[ڂ쐬
	 * @param title j[ڕ\eLXg
	 * @param mnumonic V[gJbg
	 * @return 쐬j[
	 */
	protected JMenuItem makeCommandRadioButtonMenuItem(String title,
			char mnumonic) {
		JMenuItem item = makeJRadioButtonMenuItem(title, mnumonic);
		item.addActionListener(commandAction);
		return item;
	}

	/**
	 * CommandAction`FbN{bNXj[ڂ쐬
	 * @param title j[ڕ\eLXg
	 * @param mnumonic V[gJbg
	 * @param initial I
	 * @return 쐬j[
	 */
	protected JCheckBoxMenuItem makeCheckBoxCommandMenuItem(String title,
			char mnumonic, boolean initial) {
		JCheckBoxMenuItem item = makeJCheckBoxMenuItem(title, mnumonic, initial);
		item.addActionListener(commandAction);
		return item;
	}

	/**
	 * ݂̐ݒɍ킹ăj[ڂ̑IԂXVB
	 */
	public void updateCurrentMenuSelection() {
		indexItem.setSelected(getPanelBase().isIndexMode());
		gridStyleItem.setSelected(getPanelBase().getGridStyle() > 0);
		if (cursorItem != null)
			cursorItem.setSelected(getPanelBase().isCursorMode());
		if (symmetricPlacementItem != null)
			symmetricPlacementItem.setSelected(getEventHandlerManager().isSymmetricPlacementMode());
		if (immediateAnswerCheckItem != null)
			immediateAnswerCheckItem.setSelected(getEventHandlerManager().isImmediateAnswerCheckMode());
		if (markStyleMenu != null) {
			int s = getPanelBase().getMarkStyle();
			for (int i = 0, count = markStyleMenu.getItemCount(); i < count; i++) {
				JRadioButtonMenuItem item = (JRadioButtonMenuItem) markStyleMenu.getItem(i);
				if (Integer.parseInt(item.getActionCommand()) == s) {
					item.setSelected(true);
					break;
				}
			}
		}
		buildColorMenuIcon();
	}

	/*
	 * ȉCj[쐬p⏕\bh
	 */
	/**
	 * JMenu 쐬p\bh
	 * @param text j[̕
	 * @param mnemonic
	 * @return 쐬JMenuItem
	 */
	public JMenu makeJMenu(String text, char mnemonic) {
		JMenu menu = new JMenu(text);
		menu.setMnemonic(mnemonic);
		return menu;
	}

	/**
	 * JMenuItem 쐬p\bh
	 * @param text j[̕
	 * @param mnemonic
	 * @return 쐬JMenuItem
	 */
	public JMenuItem makeJMenuItem(String text, char mnemonic) {
		return new JMenuItem(text, mnemonic);
	}

	/**
	 * JRadioButtonMenuItem 쐬p\bh
	 * @param text j[̕
	 * @param mnemonic
	 * @return 쐬j[
	 */
	public JMenuItem makeJRadioButtonMenuItem(String text, char mnemonic) {
		JMenuItem item = new JRadioButtonMenuItem(text);
		item.setMnemonic(mnemonic);
		return item;
	}

	/**
	 * JCheckBoxMenuItem 쐬p\bh
	 * @param text j[̕
	 * @param mnemonic V[gJbgL[
	 * @param initial l
	 * @return 쐬JMenuItem
	 */
	public JCheckBoxMenuItem makeJCheckBoxMenuItem(String text, char mnemonic,
			boolean initial) {
		JCheckBoxMenuItem item = new JCheckBoxMenuItem(text);
		item.setMnemonic(mnemonic);
		item.setSelected(initial);
		return item;
	}

}
