<?php

/* -------------------------------------------------------------------------
	Simple Image Transformaer
	a part of PC2M Webpage Converter for Mobile Clients
	Copyright (C) 2005 ucb@rcdtokyo.com http://www.rcdtokyo.com/pc2m/note/
------------------------------------------------------------------------- */

// must have seven args
$args = explode(',', $_SERVER['QUERY_STRING']);
if (count($args) != 7) {
	exit('The request is invalid.');
}

// if any arg is null
foreach ($args as $value) {
	if ($value == NULL) {
		exit('The request is invalid.');
	}
}

$args[6] = urldecode($args[6]);
if (
	// if destination size exceeds 999 x 999
	!preg_match('/^\d{2,6}$/', $args[0].$args[1])
	// if source size exceeds 9999 x 9999
	or !preg_match('/^\d{2,8}$/', $args[3].$args[4])
	// image format must be 1-3
	or !preg_match('/^[1-3][1-3]$/', $args[2].$args[5])
	// if source URI does not start with HTTP
	or !preg_match('/^https?:\/\/\w/', $args[6])
	) {
	exit('The request is invalid.');
}

imageResize(
	$args[0],
	$args[1],
	$args[2],
	$args[3],
	$args[4],
	$args[5],
	$args[6]
);

/* ----------------------------------------------------------------------
	imageResize
	returns image binary unless the source is not accessible
---------------------------------------------------------------------- */

function imageResize(
	$_new_width,
	$_new_height,
	$_new_type,
	$_original_width,
	$_original_height,
	$_original_type,
	$_remote_url) {

	ini_set('allow_url_fopen', '1');

	switch ($_original_type) {
		case 1:
			$_original_image = @imageCreateFromGIF($_remote_url);
			break;
		case 2:
			$_original_image = @imageCreateFromJPEG($_remote_url);
			break;
		case 3:
			$_original_image = @imageCreateFromPNG($_remote_url);
	}

	if (!$_original_image) {
		exit('Failed loading '.$_remote_url);
	} else {
		$_new_image = imageCreateTrueColor($_new_width, $_new_height);

		// Fill background white in case of transparenct GIF or PNG
		if ($_original_type != 2) {
			$color = imageColorAllocate($_new_image, 255, 255, 255);
			imagefill($_new_image, 0, 0, $color);
		}
		imageCopyResampled(
			$_new_image, $_original_image,
			0, 0, 0, 0,
			$_new_width, $_new_height,
			$_original_width, $_original_height
		);

		// Palettize the image if the destination is GIF or PNG
		if ($_new_type != 2) {

			// If the source is GIF or PNG
			if ($_original_type != 2) {

				// Dither by 32 colors if the source palette contains less colors
				//if (imageColorsTotal($_original_image) < 32) {
				//	imageTrueColorToPalette($_new_image, false, 32);

				// Otherwise dither by 256 colors and then copy the source palette
				//} else {
					imageTrueColorToPalette($_new_image, false, 256);
					imagePaletteCopy($_new_image, $_original_image);
				//}

			// Or dither by 128 colors if the source is JPEG
			} else {
				imageTrueColorToPalette($_new_image, true, 128);
			}
		}

		switch ($_new_type) {
			case 1:
				header("Content-Type:image/gif");
				imageGIF($_new_image);
				break;

			case 2:
				header("Content-Type:image/jpeg");
				imageJPEG($_new_image, '', 50);
				break;

			case 3:
				header("Content-Type:image/png");
				imagePNG($_new_image);
		}

		imageDestroy($_original_image);
		imageDestroy($_new_image);
	}
}

?>