/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.objectstorage.services.aspera.transfer.internal;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.ibm.cloud.objectstorage.event.ProgressListener;
import com.ibm.cloud.objectstorage.services.aspera.transfer.AsperaConfig;
import com.ibm.cloud.objectstorage.services.aspera.transfer.AsperaTransaction;
import com.ibm.cloud.objectstorage.services.aspera.transfer.AsperaTransferManager;
import com.ibm.cloud.objectstorage.services.aspera.transfer.TransferSpecs;
import com.ibm.cloud.objectstorage.services.s3.model.FASPConnectionInfo;
import java.io.File;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;

public class AsperaUploadCallable
implements Callable<AsperaTransaction> {
    private AsperaTransferManager transferManager;
    private CountDownLatch latch;
    private String bucket;
    private File localFileName;
    private String remoteFileName;
    private AsperaConfig sessionDetails;
    private ProgressListener progressListener;

    public AsperaUploadCallable(AsperaTransferManager transferManager, String bucket, File localFileName, String remoteFileName, AsperaConfig sessionDetails, ProgressListener progressListener) {
        this.transferManager = transferManager;
        this.bucket = bucket;
        this.localFileName = localFileName;
        this.remoteFileName = remoteFileName;
        this.sessionDetails = sessionDetails;
        this.progressListener = progressListener;
    }

    @Override
    public AsperaTransaction call() throws Exception {
        FASPConnectionInfo faspConnectionInfo = this.transferManager.getFaspConnectionInfo(this.bucket);
        TransferSpecs transferSpecs = this.transferManager.getTransferSpec(faspConnectionInfo, this.localFileName.getAbsolutePath(), this.remoteFileName, "upload");
        this.transferManager.checkMultiSessionAllGlobalConfig(transferSpecs);
        if (this.sessionDetails != null) {
            this.transferManager.modifyTransferSpec(this.sessionDetails, transferSpecs);
        }
        ObjectMapper mapper = new ObjectMapper();
        String transferSpecStr = null;
        try {
            transferSpecStr = mapper.writeValueAsString((Object)transferSpecs);
        }
        catch (JsonProcessingException e1) {
            e1.printStackTrace();
        }
        AsperaTransaction asperaTransaction = this.transferManager.processTransfer(transferSpecStr, this.bucket, this.remoteFileName, this.localFileName.getAbsolutePath(), this.progressListener);
        return asperaTransaction;
    }
}

