/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.objectstorage.http.apache.client.impl;

import com.ibm.cloud.objectstorage.http.AmazonHttpClient;
import com.ibm.cloud.objectstorage.http.IdleConnectionReaper;
import com.ibm.cloud.objectstorage.http.apache.SdkProxyRoutePlanner;
import com.ibm.cloud.objectstorage.http.apache.client.impl.ApacheConnectionManagerFactory;
import com.ibm.cloud.objectstorage.http.apache.client.impl.CRC32ChecksumResponseInterceptor;
import com.ibm.cloud.objectstorage.http.apache.client.impl.ConnectionManagerAwareHttpClient;
import com.ibm.cloud.objectstorage.http.apache.client.impl.SdkHttpClient;
import com.ibm.cloud.objectstorage.http.apache.utils.ApacheUtils;
import com.ibm.cloud.objectstorage.http.client.ConnectionManagerFactory;
import com.ibm.cloud.objectstorage.http.client.HttpClientFactory;
import com.ibm.cloud.objectstorage.http.conn.ClientConnectionManagerFactory;
import com.ibm.cloud.objectstorage.http.conn.SdkConnectionKeepAliveStrategy;
import com.ibm.cloud.objectstorage.http.protocol.SdkHttpRequestExecutor;
import com.ibm.cloud.objectstorage.http.settings.HttpClientSettings;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.protocol.HttpRequestExecutor;

public class ApacheHttpClientFactory
implements HttpClientFactory<ConnectionManagerAwareHttpClient> {
    private static final Log LOG = LogFactory.getLog(AmazonHttpClient.class);
    private final ConnectionManagerFactory<HttpClientConnectionManager> cmFactory = new ApacheConnectionManagerFactory();

    @Override
    public ConnectionManagerAwareHttpClient create(HttpClientSettings settings) {
        HttpClientBuilder builder = HttpClients.custom();
        HttpClientConnectionManager cm = this.cmFactory.create(settings);
        builder.setRequestExecutor((HttpRequestExecutor)new SdkHttpRequestExecutor()).setKeepAliveStrategy(this.buildKeepAliveStrategy(settings)).disableRedirectHandling().disableAutomaticRetries().setConnectionManager(ClientConnectionManagerFactory.wrap(cm));
        if (!settings.useGzip()) {
            builder.disableContentCompression();
        }
        CRC32ChecksumResponseInterceptor itcp = new CRC32ChecksumResponseInterceptor();
        if (settings.calculateCRC32FromCompressedData()) {
            builder.addInterceptorFirst((HttpResponseInterceptor)itcp);
        } else {
            builder.addInterceptorLast((HttpResponseInterceptor)itcp);
        }
        this.addProxyConfig(builder, settings);
        SdkHttpClient httpClient = new SdkHttpClient((HttpClient)builder.build(), cm);
        if (settings.useReaper()) {
            IdleConnectionReaper.registerConnectionManager(cm, settings.getMaxIdleConnectionTime());
        }
        return httpClient;
    }

    private void addProxyConfig(HttpClientBuilder builder, HttpClientSettings settings) {
        if (settings.isProxyEnabled()) {
            LOG.info((Object)("Configuring Proxy. Proxy Host: " + settings.getProxyHost() + " Proxy Port: " + settings.getProxyPort()));
            builder.setRoutePlanner((HttpRoutePlanner)new SdkProxyRoutePlanner(settings.getProxyHost(), settings.getProxyPort(), settings.getNonProxyHosts()));
            if (settings.isAuthenticatedProxy()) {
                builder.setDefaultCredentialsProvider(ApacheUtils.newProxyCredentialsProvider(settings));
            }
        }
    }

    private ConnectionKeepAliveStrategy buildKeepAliveStrategy(HttpClientSettings settings) {
        return settings.getMaxIdleConnectionTime() > 0L ? new SdkConnectionKeepAliveStrategy(settings.getMaxIdleConnectionTime()) : null;
    }
}

