/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.objectstorage.auth.json;

import com.ibm.cloud.objectstorage.auth.AWSCredentials;
import com.ibm.cloud.objectstorage.auth.AWSCredentialsProvider;
import com.ibm.cloud.objectstorage.auth.json.JsonConfigFile;
import java.util.concurrent.Semaphore;

public class JsonCredentialsProvider
implements AWSCredentialsProvider {
    private static final long DEFAULT_REFRESH_INTERVAL_NANOS = 300000000000L;
    private static final long DEFAULT_FORCE_RELOAD_INTERVAL_NANOS = 600000000000L;
    private volatile JsonConfigFile jsonConfigFile;
    private volatile long lastRefreshed;
    private final Semaphore refreshSemaphore = new Semaphore(1);
    private long refreshIntervalNanos = 300000000000L;
    private long refreshForceIntervalNanos = 600000000000L;

    public JsonCredentialsProvider() {
        this((JsonConfigFile)null);
    }

    public JsonCredentialsProvider(String jsonConfigFilePath) {
        this(new JsonConfigFile(jsonConfigFilePath));
    }

    public JsonCredentialsProvider(JsonConfigFile jsonConfigFile) {
        this.jsonConfigFile = jsonConfigFile;
        if (this.jsonConfigFile != null) {
            this.lastRefreshed = System.nanoTime();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AWSCredentials getCredentials() {
        long now;
        long age;
        if (this.jsonConfigFile == null) {
            JsonCredentialsProvider jsonCredentialsProvider = this;
            synchronized (jsonCredentialsProvider) {
                if (this.jsonConfigFile == null) {
                    this.jsonConfigFile = new JsonConfigFile();
                    this.lastRefreshed = System.nanoTime();
                }
            }
        }
        if ((age = (now = System.nanoTime()) - this.lastRefreshed) > this.refreshForceIntervalNanos) {
            this.refresh();
        } else if (age > this.refreshIntervalNanos && this.refreshSemaphore.tryAcquire()) {
            try {
                this.refresh();
            }
            finally {
                this.refreshSemaphore.release();
            }
        }
        return this.jsonConfigFile.getCredentials();
    }

    @Override
    public void refresh() {
        if (this.jsonConfigFile != null) {
            this.jsonConfigFile.refresh();
            this.lastRefreshed = System.nanoTime();
        }
    }

    public long getRefreshIntervalNanos() {
        return this.refreshIntervalNanos;
    }

    public void setRefreshIntervalNanos(long refreshIntervalNanos) {
        this.refreshIntervalNanos = refreshIntervalNanos;
    }

    public long getRefreshForceIntervalNanos() {
        return this.refreshForceIntervalNanos;
    }

    public void setRefreshForceIntervalNanos(long refreshForceIntervalNanos) {
        this.refreshForceIntervalNanos = refreshForceIntervalNanos;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

