/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudstorage.api.put;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ReadAwareInputStream
extends FilterInputStream {
    private long count = 0L;
    private boolean read = false;

    public ReadAwareInputStream(InputStream in) {
        super(in);
    }

    public final boolean hasBeenRead() {
        return this.read;
    }

    @Override
    public void close() throws IOException {
        if (this.read) {
            this.in.close();
        }
    }

    @Override
    public int read() throws IOException {
        this.read = true;
        int r = this.in.read();
        if (r >= 0) {
            ++this.count;
        }
        return r;
    }

    @Override
    public int read(byte[] b) throws IOException {
        this.read = true;
        int r = this.in.read(b);
        if (r > 0) {
            this.count += (long)r;
        }
        return r;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.read = true;
        int r = this.in.read(b, off, len);
        if (r > 0) {
            this.count += (long)r;
        }
        return r;
    }

    public final long getNumberOfBytesRead() {
        return this.count;
    }

    @Override
    public synchronized void reset() throws IOException {
        if (this.read) {
            this.count = 0L;
            this.read = false;
            this.in.reset();
        }
    }
}

