/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.storage.internal;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientHandler;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.client.urlconnection.HttpURLConnectionFactory;
import com.sun.jersey.client.urlconnection.URLConnectionClientHandler;
import com.sun.jersey.multipart.MultiPart;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.xml.bind.DatatypeConverter;
import oracle.cloud.storage.CloudStorage;
import oracle.cloud.storage.CloudStorageConfig;
import oracle.cloud.storage.exception.AccessDeniedException;
import oracle.cloud.storage.exception.AuthenticationException;
import oracle.cloud.storage.exception.CloudException;
import oracle.cloud.storage.exception.ContainerNotEmptyException;
import oracle.cloud.storage.exception.ExceptionUtil;
import oracle.cloud.storage.exception.InvalidContainerNameException;
import oracle.cloud.storage.exception.NoSuchContainerException;
import oracle.cloud.storage.exception.NoSuchObjectException;
import oracle.cloud.storage.exception.SystemException;
import oracle.cloud.storage.filters.HeaderOnlyLogger;
import oracle.cloud.storage.filters.StreamLogger;
import oracle.cloud.storage.internal.BasicAuthenticationProvider;
import oracle.cloud.storage.model.AclType;
import oracle.cloud.storage.model.Container;
import oracle.cloud.storage.model.ContentRange;
import oracle.cloud.storage.model.Key;
import oracle.cloud.storage.model.QueryOption;
import oracle.cloud.storage.model.QueryResult;
import oracle.cloud.storage.model.StorageInputMultistream;
import oracle.cloud.storage.model.StorageInputStream;
import oracle.cloud.storage.nls.ClientMessage;
import oracle.cloud.storage.spi.CloudStorageAuthenticationProvider;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class CloudStorageImpl
implements CloudStorage {
    private static final String API_VERSION = "v1";
    private static final int DEFAULT_CHUNK_SIZE = 2048;
    private static final String FULL_LOGGER = "full";
    private static final String HEADER_LOGGER = "headers";
    private static final String X_CONTAINER_META = "X-Container-Meta-";
    protected static final String X_OBJECT_META = "X-Object-Meta-";
    private static final String X_OBJECT_MANIFEST = "X-Object-Manifest";
    protected static final String ENVELOPE_KEY1 = "EnvelopeKey1";
    protected static final String ENVELOPE_KEY2 = "EnvelopeKey2";
    protected static final String DIGEST_KEY1 = "DigestKey1";
    protected static final String DIGEST_KEY2 = "DigestKey2";
    protected static final String DIGEST = "Digest";
    private static final int MAX_CONTAINER_NAME_LENGTH = 255;
    protected final Client client;
    protected final CloudStorageConfig config;

    public CloudStorageImpl(CloudStorageConfig config) {
        int readTimeout;
        int timeout;
        int chunkSize;
        String addFilter;
        this.config = config;
        if (config != null && config.getHttpProxyUri() != null && !config.getHttpProxyUri().isEmpty()) {
            URI proxyUri;
            try {
                proxyUri = new URI(config.getHttpProxyUri());
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("Illegal proxy URI. " + e.getMessage());
            }
            final Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyUri.getHost(), proxyUri.getPort()));
            this.client = new Client((ClientHandler)new URLConnectionClientHandler(new HttpURLConnectionFactory(){

                public HttpURLConnection getHttpURLConnection(URL url) throws IOException {
                    return (HttpURLConnection)url.openConnection(proxy);
                }
            }));
        } else {
            this.client = Client.create();
        }
        this.client.setChunkedEncodingSize(Integer.valueOf(2048));
        String authenticatorClass = BasicAuthenticationProvider.class.getName();
        if (config.getAuthProvider() != null) {
            authenticatorClass = config.getAuthProvider();
        }
        if ((addFilter = config.getLogFilter()) != null) {
            if (addFilter.equalsIgnoreCase(FULL_LOGGER)) {
                this.client.addFilter((ClientFilter)new StreamLogger());
            } else if (addFilter.equalsIgnoreCase(HEADER_LOGGER)) {
                this.client.addFilter((ClientFilter)new HeaderOnlyLogger());
            }
        }
        if ((chunkSize = config.getChunkSize()) != -1) {
            this.client.setChunkedEncodingSize(Integer.valueOf(chunkSize));
        }
        if ((timeout = config.getConnectTimeout()) != -1) {
            this.client.setConnectTimeout(Integer.valueOf(timeout));
        }
        if ((readTimeout = config.getReadTimeout()) != -1) {
            this.client.setReadTimeout(Integer.valueOf(readTimeout));
        }
        CloudStorageAuthenticationProvider authProvider = this.loadAuthenticator(authenticatorClass);
        authProvider.authenticate(this.client, config);
        this.validateAccount();
    }

    private Client getClient() {
        return this.client;
    }

    private String getServiceUrl() {
        return this.config.getServiceUrl().toExternalForm();
    }

    private CloudStorageAuthenticationProvider loadAuthenticator(String className) {
        try {
            Class<?> a = this.getClass().getClassLoader().loadClass(className);
            return (CloudStorageAuthenticationProvider)a.newInstance();
        }
        catch (InstantiationException e) {
            throw new SystemException(ClientMessage.systemError(), e);
        }
        catch (IllegalAccessException e) {
            throw new SystemException(ClientMessage.systemError(), e);
        }
        catch (ClassNotFoundException e) {
            throw new SystemException(ClientMessage.systemError(), e);
        }
    }

    private UriBuilder getUriBase() {
        String acc = this.config.getServiceName();
        String prefix = this.config.getServicePrefix();
        if (prefix != null) {
            acc = prefix + "_" + acc;
        }
        return UriBuilder.fromPath((String)this.getServiceUrl()).path(API_VERSION).path(acc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateAccount() {
        WebResource resource = this.getClient().resource(this.getUriBase().build(new Object[0]));
        ClientResponse response = resource.accept(new String[]{"application/json"}).head();
        try {
            if (response.getClientResponseStatus().getFamily() != Response.Status.Family.SUCCESSFUL) {
                throw this.convertResponseToException(response);
            }
        }
        finally {
            response.close();
        }
    }

    @Override
    public final List<Container> listContainers() {
        return this.listContainers(null);
    }

    @Override
    public final List<Container> listContainers(Map<QueryOption, String> options) {
        if (options != null) {
            if (options.containsKey((Object)QueryOption.DELIMITER)) {
                throw new IllegalArgumentException("Delimiter option not supported for container listing");
            }
            if (options.containsKey((Object)QueryOption.PREFIX)) {
                throw new IllegalArgumentException("Prefix option not supported for container listing");
            }
        }
        WebResource resource = this.getClient().resource(this.getUriBase().build(new Object[0]));
        resource = this.setQueryOptions(resource, options);
        ClientResponse response = (ClientResponse)resource.accept(new String[]{"application/json"}).get(ClientResponse.class);
        try {
            if (response.getClientResponseStatus() == ClientResponse.Status.OK) {
                ArrayList<Container> containers = new ArrayList<Container>();
                String json = (String)response.getEntity(String.class);
                try {
                    JSONArray ca = new JSONArray(json);
                    for (int i = 0; i < ca.length(); ++i) {
                        JSONObject co = ca.getJSONObject(i);
                        Container c = Container.create(co.getString("name"), co.getInt("count"), co.getLong("bytes"), null);
                        containers.add(c);
                    }
                }
                catch (JSONException e) {
                    throw new SystemException(ClientMessage.systemError(), e);
                }
                ArrayList<Container> arrayList = containers;
                return arrayList;
            }
            throw this.convertResponseToException(response);
        }
        finally {
            response.close();
        }
    }

    @Override
    public final Container describeContainer(String container) {
        WebResource resource = this.getClient().resource(this.getUriBase().path(container).build(new Object[0]));
        ClientResponse response = resource.accept(new String[]{"application/xml"}).head();
        try {
            if (response.getClientResponseStatus() == ClientResponse.Status.NO_CONTENT) {
                Container c;
                Container container2 = c = Container.create(container, Integer.parseInt((String)response.getHeaders().getFirst((Object)"X-Container-Object-Count")), Long.parseLong((String)response.getHeaders().getFirst((Object)"X-Container-Bytes-Used")), this.getMetaDataFromResponse((MultivaluedMap<String, String>)response.getHeaders(), X_CONTAINER_META));
                return container2;
            }
            if (response.getClientResponseStatus() == ClientResponse.Status.NOT_FOUND) {
                throw new NoSuchContainerException(ClientMessage.noSuchContainer(container));
            }
            throw this.convertResponseToException(response);
        }
        finally {
            response.close();
        }
    }

    @Override
    public final Container createContainer(String container) {
        return this.createContainer(container, null);
    }

    private void evaluateContainerName(String container) {
        if (container.contains("/")) {
            throw new InvalidContainerNameException(ClientMessage.invalidContainerNameCharacter(container));
        }
        if (container.getBytes(StandardCharsets.UTF_8).length > 255) {
            throw new InvalidContainerNameException(ClientMessage.invalidContainerNameLength(container));
        }
    }

    @Override
    public final Container createContainer(String container, Map<String, String> customMetadata) {
        this.evaluateContainerName(container);
        WebResource resource = this.getClient().resource(this.getUriBase().path(container).build(new Object[0]));
        WebResource.Builder wsBuilder = resource.getRequestBuilder();
        if (customMetadata != null && !customMetadata.isEmpty()) {
            for (Map.Entry<String, String> pairs : customMetadata.entrySet()) {
                String headerKey = pairs.getKey();
                wsBuilder = (WebResource.Builder)wsBuilder.header(X_CONTAINER_META + headerKey, (Object)pairs.getValue());
            }
        }
        ClientResponse response = (ClientResponse)((WebResource.Builder)wsBuilder.accept(new String[]{"application/xml"})).put(ClientResponse.class);
        try {
            if (response.getClientResponseStatus() == ClientResponse.Status.CREATED) {
                Container c;
                Container container2 = c = Container.create(container, 0, 0L, this.getMetaDataMap(customMetadata, null));
                return container2;
            }
            throw this.convertResponseToException(response);
        }
        finally {
            response.close();
        }
    }

    @Override
    public Container deleteContainerMetadata(String container, String metadataKey) {
        return this.updateContainerMetadata(container, metadataKey, null);
    }

    @Override
    public final Container updateContainerMetadata(String container, String imetadataKey, String metadataValue) {
        String metadataKey = Character.toUpperCase(imetadataKey.charAt(0)) + imetadataKey.substring(1).toLowerCase(Locale.ENGLISH);
        WebResource resource = this.getClient().resource(this.getUriBase().path(container).build(new Object[0]));
        WebResource.Builder wsBuilder = resource.getRequestBuilder();
        ClientResponse headerResponse = resource.accept(new String[]{"text/plain"}).head();
        try {
            if (headerResponse.getClientResponseStatus() == ClientResponse.Status.NO_CONTENT) {
                MultivaluedMap premetadataHeaders = headerResponse.getHeaders();
                for (Map.Entry pairs : premetadataHeaders.entrySet()) {
                    String headerKey = (String)pairs.getKey();
                    if (!headerKey.startsWith(X_CONTAINER_META) || headerKey.compareToIgnoreCase(X_CONTAINER_META + metadataKey) == 0) continue;
                    wsBuilder = (WebResource.Builder)wsBuilder.header(headerKey, premetadataHeaders.getFirst((Object)headerKey));
                }
                wsBuilder = metadataValue == null ? (WebResource.Builder)wsBuilder.header(X_CONTAINER_META + metadataKey, (Object)"") : (WebResource.Builder)wsBuilder.header(X_CONTAINER_META + metadataKey, (Object)metadataValue);
                ClientResponse response = (ClientResponse)wsBuilder.post(ClientResponse.class);
                try {
                    if (response.getClientResponseStatus() == ClientResponse.Status.NO_CONTENT) {
                        Container c = Container.create(container, Integer.parseInt((String)headerResponse.getHeaders().getFirst((Object)"X-Container-Object-Count")), Long.parseLong((String)headerResponse.getHeaders().getFirst((Object)"X-Container-Bytes-Used")), this.getMetaDataFromResponse((MultivaluedMap<String, String>)premetadataHeaders, X_CONTAINER_META));
                        String normKey = Character.toUpperCase(metadataKey.charAt(0)) + metadataKey.substring(1).toLowerCase(Locale.ENGLISH);
                        if (metadataValue == null) {
                            c.removeMetadata(normKey);
                        } else {
                            c.updateMetadata(normKey, metadataValue);
                        }
                        Container container2 = c;
                        return container2;
                    }
                    throw this.convertResponseToException(response);
                }
                finally {
                    response.close();
                }
            }
            if (headerResponse.getClientResponseStatus() == ClientResponse.Status.NOT_FOUND) {
                throw new NoSuchContainerException(ClientMessage.noSuchContainer(container));
            }
            throw this.convertResponseToException(headerResponse);
        }
        finally {
            headerResponse.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void deleteContainer(String container) {
        WebResource resource = this.getClient().resource(this.getUriBase().path(container).build(new Object[0]));
        ClientResponse response = (ClientResponse)resource.accept(new String[]{"application/json"}).delete(ClientResponse.class);
        try {
            if (response.getClientResponseStatus() != ClientResponse.Status.NO_CONTENT) {
                if (response.getClientResponseStatus() == ClientResponse.Status.CONFLICT) {
                    throw new ContainerNotEmptyException(ClientMessage.containerNotEmpty(container));
                }
                throw this.convertResponseToException(response);
            }
        }
        finally {
            response.close();
        }
    }

    @Override
    public final String getContainerAcl(String container, AclType type) {
        WebResource resource = this.getClient().resource(this.getUriBase().path(container).build(new Object[0]));
        ClientResponse response = resource.accept(new String[]{"application/json"}).head();
        try {
            if (response.getClientResponseStatus() == ClientResponse.Status.NO_CONTENT) {
                String string = (String)response.getHeaders().getFirst((Object)type.getHeader());
                return string;
            }
            throw this.convertResponseToException(response);
        }
        finally {
            response.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setContainerAcl(String container, AclType type, String aclvalue) {
        WebResource resource = this.getClient().resource(this.getUriBase().path(container).build(new Object[0]));
        ClientResponse response = (ClientResponse)((WebResource.Builder)resource.accept(new String[]{"application/json"}).header(type.getHeader(), (Object)aclvalue)).post(ClientResponse.class);
        try {
            if (response.getClientResponseStatus() != ClientResponse.Status.NO_CONTENT) {
                throw this.convertResponseToException(response);
            }
        }
        finally {
            response.close();
        }
    }

    private WebResource setQueryOptions(WebResource resource, Map<QueryOption, String> options) {
        WebResource result = resource;
        if (options != null) {
            for (Map.Entry<QueryOption, String> entry : options.entrySet()) {
                if (entry.getValue() == null) continue;
                result = result.queryParam(entry.getKey().getName(), entry.getValue());
            }
        }
        return result;
    }

    @Override
    public final List<Key> listObjects(String container, Map<QueryOption, String> options) {
        if (options != null && options.containsKey((Object)QueryOption.DELIMITER)) {
            throw new IllegalArgumentException("Delimiter option may only be specified for path queries");
        }
        WebResource resource = this.getClient().resource(this.getUriBase().path(container).build(new Object[0]));
        resource = this.setQueryOptions(resource, options);
        ClientResponse response = (ClientResponse)resource.accept(new String[]{"application/json"}).get(ClientResponse.class);
        try {
            if (response.getClientResponseStatus() == ClientResponse.Status.OK) {
                ArrayList<Key> objects = new ArrayList<Key>();
                String json = (String)response.getEntity(String.class);
                try {
                    JSONArray ca = new JSONArray(json);
                    for (int i = 0; i < ca.length(); ++i) {
                        JSONObject co = ca.getJSONObject(i);
                        Calendar c = DatatypeConverter.parseDateTime((String)co.getString("last_modified"));
                        c.setTimeZone(TimeZone.getTimeZone("GMT"));
                        Key k = Key.create(co.getString("name"), co.getString("content_type"), c.getTime(), co.getLong("bytes"), null, null);
                        objects.add(k);
                    }
                }
                catch (JSONException e) {
                    throw new SystemException(ClientMessage.systemError(), e);
                }
                ArrayList<Key> arrayList = objects;
                return arrayList;
            }
            throw this.convertResponseToException(response);
        }
        finally {
            response.close();
        }
    }

    @Override
    public final QueryResult listObjectsByPath(String container, String delimiter, String path, Map<QueryOption, String> passedOptions) {
        Map<QueryOption, String> options = passedOptions;
        if (options == null) {
            options = new EnumMap<QueryOption, String>(QueryOption.class);
        }
        options.put(QueryOption.DELIMITER, delimiter);
        if (path != null) {
            options.put(QueryOption.PREFIX, path);
        }
        WebResource resource = this.getClient().resource(this.getUriBase().path(container).build(new Object[0]));
        resource = this.setQueryOptions(resource, options);
        ClientResponse response = (ClientResponse)resource.accept(new String[]{"application/json"}).get(ClientResponse.class);
        try {
            if (response.getClientResponseStatus() == ClientResponse.Status.OK) {
                ArrayList<Key> keys = new ArrayList<Key>();
                ArrayList<String> paths = new ArrayList<String>();
                String json = (String)response.getEntity(String.class);
                try {
                    JSONArray ca = new JSONArray(json);
                    for (int i = 0; i < ca.length(); ++i) {
                        JSONObject co = ca.getJSONObject(i);
                        if (co.has("subdir")) {
                            String subDir = co.getString("subdir");
                            paths.add(subDir);
                            continue;
                        }
                        Key k = Key.create(co.getString("name"), co.getString("content_type"), DatatypeConverter.parseDateTime((String)co.getString("last_modified")).getTime(), co.getLong("bytes"), null, null);
                        keys.add(k);
                    }
                }
                catch (JSONException e) {
                    throw new SystemException(ClientMessage.systemError(), e);
                }
                QueryResult queryResult = QueryResult.create(keys, paths);
                return queryResult;
            }
            throw this.convertResponseToException(response);
        }
        finally {
            response.close();
        }
    }

    @Override
    public final Key describeObject(String container, String key) {
        WebResource resource = this.getClient().resource(this.getUriBase().path(container).path(key).build(new Object[0]));
        ClientResponse response = resource.accept(new String[]{"application/json"}).head();
        try {
            if (response.getClientResponseStatus() == ClientResponse.Status.OK) {
                String contentLenght = (String)response.getHeaders().getFirst((Object)"Content-Length");
                Key k = Key.create(key, response.getType().toString(), response.getLastModified(), Long.parseLong(contentLenght), (String)response.getHeaders().getFirst((Object)"Etag"), this.getMetaDataFromResponse((MultivaluedMap<String, String>)response.getHeaders(), X_OBJECT_META));
                if (response.getHeaders().getFirst((Object)X_OBJECT_MANIFEST) != null) {
                    k.setObjectManifest((String)response.getHeaders().getFirst((Object)X_OBJECT_MANIFEST));
                }
                Key key2 = k;
                return key2;
            }
            if (response.getClientResponseStatus() == ClientResponse.Status.NOT_FOUND) {
                throw new NoSuchObjectException(ClientMessage.noSuchObject(key, container));
            }
            throw this.convertResponseToException(response);
        }
        finally {
            response.close();
        }
    }

    @Override
    public Key storeObject(String container, String key, String contentType, InputStream in) {
        return this.storeObject(container, key, contentType, null, in);
    }

    @Override
    public Key storeObject(String container, String key, String contentType, Map<String, String> icustomMetadata, InputStream iin) {
        HashMap<String, String> customMetadata = icustomMetadata != null ? icustomMetadata : new HashMap<String, String>();
        InputStream in = this.wrapInboundInputStream(iin, customMetadata);
        WebResource resource = this.getClient().resource(this.getUriBase().path(container).path(key).build(new Object[0]));
        WebResource.Builder wsBuilder = resource.getRequestBuilder();
        this.processObjectMetadata(wsBuilder, customMetadata);
        ClientResponse response = (ClientResponse)((WebResource.Builder)((WebResource.Builder)wsBuilder.accept(new String[]{"application/json"})).type(contentType)).put(ClientResponse.class, (Object)in);
        try {
            if (response.getClientResponseStatus() == ClientResponse.Status.CREATED) {
                Key k;
                Key key2 = k = Key.create(key, contentType, response.getLastModified(), 0L, (String)response.getHeaders().getFirst((Object)"Etag"), this.getMetaDataMap(customMetadata, X_OBJECT_META));
                return key2;
            }
            if (response.getClientResponseStatus() == ClientResponse.Status.NOT_FOUND) {
                throw new NoSuchContainerException((String)response.getEntity(String.class));
            }
            throw this.convertResponseToException(response);
        }
        finally {
            response.close();
        }
    }

    protected StorageInputStream wrapOutboundInputStream(StorageInputStream is, String container, String key) {
        return is;
    }

    private void processObjectMetadata(WebResource.Builder builder, Map<String, String> metadata) {
        if (metadata == null || metadata.isEmpty()) {
            return;
        }
        for (Map.Entry<String, String> pairs : metadata.entrySet()) {
            String header = pairs.getKey();
            header = header.replaceFirst(X_OBJECT_META, "");
            builder = (WebResource.Builder)builder.header(X_OBJECT_META + header, (Object)pairs.getValue());
        }
    }

    @Override
    public final Key storeObjectManifest(String container, String key, String contentType, String segment_container, String segment_prefix) {
        return this.storeObjectManifest(container, key, contentType, segment_container, segment_prefix, null);
    }

    @Override
    public final Key storeObjectManifest(String container, String key, String contentType, String segment_container, String segment_prefix, Map<String, String> passedCustomMetadata) {
        Map<String, String> customMetadata = passedCustomMetadata;
        if (customMetadata == null) {
            customMetadata = new HashMap<String, String>();
        }
        WebResource resource = this.getClient().resource(this.getUriBase().path(container).path(key).build(new Object[0]));
        WebResource.Builder wsBuilder = resource.getRequestBuilder();
        this.processObjectMetadata(wsBuilder, customMetadata);
        String objectManifest = segment_container + "/" + segment_prefix;
        wsBuilder.header(X_OBJECT_MANIFEST, (Object)objectManifest);
        ClientResponse response = (ClientResponse)wsBuilder.put(ClientResponse.class, (Object)"");
        try {
            if (response.getClientResponseStatus() == ClientResponse.Status.CREATED) {
                Key k = Key.create(key, contentType, response.getLastModified(), 0L, (String)response.getHeaders().getFirst((Object)"Etag"), this.getMetaDataMap(customMetadata, X_OBJECT_META));
                k.setObjectManifest(objectManifest);
                Key key2 = k;
                return key2;
            }
            throw this.convertResponseToException(response);
        }
        finally {
            response.close();
        }
    }

    protected InputStream wrapInboundInputStream(InputStream is, Map<String, String> customMetadata) {
        return is;
    }

    @Override
    public StorageInputStream retrieveObject(String container, String key) {
        WebResource resource = this.getClient().resource(this.getUriBase().path(container).path(key).build(new Object[0]));
        ClientResponse response = (ClientResponse)resource.accept(new String[]{"*/*"}).get(ClientResponse.class);
        if (response.getClientResponseStatus() == ClientResponse.Status.OK) {
            HashMap<String, String> customMetadata = this.getCustomMetadata((MultivaluedMap<String, String>)response.getHeaders());
            StorageInputStream in = new StorageInputStream(response.getEntityInputStream(), customMetadata);
            return this.wrapOutboundInputStream(in, container, key);
        }
        throw this.convertResponseToException(response);
    }

    @Override
    public final StorageInputStream retrieveObject(String container, String key, ContentRange ... ranges) {
        StringBuilder range = new StringBuilder();
        if (ranges == null || ranges.length < 1) {
            return this.retrieveObject(container, key);
        }
        for (ContentRange r : ranges) {
            range.append("," + r.toString());
        }
        range.deleteCharAt(0);
        WebResource resource = this.getClient().resource(this.getUriBase().path(container).path(key).build(new Object[0]));
        ClientResponse response = (ClientResponse)((WebResource.Builder)resource.accept(new String[]{"*/*"}).header("Range", (Object)("bytes=" + range))).get(ClientResponse.class);
        if (response.getClientResponseStatus() != ClientResponse.Status.PARTIAL_CONTENT) {
            throw this.convertResponseToException(response);
        }
        HashMap<String, String> customMetadata = this.getCustomMetadata((MultivaluedMap<String, String>)response.getHeaders());
        StorageInputStream in = this.newStorageInputByType(response, customMetadata);
        return this.wrapOutboundInputStream(in, container, key);
    }

    private StorageInputStream newStorageInputByType(ClientResponse response, HashMap<String, String> customMetadata) {
        StorageInputStream in = response.getType().getType().equals("multipart") ? new StorageInputMultistream((MultiPart)response.getEntity(MultiPart.class), customMetadata) : new StorageInputStream(response.getEntityInputStream(), customMetadata);
        return in;
    }

    @Override
    public final boolean isEncrypted(String container, String key) {
        Key object = this.describeObject(container, key);
        return object.getMetadataValue(ENVELOPE_KEY1) != null;
    }

    private HashMap<String, String> getCustomMetadata(MultivaluedMap<String, String> headers) {
        HashMap<String, String> customMetadata = new HashMap<String, String>();
        for (Map.Entry pairs : headers.entrySet()) {
            String headerKey = (String)pairs.getKey();
            if (!headerKey.contains(X_OBJECT_META)) continue;
            customMetadata.put(headerKey.replaceFirst(X_OBJECT_META, ""), (String)headers.getFirst((Object)headerKey));
        }
        return customMetadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void deleteObject(String container, String key) {
        WebResource resource = this.getClient().resource(this.getUriBase().path(container).path(key).build(new Object[0]));
        ClientResponse response = (ClientResponse)resource.accept(new String[]{"application/xml"}).delete(ClientResponse.class);
        try {
            if (response.getClientResponseStatus() != ClientResponse.Status.NO_CONTENT) {
                throw this.convertResponseToException(response);
            }
        }
        finally {
            response.close();
        }
    }

    @Override
    public final Key deleteObjectMetadata(String container, String key, String metadataKey) {
        return this.updateObjectMetadata(container, key, metadataKey, null);
    }

    @Override
    public final Key updateObjectMetadata(String container, String key, String imetadataKey, String metadataValue) {
        String metadataKey = this.normalizeKey(imetadataKey, X_OBJECT_META);
        WebResource resource = this.getClient().resource(this.getUriBase().path(container).path(key).build(new Object[0]));
        WebResource.Builder wsBuilder = resource.getRequestBuilder();
        ClientResponse headerResponse = resource.head();
        headerResponse.close();
        MultivaluedMap premetadataHeaders = headerResponse.getHeaders();
        for (Map.Entry pairs : premetadataHeaders.entrySet()) {
            String headerKey = (String)pairs.getKey();
            if (!headerKey.contains(X_OBJECT_META) || headerKey.equals(X_OBJECT_META + metadataKey)) continue;
            wsBuilder = (WebResource.Builder)wsBuilder.header(headerKey, premetadataHeaders.getFirst((Object)headerKey));
        }
        wsBuilder = (WebResource.Builder)wsBuilder.header(X_OBJECT_META + metadataKey, (Object)metadataValue);
        ClientResponse response = (ClientResponse)wsBuilder.post(ClientResponse.class);
        try {
            if (response.getClientResponseStatus() == ClientResponse.Status.ACCEPTED) {
                Map<String, String> keyMetadata = this.getMetaDataFromResponse((MultivaluedMap<String, String>)premetadataHeaders, X_OBJECT_META);
                String contentLenght = (String)response.getHeaders().getFirst((Object)"Content-Length");
                Key k = Key.create(key, response.getType().toString(), response.getLastModified(), Long.parseLong(contentLenght), (String)response.getHeaders().getFirst((Object)"Etag"), keyMetadata);
                if (response.getHeaders().getFirst((Object)X_OBJECT_MANIFEST) != null) {
                    k.setObjectManifest((String)response.getHeaders().getFirst((Object)X_OBJECT_MANIFEST));
                }
                if (metadataValue == null) {
                    keyMetadata.remove(metadataKey);
                } else {
                    keyMetadata.put(metadataKey, metadataValue);
                }
                Key key2 = k;
                return key2;
            }
            throw this.convertResponseToException(response);
        }
        finally {
            response.close();
        }
    }

    private CloudException convertResponseToException(ClientResponse response) {
        String message = (String)response.getEntity(String.class);
        CloudException e = null;
        e = response.getClientResponseStatus() == ClientResponse.Status.UNAUTHORIZED ? new AuthenticationException(message) : (response.getClientResponseStatus() == ClientResponse.Status.FORBIDDEN ? new AccessDeniedException(message) : new SystemException(ClientMessage.systemError(response.getClientResponseStatus().name(), message)));
        ExceptionUtil.trimStackTrace(e, "convertResponseToException");
        try {
            response.close();
        }
        catch (Exception ex) {
            e = new SystemException(ex.getMessage(), e);
        }
        return e;
    }

    protected final String normalizeKey(String passedKey, String prefix) {
        String key = passedKey;
        if (prefix != null) {
            key = key.replaceFirst("^" + prefix, "");
        }
        key = Character.toUpperCase(key.charAt(0)) + key.substring(1).toLowerCase(Locale.ENGLISH);
        return key;
    }

    private Map<String, String> getMetaDataFromResponse(MultivaluedMap<String, String> headers, String metaPrefix) {
        HashMap<String, String> m = new HashMap<String, String>();
        if (headers == null || headers.size() == 0) {
            return m;
        }
        for (Map.Entry pairs : headers.entrySet()) {
            String headerKey = (String)pairs.getKey();
            String val = (String)headers.getFirst((Object)headerKey);
            if (val == null || !headerKey.startsWith(metaPrefix)) continue;
            String normKey = this.normalizeKey(headerKey, metaPrefix);
            m.put(normKey, val);
        }
        return m;
    }

    protected final Map<String, String> getMetaDataMap(Map<String, String> headers, String metaPrefix) {
        HashMap<String, String> m = new HashMap<String, String>();
        if (headers == null || headers.size() == 0) {
            return m;
        }
        for (Map.Entry<String, String> pairs : headers.entrySet()) {
            String headerKey = pairs.getKey();
            String normKey = this.normalizeKey(headerKey, metaPrefix);
            m.put(normKey, pairs.getValue());
        }
        return m;
    }
}

