/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.storage.exception;

public enum CloudExceptionType {
    SYSTEM_ERROR("SystemError", 500),
    NO_SUCH_OBJECT("NoSuchObject", 404),
    NO_SUCH_CONTAINER("NoSuchContainer", 404),
    CONTAINER_ALREADY_EXISTS("ContainerAlreadyExists", 409),
    BAD_DIGEST("BadDigest", 400),
    MISSING_FORM_FIELD("MissingFormField", 400),
    AUTHENTICATION_ERROR("AuthenticationError", 401),
    ACCESS_DENIED("AccessDenied", 403),
    CONTAINER_NOT_EMPTY("ContainerNotEmpty", 409),
    INVALID_CONTAINER_NAME("InvalidContainerName", 400),
    INVALID_KEY_NAME("InvalidKeyName", 400),
    INVALID_RANGE("InvalidRange", 416);

    private final String name;
    private final int responseCode;

    private CloudExceptionType(String name, int responseCode) {
        this.name = name;
        this.responseCode = responseCode;
    }

    public String getName() {
        return this.name;
    }

    public int getResponseCode() {
        return this.responseCode;
    }
}

