/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.dbinfo;

import org.hsqldb.ColumnSchema;
import org.hsqldb.Constraint;
import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.NumberSequence;
import org.hsqldb.Routine;
import org.hsqldb.RoutineSchema;
import org.hsqldb.Session;
import org.hsqldb.SqlInvariants;
import org.hsqldb.Table;
import org.hsqldb.TypeInvariants;
import org.hsqldb.dbinfo.DITableInfo;
import org.hsqldb.dbinfo.DatabaseInformation;
import org.hsqldb.index.Index;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.lib.WrapperIterator;
import org.hsqldb.map.ValuePool;
import org.hsqldb.persist.HsqlDatabaseProperties;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.rights.Grantee;
import org.hsqldb.rights.GranteeManager;
import org.hsqldb.rights.Right;
import org.hsqldb.rights.User;
import org.hsqldb.types.Charset;
import org.hsqldb.types.DateTimeType;
import org.hsqldb.types.IntervalType;
import org.hsqldb.types.NumberType;
import org.hsqldb.types.Type;

class DatabaseInformationMain
extends DatabaseInformation {
    static Type CARDINAL_NUMBER = TypeInvariants.CARDINAL_NUMBER;
    static Type YES_OR_NO = TypeInvariants.YES_OR_NO;
    static Type CHARACTER_DATA = TypeInvariants.CHARACTER_DATA;
    static Type SQL_IDENTIFIER = TypeInvariants.SQL_IDENTIFIER;
    static Type TIME_STAMP = TypeInvariants.TIME_STAMP;
    protected static final HsqlNameManager.HsqlName[] sysTableHsqlNames;
    protected static final boolean[] sysTableSessionDependent;
    protected static final HashSet nonCachedTablesSet;
    protected static final String[] tableTypes;
    protected final Table[] sysTables = new Table[sysTableNames.length];

    DatabaseInformationMain(Database database) {
        super(database);
        Session session = database.sessionManager.getSysSession();
        this.init(session);
    }

    protected final void addColumn(Table table, String string, Type type) {
        HsqlNameManager cfr_ignored_0 = this.database.nameManager;
        HsqlNameManager.HsqlName hsqlName = HsqlNameManager.newInfoSchemaColumnName(string, table.getName());
        ColumnSchema columnSchema = new ColumnSchema(hsqlName, type, true, false, null);
        table.addColumn(columnSchema);
    }

    protected final Iterator allTables() {
        return new WrapperIterator(this.database.schemaManager.databaseObjectIterator(3), new WrapperIterator(this.sysTables, true));
    }

    protected final void cacheClear(Session session) {
        int n = this.sysTables.length;
        while (n-- > 0) {
            Table table = this.sysTables[n];
            if (table == null) continue;
            table.clearAllData(session);
        }
    }

    protected Table generateTable(Session session, PersistentStore persistentStore, int n) {
        switch (n) {
            case 0: {
                return this.SYSTEM_BESTROWIDENTIFIER(session, persistentStore);
            }
            case 1: {
                return this.SYSTEM_COLUMNS(session, persistentStore);
            }
            case 18: {
                return this.SYSTEM_CONNECTION_PROPERTIES(session, persistentStore);
            }
            case 2: {
                return this.SYSTEM_CROSSREFERENCE(session, persistentStore);
            }
            case 3: {
                return this.SYSTEM_INDEXINFO(session, persistentStore);
            }
            case 4: {
                return this.SYSTEM_PRIMARYKEYS(session, persistentStore);
            }
            case 5: {
                return this.SYSTEM_PROCEDURECOLUMNS(session, persistentStore);
            }
            case 6: {
                return this.SYSTEM_PROCEDURES(session, persistentStore);
            }
            case 7: {
                return this.SYSTEM_SCHEMAS(session, persistentStore);
            }
            case 14: {
                return this.SYSTEM_SEQUENCES(session, persistentStore);
            }
            case 8: {
                return this.SYSTEM_TABLES(session, persistentStore);
            }
            case 9: {
                return this.SYSTEM_TABLETYPES(session, persistentStore);
            }
            case 10: {
                return this.SYSTEM_TYPEINFO(session, persistentStore);
            }
            case 12: {
                return this.SYSTEM_USERS(session, persistentStore);
            }
            case 11: {
                return this.SYSTEM_UDTS(session, persistentStore);
            }
            case 13: {
                return this.SYSTEM_VERSIONCOLUMNS(session, persistentStore);
            }
            case 35: {
                return this.COLUMN_PRIVILEGES(session, persistentStore);
            }
            case 71: {
                return this.SEQUENCES(session, persistentStore);
            }
            case 79: {
                return this.TABLE_PRIVILEGES(session, persistentStore);
            }
            case 45: {
                return this.INFORMATION_SCHEMA_CATALOG_NAME(session, persistentStore);
            }
        }
        return null;
    }

    protected final void init(Session session) {
        for (int i = 0; i < this.sysTables.length; ++i) {
            this.sysTables[i] = this.generateTable(session, null, i);
            Table table = this.sysTables[i];
            if (table == null) continue;
            table.setDataReadOnly(true);
        }
        GranteeManager granteeManager = this.database.getGranteeManager();
        Right right = new Right();
        right.set(1, null);
        for (int i = 0; i < sysTableHsqlNames.length; ++i) {
            if (this.sysTables[i] == null) continue;
            granteeManager.grantSystemToPublic(this.sysTables[i], right);
        }
        right = Right.fullRights;
        granteeManager.grantSystemToPublic(Charset.SQL_CHARACTER, right);
        granteeManager.grantSystemToPublic(Charset.SQL_IDENTIFIER_CHARSET, right);
        granteeManager.grantSystemToPublic(Charset.SQL_TEXT, right);
        granteeManager.grantSystemToPublic(TypeInvariants.SQL_IDENTIFIER, right);
        granteeManager.grantSystemToPublic(TypeInvariants.YES_OR_NO, right);
        granteeManager.grantSystemToPublic(TypeInvariants.TIME_STAMP, right);
        granteeManager.grantSystemToPublic(TypeInvariants.CARDINAL_NUMBER, right);
        granteeManager.grantSystemToPublic(TypeInvariants.CHARACTER_DATA, right);
    }

    protected final boolean isAccessibleTable(Session session, Table table) {
        return session.getGrantee().isAccessible(table);
    }

    protected final Table createBlankTable(HsqlNameManager.HsqlName hsqlName) {
        Table table = new Table(this.database, hsqlName, 1);
        return table;
    }

    @Override
    public final Table getSystemTable(Session session, String string) {
        if (!this.isSystemTable(string)) {
            return null;
        }
        int n = DatabaseInformationMain.getSysTableID(string);
        Table table = this.sysTables[n];
        if (table == null) {
            return table;
        }
        if (!this.withContent) {
            return table;
        }
        return table;
    }

    public boolean isNonCachedTable(String string) {
        return nonCachedTablesSet.contains(string);
    }

    @Override
    public final void setStore(Session session, Table table, PersistentStore persistentStore) {
        long l = this.database.schemaManager.getSchemaChangeTimestamp();
        if (persistentStore.getTimestamp() == l && !this.isNonCachedTable(table.getName().name)) {
            return;
        }
        persistentStore.removeAll();
        persistentStore.setTimestamp(l);
        int n = DatabaseInformationMain.getSysTableID(table.getName().name);
        this.generateTable(session, persistentStore, n);
    }

    final Table SYSTEM_BESTROWIDENTIFIER(Session session, PersistentStore persistentStore) {
        Table table = this.sysTables[0];
        if (table == null) {
            table = this.createBlankTable(sysTableHsqlNames[0]);
            this.addColumn(table, "SCOPE", Type.SQL_SMALLINT);
            this.addColumn(table, "COLUMN_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "DATA_TYPE", Type.SQL_SMALLINT);
            this.addColumn(table, "TYPE_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "COLUMN_SIZE", Type.SQL_INTEGER);
            this.addColumn(table, "BUFFER_LENGTH", Type.SQL_INTEGER);
            this.addColumn(table, "DECIMAL_DIGITS", Type.SQL_SMALLINT);
            this.addColumn(table, "PSEUDO_COLUMN", Type.SQL_SMALLINT);
            this.addColumn(table, "TABLE_CAT", SQL_IDENTIFIER);
            this.addColumn(table, "TABLE_SCHEM", SQL_IDENTIFIER);
            this.addColumn(table, "TABLE_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "NULLABLE", Type.SQL_SMALLINT);
            this.addColumn(table, "IN_KEY", Type.SQL_BOOLEAN);
            HsqlNameManager.HsqlName hsqlName = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationMain.sysTableHsqlNames[0].name, false, 20);
            table.createPrimaryKeyConstraint(hsqlName, new int[]{0, 8, 9, 10, 1}, false);
            return table;
        }
        DITableInfo dITableInfo = new DITableInfo();
        Iterator iterator = this.database.schemaManager.databaseObjectIterator(3);
        boolean bl = this.database.sqlTranslateTTI;
        while (iterator.hasNext()) {
            int[] nArray;
            Table table2 = (Table)iterator.next();
            if (table2.isView() || !this.isAccessibleTable(session, table2) || (nArray = table2.getBestRowIdentifiers()) == null) continue;
            dITableInfo.setTable(table2);
            Boolean bl2 = table2.isBestRowIdentifiersStrict() ? Boolean.TRUE : Boolean.FALSE;
            String string = table2.getCatalogName().name;
            String string2 = table2.getSchemaName().name;
            String string3 = table2.getName().name;
            Type[] typeArray = table2.getColumnTypes();
            Integer n = dITableInfo.getBRIScope();
            Integer n2 = dITableInfo.getBRIPseudo();
            for (int i = 0; i < nArray.length; ++i) {
                ColumnSchema columnSchema = table2.getColumn(i);
                Type type = typeArray[i];
                if (bl) {
                    if (type.isIntervalType()) {
                        type = ((IntervalType)type).getCharacterType();
                    } else if (type.isDateTimeTypeWithZone()) {
                        type = ((DateTimeType)type).getDateTimeTypeWithoutZone();
                    }
                }
                Object[] objectArray = table.getEmptyRowData();
                objectArray[0] = n;
                objectArray[1] = columnSchema.getName().name;
                objectArray[2] = ValuePool.getInt(type.getJDBCTypeCode());
                objectArray[3] = type.getNameString();
                objectArray[4] = ValuePool.getInt(type.getJDBCPrecision());
                objectArray[5] = null;
                objectArray[6] = type.acceptsScale() ? ValuePool.getInt(type.getJDBCScale()) : null;
                objectArray[7] = n2;
                objectArray[8] = string;
                objectArray[9] = string2;
                objectArray[10] = string3;
                objectArray[11] = ValuePool.getInt(columnSchema.getNullability());
                objectArray[12] = bl2;
                table.insertSys(session, persistentStore, objectArray);
            }
        }
        return table;
    }

    final Table SYSTEM_COLUMNS(Session session, PersistentStore persistentStore) {
        Table table = this.sysTables[1];
        if (table == null) {
            table = this.createBlankTable(sysTableHsqlNames[1]);
            this.addColumn(table, "TABLE_CAT", SQL_IDENTIFIER);
            this.addColumn(table, "TABLE_SCHEM", SQL_IDENTIFIER);
            this.addColumn(table, "TABLE_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "COLUMN_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "DATA_TYPE", Type.SQL_SMALLINT);
            this.addColumn(table, "TYPE_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "COLUMN_SIZE", Type.SQL_INTEGER);
            this.addColumn(table, "BUFFER_LENGTH", Type.SQL_INTEGER);
            this.addColumn(table, "DECIMAL_DIGITS", Type.SQL_INTEGER);
            this.addColumn(table, "NUM_PREC_RADIX", Type.SQL_INTEGER);
            this.addColumn(table, "NULLABLE", Type.SQL_INTEGER);
            this.addColumn(table, "REMARKS", CHARACTER_DATA);
            this.addColumn(table, "COLUMN_DEF", CHARACTER_DATA);
            this.addColumn(table, "SQL_DATA_TYPE", Type.SQL_INTEGER);
            this.addColumn(table, "SQL_DATETIME_SUB", Type.SQL_INTEGER);
            this.addColumn(table, "CHAR_OCTET_LENGTH", Type.SQL_INTEGER);
            this.addColumn(table, "ORDINAL_POSITION", Type.SQL_INTEGER);
            this.addColumn(table, "IS_NULLABLE", YES_OR_NO);
            this.addColumn(table, "SCOPE_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "SCOPE_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "SCOPE_TABLE", SQL_IDENTIFIER);
            this.addColumn(table, "SOURCE_DATA_TYPE", Type.SQL_SMALLINT);
            this.addColumn(table, "IS_AUTOINCREMENT", YES_OR_NO);
            this.addColumn(table, "IS_GENERATEDCOLUMN", YES_OR_NO);
            HsqlNameManager.HsqlName hsqlName = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationMain.sysTableHsqlNames[1].name, false, 20);
            table.createPrimaryKeyConstraint(hsqlName, new int[]{0, 1, 2, 16}, false);
            return table;
        }
        Iterator iterator = this.allTables();
        DITableInfo dITableInfo = new DITableInfo();
        boolean bl = this.database.sqlTranslateTTI;
        while (iterator.hasNext()) {
            Table table2 = (Table)iterator.next();
            if (!this.isAccessibleTable(session, table2)) continue;
            dITableInfo.setTable(table2);
            String string = table2.getCatalogName().name;
            String string2 = table2.getSchemaName().name;
            String string3 = table2.getName().name;
            int n = table2.getColumnCount();
            for (int i = 0; i < n; ++i) {
                ColumnSchema columnSchema = table2.getColumn(i);
                Type type = columnSchema.getDataType();
                if (bl) {
                    if (type.isIntervalType()) {
                        type = ((IntervalType)type).getCharacterType();
                    } else if (type.isDateTimeTypeWithZone()) {
                        type = ((DateTimeType)type).getDateTimeTypeWithoutZone();
                    }
                }
                Object[] objectArray = table.getEmptyRowData();
                objectArray[0] = string;
                objectArray[1] = string2;
                objectArray[2] = string3;
                objectArray[3] = columnSchema.getName().name;
                objectArray[4] = ValuePool.getInt(type.getJDBCTypeCode());
                objectArray[5] = type.getNameString();
                objectArray[6] = ValuePool.INTEGER_0;
                objectArray[15] = ValuePool.INTEGER_0;
                if (type.isArrayType()) {
                    objectArray[5] = type.getDefinition();
                }
                if (type.isCharacterType()) {
                    objectArray[6] = ValuePool.getInt(type.getJDBCPrecision());
                    objectArray[15] = ValuePool.getInt(type.getJDBCPrecision());
                }
                if (type.isBinaryType()) {
                    objectArray[6] = ValuePool.getInt(type.getJDBCPrecision());
                    objectArray[15] = ValuePool.getInt(type.getJDBCPrecision());
                }
                if (type.isNumberType()) {
                    objectArray[6] = ValuePool.getInt(((NumberType)type).getNumericPrecisionInRadix());
                    objectArray[9] = ValuePool.getInt(type.getPrecisionRadix());
                    if (type.isExactNumberType()) {
                        objectArray[8] = ValuePool.getLong(type.scale);
                    }
                }
                if (type.isDateTimeType()) {
                    int n2 = columnSchema.getDataType().displaySize();
                    objectArray[6] = ValuePool.getInt(n2);
                    objectArray[14] = ValuePool.getInt(((DateTimeType)type).getSqlDateTimeSub());
                }
                objectArray[10] = ValuePool.getInt(columnSchema.getNullability());
                objectArray[11] = dITableInfo.getColRemarks(i);
                objectArray[12] = columnSchema.getDefaultSQL();
                objectArray[13] = ValuePool.getInt(type.typeCode);
                objectArray[16] = ValuePool.getInt(i + 1);
                Object object = objectArray[17] = columnSchema.isNullable() ? "YES" : "NO";
                if (type.isDistinctType() || type.isDomainType()) {
                    objectArray[5] = type.getTypeDefinition();
                    objectArray[21] = objectArray[4];
                }
                objectArray[22] = columnSchema.isIdentity() ? "YES" : "NO";
                objectArray[23] = columnSchema.isGenerated() ? "YES" : "NO";
                table.insertSys(session, persistentStore, objectArray);
            }
        }
        return table;
    }

    final Table SYSTEM_CROSSREFERENCE(Session session, PersistentStore persistentStore) {
        Constraint constraint;
        int n;
        Table table = this.sysTables[2];
        if (table == null) {
            table = this.createBlankTable(sysTableHsqlNames[2]);
            this.addColumn(table, "PKTABLE_CAT", SQL_IDENTIFIER);
            this.addColumn(table, "PKTABLE_SCHEM", SQL_IDENTIFIER);
            this.addColumn(table, "PKTABLE_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "PKCOLUMN_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "FKTABLE_CAT", SQL_IDENTIFIER);
            this.addColumn(table, "FKTABLE_SCHEM", SQL_IDENTIFIER);
            this.addColumn(table, "FKTABLE_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "FKCOLUMN_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "KEY_SEQ", Type.SQL_SMALLINT);
            this.addColumn(table, "UPDATE_RULE", Type.SQL_SMALLINT);
            this.addColumn(table, "DELETE_RULE", Type.SQL_SMALLINT);
            this.addColumn(table, "FK_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "PK_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "DEFERRABILITY", Type.SQL_SMALLINT);
            HsqlNameManager.HsqlName hsqlName = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationMain.sysTableHsqlNames[2].name, false, 20);
            table.createPrimaryKeyConstraint(hsqlName, new int[]{4, 5, 6, 8, 11}, false);
            return table;
        }
        Iterator iterator = this.database.schemaManager.databaseObjectIterator(3);
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        while (iterator.hasNext()) {
            Table table2 = (Table)iterator.next();
            if (table2.isView() || !this.isAccessibleTable(session, table2)) continue;
            Constraint[] constraintArray = table2.getConstraints();
            int n2 = constraintArray.length;
            for (n = 0; n < n2; ++n) {
                constraint = constraintArray[n];
                if (constraint.getConstraintType() != 0 || !this.isAccessibleTable(session, constraint.getRef())) continue;
                hsqlArrayList.add(constraint);
            }
        }
        for (n = 0; n < hsqlArrayList.size(); ++n) {
            constraint = (Constraint)hsqlArrayList.get(n);
            Table table3 = constraint.getMain();
            String string = table3.getName().name;
            Table table4 = constraint.getRef();
            String string2 = table4.getName().name;
            String string3 = table3.getCatalogName().name;
            String string4 = table3.getSchemaName().name;
            String string5 = table4.getCatalogName().name;
            String string6 = table4.getSchemaName().name;
            int[] nArray = constraint.getMainColumns();
            int[] nArray2 = constraint.getRefColumns();
            int n3 = nArray2.length;
            String string7 = constraint.getRefName().name;
            String string8 = constraint.getUniqueName().name;
            Integer n4 = ValuePool.getInt(constraint.getDeferability());
            Integer n5 = ValuePool.getInt(constraint.getDeleteAction());
            Integer n6 = ValuePool.getInt(constraint.getUpdateAction());
            for (int i = 0; i < n3; ++i) {
                Integer n7 = ValuePool.getInt(i + 1);
                String string9 = table3.getColumn(nArray[i]).getNameString();
                String string10 = table4.getColumn(nArray2[i]).getNameString();
                Object[] objectArray = table.getEmptyRowData();
                objectArray[0] = string3;
                objectArray[1] = string4;
                objectArray[2] = string;
                objectArray[3] = string9;
                objectArray[4] = string5;
                objectArray[5] = string6;
                objectArray[6] = string2;
                objectArray[7] = string10;
                objectArray[8] = n7;
                objectArray[9] = n6;
                objectArray[10] = n5;
                objectArray[11] = string7;
                objectArray[12] = string8;
                objectArray[13] = n4;
                table.insertSys(session, persistentStore, objectArray);
            }
        }
        return table;
    }

    final Table SYSTEM_INDEXINFO(Session session, PersistentStore persistentStore) {
        Table table = this.sysTables[3];
        if (table == null) {
            table = this.createBlankTable(sysTableHsqlNames[3]);
            this.addColumn(table, "TABLE_CAT", SQL_IDENTIFIER);
            this.addColumn(table, "TABLE_SCHEM", SQL_IDENTIFIER);
            this.addColumn(table, "TABLE_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "NON_UNIQUE", Type.SQL_BOOLEAN);
            this.addColumn(table, "INDEX_QUALIFIER", SQL_IDENTIFIER);
            this.addColumn(table, "INDEX_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "TYPE", Type.SQL_SMALLINT);
            this.addColumn(table, "ORDINAL_POSITION", Type.SQL_SMALLINT);
            this.addColumn(table, "COLUMN_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "ASC_OR_DESC", CHARACTER_DATA);
            this.addColumn(table, "CARDINALITY", Type.SQL_INTEGER);
            this.addColumn(table, "PAGES", Type.SQL_INTEGER);
            this.addColumn(table, "FILTER_CONDITION", CHARACTER_DATA);
            this.addColumn(table, "ROW_CARDINALITY", Type.SQL_INTEGER);
            HsqlNameManager.HsqlName hsqlName = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationMain.sysTableHsqlNames[3].name, false, 20);
            table.createPrimaryKeyConstraint(hsqlName, new int[]{0, 1, 2, 3, 4, 5, 7, 8}, false);
            return table;
        }
        Iterator iterator = this.database.schemaManager.databaseObjectIterator(3);
        while (iterator.hasNext()) {
            Table table2 = (Table)iterator.next();
            if (table2.isView() || !this.isAccessibleTable(session, table2)) continue;
            String string = table2.getCatalogName().name;
            String string2 = table2.getSchemaName().name;
            String string3 = table2.getName().name;
            Object var13_15 = null;
            String string4 = string;
            int n = table2.getIndexCount();
            for (int i = 0; i < n; ++i) {
                Index index = table2.getIndex(i);
                int n2 = table2.getIndex(i).getColumnCount();
                if (n2 < 1) continue;
                String string5 = index.getName().name;
                Boolean bl = index.isUnique() ? Boolean.FALSE : Boolean.TRUE;
                Object var11_13 = null;
                Integer n3 = ValuePool.INTEGER_0;
                Object var14_16 = null;
                int[] nArray = index.getColumns();
                Integer n4 = ValuePool.getInt(3);
                for (int j = 0; j < n2; ++j) {
                    int n5 = nArray[j];
                    Object[] objectArray = table.getEmptyRowData();
                    objectArray[0] = string;
                    objectArray[1] = string2;
                    objectArray[2] = string3;
                    objectArray[3] = bl;
                    objectArray[4] = string4;
                    objectArray[5] = string5;
                    objectArray[6] = n4;
                    objectArray[7] = ValuePool.getInt(j + 1);
                    objectArray[8] = table2.getColumn((int)nArray[j]).getName().name;
                    objectArray[9] = "A";
                    objectArray[10] = var11_13;
                    objectArray[11] = n3;
                    objectArray[13] = var14_16;
                    objectArray[12] = var13_15;
                    table.insertSys(session, persistentStore, objectArray);
                }
            }
        }
        return table;
    }

    final Table SYSTEM_PRIMARYKEYS(Session session, PersistentStore persistentStore) {
        Table table = this.sysTables[4];
        if (table == null) {
            table = this.createBlankTable(sysTableHsqlNames[4]);
            this.addColumn(table, "TABLE_CAT", SQL_IDENTIFIER);
            this.addColumn(table, "TABLE_SCHEM", SQL_IDENTIFIER);
            this.addColumn(table, "TABLE_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "COLUMN_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "KEY_SEQ", Type.SQL_SMALLINT);
            this.addColumn(table, "PK_NAME", SQL_IDENTIFIER);
            HsqlNameManager.HsqlName hsqlName = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationMain.sysTableHsqlNames[4].name, false, 20);
            table.createPrimaryKeyConstraint(hsqlName, new int[]{3, 2, 1, 0}, false);
            return table;
        }
        HsqlDatabaseProperties hsqlDatabaseProperties = this.database.getProperties();
        Iterator iterator = this.database.schemaManager.databaseObjectIterator(3);
        while (iterator.hasNext()) {
            Table table2 = (Table)iterator.next();
            if (table2.isView() || !this.isAccessibleTable(session, table2) || !table2.hasPrimaryKey()) continue;
            Constraint constraint = table2.getPrimaryConstraint();
            String string = table2.getCatalogName().name;
            String string2 = table2.getSchemaName().name;
            String string3 = table2.getName().name;
            String string4 = constraint.getName().name;
            int[] nArray = constraint.getMainColumns();
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                Object[] objectArray = table.getEmptyRowData();
                objectArray[0] = string;
                objectArray[1] = string2;
                objectArray[2] = string3;
                objectArray[3] = table2.getColumn((int)nArray[i]).getName().name;
                objectArray[4] = ValuePool.getInt(i + 1);
                objectArray[5] = string4;
                table.insertSys(session, persistentStore, objectArray);
            }
        }
        return table;
    }

    Table SYSTEM_PROCEDURECOLUMNS(Session session, PersistentStore persistentStore) {
        Table table = this.sysTables[5];
        if (table == null) {
            table = this.createBlankTable(sysTableHsqlNames[5]);
            this.addColumn(table, "PROCEDURE_CAT", SQL_IDENTIFIER);
            this.addColumn(table, "PROCEDURE_SCHEM", SQL_IDENTIFIER);
            this.addColumn(table, "PROCEDURE_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "COLUMN_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "COLUMN_TYPE", Type.SQL_SMALLINT);
            this.addColumn(table, "DATA_TYPE", Type.SQL_SMALLINT);
            this.addColumn(table, "TYPE_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "PRECISION", Type.SQL_INTEGER);
            this.addColumn(table, "LENGTH", Type.SQL_INTEGER);
            this.addColumn(table, "SCALE", Type.SQL_SMALLINT);
            this.addColumn(table, "RADIX", Type.SQL_SMALLINT);
            this.addColumn(table, "NULLABLE", Type.SQL_SMALLINT);
            this.addColumn(table, "REMARKS", CHARACTER_DATA);
            this.addColumn(table, "COLUMN_DEF", CHARACTER_DATA);
            this.addColumn(table, "SQL_DATA_TYPE", Type.SQL_INTEGER);
            this.addColumn(table, "SQL_DATETIME_SUB", Type.SQL_INTEGER);
            this.addColumn(table, "CHAR_OCTET_LENGTH", Type.SQL_INTEGER);
            this.addColumn(table, "ORDINAL_POSITION", Type.SQL_INTEGER);
            this.addColumn(table, "IS_NULLABLE", CHARACTER_DATA);
            this.addColumn(table, "SPECIFIC_NAME", SQL_IDENTIFIER);
            HsqlNameManager.HsqlName hsqlName = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationMain.sysTableHsqlNames[5].name, false, 20);
            table.createPrimaryKeyConstraint(hsqlName, new int[]{0, 1, 2, 19, 17}, false);
            return table;
        }
        boolean bl = this.database.sqlTranslateTTI;
        Iterator iterator = this.database.schemaManager.databaseObjectIterator(18);
        while (iterator.hasNext()) {
            RoutineSchema routineSchema = (RoutineSchema)iterator.next();
            if (!session.getGrantee().isAccessible(routineSchema)) continue;
            Routine[] routineArray = routineSchema.getSpecificRoutines();
            for (int i = 0; i < routineArray.length; ++i) {
                Routine routine = routineArray[i];
                int n = routine.getParameterCount();
                for (int j = 0; j < n; ++j) {
                    ColumnSchema columnSchema = routine.getParameter(j);
                    Object[] objectArray = table.getEmptyRowData();
                    Type type = columnSchema.getDataType();
                    if (bl) {
                        if (type.isIntervalType()) {
                            type = ((IntervalType)type).getCharacterType();
                        } else if (type.isDateTimeTypeWithZone()) {
                            type = ((DateTimeType)type).getDateTimeTypeWithoutZone();
                        }
                    }
                    objectArray[0] = this.database.getCatalogName().name;
                    objectArray[1] = routine.getSchemaName().name;
                    objectArray[19] = routine.getSpecificName().name;
                    objectArray[2] = routine.getName().name;
                    objectArray[3] = columnSchema.getName().name;
                    objectArray[17] = ValuePool.getInt(j + 1);
                    objectArray[4] = ValuePool.getInt(columnSchema.getParameterMode());
                    objectArray[6] = type.getFullNameString();
                    objectArray[5] = ValuePool.getInt(type.getJDBCTypeCode());
                    objectArray[7] = ValuePool.INTEGER_0;
                    objectArray[16] = ValuePool.INTEGER_0;
                    if (type.isCharacterType()) {
                        objectArray[7] = ValuePool.getInt(type.getJDBCPrecision());
                        objectArray[16] = ValuePool.getInt(type.getJDBCPrecision());
                    }
                    if (type.isBinaryType()) {
                        objectArray[7] = ValuePool.getInt(type.getJDBCPrecision());
                        objectArray[16] = ValuePool.getInt(type.getJDBCPrecision());
                    }
                    if (type.isNumberType()) {
                        objectArray[7] = ValuePool.getInt(((NumberType)type).getNumericPrecisionInRadix());
                        objectArray[10] = ValuePool.getLong(type.getPrecisionRadix());
                        if (type.isExactNumberType()) {
                            objectArray[9] = ValuePool.getLong(type.scale);
                        }
                    }
                    if (type.isDateTimeType()) {
                        int n2 = columnSchema.getDataType().displaySize();
                        objectArray[7] = ValuePool.getInt(n2);
                    }
                    objectArray[14] = ValuePool.getInt(columnSchema.getDataType().typeCode);
                    objectArray[11] = ValuePool.getInt(columnSchema.getNullability());
                    objectArray[18] = columnSchema.isNullable() ? "YES" : "NO";
                    table.insertSys(session, persistentStore, objectArray);
                }
            }
        }
        return table;
    }

    Table SYSTEM_PROCEDURES(Session session, PersistentStore persistentStore) {
        Table table = this.sysTables[6];
        if (table == null) {
            table = this.createBlankTable(sysTableHsqlNames[6]);
            this.addColumn(table, "PROCEDURE_CAT", SQL_IDENTIFIER);
            this.addColumn(table, "PROCEDURE_SCHEM", SQL_IDENTIFIER);
            this.addColumn(table, "PROCEDURE_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "COL_4", Type.SQL_INTEGER);
            this.addColumn(table, "COL_5", Type.SQL_INTEGER);
            this.addColumn(table, "COL_6", Type.SQL_INTEGER);
            this.addColumn(table, "REMARKS", CHARACTER_DATA);
            this.addColumn(table, "PROCEDURE_TYPE", Type.SQL_SMALLINT);
            this.addColumn(table, "SPECIFIC_NAME", SQL_IDENTIFIER);
            HsqlNameManager.HsqlName hsqlName = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationMain.sysTableHsqlNames[6].name, false, 20);
            table.createPrimaryKeyConstraint(hsqlName, new int[]{0, 1, 2, 8}, false);
            return table;
        }
        Iterator iterator = this.database.schemaManager.databaseObjectIterator(24);
        while (iterator.hasNext()) {
            Routine routine = (Routine)iterator.next();
            Object[] objectArray = table.getEmptyRowData();
            objectArray[0] = this.database.getCatalogName().name;
            objectArray[1] = routine.getSchemaName().name;
            objectArray[2] = routine.getName().name;
            objectArray[6] = routine.getName().comment;
            objectArray[7] = routine.isProcedure() ? ValuePool.INTEGER_1 : ValuePool.INTEGER_2;
            objectArray[8] = routine.getSpecificName().name;
            table.insertSys(session, persistentStore, objectArray);
        }
        return table;
    }

    final Table SYSTEM_CONNECTION_PROPERTIES(Session session, PersistentStore persistentStore) {
        Table table = this.sysTables[18];
        if (table == null) {
            table = this.createBlankTable(sysTableHsqlNames[18]);
            this.addColumn(table, "NAME", SQL_IDENTIFIER);
            this.addColumn(table, "MAX_LEN", Type.SQL_INTEGER);
            this.addColumn(table, "DEFAULT_VALUE", SQL_IDENTIFIER);
            this.addColumn(table, "DESCRIPTION", SQL_IDENTIFIER);
            HsqlNameManager.HsqlName hsqlName = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationMain.sysTableHsqlNames[18].name, false, 20);
            table.createPrimaryKeyConstraint(hsqlName, new int[]{0}, true);
            return table;
        }
        Iterator iterator = HsqlDatabaseProperties.getPropertiesMetaIterator();
        while (iterator.hasNext()) {
            Object[] objectArray = (Object[])iterator.next();
            int n = (Integer)objectArray[1];
            if (n == 1) {
                if (!"readonly".equals(objectArray[0]) && !"files_readonly".equals(objectArray[0])) continue;
            } else if (n != 2) continue;
            Object[] objectArray2 = table.getEmptyRowData();
            Object object = objectArray[4];
            objectArray2[0] = objectArray[0];
            objectArray2[1] = ValuePool.getInt(8);
            objectArray2[2] = object == null ? null : object.toString();
            objectArray2[3] = "see HyperSQL guide";
            table.insertSys(session, persistentStore, objectArray2);
        }
        return table;
    }

    protected void addProcRows(Session session, Table table, HsqlArrayList hsqlArrayList, String string, String string2, String string3, Integer n, Integer n2, Integer n3, String string4, Integer n4, String string5, String string6) {
        PersistentStore persistentStore = table.getRowStore(session);
        Object[] objectArray = table.getEmptyRowData();
        objectArray[0] = string;
        objectArray[1] = string2;
        objectArray[2] = string3;
        objectArray[3] = n;
        objectArray[4] = n2;
        objectArray[5] = n3;
        objectArray[6] = string4;
        objectArray[7] = n4;
        objectArray[9] = string6;
        objectArray[8] = string5;
        table.insertSys(session, persistentStore, objectArray);
        if (hsqlArrayList != null) {
            int n5 = hsqlArrayList.size();
            for (int i = 0; i < n5; ++i) {
                objectArray = table.getEmptyRowData();
                string3 = (String)hsqlArrayList.get(i);
                objectArray[0] = string;
                objectArray[1] = string2;
                objectArray[2] = string3;
                objectArray[3] = n;
                objectArray[4] = n2;
                objectArray[5] = n3;
                objectArray[6] = string4;
                objectArray[7] = n4;
                objectArray[9] = "ALIAS";
                objectArray[8] = string5;
                table.insertSys(session, persistentStore, objectArray);
            }
        }
    }

    protected void addPColRows(Session session, Table table, HsqlArrayList hsqlArrayList, String string, String string2, String string3, String string4, Integer n, Integer n2, String string5, Integer n3, Integer n4, Integer n5, Integer n6, Integer n7, String string6, String string7, Integer n8, Integer n9, Integer n10, Integer n11, String string8, String string9) {
        PersistentStore persistentStore = table.getRowStore(session);
        Object[] objectArray = table.getEmptyRowData();
        objectArray[0] = string;
        objectArray[1] = string2;
        objectArray[2] = string3;
        objectArray[3] = string4;
        objectArray[4] = n;
        objectArray[5] = n2;
        objectArray[6] = string5;
        objectArray[7] = n3;
        objectArray[8] = n4;
        objectArray[9] = n5;
        objectArray[10] = n6;
        objectArray[11] = n7;
        objectArray[12] = string6;
        objectArray[13] = string7;
        objectArray[14] = n8;
        objectArray[15] = n9;
        objectArray[16] = n10;
        objectArray[17] = n11;
        objectArray[18] = string8;
        objectArray[19] = string9;
        table.insertSys(session, persistentStore, objectArray);
        if (hsqlArrayList != null) {
            int n12 = hsqlArrayList.size();
            for (int i = 0; i < n12; ++i) {
                objectArray = table.getEmptyRowData();
                string3 = (String)hsqlArrayList.get(i);
                objectArray[0] = string;
                objectArray[1] = string2;
                objectArray[2] = string3;
                objectArray[3] = string4;
                objectArray[4] = n;
                objectArray[5] = n2;
                objectArray[6] = string5;
                objectArray[7] = n3;
                objectArray[8] = n4;
                objectArray[9] = n5;
                objectArray[10] = n6;
                objectArray[11] = n7;
                objectArray[12] = string6;
                objectArray[13] = string7;
                objectArray[14] = n8;
                objectArray[15] = n9;
                objectArray[16] = n10;
                objectArray[17] = n11;
                objectArray[18] = string8;
                objectArray[19] = string9;
                table.insertSys(session, persistentStore, objectArray);
            }
        }
    }

    final Table SYSTEM_SCHEMAS(Session session, PersistentStore persistentStore) {
        Table table = this.sysTables[7];
        if (table == null) {
            table = this.createBlankTable(sysTableHsqlNames[7]);
            this.addColumn(table, "TABLE_SCHEM", SQL_IDENTIFIER);
            this.addColumn(table, "TABLE_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "IS_DEFAULT", Type.SQL_BOOLEAN);
            HsqlNameManager.HsqlName hsqlName = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationMain.sysTableHsqlNames[7].name, false, 20);
            table.createPrimaryKeyConstraint(hsqlName, new int[]{0}, true);
            return table;
        }
        String[] stringArray = this.database.schemaManager.getSchemaNamesArray();
        String string = this.database.schemaManager.getDefaultSchemaHsqlName().name;
        for (int i = 0; i < stringArray.length; ++i) {
            Object[] objectArray = table.getEmptyRowData();
            String string2 = stringArray[i];
            objectArray[0] = string2;
            objectArray[1] = this.database.getCatalogName().name;
            objectArray[2] = string2.equals(string) ? Boolean.TRUE : Boolean.FALSE;
            table.insertSys(session, persistentStore, objectArray);
        }
        return table;
    }

    final Table SYSTEM_TABLES(Session session, PersistentStore persistentStore) {
        Table table = this.sysTables[8];
        if (table == null) {
            table = this.createBlankTable(sysTableHsqlNames[8]);
            this.addColumn(table, "TABLE_CAT", SQL_IDENTIFIER);
            this.addColumn(table, "TABLE_SCHEM", SQL_IDENTIFIER);
            this.addColumn(table, "TABLE_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "TABLE_TYPE", CHARACTER_DATA);
            this.addColumn(table, "REMARKS", CHARACTER_DATA);
            this.addColumn(table, "TYPE_CAT", SQL_IDENTIFIER);
            this.addColumn(table, "TYPE_SCHEM", SQL_IDENTIFIER);
            this.addColumn(table, "TYPE_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "SELF_REFERENCING_COL_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "REF_GENERATION", CHARACTER_DATA);
            this.addColumn(table, "HSQLDB_TYPE", SQL_IDENTIFIER);
            this.addColumn(table, "READ_ONLY", Type.SQL_BOOLEAN);
            this.addColumn(table, "COMMIT_ACTION", CHARACTER_DATA);
            HsqlNameManager.HsqlName hsqlName = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationMain.sysTableHsqlNames[8].name, false, 20);
            table.createPrimaryKeyConstraint(hsqlName, new int[]{3, 1, 2, 0}, false);
            return table;
        }
        Iterator iterator = this.allTables();
        DITableInfo dITableInfo = new DITableInfo();
        while (iterator.hasNext()) {
            Table table2 = (Table)iterator.next();
            if (!this.isAccessibleTable(session, table2)) continue;
            dITableInfo.setTable(table2);
            Object[] objectArray = table.getEmptyRowData();
            objectArray[0] = this.database.getCatalogName().name;
            objectArray[1] = table2.getSchemaName().name;
            objectArray[2] = table2.getName().name;
            objectArray[3] = dITableInfo.getJDBCStandardType();
            objectArray[4] = dITableInfo.getRemark();
            objectArray[10] = dITableInfo.getHsqlType();
            Object object = objectArray[11] = table2.isDataReadOnly() ? Boolean.TRUE : Boolean.FALSE;
            objectArray[12] = table2.isTemp() ? (table2.onCommitPreserve() ? "PRESERVE" : "DELETE") : null;
            table.insertSys(session, persistentStore, objectArray);
        }
        return table;
    }

    Table SYSTEM_TABLETYPES(Session session, PersistentStore persistentStore) {
        Table table = this.sysTables[9];
        if (table == null) {
            table = this.createBlankTable(sysTableHsqlNames[9]);
            this.addColumn(table, "TABLE_TYPE", SQL_IDENTIFIER);
            HsqlNameManager.HsqlName hsqlName = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationMain.sysTableHsqlNames[9].name, false, 20);
            table.createPrimaryKeyConstraint(hsqlName, new int[]{0}, true);
            return table;
        }
        for (int i = 0; i < tableTypes.length; ++i) {
            Object[] objectArray = table.getEmptyRowData();
            objectArray[0] = tableTypes[i];
            table.insertSys(session, persistentStore, objectArray);
        }
        return table;
    }

    final Table SYSTEM_TYPEINFO(Session session, PersistentStore persistentStore) {
        Object[] objectArray;
        Table table = this.sysTables[10];
        if (table == null) {
            table = this.createBlankTable(sysTableHsqlNames[10]);
            this.addColumn(table, "TYPE_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "DATA_TYPE", Type.SQL_SMALLINT);
            this.addColumn(table, "PRECISION", Type.SQL_INTEGER);
            this.addColumn(table, "LITERAL_PREFIX", CHARACTER_DATA);
            this.addColumn(table, "LITERAL_SUFFIX", CHARACTER_DATA);
            this.addColumn(table, "CREATE_PARAMS", CHARACTER_DATA);
            this.addColumn(table, "NULLABLE", Type.SQL_SMALLINT);
            this.addColumn(table, "CASE_SENSITIVE", Type.SQL_BOOLEAN);
            this.addColumn(table, "SEARCHABLE", Type.SQL_INTEGER);
            this.addColumn(table, "UNSIGNED_ATTRIBUTE", Type.SQL_BOOLEAN);
            this.addColumn(table, "FIXED_PREC_SCALE", Type.SQL_BOOLEAN);
            this.addColumn(table, "AUTO_INCREMENT", Type.SQL_BOOLEAN);
            this.addColumn(table, "LOCAL_TYPE_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "MINIMUM_SCALE", Type.SQL_SMALLINT);
            this.addColumn(table, "MAXIMUM_SCALE", Type.SQL_SMALLINT);
            this.addColumn(table, "SQL_DATA_TYPE", Type.SQL_INTEGER);
            this.addColumn(table, "SQL_DATETIME_SUB", Type.SQL_INTEGER);
            this.addColumn(table, "NUM_PREC_RADIX", Type.SQL_INTEGER);
            this.addColumn(table, "INTERVAL_PRECISION", Type.SQL_INTEGER);
            HsqlNameManager.HsqlName hsqlName = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationMain.sysTableHsqlNames[10].name, false, 20);
            table.createPrimaryKeyConstraint(hsqlName, new int[]{1, 0}, true);
            return table;
        }
        Iterator iterator = Type.typeNames.keySet().iterator();
        boolean bl = this.database.sqlTranslateTTI;
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            int n = Type.typeNames.get(string);
            Type type = Type.getDefaultType(n);
            if (type == null) continue;
            if (bl) {
                if (type.isIntervalType()) {
                    type = ((IntervalType)type).getCharacterType();
                } else if (type.isDateTimeTypeWithZone()) {
                    type = ((DateTimeType)type).getDateTimeTypeWithoutZone();
                }
            }
            objectArray = table.getEmptyRowData();
            objectArray[0] = string;
            objectArray[1] = ValuePool.getInt(type.getJDBCTypeCode());
            long l = type.getMaxPrecision();
            Object object = objectArray[2] = l > Integer.MAX_VALUE ? ValuePool.INTEGER_MAX : ValuePool.getInt((int)l);
            if (type.isBinaryType() || type.isCharacterType() || type.isDateTimeType() || type.isIntervalType()) {
                objectArray[3] = "'";
                objectArray[4] = "'";
            }
            if (type.acceptsPrecision() && type.acceptsScale()) {
                objectArray[5] = "PRECISION,SCALE";
            } else if (type.acceptsPrecision()) {
                objectArray[5] = type.isNumberType() ? "PRECISION" : "LENGTH";
            } else if (type.acceptsScale()) {
                objectArray[5] = "SCALE";
            }
            objectArray[6] = ValuePool.INTEGER_1;
            Object object2 = objectArray[7] = type.isCharacterType() && type.getCollation().isCaseSensitive() ? Boolean.TRUE : Boolean.FALSE;
            objectArray[8] = type.isLobType() ? ValuePool.INTEGER_0 : (type.isCharacterType() || type.isBinaryType() && !type.isBitType() ? ValuePool.getInt(3) : ValuePool.getInt(2));
            objectArray[9] = Boolean.FALSE;
            objectArray[10] = type.typeCode == 2 || type.typeCode == 3 ? Boolean.TRUE : Boolean.FALSE;
            objectArray[11] = type.isIntegralType() ? Boolean.TRUE : Boolean.FALSE;
            objectArray[12] = null;
            objectArray[13] = ValuePool.INTEGER_0;
            objectArray[14] = ValuePool.getInt(type.getMaxScale());
            objectArray[15] = null;
            objectArray[16] = null;
            objectArray[17] = ValuePool.getInt(type.getPrecisionRadix());
            if (type.isIntervalType()) {
                objectArray[18] = null;
            }
            table.insertSys(session, persistentStore, objectArray);
        }
        objectArray = table.getEmptyRowData();
        objectArray[0] = "DISTINCT";
        objectArray[1] = ValuePool.getInt(2001);
        return table;
    }

    Table SYSTEM_UDTS(Session session, PersistentStore persistentStore) {
        Table table = this.sysTables[11];
        if (table == null) {
            table = this.createBlankTable(sysTableHsqlNames[11]);
            this.addColumn(table, "TYPE_CAT", SQL_IDENTIFIER);
            this.addColumn(table, "TYPE_SCHEM", SQL_IDENTIFIER);
            this.addColumn(table, "TYPE_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "CLASS_NAME", CHARACTER_DATA);
            this.addColumn(table, "DATA_TYPE", Type.SQL_INTEGER);
            this.addColumn(table, "REMARKS", CHARACTER_DATA);
            this.addColumn(table, "BASE_TYPE", Type.SQL_SMALLINT);
            HsqlNameManager.HsqlName hsqlName = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationMain.sysTableHsqlNames[11].name, false, 20);
            table.createPrimaryKeyConstraint(hsqlName, null, false);
            return table;
        }
        boolean bl = this.database.sqlTranslateTTI;
        Iterator iterator = this.database.schemaManager.databaseObjectIterator(12);
        while (iterator.hasNext()) {
            Type type = (Type)iterator.next();
            if (!type.isDistinctType()) continue;
            Object[] objectArray = table.getEmptyRowData();
            Type type2 = type;
            if (bl) {
                if (type2.isIntervalType()) {
                    type2 = ((IntervalType)type2).getCharacterType();
                } else if (type2.isDateTimeTypeWithZone()) {
                    type2 = ((DateTimeType)type2).getDateTimeTypeWithoutZone();
                }
            }
            objectArray[0] = this.database.getCatalogName().name;
            objectArray[1] = type.getSchemaName().name;
            objectArray[2] = type.getName().name;
            objectArray[3] = type2.getJDBCClassName();
            objectArray[4] = ValuePool.getInt(2001);
            objectArray[5] = null;
            objectArray[6] = ValuePool.getInt(type2.getJDBCTypeCode());
            table.insertSys(session, persistentStore, objectArray);
        }
        return table;
    }

    Table SYSTEM_VERSIONCOLUMNS(Session session, PersistentStore persistentStore) {
        Table table = this.sysTables[13];
        if (table == null) {
            table = this.createBlankTable(sysTableHsqlNames[13]);
            this.addColumn(table, "SCOPE", Type.SQL_INTEGER);
            this.addColumn(table, "COLUMN_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "DATA_TYPE", Type.SQL_SMALLINT);
            this.addColumn(table, "TYPE_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "COLUMN_SIZE", Type.SQL_SMALLINT);
            this.addColumn(table, "BUFFER_LENGTH", Type.SQL_INTEGER);
            this.addColumn(table, "DECIMAL_DIGITS", Type.SQL_SMALLINT);
            this.addColumn(table, "PSEUDO_COLUMN", Type.SQL_SMALLINT);
            this.addColumn(table, "TABLE_CAT", SQL_IDENTIFIER);
            this.addColumn(table, "TABLE_SCHEM", SQL_IDENTIFIER);
            this.addColumn(table, "TABLE_NAME", SQL_IDENTIFIER);
            HsqlNameManager.HsqlName hsqlName = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationMain.sysTableHsqlNames[13].name, false, 20);
            table.createPrimaryKeyConstraint(hsqlName, null, false);
            return table;
        }
        return table;
    }

    Table SYSTEM_USERS(Session session, PersistentStore persistentStore) {
        Table table = this.sysTables[12];
        if (table == null) {
            table = this.createBlankTable(sysTableHsqlNames[12]);
            this.addColumn(table, "USER_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "ADMIN", Type.SQL_BOOLEAN);
            this.addColumn(table, "INITIAL_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "AUTHENTICATION", SQL_IDENTIFIER);
            this.addColumn(table, "PASSWORD_DIGEST", SQL_IDENTIFIER);
            HsqlNameManager.HsqlName hsqlName = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationMain.sysTableHsqlNames[12].name, false, 20);
            table.createPrimaryKeyConstraint(hsqlName, new int[]{0}, true);
            return table;
        }
        HsqlArrayList hsqlArrayList = this.database.getUserManager().listVisibleUsers(session);
        for (int i = 0; i < hsqlArrayList.size(); ++i) {
            Object[] objectArray = table.getEmptyRowData();
            User user = (User)hsqlArrayList.get(i);
            HsqlNameManager.HsqlName hsqlName = user.getInitialSchema();
            objectArray[0] = user.getName().getNameString();
            objectArray[1] = user.isAdmin() ? Boolean.TRUE : Boolean.FALSE;
            Object object = objectArray[2] = hsqlName == null ? null : hsqlName.name;
            objectArray[3] = user.isLocalOnly ? "LOCAL" : (user.isExternalOnly ? "EXTERNAL" : "ANY");
            objectArray[4] = user.getPasswordDigest();
            table.insertSys(session, persistentStore, objectArray);
        }
        return table;
    }

    final Table COLUMN_PRIVILEGES(Session session, PersistentStore persistentStore) {
        Table table = this.sysTables[35];
        if (table == null) {
            table = this.createBlankTable(sysTableHsqlNames[35]);
            this.addColumn(table, "GRANTOR", SQL_IDENTIFIER);
            this.addColumn(table, "GRANTEE", SQL_IDENTIFIER);
            this.addColumn(table, "TABLE_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "TABLE_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "TABLE_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "COLUMN_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "PRIVILEGE_TYPE", CHARACTER_DATA);
            this.addColumn(table, "IS_GRANTABLE", YES_OR_NO);
            HsqlNameManager.HsqlName hsqlName = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationMain.sysTableHsqlNames[35].name, false, 20);
            table.createPrimaryKeyConstraint(hsqlName, new int[]{2, 3, 4, 5, 6, 1, 0}, false);
            return table;
        }
        OrderedHashSet orderedHashSet = session.getGrantee().getGranteeAndAllRolesWithPublic();
        Iterator iterator = this.allTables();
        while (iterator.hasNext()) {
            Table table2 = (Table)iterator.next();
            String string = table2.getName().name;
            String string2 = this.database.getCatalogName().name;
            String string3 = table2.getSchemaName().name;
            for (int i = 0; i < orderedHashSet.size(); ++i) {
                Grantee grantee = (Grantee)orderedHashSet.get(i);
                OrderedHashSet orderedHashSet2 = grantee.getAllDirectPrivileges(table2);
                OrderedHashSet orderedHashSet3 = grantee.getAllGrantedPrivileges(table2);
                if (!orderedHashSet3.isEmpty()) {
                    orderedHashSet3.addAll(orderedHashSet2);
                    orderedHashSet2 = orderedHashSet3;
                }
                for (int j = 0; j < orderedHashSet2.size(); ++j) {
                    Right right = (Right)orderedHashSet2.get(j);
                    Right right2 = right.getGrantableRights();
                    for (int k = 0; k < Right.privilegeTypes.length; ++k) {
                        OrderedHashSet orderedHashSet4 = right.getColumnsForPrivilege(table2, Right.privilegeTypes[k]);
                        OrderedHashSet orderedHashSet5 = right2.getColumnsForPrivilege(table2, Right.privilegeTypes[k]);
                        for (int i2 = 0; i2 < orderedHashSet4.size(); ++i2) {
                            HsqlNameManager.HsqlName hsqlName = (HsqlNameManager.HsqlName)orderedHashSet4.get(i2);
                            Object[] objectArray = table.getEmptyRowData();
                            objectArray[0] = right.getGrantor().getName().name;
                            objectArray[1] = right.getGrantee().getName().name;
                            objectArray[2] = string2;
                            objectArray[3] = string3;
                            objectArray[4] = string;
                            objectArray[5] = hsqlName.name;
                            objectArray[6] = Right.privilegeNames[k];
                            objectArray[7] = right.getGrantee() == table2.getOwner() || orderedHashSet5.contains(hsqlName) ? "YES" : "NO";
                            try {
                                table.insertSys(session, persistentStore, objectArray);
                                continue;
                            }
                            catch (HsqlException hsqlException) {
                                // empty catch block
                            }
                        }
                    }
                }
            }
        }
        return table;
    }

    final Table SEQUENCES(Session session, PersistentStore persistentStore) {
        Table table = this.sysTables[71];
        if (table == null) {
            table = this.createBlankTable(sysTableHsqlNames[71]);
            this.addColumn(table, "SEQUENCE_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "SEQUENCE_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "SEQUENCE_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "DATA_TYPE", CHARACTER_DATA);
            this.addColumn(table, "NUMERIC_PRECISION", CARDINAL_NUMBER);
            this.addColumn(table, "NUMERIC_PRECISION_RADIX", CARDINAL_NUMBER);
            this.addColumn(table, "NUMERIC_SCALE", CARDINAL_NUMBER);
            this.addColumn(table, "MAXIMUM_VALUE", CHARACTER_DATA);
            this.addColumn(table, "MINIMUM_VALUE", CHARACTER_DATA);
            this.addColumn(table, "INCREMENT", CHARACTER_DATA);
            this.addColumn(table, "CYCLE_OPTION", YES_OR_NO);
            this.addColumn(table, "DECLARED_DATA_TYPE", CHARACTER_DATA);
            this.addColumn(table, "DECLARED_NUMERIC_PRECISION", CARDINAL_NUMBER);
            this.addColumn(table, "DECLARED_NUMERIC_SCALE", CARDINAL_NUMBER);
            this.addColumn(table, "START_WITH", CHARACTER_DATA);
            this.addColumn(table, "NEXT_VALUE", CHARACTER_DATA);
            HsqlNameManager.HsqlName hsqlName = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationMain.sysTableHsqlNames[71].name, false, 20);
            table.createPrimaryKeyConstraint(hsqlName, new int[]{0, 1, 2}, false);
            return table;
        }
        Iterator iterator = this.database.schemaManager.databaseObjectIterator(7);
        while (iterator.hasNext()) {
            NumberSequence numberSequence = (NumberSequence)iterator.next();
            if (!session.getGrantee().isAccessible(numberSequence)) continue;
            Object[] objectArray = table.getEmptyRowData();
            NumberType numberType = (NumberType)numberSequence.getDataType();
            int n = numberType.typeCode == 2 || numberType.typeCode == 3 ? 10 : 2;
            objectArray[0] = this.database.getCatalogName().name;
            objectArray[1] = numberSequence.getSchemaName().name;
            objectArray[2] = numberSequence.getName().name;
            objectArray[3] = numberSequence.getDataType().getFullNameString();
            objectArray[4] = ValuePool.getInt(numberType.getPrecision());
            objectArray[5] = ValuePool.getInt(n);
            objectArray[6] = ValuePool.INTEGER_0;
            objectArray[7] = String.valueOf(numberSequence.getMaxValue());
            objectArray[8] = String.valueOf(numberSequence.getMinValue());
            objectArray[9] = String.valueOf(numberSequence.getIncrement());
            objectArray[10] = numberSequence.isCycle() ? "YES" : "NO";
            objectArray[11] = objectArray[3];
            objectArray[12] = objectArray[4];
            objectArray[13] = objectArray[13];
            objectArray[14] = String.valueOf(numberSequence.getStartValue());
            objectArray[15] = String.valueOf(numberSequence.peek());
            table.insertSys(session, persistentStore, objectArray);
        }
        return table;
    }

    final Table SYSTEM_SEQUENCES(Session session, PersistentStore persistentStore) {
        Table table = this.sysTables[14];
        if (table == null) {
            table = this.createBlankTable(sysTableHsqlNames[14]);
            this.addColumn(table, "SEQUENCE_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "SEQUENCE_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "SEQUENCE_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "DATA_TYPE", CHARACTER_DATA);
            this.addColumn(table, "NUMERIC_PRECISION", CARDINAL_NUMBER);
            this.addColumn(table, "NUMERIC_PRECISION_RADIX", CARDINAL_NUMBER);
            this.addColumn(table, "NUMERIC_SCALE", CARDINAL_NUMBER);
            this.addColumn(table, "MAXIMUM_VALUE", CHARACTER_DATA);
            this.addColumn(table, "MINIMUM_VALUE", CHARACTER_DATA);
            this.addColumn(table, "INCREMENT", CHARACTER_DATA);
            this.addColumn(table, "CYCLE_OPTION", YES_OR_NO);
            this.addColumn(table, "DECLARED_DATA_TYPE", CHARACTER_DATA);
            this.addColumn(table, "DECLARED_NUMERIC_PRECISION", CARDINAL_NUMBER);
            this.addColumn(table, "DECLARED_NUMERIC_SCALE", CARDINAL_NUMBER);
            this.addColumn(table, "START_WITH", CHARACTER_DATA);
            this.addColumn(table, "NEXT_VALUE", CHARACTER_DATA);
            HsqlNameManager.HsqlName hsqlName = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationMain.sysTableHsqlNames[14].name, false, 20);
            table.createPrimaryKeyConstraint(hsqlName, new int[]{0, 1, 2}, false);
            return table;
        }
        Iterator iterator = this.database.schemaManager.databaseObjectIterator(7);
        while (iterator.hasNext()) {
            NumberSequence numberSequence = (NumberSequence)iterator.next();
            if (!session.getGrantee().isAccessible(numberSequence)) continue;
            Object[] objectArray = table.getEmptyRowData();
            NumberType numberType = (NumberType)numberSequence.getDataType();
            int n = numberType.typeCode == 2 || numberType.typeCode == 3 ? 10 : 2;
            objectArray[0] = this.database.getCatalogName().name;
            objectArray[1] = numberSequence.getSchemaName().name;
            objectArray[2] = numberSequence.getName().name;
            objectArray[3] = numberSequence.getDataType().getFullNameString();
            objectArray[4] = ValuePool.getInt(numberType.getPrecision());
            objectArray[5] = ValuePool.getInt(n);
            objectArray[6] = ValuePool.INTEGER_0;
            objectArray[7] = String.valueOf(numberSequence.getMaxValue());
            objectArray[8] = String.valueOf(numberSequence.getMinValue());
            objectArray[9] = String.valueOf(numberSequence.getIncrement());
            objectArray[10] = numberSequence.isCycle() ? "YES" : "NO";
            objectArray[11] = objectArray[3];
            objectArray[12] = objectArray[4];
            objectArray[13] = objectArray[13];
            objectArray[14] = String.valueOf(numberSequence.getStartValue());
            objectArray[15] = String.valueOf(numberSequence.peek());
            table.insertSys(session, persistentStore, objectArray);
        }
        return table;
    }

    final Table TABLE_PRIVILEGES(Session session, PersistentStore persistentStore) {
        Table table = this.sysTables[79];
        if (table == null) {
            table = this.createBlankTable(sysTableHsqlNames[79]);
            this.addColumn(table, "GRANTOR", SQL_IDENTIFIER);
            this.addColumn(table, "GRANTEE", SQL_IDENTIFIER);
            this.addColumn(table, "TABLE_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "TABLE_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "TABLE_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "PRIVILEGE_TYPE", CHARACTER_DATA);
            this.addColumn(table, "IS_GRANTABLE", YES_OR_NO);
            this.addColumn(table, "WITH_HIERARCHY", YES_OR_NO);
            HsqlNameManager.HsqlName hsqlName = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationMain.sysTableHsqlNames[79].name, false, 20);
            table.createPrimaryKeyConstraint(hsqlName, new int[]{0, 1, 2, 3, 4, 5, 6}, false);
            return table;
        }
        OrderedHashSet orderedHashSet = session.getGrantee().getGranteeAndAllRolesWithPublic();
        Iterator iterator = this.allTables();
        while (iterator.hasNext()) {
            Table table2 = (Table)iterator.next();
            String string = table2.getName().name;
            String string2 = table2.getCatalogName().name;
            String string3 = table2.getSchemaName().name;
            for (int i = 0; i < orderedHashSet.size(); ++i) {
                Grantee grantee = (Grantee)orderedHashSet.get(i);
                OrderedHashSet orderedHashSet2 = grantee.getAllDirectPrivileges(table2);
                OrderedHashSet orderedHashSet3 = grantee.getAllGrantedPrivileges(table2);
                if (!orderedHashSet3.isEmpty()) {
                    orderedHashSet3.addAll(orderedHashSet2);
                    orderedHashSet2 = orderedHashSet3;
                }
                for (int j = 0; j < orderedHashSet2.size(); ++j) {
                    Right right = (Right)orderedHashSet2.get(j);
                    Right right2 = right.getGrantableRights();
                    for (int k = 0; k < Right.privilegeTypes.length; ++k) {
                        if (!right.canAccessFully(Right.privilegeTypes[k])) continue;
                        String string4 = Right.privilegeNames[k];
                        Object[] objectArray = table.getEmptyRowData();
                        objectArray[0] = right.getGrantor().getName().name;
                        objectArray[1] = right.getGrantee().getName().name;
                        objectArray[2] = string2;
                        objectArray[3] = string3;
                        objectArray[4] = string;
                        objectArray[5] = string4;
                        objectArray[6] = right.getGrantee() == table2.getOwner() || right2.canAccessFully(Right.privilegeTypes[k]) ? "YES" : "NO";
                        objectArray[7] = "NO";
                        try {
                            table.insertSys(session, persistentStore, objectArray);
                            continue;
                        }
                        catch (HsqlException hsqlException) {
                            // empty catch block
                        }
                    }
                }
            }
        }
        return table;
    }

    Table TABLES(Session session, PersistentStore persistentStore) {
        Table table = this.sysTables[80];
        if (table == null) {
            table = this.createBlankTable(sysTableHsqlNames[80]);
            this.addColumn(table, "TABLE_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "TABLE_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "TABLE_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "TABLE_TYPE", CHARACTER_DATA);
            this.addColumn(table, "SELF_REFERENCING_COLUMN_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "REFERENCE_GENERATION", CHARACTER_DATA);
            this.addColumn(table, "USER_DEFINED_TYPE_CATALOG", SQL_IDENTIFIER);
            this.addColumn(table, "USER_DEFINED_TYPE_SCHEMA", SQL_IDENTIFIER);
            this.addColumn(table, "USER_DEFINED_TYPE_NAME", SQL_IDENTIFIER);
            this.addColumn(table, "IS_INSERTABLE_INTO", YES_OR_NO);
            this.addColumn(table, "IS_TYPED", YES_OR_NO);
            this.addColumn(table, "COMMIT_ACTION", CHARACTER_DATA);
            HsqlNameManager.HsqlName hsqlName = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationMain.sysTableHsqlNames[80].name, false, 20);
            table.createPrimaryKeyConstraint(hsqlName, new int[]{0, 1, 2}, false);
            return table;
        }
        Iterator iterator = this.allTables();
        while (iterator.hasNext()) {
            Table table2 = (Table)iterator.next();
            if (!this.isAccessibleTable(session, table2)) continue;
            Object[] objectArray = table.getEmptyRowData();
            objectArray[0] = this.database.getCatalogName().name;
            objectArray[1] = table2.getSchemaName().name;
            objectArray[2] = table2.getName().name;
            switch (table2.getTableType()) {
                case 1: 
                case 8: {
                    objectArray[3] = "VIEW";
                    objectArray[9] = table2.isInsertable() ? "YES" : "NO";
                    break;
                }
                case 3: 
                case 6: {
                    objectArray[3] = "GLOBAL TEMPORARY";
                    objectArray[9] = "YES";
                    break;
                }
                default: {
                    objectArray[3] = "BASE TABLE";
                    objectArray[9] = table2.isInsertable() ? "YES" : "NO";
                }
            }
            objectArray[4] = null;
            objectArray[5] = null;
            objectArray[6] = null;
            objectArray[7] = null;
            objectArray[8] = null;
            objectArray[10] = "NO";
            objectArray[11] = table2.isTemp() ? (table2.onCommitPreserve() ? "PRESERVE" : "DELETE") : null;
            table.insertSys(session, persistentStore, objectArray);
        }
        return table;
    }

    final Table INFORMATION_SCHEMA_CATALOG_NAME(Session session, PersistentStore persistentStore) {
        Table table = this.sysTables[45];
        if (table == null) {
            table = this.createBlankTable(sysTableHsqlNames[45]);
            this.addColumn(table, "CATALOG_NAME", SQL_IDENTIFIER);
            HsqlNameManager.HsqlName hsqlName = HsqlNameManager.newInfoSchemaObjectName(DatabaseInformationMain.sysTableHsqlNames[45].name, false, 20);
            table.createPrimaryKeyConstraint(hsqlName, new int[]{0}, true);
            return table;
        }
        Object[] objectArray = table.getEmptyRowData();
        objectArray[0] = this.database.getCatalogName().name;
        table.insertSys(session, persistentStore, objectArray);
        return table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        sysTableSessionDependent = new boolean[sysTableNames.length];
        tableTypes = new String[]{"GLOBAL TEMPORARY", "SYSTEM TABLE", "TABLE", "VIEW"};
        Class<DatabaseInformationMain> clazz = DatabaseInformationMain.class;
        synchronized (DatabaseInformationMain.class) {
            nonCachedTablesSet = new HashSet();
            sysTableHsqlNames = new HsqlNameManager.HsqlName[sysTableNames.length];
            for (int i = 0; i < sysTableNames.length; ++i) {
                DatabaseInformationMain.sysTableHsqlNames[i] = HsqlNameManager.newInfoSchemaTableName(sysTableNames[i]);
                DatabaseInformationMain.sysTableHsqlNames[i].schema = SqlInvariants.INFORMATION_SCHEMA_HSQLNAME;
                DatabaseInformationMain.sysTableSessionDependent[i] = true;
            }
            nonCachedTablesSet.add("SYSTEM_CACHEINFO");
            nonCachedTablesSet.add("SYSTEM_SESSIONINFO");
            nonCachedTablesSet.add("SYSTEM_SESSIONS");
            nonCachedTablesSet.add("SYSTEM_PROPERTIES");
            nonCachedTablesSet.add("SYSTEM_SEQUENCES");
            nonCachedTablesSet.add("SYSTEM_INDEXSTATS");
            nonCachedTablesSet.add("SYSTEM_TABLESTATS");
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }
}

