/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.resource.ResourceException;
import org.firebirdsql.gds.DatabaseParameterBuffer;
import org.firebirdsql.gds.GDS;
import org.firebirdsql.gds.GDSException;
import org.firebirdsql.gds.IscDbHandle;
import org.firebirdsql.gds.TransactionParameterBuffer;
import org.firebirdsql.gds.impl.GDSHelper;
import org.firebirdsql.jca.FBConnectionRequestInfo;
import org.firebirdsql.jca.FBLocalTransaction;
import org.firebirdsql.jca.FBManagedConnection;
import org.firebirdsql.jca.FirebirdLocalTransaction;
import org.firebirdsql.jdbc.AbstractCallableStatement;
import org.firebirdsql.jdbc.AbstractGeneratedKeysQuery;
import org.firebirdsql.jdbc.AbstractPreparedStatement;
import org.firebirdsql.jdbc.AbstractStatement;
import org.firebirdsql.jdbc.FBBlob;
import org.firebirdsql.jdbc.FBClob;
import org.firebirdsql.jdbc.FBConnection;
import org.firebirdsql.jdbc.FBDatabaseMetaData;
import org.firebirdsql.jdbc.FBDriverNotCapableException;
import org.firebirdsql.jdbc.FBEscapedParser;
import org.firebirdsql.jdbc.FBObjectListener;
import org.firebirdsql.jdbc.FBSQLException;
import org.firebirdsql.jdbc.FBSQLWarning;
import org.firebirdsql.jdbc.FBSavepoint;
import org.firebirdsql.jdbc.FBStatementFactory;
import org.firebirdsql.jdbc.FirebirdConnection;
import org.firebirdsql.jdbc.FirebirdSavepoint;
import org.firebirdsql.jdbc.InternalTransactionCoordinator;
import org.firebirdsql.jdbc.StoredProcedureMetaData;
import org.firebirdsql.jdbc.StoredProcedureMetaDataFactory;
import org.firebirdsql.util.SQLExceptionChainBuilder;

public abstract class AbstractConnection
implements FirebirdConnection {
    private boolean invalid = false;
    protected FBManagedConnection mc;
    private FBLocalTransaction localTransaction;
    private FBDatabaseMetaData metaData;
    protected final InternalTransactionCoordinator txCoordinator;
    private SQLWarning firstWarning;
    protected HashSet activeStatements = new HashSet();
    private int resultSetHoldability = 2;
    private StoredProcedureMetaData storedProcedureMetaData;
    private int savepointCounter = 0;
    private List savepoints = new LinkedList();

    public AbstractConnection(FBManagedConnection mc) {
        this.mc = mc;
        this.txCoordinator = new InternalTransactionCoordinator(this);
        FBConnectionRequestInfo cri = mc.getConnectionRequestInfo();
        this.resultSetHoldability = cri.hasArgument(138) ? 1 : 2;
    }

    public FBObjectListener.StatementListener getStatementListener() {
        return this.txCoordinator;
    }

    @Override
    public int getHoldability() throws SQLException {
        return this.resultSetHoldability;
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.resultSetHoldability = holdability;
    }

    protected void checkValidity() throws SQLException {
        if (this.invalid || this.isClosed()) {
            throw new FBSQLException("This connection is closed and cannot be used now.", "08003");
        }
    }

    void notifyStatementClosed(AbstractStatement stmt) {
        if (!this.activeStatements.remove(stmt)) {
            throw new IllegalArgumentException("Specified statement was not created by this connection.");
        }
    }

    private void freeStatements() throws SQLException {
        Set statements = (Set)this.activeStatements.clone();
        Iterator iter = statements.iterator();
        SQLExceptionChainBuilder<SQLException> chain = new SQLExceptionChainBuilder<SQLException>();
        while (iter.hasNext()) {
            try {
                AbstractStatement stmt = (AbstractStatement)iter.next();
                stmt.close();
            }
            catch (SQLException ex) {
                chain.append(ex);
            }
        }
        if (chain.hasException()) {
            throw chain.getException();
        }
    }

    public void setManagedConnection(FBManagedConnection mc) {
        if (this.mc != mc && this.metaData != null) {
            this.metaData.close();
            this.metaData = null;
        }
        this.mc = mc;
    }

    public FBManagedConnection getManagedConnection() {
        return this.mc;
    }

    public IscDbHandle getIscDBHandle() throws GDSException {
        return this.getGDSHelper().getIscDBHandle();
    }

    public GDS getInternalAPIHandler() throws SQLException {
        try {
            return this.getGDSHelper().getInternalAPIHandler();
        }
        catch (GDSException ex) {
            throw new FBSQLException(ex);
        }
    }

    public DatabaseParameterBuffer getDatabaseParameterBuffer() {
        return this.mc.getConnectionRequestInfo().getDpb();
    }

    @Override
    public void setTransactionParameters(int isolationLevel, int[] parameters) throws SQLException {
        TransactionParameterBuffer tpbParams = this.createTransactionParameterBuffer();
        for (int parameter : parameters) {
            tpbParams.addArgument(parameter);
        }
        this.setTransactionParameters(isolationLevel, tpbParams);
    }

    @Override
    public TransactionParameterBuffer getTransactionParameters(int isolationLevel) throws SQLException {
        return this.mc.getTransactionParameters(isolationLevel);
    }

    @Override
    public TransactionParameterBuffer createTransactionParameterBuffer() throws SQLException {
        return this.getInternalAPIHandler().newTransactionParameterBuffer();
    }

    @Override
    public void setTransactionParameters(int isolationLevel, TransactionParameterBuffer tpb) throws SQLException {
        if (this.mc.isManagedEnvironment()) {
            throw new FBSQLException("Cannot set transaction parameters in managed environment.");
        }
        this.mc.setTransactionParameters(isolationLevel, tpb);
    }

    @Override
    public void setTransactionParameters(TransactionParameterBuffer tpb) throws SQLException {
        try {
            if (this.getLocalTransaction().inTransaction()) {
                throw new FBSQLException("Cannot set transaction parameters when transaction is already started.");
            }
            this.mc.setTransactionParameters(tpb);
        }
        catch (ResourceException ex) {
            throw new FBSQLException(ex);
        }
    }

    @Override
    public synchronized Statement createStatement() throws SQLException {
        return this.createStatement(1003, 1007, this.resultSetHoldability);
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.prepareStatement(sql, 1003, 1007);
    }

    @Override
    public synchronized CallableStatement prepareCall(String sql) throws SQLException {
        return this.prepareCall(sql, 1003, 1007);
    }

    @Override
    public synchronized Blob createBlob() throws SQLException {
        try {
            return new FBBlob(this.getGDSHelper(), this.txCoordinator);
        }
        catch (GDSException ex) {
            throw new FBSQLException(ex);
        }
    }

    @Override
    public Clob createClob() throws SQLException {
        FBBlob blob = (FBBlob)this.createBlob();
        return new FBClob(blob);
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        DatabaseParameterBuffer dpb = this.getDatabaseParameterBuffer();
        int mode = dpb.hasArgument(134) ? 1 : 0;
        return new FBEscapedParser(mode).parse(sql);
    }

    @Override
    public synchronized void setAutoCommit(boolean autoCommit) throws SQLException {
        this.checkValidity();
        if (this.getAutoCommit() == autoCommit) {
            return;
        }
        this.txCoordinator.switchTransactionCoordinator(autoCommit);
    }

    public synchronized void setManagedEnvironment(boolean managedConnection) throws SQLException {
        this.checkValidity();
        this.txCoordinator.setTransactionCoordinator(managedConnection, true);
    }

    @Override
    public synchronized boolean getAutoCommit() throws SQLException {
        if (this.isClosed()) {
            throw new FBSQLException("You cannot getAutoCommit on an unassociated closed connection.");
        }
        return this.txCoordinator.getAutoCommit();
    }

    @Override
    public synchronized void commit() throws SQLException {
        if (this.isClosed()) {
            throw new FBSQLException("You cannot commit a closed connection.", "08003");
        }
        if (this.mc.inDistributedTransaction()) {
            throw new FBSQLException("Connection enlisted in distributed transaction", "25000");
        }
        this.txCoordinator.commit();
        this.invalidateTransactionLifetimeObjects();
    }

    @Override
    public synchronized void rollback() throws SQLException {
        if (this.isClosed()) {
            throw new FBSQLException("You cannot rollback closed connection.", "08003");
        }
        if (this.mc.inDistributedTransaction()) {
            throw new FBSQLException("Connection enlisted in distributed transaction", "25000");
        }
        this.txCoordinator.rollback();
        this.invalidateTransactionLifetimeObjects();
    }

    protected void invalidateTransactionLifetimeObjects() {
        this.invalidateSavepoints();
        this.storedProcedureMetaData = null;
    }

    @Override
    public synchronized void close() throws SQLException {
        try {
            this.freeStatements();
        }
        finally {
            if (this.mc != null) {
                if (!this.mc.inDistributedTransaction()) {
                    try {
                        this.txCoordinator.handleConnectionClose();
                    }
                    finally {
                        this.setAutoCommit(true);
                    }
                }
                this.mc.close(this);
                this.mc = null;
            }
        }
    }

    @Override
    public boolean isClosed() {
        return this.mc == null;
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        try {
            GDS gds = this.getInternalAPIHandler();
            byte[] infoRequest = new byte[]{53, 1};
            gds.iscDatabaseInfo(this.getIscDBHandle(), infoRequest, 1024);
            return true;
        }
        catch (GDSException ex) {
            return false;
        }
    }

    @Override
    public synchronized DatabaseMetaData getMetaData() throws SQLException {
        try {
            if (this.metaData == null) {
                this.metaData = new FBDatabaseMetaData(this);
            }
            return this.metaData;
        }
        catch (GDSException ex) {
            throw new FBSQLException(ex);
        }
    }

    @Override
    public synchronized void setReadOnly(boolean readOnly) throws SQLException {
        try {
            if (this.getLocalTransaction().inTransaction() && !this.mc.isManagedEnvironment()) {
                throw new FBSQLException("Calling setReadOnly(boolean) method is not allowed when transaction is already started.");
            }
            this.mc.setReadOnly(readOnly);
        }
        catch (ResourceException ex) {
            throw new FBSQLException(ex);
        }
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.mc.isReadOnly();
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.checkValidity();
    }

    @Override
    public String getCatalog() throws SQLException {
        this.checkValidity();
        return null;
    }

    @Override
    public synchronized void setTransactionIsolation(int level) throws SQLException {
        if (this.isClosed()) {
            throw new FBSQLException("Connection has being closed.", "08003");
        }
        try {
            if (!this.getAutoCommit() && !this.mc.isManagedEnvironment()) {
                this.txCoordinator.commit();
            }
            this.mc.setTransactionIsolation(level);
        }
        catch (ResourceException re) {
            throw new FBSQLException(re);
        }
    }

    @Override
    public synchronized int getTransactionIsolation() throws SQLException {
        try {
            return this.mc.getTransactionIsolation();
        }
        catch (ResourceException e) {
            throw new FBSQLException(e);
        }
    }

    @Override
    public synchronized SQLWarning getWarnings() throws SQLException {
        SQLWarning warning = this.firstWarning;
        SQLWarning iscWarning = this.getIscWarnings();
        if (warning == null) {
            warning = iscWarning;
        } else if (iscWarning != null) {
            warning.setNextWarning(iscWarning);
        }
        return warning;
    }

    @Override
    public synchronized void clearWarnings() throws SQLException {
        this.firstWarning = null;
        this.clearIscWarnings();
    }

    @Override
    public synchronized Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.createStatement(resultSetType, resultSetConcurrency, this.resultSetHoldability);
    }

    @Override
    public synchronized Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (resultSetHoldability == 1 && resultSetType == 1003) {
            this.addWarning(new FBSQLWarning("Holdable result set must be scrollable."));
            resultSetType = 1004;
        }
        if (resultSetType == 1005) {
            this.addWarning(new FBSQLWarning("Unsupported type and/or concurrency"));
            resultSetType = 1004;
        }
        this.checkHoldability(resultSetType, resultSetHoldability);
        try {
            AbstractStatement stmt = FBStatementFactory.createStatement(this.getGDSHelper(), resultSetType, resultSetConcurrency, resultSetHoldability, this.txCoordinator);
            this.activeStatements.add(stmt);
            return stmt;
        }
        catch (GDSException ex) {
            throw new FBSQLException(ex);
        }
    }

    private void checkHoldability(int resultSetType, int resultSetHoldability) throws SQLException {
        boolean notScrollable;
        boolean holdable = resultSetHoldability == 1;
        boolean bl = notScrollable = resultSetType != 1004;
        if (holdable && notScrollable) {
            throw new FBDriverNotCapableException("Holdable cursors are supported only for scrollable insensitive result sets.");
        }
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.prepareStatement(sql, resultSetType, resultSetConcurrency, this.resultSetHoldability);
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability, false, false);
    }

    protected synchronized PreparedStatement prepareMetaDataStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.prepareStatement(sql, resultSetType, resultSetConcurrency, this.resultSetHoldability, true, false);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkValidity();
        if (autoGeneratedKeys == 1) {
            this.checkAutoGeneratedKeysSupport();
        }
        GeneratedKeysQuery query = new GeneratedKeysQuery(sql, autoGeneratedKeys);
        return this.prepareStatement(query);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        this.checkValidity();
        this.checkAutoGeneratedKeysSupport();
        GeneratedKeysQuery query = new GeneratedKeysQuery(sql, columnIndexes);
        return this.prepareStatement(query);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        this.checkValidity();
        this.checkAutoGeneratedKeysSupport();
        GeneratedKeysQuery query = new GeneratedKeysQuery(sql, columnNames);
        return this.prepareStatement(query);
    }

    private PreparedStatement prepareStatement(AbstractGeneratedKeysQuery query) throws SQLException {
        if (query.generatesKeys()) {
            return this.prepareStatement(query.getQueryString(), 1003, 1007, 2, false, true);
        }
        return this.prepareStatement(query.getQueryString());
    }

    protected void checkAutoGeneratedKeysSupport() throws SQLException {
        GDSHelper gdsHelper;
        try {
            gdsHelper = this.getGDSHelper();
        }
        catch (GDSException ex) {
            throw new FBSQLException(ex);
        }
        if (gdsHelper.compareToVersion(2, 0) < 0) {
            throw new FBDriverNotCapableException("This version of Firebird does not support retrieving generated keys (support was added in Firebird 2.0)");
        }
    }

    protected synchronized PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability, boolean metaData, boolean generatedKeys) throws SQLException {
        if (resultSetHoldability == 1 && resultSetType == 1003) {
            this.addWarning(new FBSQLWarning("Holdable result set must be scrollable."));
            resultSetType = 1004;
        }
        if (resultSetType == 1005) {
            this.addWarning(new FBSQLWarning("resultSetType or resultSetConcurrency changed"));
            if (resultSetType == 1005) {
                resultSetType = 1004;
            }
        }
        this.checkHoldability(resultSetType, resultSetHoldability);
        try {
            FBObjectListener.StatementListener coordinator = this.txCoordinator;
            if (metaData) {
                coordinator = new InternalTransactionCoordinator.MetaDataTransactionCoordinator(this.txCoordinator);
            }
            InternalTransactionCoordinator blobCoordinator = metaData ? null : this.txCoordinator;
            AbstractPreparedStatement stmt = FBStatementFactory.createPreparedStatement(this.getGDSHelper(), sql, resultSetType, resultSetConcurrency, resultSetHoldability, coordinator, blobCoordinator, metaData, false, generatedKeys);
            this.activeStatements.add(stmt);
            return stmt;
        }
        catch (GDSException ex) {
            throw new FBSQLException(ex);
        }
    }

    @Override
    public synchronized CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.prepareCall(sql, resultSetType, resultSetConcurrency, this.resultSetHoldability);
    }

    @Override
    public synchronized CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (resultSetHoldability == 1 && resultSetType == 1003) {
            this.addWarning(new FBSQLWarning("Holdable result set must be scrollable."));
            resultSetType = 1004;
        }
        if (resultSetType == 1005) {
            this.addWarning(new FBSQLWarning("Scroll-sensitive result sets are not supported."));
            resultSetType = 1004;
        }
        if (resultSetConcurrency != 1007) {
            this.addWarning(new FBSQLWarning("Updatable result sets from stored procedures are not supported."));
            resultSetConcurrency = 1007;
        }
        this.checkHoldability(resultSetType, resultSetHoldability);
        if (this.storedProcedureMetaData == null) {
            this.storedProcedureMetaData = StoredProcedureMetaDataFactory.getInstance(this);
        }
        try {
            AbstractCallableStatement stmt = FBStatementFactory.createCallableStatement(this.getGDSHelper(), sql, resultSetType, resultSetConcurrency, resultSetHoldability, this.storedProcedureMetaData, this.txCoordinator, this.txCoordinator);
            this.activeStatements.add(stmt);
            return stmt;
        }
        catch (GDSException ex) {
            throw new FBSQLException(ex);
        }
    }

    public Map getTypeMap() throws SQLException {
        return new HashMap();
    }

    public void setTypeMap(Map map) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        return this.setFirebirdSavepoint();
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        return this.setFirebirdSavepoint(name);
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.rollback((FirebirdSavepoint)savepoint);
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.releaseSavepoint((FirebirdSavepoint)savepoint);
    }

    private synchronized int getNextSavepointCounter() {
        return this.savepointCounter++;
    }

    @Override
    @Deprecated
    public synchronized FirebirdSavepoint setFirebirdSavepoint() throws SQLException {
        FBSavepoint savepoint = new FBSavepoint(this.getNextSavepointCounter());
        this.setSavepoint(savepoint);
        return savepoint;
    }

    private void setSavepoint(FBSavepoint savepoint) throws SQLException {
        if (this.getAutoCommit()) {
            throw new SQLException("Connection.setSavepoint() method cannot be used in auto-commit mode.", "25000");
        }
        if (this.mc.inDistributedTransaction()) {
            throw new FBSQLException("Connection enlisted in distributed transaction", "25000");
        }
        try {
            this.txCoordinator.ensureTransaction();
            this.getGDSHelper().executeImmediate("SAVEPOINT " + savepoint.getServerSavepointId());
            this.savepoints.add(savepoint);
        }
        catch (GDSException ex) {
            throw new FBSQLException(ex);
        }
    }

    @Override
    @Deprecated
    public synchronized FirebirdSavepoint setFirebirdSavepoint(String name) throws SQLException {
        FBSavepoint savepoint = new FBSavepoint(name);
        this.setSavepoint(savepoint);
        return savepoint;
    }

    @Override
    @Deprecated
    public synchronized void rollback(FirebirdSavepoint savepoint) throws SQLException {
        if (this.getAutoCommit()) {
            throw new SQLException("Connection.setSavepoint() method cannot be used in auto-commit mode.");
        }
        if (!(savepoint instanceof FBSavepoint)) {
            throw new SQLException("Specified savepoint was not obtained from this connection.");
        }
        if (this.mc.inDistributedTransaction()) {
            throw new FBSQLException("Connection enlisted in distributed transaction", "25000");
        }
        FBSavepoint fbSavepoint = (FBSavepoint)savepoint;
        if (!fbSavepoint.isValid()) {
            throw new SQLException("Savepoint is no longer valid.");
        }
        try {
            this.getGDSHelper().executeImmediate("ROLLBACK TO " + fbSavepoint.getServerSavepointId());
        }
        catch (GDSException ex) {
            throw new FBSQLException(ex);
        }
    }

    @Override
    @Deprecated
    public synchronized void releaseSavepoint(FirebirdSavepoint savepoint) throws SQLException {
        if (this.getAutoCommit()) {
            throw new SQLException("Connection.setSavepoint() method cannot be used in auto-commit mode.");
        }
        if (!(savepoint instanceof FBSavepoint)) {
            throw new SQLException("Specified savepoint was not obtained from this connection.");
        }
        FBSavepoint fbSavepoint = (FBSavepoint)savepoint;
        if (!fbSavepoint.isValid()) {
            throw new SQLException("Savepoint is no longer valid.");
        }
        try {
            this.getGDSHelper().executeImmediate("RELEASE SAVEPOINT " + fbSavepoint.getServerSavepointId() + " ONLY");
        }
        catch (GDSException ex) {
            throw new FBSQLException(ex);
        }
        fbSavepoint.invalidate();
        this.savepoints.remove(fbSavepoint);
    }

    protected synchronized void invalidateSavepoints() {
        Iterator iter = this.savepoints.iterator();
        while (iter.hasNext()) {
            ((FBSavepoint)iter.next()).invalidate();
        }
        this.savepoints.clear();
    }

    public synchronized FirebirdLocalTransaction getLocalTransaction() {
        if (this.localTransaction == null) {
            this.localTransaction = new FBLocalTransaction(this.mc, this);
        }
        return this.localTransaction;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface != null && iface.isAssignableFrom(FBConnection.class);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (!this.isWrapperFor(iface)) {
            throw new FBDriverNotCapableException();
        }
        return iface.cast(this);
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        this.checkValidity();
    }

    @Override
    public String getSchema() throws SQLException {
        this.checkValidity();
        return null;
    }

    public boolean inTransaction() throws SQLException {
        try {
            return this.getGDSHelper().inTransaction();
        }
        catch (GDSException ex) {
            throw new FBSQLException(ex);
        }
    }

    @Override
    public String getIscEncoding() throws SQLException {
        try {
            return this.getGDSHelper().getIscEncoding();
        }
        catch (GDSException ex) {
            throw new FBSQLException(ex);
        }
    }

    protected synchronized void addWarning(SQLWarning warning) {
        if (this.firstWarning == null) {
            this.firstWarning = warning;
        } else {
            SQLWarning lastWarning = this.firstWarning;
            while (lastWarning.getNextWarning() != null) {
                lastWarning = lastWarning.getNextWarning();
            }
            lastWarning.setNextWarning(warning);
        }
    }

    private SQLWarning getIscWarnings() throws SQLException {
        try {
            FBSQLWarning firstWarning = null;
            SQLWarning lastWarning = null;
            for (GDSException item : this.getGDSHelper().getWarnings()) {
                FBSQLWarning warning = new FBSQLWarning(item);
                if (firstWarning == null) {
                    firstWarning = warning;
                    lastWarning = firstWarning;
                    continue;
                }
                lastWarning.setNextWarning(warning);
                lastWarning = warning;
            }
            return firstWarning;
        }
        catch (GDSException ex) {
            throw new FBSQLException(ex);
        }
    }

    private void clearIscWarnings() throws SQLException {
        try {
            this.getGDSHelper().clearWarnings();
        }
        catch (GDSException ex) {
            throw new FBSQLException(ex);
        }
    }

    public GDSHelper getGDSHelper() throws GDSException {
        if (this.mc == null) {
            throw new GDSException(1, 335544363);
        }
        return this.mc.getGDSHelper();
    }

    @Override
    public boolean isUseFirebirdAutoCommit() {
        return this.getDatabaseParameterBuffer().hasArgument(143);
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    protected class GeneratedKeysQuery
    extends AbstractGeneratedKeysQuery {
        protected GeneratedKeysQuery(String sql, int autoGeneratedKeys) throws SQLException {
            super(sql, autoGeneratedKeys);
        }

        protected GeneratedKeysQuery(String sql, int[] columnIndexes) throws SQLException {
            super(sql, columnIndexes);
        }

        protected GeneratedKeysQuery(String sql, String[] columnNames) throws SQLException {
            super(sql, columnNames);
        }

        @Override
        DatabaseMetaData getDatabaseMetaData() throws SQLException {
            return AbstractConnection.this.getMetaData();
        }
    }
}

