/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import org.opengion.fukurou.util.LogWriter;
import org.opengion.fukurou.util.TimeStampObject;

public abstract class AbstractObjectPool<E> {
    private List<E> pool = null;
    private Map<Integer, TimeStampObject> poolBack = null;
    private boolean limit;
    private int maxsize;
    private int limitTime;
    private static final int MAX_LIMIT_COUNT = 1000;

    protected synchronized void init(int n, int n2, boolean bl) {
        this.init(n, n2, bl, 0);
    }

    protected synchronized void init(int n, int n2, boolean bl, int n3) {
        this.pool = new ArrayList(n2);
        this.poolBack = new HashMap<Integer, TimeStampObject>();
        this.maxsize = n2;
        this.limit = bl;
        this.limitTime = n3;
        for (int i = 0; i < n; ++i) {
            E e = this.createInstance();
            this.pool.add(e);
            Integer n4 = e.hashCode();
            this.poolBack.put(n4, new TimeStampObject(e, n3));
        }
    }

    public synchronized E newInstance() throws MissingResourceException {
        E e;
        if (this.pool.isEmpty()) {
            if (this.limit && this.poolBack.size() >= this.maxsize) {
                String string = "\u751f\u6210\u30ea\u30df\u30c3\u30c8\u3044\u3063\u3071\u3044\u3067\u65b0\u305f\u306b\u751f\u6210\u3067\u304d\u307e\u305b\u3093\u3002[" + this.poolBack.size() + "]";
                Iterator<TimeStampObject> iterator = this.poolBack.values().iterator();
                while (iterator.hasNext()) {
                    TimeStampObject timeStampObject = iterator.next();
                    if (timeStampObject != null && !timeStampObject.isTimeOver()) continue;
                    iterator.remove();
                }
                throw new MissingResourceException(string, this.getClass().getName(), "limit");
            }
            if (this.poolBack.size() > 1000) {
                this.clear();
                String string = "ObjectPool \u3067\u3001\u30e1\u30e2\u30ea\u30ea\u30fc\u30af\u306e\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059\u3002[" + this.poolBack.size() + "]";
                throw new RuntimeException(string);
            }
            e = this.createInstance();
            Integer n = e.hashCode();
            this.poolBack.put(n, new TimeStampObject(e, this.limitTime));
        } else {
            e = this.pool.remove(0);
            if (e != null) {
                Integer n = e.hashCode();
                TimeStampObject timeStampObject = this.poolBack.get(n);
                if (timeStampObject == null || timeStampObject.isTimeOver()) {
                    this.remove(e);
                    return this.newInstance();
                }
            } else {
                String string = "\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306e\u53d6\u5f97\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002";
                throw new MissingResourceException(string, this.getClass().getName(), "pool");
            }
        }
        return e;
    }

    protected abstract E createInstance();

    public synchronized void release(E e) {
        E e2 = this.objectInitial(e);
        if (e2 != null) {
            Integer n = e2.hashCode();
            TimeStampObject timeStampObject = this.poolBack.get(n);
            if (timeStampObject != null) {
                this.pool.add(e2);
            } else {
                LogWriter.log("ObjectPool \u3067\u3001\u30e1\u30e2\u30ea\u30ea\u30fc\u30af\u306e\u53ef\u80fd\u6027\u304c\u3042\u308b\u3002[" + e2 + "]");
                this.remove(e2);
            }
        }
    }

    public synchronized void remove(E e) {
        if (e != null) {
            Integer n = e.hashCode();
            this.poolBack.remove(n);
        }
        this.objectFinal(e);
    }

    public synchronized int size() {
        return this.poolBack.size();
    }

    public synchronized boolean isEmpty() {
        return this.poolBack.isEmpty();
    }

    public synchronized boolean clear() {
        Iterator<E> iterator = this.pool.iterator();
        while (iterator.hasNext()) {
            this.remove(iterator.next());
        }
        this.pool.clear();
        boolean bl = this.poolBack.isEmpty();
        this.poolBack.clear();
        return bl;
    }

    protected synchronized void objectFinal(E e) {
    }

    protected synchronized E objectInitial(E e) {
        return e;
    }

    public synchronized String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("  freeCount    = [").append(this.pool.size()).append("]\n");
        stringBuilder.append("  createCount  = [").append(this.poolBack.size()).append("]");
        stringBuilder.append(" ( max=[").append(this.maxsize).append("] )\n");
        stringBuilder.append("  limiter      = [").append(this.limit).append("]\n");
        stringBuilder.append("  limitTime    = [").append(this.limitTime).append("](s)\n");
        Iterator<E> iterator = this.pool.iterator();
        stringBuilder.append("Free Objects \n");
        while (iterator.hasNext()) {
            E e = iterator.next();
            if (e == null) continue;
            Integer n = e.hashCode();
            stringBuilder.append("  ");
            stringBuilder.append(this.poolBack.get(n));
            stringBuilder.append("  ").append(e);
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }
}

