/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.plugin.column;

import org.opengion.fukurou.util.Attributes;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.util.TagBuffer;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.db.CellEditor;
import org.opengion.hayabusa.db.DBColumn;

public abstract class AbstractEditor
implements CellEditor {
    private final int COLUMNS_MAXSIZE = HybsSystem.sysInt((String)"HTML_COLUMNS_MAXSIZE");
    private final int VIEW_COLUMNS_MAXSIZE = HybsSystem.sysInt((String)"HTML_VIEW_COLUMNS_MAXSIZE");
    protected Attributes attributes;
    protected String name;
    protected String size1;
    protected String size2;
    protected String optAttr;
    protected TagBuffer tagBuffer = new TagBuffer();
    protected String eventColumn;
    protected String eventURL;
    protected String editor;

    public AbstractEditor() {
    }

    protected AbstractEditor(DBColumn dBColumn) {
        this.name = dBColumn.getName();
        String string = dBColumn.isWritable() ? null : "disabled";
        this.eventColumn = dBColumn.getEventColumn();
        this.eventURL = dBColumn.getEventURL();
        this.editor = dBColumn.getEditor();
        int n = dBColumn.getTotalSize();
        this.attributes = new Attributes();
        this.attributes.set("type", "text");
        this.attributes.set("maxlength", String.valueOf(n));
        this.attributes.set("disabled", string);
        this.attributes.addAttributes(dBColumn.getEditorAttributes());
        String string2 = dBColumn.getDbType();
        this.attributes.add("class", string2);
        if (n <= 5) {
            this.attributes.add("class", "S0" + n);
        }
        this.optAttr = this.attributes.get("optionAttributes");
        String string3 = dBColumn.getViewLength();
        if (string3 != null) {
            if (string3.indexOf(44) >= 0) {
                string3 = string3.substring(0, string3.indexOf(44));
            }
            this.size1 = string3;
            this.size2 = string3;
        } else {
            this.size1 = String.valueOf(dBColumn.getFieldSize(n, this.COLUMNS_MAXSIZE));
            this.size2 = String.valueOf(dBColumn.getFieldSize(n, this.VIEW_COLUMNS_MAXSIZE));
        }
    }

    public String getValue(String string) {
        TagBuffer tagBuffer = new TagBuffer("input");
        tagBuffer.add("name", this.name);
        if (this.attributes.get("id") == null || this.attributes.get("id").length() == 0) {
            tagBuffer.add("id", this.name);
        }
        tagBuffer.add("value", string);
        tagBuffer.add("size", this.size1);
        tagBuffer.add(this.tagBuffer.makeTag());
        tagBuffer.add(this.optAttr);
        return tagBuffer.makeTag() + this.createEventColumnJS(this.name, this.editor, -1, this.eventURL);
    }

    public String getValue(int n, String string) {
        TagBuffer tagBuffer = new TagBuffer("input");
        String string2 = this.name + "__" + n;
        tagBuffer.add("name", string2);
        if (this.attributes.get("id") == null || this.attributes.get("id").length() == 0) {
            tagBuffer.add("id", string2);
        }
        tagBuffer.add("value", string);
        tagBuffer.add("size", this.size2);
        tagBuffer.add(this.tagBuffer.makeTag());
        tagBuffer.add(this.optAttr);
        return tagBuffer.makeTag(n, string) + this.createEventColumnJS(this.name, this.editor, n, this.eventURL);
    }

    protected String createEventColumnJS(String string, String string2, int n, String string3) {
        if (this.eventColumn != null && this.eventColumn.length() > 0) {
            StringBuilder stringBuilder = new StringBuilder();
            String[] stringArray = StringUtil.csv2Array((String)this.eventColumn);
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuilder.append("<script type=\"text/javascript\">").append("$(function(){$('#").append(stringArray[i]);
                if (n >= 0) {
                    stringBuilder.append("__").append(n);
                }
                stringBuilder.append("').change(function(){").append("makeColumn('").append(string);
                if (n >= 0) {
                    stringBuilder.append("__").append(n);
                }
                stringBuilder.append("','").append(string).append("',EC_").append(string).append(",'").append(string2).append("','").append(string3).append("');}).change();});").append("</script>");
            }
            return stringBuilder.toString();
        }
        return "";
    }
}

