/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.report2;

import java.io.File;
import java.io.IOException;
import org.opengion.fukurou.util.AbstractObjectPool;
import org.opengion.fukurou.util.Cleanable;
import org.opengion.fukurou.util.FileUtil;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.SystemManager;
import org.opengion.hayabusa.report2.SOfficeProcess;

public final class ProcessFactory {
    private static ProcessPool pp = new ProcessPool();

    private ProcessFactory() {
    }

    public static SOfficeProcess newInstance() {
        return (SOfficeProcess)pp.newInstance();
    }

    public static void release(SOfficeProcess sOfficeProcess) {
        pp.release(sOfficeProcess);
    }

    public static void remove(SOfficeProcess sOfficeProcess) {
        pp.remove(sOfficeProcess);
    }

    public static void clear() {
        pp.clear();
    }

    public static void kill() {
        try {
            String string = HybsSystem.sys("OS_INFO");
            if (string.indexOf("Windows") >= 0) {
                new ProcessBuilder("cmd.exe", "/c", "taskkill", "/F", "/IM", "soffice.bin").start().waitFor();
            } else {
                new ProcessBuilder("killall", "-9", "-w", "soffice.bin").start().waitFor();
            }
            FileUtil.deleteFiles((File)new File(SOfficeProcess.ENV_DIR));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
        }
    }

    public static String information() {
        return pp.toString();
    }

    static {
        Cleanable cleanable = new Cleanable(){

            public void clear() {
                ProcessFactory.clear();
            }
        };
        SystemManager.addCleanable(cleanable);
    }

    protected static class ProcessPool
    extends AbstractObjectPool<SOfficeProcess> {
        private int count = 0;

        protected ProcessPool() {
            this.init(0, HybsSystem.sysInt("REPORT_MAX_PROCESS_COUNT"), true, HybsSystem.sysInt("REPORT_PROCESS_ALIVE"));
        }

        protected SOfficeProcess createInstance() {
            SOfficeProcess sOfficeProcess = null;
            try {
                sOfficeProcess = new SOfficeProcess("env_" + this.count);
                sOfficeProcess.bootstrap();
                ++this.count;
            }
            catch (RuntimeException runtimeException) {
                System.out.println("[ERROR]OOo:Failed to Connect Soffice! " + runtimeException.getMessage());
            }
            return sOfficeProcess;
        }

        protected void objectFinal(SOfficeProcess sOfficeProcess) {
            sOfficeProcess.close();
        }
    }
}

