/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.db;

import org.opengion.fukurou.util.LogWriter;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.db.Selection;
import org.opengion.hayabusa.resource.CodeData;

public class Selection_CODE
implements Selection {
    private final CodeData codeData;
    private final int[] ADRS;
    private final String CACHE;
    private final int LEN;
    private final int[] LADRS;
    private final String LCACHE;
    private final int LLEN;

    public Selection_CODE(CodeData codeData) {
        this.codeData = codeData;
        int n = this.codeData.getSize();
        this.ADRS = new int[n];
        StringBuilder stringBuilder = new StringBuilder(200);
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            bl = !this.codeData.getRawShortLabel(i).equals(this.codeData.getLongLabel(i));
            stringBuilder.append("<option value=\"").append(this.codeData.getCodeKey(i)).append("\"");
            this.ADRS[i] = stringBuilder.length();
            if (bl) {
                stringBuilder.append(" title=\"").append(this.codeData.getLongLabel(i)).append("\"");
            }
            stringBuilder.append(">").append(this.codeData.getRawShortLabel(i)).append("</option>");
        }
        this.CACHE = stringBuilder.toString();
        this.LEN = this.CACHE.length() + 30;
        if (this.CACHE.indexOf("title=\"") < 0) {
            this.LADRS = null;
            this.LCACHE = null;
            this.LLEN = 0;
        } else {
            this.LADRS = new int[n];
            StringBuilder stringBuilder2 = new StringBuilder(200);
            for (int i = 0; i < n; ++i) {
                stringBuilder2.append("<option value=\"").append(this.codeData.getCodeKey(i)).append("\"");
                this.LADRS[i] = stringBuilder2.length();
                stringBuilder2.append(">").append(this.codeData.getLongLabel(i)).append("</option>");
            }
            this.LCACHE = stringBuilder2.toString();
            this.LLEN = this.LCACHE.length() + 30;
        }
    }

    @Override
    public String getOption(String string, boolean bl) {
        return this.getOption(string, bl, false);
    }

    @Override
    public String getOption(String string, boolean bl, boolean bl2) {
        int[] nArray = null;
        String string2 = null;
        int n = 0;
        if (!bl2 && this.LCACHE != null && this.LCACHE.length() > 0) {
            nArray = this.LADRS;
            string2 = this.LCACHE;
            n = this.LLEN;
        } else {
            nArray = this.ADRS;
            string2 = this.CACHE;
            n = this.LEN;
        }
        int n2 = this.codeData.getAddress(string);
        if (n2 < 0) {
            if (string != null && string.length() > 0) {
                String string3 = "\u30b3\u30fc\u30c9\u306b\u5b58\u5728\u3057\u306a\u3044\u5024\u304c\u6307\u5b9a\u3055\u308c\u307e\u3057\u305f\u3002 Value=[" + string + "]" + HybsSystem.CR + this.codeData;
                LogWriter.log((String)string3);
            }
            return string2;
        }
        StringBuilder stringBuilder = new StringBuilder(n);
        if (bl) {
            stringBuilder.append("<option value=\"").append(this.codeData.getCodeKey(n2)).append("\"");
        } else {
            stringBuilder.append(string2.substring(0, nArray[n2]));
        }
        stringBuilder.append(" selected=\"selected\"");
        stringBuilder.append(string2.substring(nArray[n2]));
        return stringBuilder.toString();
    }

    @Override
    public String getRadio(String string, String string2, boolean bl) {
        String string3 = "\u3053\u306e\u30af\u30e9\u30b9\u3067\u306f\u5b9f\u88c5\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002";
        throw new UnsupportedOperationException(string3);
    }

    @Override
    public String getRadioLabel(String string) {
        String string2 = "\u3053\u306e\u30af\u30e9\u30b9\u3067\u306f\u5b9f\u88c5\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002";
        throw new UnsupportedOperationException(string2);
    }

    @Override
    public String getValueLabel(String string) {
        return this.getValueLabel(string, false);
    }

    @Override
    public String getValueLabel(String string, boolean bl) {
        int n = this.codeData.getAddress(string);
        if (n < 0) {
            return string;
        }
        if (bl) {
            return this.codeData.getShortLabel(n);
        }
        return this.codeData.getLongLabel(n);
    }

    @Override
    public boolean useMultiSelect() {
        return this.codeData.useMultiSelect();
    }

    @Override
    public boolean isTimeOver() {
        return false;
    }
}

