
/////////////////////////
///// カルテからの継承値 ///

function noa(){
    if (window.opener.name == "noa"){
        return window.opener;
    } else if (window.opener.name == "tools"){
        return window.opener.top.noa;
    } else if (window.top.noa){
        return window.top.noa;
    } else {
        alert("ERROR *** chartFinder.js: window.opener としての NOA が見つかりません");
        return null;
    }
}

///// カルテからの継承値 ///
/////////////////////////


/////////////////////////////////////////////////////////////
///// Ajax //////////////////////////////////////////////////

function gotLimittedVisitor(answer){
    // 受診者リストを表示
    obj = JSON.parse(answer);
    
    // obj = '11108400(name(村岡　敬子)lvd(2013-07-22 09:48:22))11187000(name(丸山 かえで)lvd(2013-07-22 10:42:03))' 型式
    if (obj == null){
        document.getElementById("dataArea").innerHTML = "　該当するものはありません";
    } else {
        var elm = document.getElementById("dataArea");
        elm.innerHTML = "";
        
        //alert(encodeObject(obj)); //##
        
        var tbl = newTABLE(elm, "/base-table");
        tbl.style.fontSize = "9pt";
        
        var tr = newTR(tbl, "", "");
        tr.style.background = "#eee";
        var td = newTD(tr, "", "カルテID 氏名");
        td.style.paddingLeft = "5px";
        td.style.width = "100px";
        var td = newTD(tr, "", "最終受診日");
        
        var count = 0;
        for (lvd in obj){
            var rec = obj[lvd];
            var tr = newTR(tbl, "/row", "");
            var action = "noa().openChart('"+rec.patientId+"','"+rec.name+"')";
            tr.setAttribute("onclick", action);
            var td = newTD(tr, "", rec.patientId + " " + rec.name);
            td.style.paddingLeft = "5px";
            var td = newTD(tr, "", lvd);
            count++;
        }
        
        var tr = newTR(tbl, "", "");
        tr.style.background = "#eee";
        var td = newTD(tr, "", "該当件数");
        td.style.paddingLeft = "5px";
        var td = newTD(tr, "", count + " 件");
    }
}
function getConditionalPatient(from, to){
    // yyyy/mm/dd 以後受診していないカルテを検索
    NRGetConditionalPatient(from, to, gotLimittedVisitor);
}

///// Ajax //////////////////////////////////////////////////
/////////////////////////////////////////////////////////////


function search(){
    // 指定された年月日以後受診していないカルテを検索
    var from = "";
    var val = document.getElementById("fromPop").value;
    var array = val.split("-");
    if (array.length == 3){
        from = val + " 00:00:00";
    }

    var to = "";
    var val = document.getElementById("toPop").value;
    var array = val.split("-");
    if (array.length == 3){
        to = val + " 23:59:59";
    }
    
    if (!from && !to){
        alert("年月日が指定されていません");
    } else {
        if (from == "")
            from = "0000-00-00 00:00:00";
        if (to == "")
            to = todayAndTime();
        getConditionalPatient(from, to);
    }
}

function initLvdSearcher(){
    //_initDebug(false); //##

	var elm = document.getElementById("base");
    elm.style.fontSize = "10pt";
	
	// === HEADER =======================
    var div = newDIV(elm, "");
    var dv = newDIV(div, "/tool-header");
    dv.innerHTML = "最終受診日検索";
    dv.style.fontSize = "12px";
    dv.style.paddingLeft = "10px";

    // === CONTENTS ======================
    var div = newDIV(elm, "");
    div.style.padding = "5px 10px";
    // from popup
    makeTodayPop(div, "fromPop", "から");
    
    // to popup
    makeTodayPop(div, "toPop", "まで");

    // button
    var dv = newDIV(div, "");
    dv.style.fontSize = "10pt";
    var sp = newSPAN(dv, "");
    sp.style.paddingLeft = "10px";
    sp.innerHTML = "の期間が最終受診日のカルテを";
    var bt = newBUTTON(sp, "", "リストアップ");
    bt.setAttribute("onclick", "search()");

    // === FWORK AREA ===================
    var div = newDIV(elm, "dataArea");

	// === FOOTER ===================
    var div = newDIV(elm, "");
	var tbl = newTABLE(div, "/base-table");
	var tr = newTR(tbl, "/tool-footer", "");
	var td = newTD(tr, "/left-side", version());
	var td = newTD(tr, "", "");
    
    function makeTodayPop(elm, id, label){
        // 年月日ポップアップを生成
        var div = newDIV(elm, "");
        div.style.paddingBottom = "2px";
        var sp = newSPAN(div, "");
        sp.style.paddingLeft = "5px";
        var array = today().split("-");
        var yyyy = array[0] * 1;
        var mm = array[1] * 1;
        var dd = array[2] * 1;
        var pm = newDatePopUp(sp, id, "平成", yyyy, mm, dd, false, null);
        var sp = newSPAN(div, "");
        sp.style.paddingLeft = "5px";
        sp.innerHTML = label;
    }
}

function version(){
	return "Ver.130725";
}
