
var _editObject = null; // Global 変数
var _labelWidth = 9;
var _rangeWidth = 12;
var _item = ""; // Global 変数

function editObject(){
	return _editObject;
}
function setEditObject(obj){
	_editObject = obj;
}

function menuItem(){
	return _item;
}
function setMenuItem(item){
	_item = item;
}



////////////////////////////////
/// neuron.js による処理 /////////

function removeItem(tag){
	// 表示されているテンプレートをサーバから削除
	var item = document.getElementById("_item").value;
	
	if (confirm(item + " を削除していいですか")){
		closeEditor();
		NRRemoveMenu(owner(), cellLabel(), item, showItemPopUp);
	}
}

function putMenuItem(item, value){
	// item をサーバに登録し item の頻度インクリメント
	if (item == "...その他") return;
	
	NRPutMenu(owner(), cellLabel(), item, "", value, showItemPopUp);
}

/// neuron.js による処理 /////////
////////////////////////////////


function saveItem(){
	// 表示されているポップアップメニューのアイテム（テンプレート名）をサーバへ登録
	var item = document.getElementById("_item").value;
	if (item.length == 0){
		alert("タイトルが入力されていません");
		return;
	}
	
	setMenuItem(item); // 選択されたメニューアイテムを記憶
	
	// 選択アイテムが存在しなければ登録、存在すれば頻度をインクリメント
	var obj = editObject();
	var value = form2buff(obj, false, formatMode());
	putMenuItem(item, value);
	closeEditor();
}

function toggleHeader(status){
	// editorTable と bodyTable を見かけ上、入れ替え
	var body = document.getElementById("bodyTable");
	var editor = document.getElementById("editorTable");
	if (status){
		body.style.display = "";
		editor.style.display = "none"; // 表示しない
	} else {
		body.style.display = "none"; // 表示しない
		editor.style.display = "";
	}
}

function closeEditor(){
	// editorTable を隠し bodyTable を表示
	// editorTable と bodyTable を見かけ上、入れ替え
	toggleHeader(true);
}

function form2buff(parentObj, skipNull, formatter){
	// FORM に表示された内容を label(..) の文字列へ展開して返す
	var buff = "";
	var fmt = (formatter) ? formSeparator() : ""; // "\n   "
	var fm = (formatter) ? "<BR/>" : "";
	var i, count = parentObj.children.length;
	for (i=1; i < count; i++){
		var obj = parentObj.children[i];
		var label = obj.label;
		if (obj.hasChild && (obj.hasChild > 0)){
			// 佐々木先生のリクエストにより伝票ごと末尾に改行を入れる
			buff+=label+"("+form2buff(obj,skipNull,formatter)+")\n"+fm;
		} else {
			if (skipNull){
				// FORM 表示の場合 value は obj に記憶していない
				var value =
                document.getElementById(obj.id+".value").value;
				if (value.length > 0){ // value が空のものはスキップ
					// value に unit を埋め込む
					var unit =
					document.getElementById(obj.id+".unit").innerHTML;
					if (unit.length)
						buff += fmt + label + "(" + value + " " + unit + ")";
					else
						buff += fmt + label + "(" + value + ")" ;
				}
			} else {　// FORM 編集の場合 value(実際は range) は obj に記憶
				buff += fmt + label + "(" + obj.value + ")" ;
			}
		}
	}
	return buff;
}

function prevIdOf(cellId){
	// cellId の前の id を返す
	var array = cellId.split(".");
	var lastNum = array[array.length - 1] * 1;
	array[array.length - 1] = (lastNum - 1) + "";
	return array.join(".");
}
function nextIdOf(cellId){
	// cellId の次の id を返す
	var array = cellId.split(".");
	var lastNum = array[array.length - 1] * 1;
	array[array.length - 1] = (lastNum + 1) + "";
	return array.join(".");
}
function addCell(cid){
	// 新しい行を追加
	var tr = document.getElementById("_structure");
	tr.innerHTML = "";
	
	// クリックされた行へ挿入するため、対象 cellId をひとつ前へずらす
	cellId = prevIdOf(cid);
	
	// cellId のセルを削除して再表示
	var _targetId = "";
	var parentObj = addCellForId(editObject(), cellId);
	setEditObject(parentObj); // 構造を記憶
	showStructure(tr, parentObj); // 構造化したものを表示
	
	// 最後に追加された行の label フィールドにフォーカス
	document.getElementById(_targetId+"_name").focus();
	
	function addCellForId(parentCell, cellId){
		// parentCell へ cellId のセルを挿入して返す
		var newCell = new Object();
		newCell.id = parentCell.id;
		newCell.label = parentCell.label;
		newCell.children = new Array();
		newCell.hasChild = (parentCell.hasChild) ? parentCell.hasChild : 0;
		var i, num, count = parentCell.children.length;
		if (count == 0){
			var firstId = parentCell.id+".0";
			if (isSame(firstId, cid)){
				// 新しい行を挿入
				var aCell = new Object();
				aCell.id = parentCell.id+".1";
				_targetId = aCell.id; // 追加された行を記憶
				aCell.label = "";
				aCell.value = "";
				aCell.hasChild = 0;
				aCell.children = new Array();
				newCell.children[0] = aCell;
			}
		}
		
		for (i=num=0; i < count; i++){
			var cell = parentCell.children[i];
			cell.id = parentCell.id + "." + num; // id を付け直す
			if ((cell.hasChild != null) && (cell.hasChild > 0))
				newCell.children[num++] = addCellForId(cell, cellId);
			else
				newCell.children[num++] = cell;
			if (isSame(cell.id, cellId)){
				// 新しい行を挿入
				var aCell = new Object();
				aCell.id = nextIdOf(cellId);
				_targetId = aCell.id; // 追加された行を記憶
				aCell.label = "";
				aCell.value = "";
				aCell.hasChild = 0;
				aCell.children = new Array();
				newCell.children[num++] = aCell;
			}
		}
		return newCell;
	}
}


function removeCell(cellId){
	// cellId の行を削除
	var label = document.getElementById(cellId+"_name").value;
	if (window.confirm(label+" ("+cellId+") を削除しますか　")){
		var tr = document.getElementById("_structure");
		tr.innerHTML = "";
		
		// cellId のセルを削除して再表示
		var parentObj = removeCellForId(editObject(), cellId);
		setEditObject(parentObj); // 構造を記憶
		showStructure(tr, parentObj); // 構造化したものを表示
	}
	
	function removeCellForId(parentCell, cellId){
		// parentCell から cellId のセルを削除して返す
		var newCell = new Object();
		newCell.id = parentCell.id;
		newCell.label = parentCell.label;
		newCell.hasChild = parentCell.hasChild;
		newCell.children = new Array();
		newCell.hasChild = (parentCell.hasChild) ? parentCell.hasChild : 0;
		var i, num, count = parentCell.children.length;
		for (i=num=0; i < count; i++){
			var cell = parentCell.children[i];
			if (isSame(cell.id, cellId)) continue; // item removed
			cell.id = parentCell.id + "." + num; // 削除したため id を付け直す
			if ((cell.hasChild != null) && (cell.hasChild > 0))
				newCell.children[num++] = removeCellForId(cell, cellId);
			else
				newCell.children[num++] = cell;
		}
		return newCell;
	}
}

function setCellValue(cellId){
	// EDITOR: cellId の value を structure 中の object に設定
	var label = document.getElementById(cellId+"_name").value;
	var value = document.getElementById(cellId+"_value").value;
	setValueForId(editObject(), cellId, label, value);
}

function setUnitValue(cellId){
	// EDITOR: cellId の value を structure 中の object に設定
	var label = document.getElementById(cellId+"_name").value;
	var unit = document.getElementById(cellId+"_unit").value;
	var value = document.getElementById(cellId+"_value").value;
	var array = value.split("|");
	array[1] = unit;
	value = array.join("|");
	setValueForId(editObject(), cellId, label, value);
}

function makeEditRecord(tr, objId, label, value){
	// エディターの１行分を作成
	var td = newTD(tr, "valLabel", ""); // objId を表示も可
	
	// optionEditor との値受け渡しのためメモリー上に保持
	var hd = newHIDDEN(td, objId+"_value", value); // value:"val|range|menu"
	
	var im = newIMAGE(td, "icon", "./blueGem.png", "X");
	var action = "addCell('" + objId + "')";
	im.setAttribute("onclick", action);
	
	var fd = newFIELD(td, objId+"_name", "", _labelWidth, label);
	var action = "setCellValue('"+objId+"')";
	fd.setAttribute("onchange", action);
	
	var td = newTD(tr, "valRange", "");
	var fd = newFIELD(td, objId+"_unit", "", _rangeWidth, unitOfRecord(value));
	var action = "setUnitValue('"+objId+"')";
	fd.setAttribute("onchange", action);
	
	//newTEXT(td,value);//===
	
	var im = newIMAGE(td, "icon", "./hammer.png", "X");
	var action = "editOption('"+objId+"')";
	im.setAttribute("onclick", action);
	
	var im = newIMAGE(td, "icon", "./redGem.png", "X");
	var action = "removeCell('"+objId+"')";
	im.setAttribute("onclick", action);
}

function optionOK(cellId){
	// オプション編集ペーンを閉じる
	var label = document.getElementById("_label").value;
	var unit = document.getElementById("_unit").value;
	var val = document.getElementById("_default").value;
	var range = document.getElementById("_range").value;
	var st = document.getElementById("_menuItems").value;
	var array = st.split("\n");
	var menu = array.join(",");
	var value = (val.length + unit.length + range.length + menu.length == 0)
	? "" : val + "|" + unit + "|" + range + "|" +menu;
	
	// object の value を更新
	setValueForId(editObject(), cellId, label, value);
	
	var tr = document.getElementById("_editor"+cellId);
	tr.innerHTML = "";
	makeEditRecord(tr, cellId, label, value);
	setCellValue(cellId);
}

function optionClose(cellId){
	// オプション編集ペーンを閉じる
	var label = document.getElementById("_label").value;
	var value = document.getElementById("_value").value;
	
	var tr = document.getElementById("_editor"+cellId);
	tr.innerHTML = "";
	makeEditRecord(tr, cellId, label, value);
	setCellValue(cellId);
}

function updateMenuForRecord(menu, rec){
	// レコード "50|mg|10..20|menu" に、メニュー "red,#ff0,blue" を追加し
	// "50|mg|10..20|red,#ff0,blue" とする
	var array = rec.split("|");
	if (array.length >= 3)
		array[3] = menu;
	else
		array.push(menu);
	return array.join("|");
}

/*function addPopUpItem(cellId){
 // オプション・ポップアップにアイテムを追加
 var newItem = window.prompt("追加メニュー項目");
 if (newItem == null) return;
 if (newItem.length == 0) return; // 空アイテムは追加できない
 
 var value = document.getElementById("_value").value; // hidden
 var selectedItem = document.getElementById("_optionPopUp").value;
 var menu = menuOfRecord(value);
 var array = (menu != null) ? menu.split(",") : new Array();
 
 // 挿入位置を決める
 var i, count = array.length, insertPoint = count;
 for (i=0; i < count; i++){
 var item = array[i];
 if (isSame(item, selectedItem)) insertPoint = i;
 }
 array.splice(insertPoint, 0, newItem);
 menu = array.join(",");
 document.getElementById("_menu").value = menu;
 document.getElementById("_value").value = updateMenuForRecord(menu, value);
 showOptionPopUp(cellId, menu);
 }*/

function removePopUpItem(cellId){
	// オプション・ポップアップの選択されたアイテムを削除
	var selectedItem = document.getElementById("_optionPopUp").value;
	if (selectedItem.length == 0){
		// 最終アイテムは削除できない
		alert("この項目は削除できません");
		return;
	}
	if (window.confirm("("+selectedItem + ") をメニューから削除していいですか")){
		var value = document.getElementById("_value").value; // hidden
		var menu = menuOfRecord(value);
		if (menu == null) return;
		var array = menu.split(",");
		var i, num, count = array.length;
		var narray = new Array();
		for (i=num=0; i < count; i++){
			var item = array[i];
			if (isSame(item, selectedItem)) continue;
			narray[num++] = item;
		}
		menu = narray.join(",");
		document.getElementById("_menu").value = menu;
		document.getElementById("_value").value = updateMenuForRecord(menu, value);
		showOptionPopUp(cellId, menu);
	}
}

function showOptionPopUp(cellId, menu){
	// オプション設定のポップアップメニュー編集ペーンを表示
	var array = (menu != null) ? menu.split(",") : new Array();
	
	var td = document.getElementById("_optionMenuItemArea");
	td.innerHTML = "メニュー";
	td.style.verticalAlign = "top"; // 機能していない
	var array = menu.split(",");
	var buff = array.join("\n");
	var ta = newTEXTAREA(td, "_menuItems", 20, 5, buff);
}

function editOption(cellId){
	// オプション編集ペーンを表示
	// label = "メモ"
	var label = document.getElementById(cellId+"_name").value;
	// value="default|単位|範囲|メニュー項目"
	// ex. "||-|-,,+,+-" あるいは "|mmHg|0..140|"
	var value = document.getElementById(cellId+"_value").value;
	var unit = unitOfRecord(value);
	var menu = menuOfRecord(value);
	if (menu == null) menu = "";
	
	// tr.innerHTML = "" を実行する前に label, unit をメモリー上に確保
	var tr = document.getElementById("_editor"+cellId);
	tr.innerHTML = "";
	
	var td = newTD(tr, "", "");
	td.setAttribute("colspan", "2");
	var hd = newHIDDEN(td, "_label", label);
	var hd = newHIDDEN(td, "_value", value);
	var hd = newHIDDEN(td, "_unit", unit);
	var hd = newHIDDEN(td, "_menu", menu);
	
	var tbl = newTABLE(td, "optionTable");
	
	var tr = newTR(tbl, "optionHeader", label);
	
	var tr = newTR(tbl, "", "");
	var text = "基準値は以下のような形式で入れてください";
	var td = newTD(tr, "optionMessage", text);
	var tr = newTR(tbl, "", "");
	var text = "　範囲指定の場合：最低..最高（数値のみ）";
	var td = newTD(tr, "optionMessage", text);
	var tr = newTR(tbl, "", "");
	var text = "　単一指定の場合：基準値";
	var td = newTD(tr, "optionMessage", text);
	var tr = newTR(tbl, "", "");
	var text = "　複数指定の場合：基準値,基準値,基準値";
	var td = newTD(tr, "optionMessage", text);
	
	var tr = newTR(tbl, "optionFooter", "");
	var td = newTD(tr, "", "default値");
	var val = document.getElementById(cellId+".value").value;
	var fd = newFIELD(td, "_default", "", 25, val);
	
	var tr = newTR(tbl, "optionFooter", "");
	var td = newTD(tr, "", "基準値");
	var fd = newFIELD(td, "_range", "", 25, rangeOfRecord(value));
	
	var tr = newTR(tbl, "", "");
	var text = "ポップアップ・メニューのメニュー項目を１行ずつ入れてください";
	var td = newTD(tr, "optionMessage", text);
	
	var tr = newTR(tbl, "", "");
	var td = newTD(tr, "_optionMenuItemArea", "");
	showOptionPopUp(cellId, menu);
	
	var tr = newTR(tbl, "optionFooter", "");
	var td = newTD(tr, "", "");
	var bt = newBUTTON(td, "", "とりやめ");
	var action = "optionClose('"+cellId+"')";
	bt.setAttribute("onclick", action);
	var bt = newBUTTON(td, "", "確定");
	var action = "optionOK('"+cellId+"')";
	bt.setAttribute("onclick", action);
}


function showSameEditor(){
	return 1;
}

function showStructure(elm, parentObj){
	// EDITOR: parentObj の構造に従い編集用 FORM を表示
	if (parentObj == null) return;
	
	var td = newTD(elm, "", "");
	td.setAttribute("colspan", "2");
	
	// 子供グループを表示するテーブル生成
	var tbl = newTABLE(td, "valueTable");
	
	// cell header を生成
	var tr = newTR(tbl, "valHeader", "");
	// cell header のタイトル名入力部分
	var td = newTD(tr, "", "");
	td.style.padding = "3px 10px";
	if (isSame(parentObj.id, "0")){
		// root object のヘッダー
		var tx = newTEXT(td, parentObj.label);
	} else {
		// root object 以外は変更可能
		var im = newIMAGE(td, "icon", "./blueGem.png", "X");
		var action = "addCell('" + parentObj.id + "')";
		im.setAttribute("onclick", action);
		var fd = newFIELD(td, parentObj.id+"_name", "", 10, parentObj.label);
		var action = "setCellValue('"+parentObj.id+"')";
		fd.setAttribute("onchange", action);
	}
	// cell header の後半部分
	var td = newTD(tr, "valHeaderRight", "");　// parentObj.id を表示も可
	if (isSame(parentObj.id, "0") == 0){
		// root object 以外は変更可能
		var im = newIMAGE(td, "icon", "./redGem.png", "X");
		var action = "removeCell('"+parentObj.id+"')";
		im.setAttribute("onclick", action);
	}
	
	// 子供 cell を生成
	for (var i=0,count=parentObj.children.length; i < count; i++){
		var obj = parentObj.children[i];
		var label = trim(obj.label);
		
		if (obj.hasChild == 0){
			// 子供が文字列(value)を持ち、孫(children)を持たない場合
			var tr = newTR(tbl, "_editor"+obj.id, "");
			var value = trim(obj.value);
			if (i == 0){
				// タイトル行を read-only で表示
				var td = newTD(tr, "valTitle", label); // 項目名
				td.style.padding = "0px 30px";
				td.style.textAlign = "left";
				var td = newTD(tr, "valTitle", value); // 単位
				td.style.padding = "0px 30px";
				td.style.textAlign = "right";
			} else {
				// １行分のエレメント作成
				makeEditRecord(tr, obj.id, label, value);
			}
		} else {
			// 子供が孫(children)を持ち、文字列(value)を持たない場合
			var tr = newTR(tbl, "_editor"+obj.id, "");
			showStructure(tr, obj);
		}
	}
	
	// control 行を生成
	var cellId = parentObj.id + "." + parentObj.children.length;
	var objId = cellId; //nextIdOf(cellId);
	
	var tr = newTR(tbl, "valControl", "");
	var td = newTD(tr, "valControLeft", "");
	td.style.height = "15pt";
	var im = newIMAGE(td, "icon", "./blueGem.png", "X");
	var action = "addCell('" + objId + "')";
	im.setAttribute("onclick", action);
	
	var td = newTD(tr, "valControRight", ""); // cellId を表示も可
}

function closeTemplate(){
	var elm = document.getElementById("message");
	elm.innerHTML = "";
}
function showTemplate(){
	// 伝票のテンプレートを表示
	var elm = document.getElementById("message");
	elm.innerHTML = "";
	
    var dv = newDIV(elm, "");
    dv.style.margin = "5px 5px";
	var im = newIMAGE(dv, "", "./close.png", "?");
	im.setAttribute("onclick", "closeTemplate()");
	im.style.height = "11px";
	
	var array = ["　以下の文字列がこの伝票のテンプレート。"];
	array.push("これを別途保存しておけば、万一テンプレート");
	array.push("を失っても、この文字列をカルテの検査欄へコピーし");
	array.push("伝票を開けば、ツール・エリアに伝票が再現されるので、");
	array.push("編集モードにして、それを登録すればよい。");
	var tx = newTEXT(dv, array.join(""));
	
	var templateName = document.getElementById("_item").value;
	var value = form2buff(editObject(), false, false);
	var p = newP(dv, templateName +"(" + value +")");
}

function showEditor(isNew){
	// FORM のエディターを開く（isNew が 1 なら空のエディター）
	var item = "";
	var parentObj = buff2cell("0", "伝票構造", "()"); // メニューのバリューを構造化
	if (isNew == 0){ // 既存テンプレートの編集
		var value = form2buff(structure(), false, false);
		//if (isDebugMode()) alert(value);//##
		var obj = buff2cell("0", "", value); // メニューのバリューを構造化
		parentObj = obj.children[1];
		item = parentObj.label;
		if (obj.children.length > 2){
			alert("最初の伝票 ( " + item + " ) のみ編集します");
		}
		parentObj.label = "伝票構造";
		parentObj.id = "0";
	}
	setEditObject(parentObj); // 構造を記憶
	
	// editorTable と bodyTable を見かけ上、入れ替え
	toggleHeader(false);
    
	// 編集テーブルを生成
	var tbl = document.getElementById("editorTable");
	tbl.innerHTML = "";
	
	// header
	var tr = newTR(tbl, "edHeader", "");
	var td = newTD(tr, "", "伝票編集");
	var td = newTD(tr, "", "");
	var im = newIMAGE(td, "", "./Help.png", "?");
	im.setAttribute("onclick", "help()");
	im.style.height = "18px";
	
	// テンプレート名
	var tr = newTR(tbl, "", "");
	var td = newTD(tr, "", "");
	td.setAttribute("colspan","2");
	var fd = newFIELD(td, "_item", "", 18, item);
	var bt = newBUTTON(td, "", "の伝票を削除");
	bt.setAttribute("onclick", "removeItem()");
	
	var tr = newTR(tbl, "_structure", ""); // 削除・再生できるよう TR 上に以下を構築
	showStructure(tr, parentObj); // 構造化したものを表示
	
	// footer
	var tr = newTR(tbl, "edFooter", "");
	var td = newTD(tr, "", "");
	td.setAttribute("colspan", "2");
	var bt = newBUTTON(td, "", "テンプレート出力");
	bt.setAttribute("onclick", "showTemplate()");
	var bt = newBUTTON(td, "", "とりやめ");
	bt.setAttribute("onclick", "closeEditor()");
	var bt = newBUTTON(td, "", "登録");
	bt.setAttribute("onclick", "saveItem()");
}
