package net.morilib.regex;

import net.morilib.regex.dfa.RegexParserUtils;
import junit.framework.TestCase;

public class RegexParserUtilsTest extends TestCase {

	static void chk(String s, String a, String b) {
		String[] x;

		x = RegexParserUtils.splitLookahead(s);
		assertEquals(a, x[0]);
		assertEquals(b, x[1]);
	}

	static void chk(String s, String a) {
		chk(s, a, null);
	}

	public void testSplit0001() {
		chk("abc", "abc");
	}

	public void testSplit0002() {
		chk("abc(?=aaa)", "abc", "=aaa");
		chk("abc(?!aaa)", "abc", "!aaa");
	}

	public void testSplit0003() {
		chk("abc(aaa)", "abc(aaa)");
		chk("abc(a(a)a)", "abc(a(a)a)");
		chk("abc(a(?=a)a)", "abc(a(?=a)a)");
		chk("abc(a(?!a)a)", "abc(a(?!a)a)");
	}

	public void testSplit0004() {
		chk("abc[abc]", "abc[abc]");
		chk("abc[a(b)c]", "abc[a(b)c]");
		chk("abc[a(?=bc]", "abc[a(?=bc]");
		chk("abc[a(?!bc]", "abc[a(?!bc]");
	}

	public void testSplit0005() {
		chk("abc(a(?=a)a)(?=aaa)", "abc(a(?=a)a)", "=aaa");
		chk("abc[a(?=bc](?!aaa)", "abc[a(?=bc]", "!aaa");
		chk("abc(a(b(?=a))a)(?=aaa)", "abc(a(b(?=a))a)", "=aaa");
		chk("abc[a&[^z(?=b]c](?!aaa)", "abc[a&[^z(?=b]c]", "!aaa");
	}

	public void testSplit0006() {
		chk("abc\\(?=aaa)", "abc\\(?=aaa)");
		chk("abc\\(?!aaa)", "abc\\(?!aaa)");
		chk("abc(\\?=aaa)", "abc(\\?=aaa)");
		chk("abc\\(?=aaa(?=a)", "abc\\(?=aaa", "=a");
		chk("abc\\[?=aaa(?=\\]a)", "abc\\[?=aaa", "=\\]a");
		chk("abc\\[(?=aaa(?=\\]a)", "abc\\[", "=aaa(?=\\]a");
	}

	public void testSplit0007() {
		chk("(abc(?=aaa)", "(abc(?=aaa)");
		chk("((abc(?=aaa)", "((abc(?=aaa)");
		chk("[abc(?=aaa)", "[abc(?=aaa)");
	}

}
