/*
 * Translated by Nina
 * This source code is under public domain
 */

package net.morilib.deculture.parser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import net.morilib.automata.lr.ContextFreeRule;
import net.morilib.automata.lr.GrammarSymbol;
import net.morilib.automata.lr.Nonterminal;
import net.morilib.deculture.misc.CharacterTerminal;
import net.morilib.deculture.misc.ConstantNonterminal;
import net.morilib.deculture.misc.ConstantTerminal;
import net.morilib.deculture.misc.DecultureException;
import net.morilib.deculture.misc.PrecedenceTerminal;
import net.morilib.deculture.misc.SubautomatonTerminal;

public  class DecultureAction   {

	static class TokenException extends RuntimeException {
	}

	static abstract class Engine {
		abstract int step(java.io.Reader __rd, int c) throws java.io.IOException;
		abstract boolean accepted();
		abstract int execaction(int c);
		abstract boolean isend();
		abstract int recover(Exception e);
		abstract int deadState();
		abstract int stateSize();
		abstract int finallyState();
	}
	private static final int NINA_EOF = -1;
	private static final int NINA_ACCEPT = -8;
	private static final int NINA_FAIL = -9;
	private static final int NINA_HALT_ACCEPT = -91;
	private static final int NINA_HALT_REJECT = -72;
	private static final int NINA_YIELD = -85;
	private static final int NINA_BEGIN = -2;
	private static final int NINA_STACKLEN = 72;
	static final int INITIAL = 0;

	private int STATE;
	private int[] __sts = new int[NINA_STACKLEN];
	private Engine[] __stk = new Engine[NINA_STACKLEN];
	private Object[][] __stv = new Object[NINA_STACKLEN][];
	private int __slen = 0;

	private int unread = -1;
	Object yieldObject;
	java.io.Reader befstream = null;
	Throwable exception;


	int _read1(java.io.Reader stream) throws java.io.IOException {
		int c;

		c = stream.read();
		return c < 0 ? NINA_EOF : c;
	}

	private int _read(java.io.Reader rd) throws java.io.IOException {
		int c;

		while(true) {
			if(unread != -1) {

				c = unread;
				unread = -1;
				__logprint("Read unread: ", c);
			} else if((c = _read1(rd)) != -1) {
				__logprint("Read: ", c);
			} else {
				__logprint("Read end-of-file");
			}
			return c;
		}
	}

	void UNGET(int c) {
		unread = c;
		__logprint("Set unread: ", c);
	}

	void __sleep(int m) {
		try {
			Thread.sleep(m);
		} catch(InterruptedException e) {
			throw new RuntimeException(e);
		}
	}

	private void __logprint(String s, int c) {
	}

	private void __logopen() {
	}

	private void __logprint(String s) {
	}

	private void __logclose() {
	}

	private void __puttrace() {
	}


	private int c_step(java.io.Reader __rd, int  $c)  throws java.io.IOException {
		switch(STATE) {
		case 0:
			if($c == '/') {
				STATE = 1;
				return 1;
			} else if($c >= 0) {
				STATE = 2;
				return 1;
			}
			return 0;
		case 2:
			if($c == '/') {
				STATE = 3;
				return 1;
			} else if($c >= 0) {
				STATE = 2;
				return 1;
			}
			return 0;
		case 3:
			return 0;
		case 1:
			if($c == '\n') {
				STATE = 4;
				return 1;
			} else if($c >= 0) {
				STATE = 1;
				return 1;
			}
			return 0;
		case 4:
			return 0;
		}
		return 0;
	}

	private boolean c_accepted() {
		return (STATE == 3 ||
				STATE == 4);
	}

	int c_execaction(int  $c) {
		switch(STATE) {
		case 3:
			break;
		case 2:
			break;
		case 0:
			break;
		case 4:
			break;
		case 1:
			break;
		}
		return 1;
	}

	boolean c_isend() {
		return false;
	}

	private final Engine ENGINE_c = new Engine() {

		int step(java.io.Reader __rd, int c) throws java.io.IOException {
			return c_step(__rd, c);
		}

		boolean accepted() {
			return c_accepted();
		}

		int execaction(int c) {
			return c_execaction(c);
		}

		boolean isend() {
			return c_isend();
		}

		int recover(Exception e) {
			return -1;
		}

		int deadState() {
			return -1;
		}

		int stateSize() {
			return 5;
		}

		int finallyState() {
			return -1;
		}

		public String toString() {
			return "c";
		}

	};

	private int action_step(java.io.Reader __rd, int  $c)  throws java.io.IOException {
		switch(STATE) {
		case 0:
			if($c >= 0 && $c <= 'z') {
				STATE = 0;
				return 1;
			} else if($c == '{') {
				STATE = 1;
				return 1;
			} else if($c == '|') {
				STATE = 0;
				return 1;
			} else if($c >= '~' && $c <= 2147483647) {
				STATE = 0;
				return 1;
			}
			return 0;
		case 1:
			if($c >= 0) {
				__stkpush(2, ENGINE_action);
				STATE = 0;
				return NINA_ACCEPT;
			}
			return 0;
		case 2:
			if($c == '}') {
				STATE = 3;
				return 1;
			}
			return 0;
		case 3:
			if($c >= 0 && $c <= 'z') {
				STATE = 3;
				return 1;
			} else if($c == '{') {
				STATE = 1;
				return 1;
			} else if($c == '|') {
				STATE = 3;
				return 1;
			} else if($c >= '~' && $c <= 2147483647) {
				STATE = 3;
				return 1;
			}
			return 0;
		}
		return 0;
	}

	private boolean action_accepted() {
		return (STATE == 0 ||
				STATE == 3);
	}

	int action_execaction(int  $c) {
		switch(STATE) {
		case 2:
			break;
		case 1:
			_b($c);
			break;
		case 0:
			_b($c);
			break;
		case 3:
			_b($c);
			break;
		}
		return 1;
	}

	boolean action_isend() {
		return false;
	}

	private final Engine ENGINE_action = new Engine() {

		int step(java.io.Reader __rd, int c) throws java.io.IOException {
			return action_step(__rd, c);
		}

		boolean accepted() {
			return action_accepted();
		}

		int execaction(int c) {
			return action_execaction(c);
		}

		boolean isend() {
			return action_isend();
		}

		int recover(Exception e) {
			return -1;
		}

		int deadState() {
			return -1;
		}

		int stateSize() {
			return 4;
		}

		int finallyState() {
			return -1;
		}

		public String toString() {
			return "action";
		}

	};

	private int char1_step(java.io.Reader __rd, int  $c)  throws java.io.IOException {
		switch(STATE) {
		case 0:
			if($c == '\\') {
				STATE = 1;
				return 1;
			} else if($c >= 0) {
				STATE = 2;
				return 1;
			}
			return 0;
		case 2:
			if($c == '\'') {
				STATE = 3;
				return 1;
			}
			return 0;
		case 3:
			return 0;
		case 1:
			if($c == 'n') {
				STATE = 4;
				return 1;
			} else if($c == 'r') {
				STATE = 5;
				return 1;
			} else if($c == 't') {
				STATE = 6;
				return 1;
			} else if($c >= 0) {
				STATE = 2;
				return 1;
			}
			return 0;
		case 6:
			if($c == '\'') {
				STATE = 3;
				return 1;
			}
			return 0;
		case 5:
			if($c == '\'') {
				STATE = 3;
				return 1;
			}
			return 0;
		case 4:
			if($c == '\'') {
				STATE = 3;
				return 1;
			}
			return 0;
		}
		return 0;
	}

	private boolean char1_accepted() {
		return (STATE == 3);
	}

	int char1_execaction(int  $c) {
		switch(STATE) {
		case 1:
			break;
		case 3:
			break;
		case 2:
			_ch = $c;
			break;
		case 6:
			_ch = '\t';
			break;
		case 0:
			break;
		case 4:
			_ch = '\n';
			break;
		case 5:
			_ch = '\r';
			break;
		}
		return 1;
	}

	boolean char1_isend() {
		return false;
	}

	private final Engine ENGINE_char1 = new Engine() {

		int step(java.io.Reader __rd, int c) throws java.io.IOException {
			return char1_step(__rd, c);
		}

		boolean accepted() {
			return char1_accepted();
		}

		int execaction(int c) {
			return char1_execaction(c);
		}

		boolean isend() {
			return char1_isend();
		}

		int recover(Exception e) {
			return -1;
		}

		int deadState() {
			return -1;
		}

		int stateSize() {
			return 7;
		}

		int finallyState() {
			return -1;
		}

		public String toString() {
			return "char1";
		}

	};

	private int decultureAction_step(java.io.Reader __rd, int  $c)  throws java.io.IOException {
		switch(STATE) {
		case 0:
			if($c >= 9 && $c <= 13) {
				STATE = 0;
				return 1;
			} else if($c == ' ') {
				STATE = 0;
				return 1;
			} else if($c == '/') {
				STATE = 1;
				return 1;
			} else if($c >= 'A' && $c <= 'Z') {
				STATE = 2;
				return 1;
			} else if($c >= 'a' && $c <= 'z') {
				STATE = 2;
				return 1;
			}
			return 0;
		case 2:
			if($c >= 9 && $c <= 13) {
				STATE = 3;
				return 1;
			} else if($c == ' ') {
				STATE = 3;
				return 1;
			} else if($c >= '0' && $c <= '9') {
				STATE = 2;
				return 1;
			} else if($c == ':') {
				STATE = 4;
				return 1;
			} else if($c >= 'A' && $c <= 'Z') {
				STATE = 2;
				return 1;
			} else if($c >= 'a' && $c <= 'z') {
				STATE = 2;
				return 1;
			}
			return 0;
		case 4:
			if($c >= 9 && $c <= 13) {
				STATE = 4;
				return 1;
			} else if($c == ' ') {
				STATE = 4;
				return 1;
			} else if($c == '\'') {
				STATE = 5;
				return 1;
			} else if($c == '/') {
				STATE = 6;
				return 1;
			} else if($c == ';') {
				_ac();
				STATE = 0;
				return 1;
			} else if($c == '<') {
				STATE = 7;
				return 1;
			} else if($c == '>') {
				STATE = 7;
				return 1;
			} else if($c >= 'A' && $c <= 'Z') {
				STATE = 7;
				return 1;
			} else if($c >= 'a' && $c <= 'z') {
				STATE = 7;
				return 1;
			} else if($c == '{') {
				STATE = 8;
				return 1;
			}
			return 0;
		case 8:
			if($c >= 0) {
				__stkpush(9, ENGINE_action);
				STATE = 0;
				return NINA_ACCEPT;
			}
			return 0;
		case 9:
			if($c == '}') {
				STATE = 10;
				return 1;
			}
			return 0;
		case 10:
			if($c >= 9 && $c <= 13) {
				STATE = 10;
				return 1;
			} else if($c == ' ') {
				STATE = 10;
				return 1;
			} else if($c == ';') {
				_ac();
				STATE = 11;
				return 1;
			} else if($c == '|') {
				_ac();
				STATE = 4;
				return 1;
			} else if($c >= 0) {
				UNGET($c);_aa();
				STATE = 4;
				return 1;
			}
			return 0;
		case 11:
			if($c >= 9 && $c <= 13) {
				STATE = 11;
				return 1;
			} else if($c == ' ') {
				STATE = 11;
				return 1;
			} else if($c >= 0) {
				UNGET($c);
				STATE = 0;
				return 1;
			}
			return 0;
		case 7:
			if($c >= 9 && $c <= 13) {
				STATE = 12;
				return 1;
			} else if($c == ' ') {
				STATE = 12;
				return 1;
			} else if($c >= '0' && $c <= '9') {
				STATE = 7;
				return 1;
			} else if($c == '<') {
				STATE = 7;
				return 1;
			} else if($c == '>') {
				STATE = 7;
				return 1;
			} else if($c >= 'A' && $c <= 'Z') {
				STATE = 7;
				return 1;
			} else if($c >= 'a' && $c <= 'z') {
				STATE = 7;
				return 1;
			} else if($c == '{') {
				STATE = 8;
				return 1;
			}
			return 0;
		case 12:
			if($c >= 9 && $c <= 13) {
				STATE = 12;
				return 1;
			} else if($c == ' ') {
				STATE = 12;
				return 1;
			} else if($c == '%') {
				STATE = 13;
				return 1;
			} else if($c == '\'') {
				STATE = 14;
				return 1;
			} else if($c == '<') {
				STATE = 7;
				return 1;
			} else if($c == '>') {
				STATE = 7;
				return 1;
			} else if($c >= 'A' && $c <= 'Z') {
				STATE = 7;
				return 1;
			} else if($c >= 'a' && $c <= 'z') {
				STATE = 7;
				return 1;
			} else if($c == '{') {
				STATE = 8;
				return 1;
			} else if($c >= 0) {
				UNGET($c);
				STATE = 10;
				return 1;
			}
			return 0;
		case 14:
			if($c >= 0) {
				__stkpush(12, ENGINE_char1);
				STATE = 0;
				return NINA_ACCEPT;
			}
			return 0;
		case 13:
			if($c == 'p') {
				STATE = 15;
				return 1;
			}
			return 0;
		case 15:
			if($c == 'r') {
				STATE = 16;
				return 1;
			}
			return 0;
		case 16:
			if($c == 'e') {
				STATE = 17;
				return 1;
			}
			return 0;
		case 17:
			if($c == 'c') {
				STATE = 18;
				return 1;
			}
			return 0;
		case 18:
			if($c >= 9 && $c <= 13) {
				STATE = 18;
				return 1;
			} else if($c == ' ') {
				STATE = 18;
				return 1;
			} else if($c == '\'') {
				STATE = 19;
				return 1;
			} else if($c >= 'A' && $c <= 'Z') {
				STATE = 20;
				return 1;
			} else if($c >= 'a' && $c <= 'z') {
				STATE = 20;
				return 1;
			}
			return 0;
		case 20:
			if($c >= '0' && $c <= '9') {
				STATE = 20;
				return 1;
			} else if($c >= 'A' && $c <= 'Z') {
				STATE = 20;
				return 1;
			} else if($c >= 'a' && $c <= 'z') {
				STATE = 20;
				return 1;
			} else if($c >= 0) {
				UNGET($c);_pr();
				STATE = 12;
				return 1;
			}
			return 0;
		case 19:
			if($c >= 0) {
				__stkpush(21, ENGINE_char1);
				STATE = 0;
				return NINA_ACCEPT;
			}
			return 0;
		case 21:
			if($c >= 0) {
				UNGET($c);_pr();
				STATE = 12;
				return 1;
			}
			return 0;
		case 6:
			if($c >= 0) {
				__stkpush(4, ENGINE_c);
				STATE = 0;
				return NINA_ACCEPT;
			}
			return 0;
		case 5:
			if($c >= 0) {
				__stkpush(12, ENGINE_char1);
				STATE = 0;
				return NINA_ACCEPT;
			}
			return 0;
		case 3:
			if($c == ':') {
				STATE = 4;
				return 1;
			}
			return 0;
		case 1:
			if($c >= 0) {
				__stkpush(0, ENGINE_c);
				STATE = 0;
				return NINA_ACCEPT;
			}
			return 0;
		}
		return 0;
	}

	private boolean decultureAction_accepted() {
		return (STATE == 11);
	}

	int decultureAction_execaction(int  $c) {
		switch(STATE) {
		case 19:
			break;
		case 4:
			_st($c);
			break;
		case 0:
			break;
		case 11:
			break;
		case 12:
			_st(0);
			break;
		case 13:
			break;
		case 1:
			break;
		case 8:
			_x($c);
			break;
		case 16:
			break;
		case 9:
			break;
		case 15:
			break;
		case 6:
			break;
		case 20:
			_b($c);
			break;
		case 18:
			break;
		case 5:
			break;
		case 10:
			break;
		case 21:
			break;
		case 7:
			_b($c);
			break;
		case 17:
			break;
		case 2:
			_b($c);
			break;
		case 3:
			break;
		case 14:
			break;
		}
		return 1;
	}

	boolean decultureAction_isend() {
		return false;
	}

	private final Engine ENGINE_decultureAction = new Engine() {

		int step(java.io.Reader __rd, int c) throws java.io.IOException {
			return decultureAction_step(__rd, c);
		}

		boolean accepted() {
			return decultureAction_accepted();
		}

		int execaction(int c) {
			return decultureAction_execaction(c);
		}

		boolean isend() {
			return decultureAction_isend();
		}

		int recover(Exception e) {
			return -1;
		}

		int deadState() {
			return -1;
		}

		int stateSize() {
			return 22;
		}

		int finallyState() {
			return -1;
		}

		public String toString() {
			return "decultureAction";
		}

	};

	void __stkpush(int st, Engine en) {
		Object[][] c;
		Engine[] b;
		int[] a;

		if(__slen >= __sts.length) {
			a = new int[__sts.length * 2];
			b = new Engine[__stk.length * 2];
			c = new Object[__stk.length * 2][];
			System.arraycopy(__sts, 0, a, 0, __sts.length);
			System.arraycopy(__stk, 0, b, 0, __stk.length);
			System.arraycopy(__stv, 0, c, 0, __stv.length);
			__sts = a;
			__stk = b;
			__stv = c;
		}
		__sts[__slen] = st;
		__stk[__slen] = en;
		__stv[__slen++] = new Object[en.stateSize()];
	}

	private int _parse(java.io.Reader rd, int x, Boolean rt,
			boolean skip, int[] st) throws java.io.IOException {
		boolean b = false, p = skip;
		int c = x;
		Engine en;
		int a;

		b = __stk[__slen - 1].accepted();
		if(rd == null) {
			throw new RuntimeException("can not recurse");
		} else if(rt.booleanValue()) {
			switch(__stk[__slen - 1].execaction(NINA_BEGIN)) {
			case NINA_ACCEPT:
				__logprint("accept " + __stk[__slen - 1]);
				st[0] = NINA_ACCEPT;  return -1;
			case NINA_FAIL:
				__logprint("match failed: begin");
				__puttrace();
				st[0] = NINA_FAIL;  return -1;
			case NINA_HALT_ACCEPT:
				__logprint("machine halted: begin");
				st[0] = NINA_HALT_ACCEPT;  return -1;
			case NINA_HALT_REJECT:
				__logprint("machine halted: begin");
				st[0] = NINA_HALT_REJECT;  return -1;
			case NINA_YIELD:
				__logprint("machine yielded: ", c);
				st[0] = NINA_YIELD;  return -1;
			}
		}

		try {
			do {
				en = __stk[__slen - 1];
				if(p) {
					p = false;
				} else if((a = en.step(rd, c)) > 0) {
					__logprint("transit to state " + STATE + ": ", c);
					b = en.accepted();
					switch(en.execaction(c)) {
					case NINA_ACCEPT:
						__logprint("accept " + __stk[__slen - 1]);
						UNGET(c);
						st[0] = NINA_ACCEPT;  return -1;
					case NINA_FAIL:
						__logprint("match failed: ", c);
						__puttrace();
						UNGET(c);
						st[0] = NINA_FAIL;  return -1;
					case NINA_HALT_ACCEPT:
						__logprint("machine halted: ", c);
						st[0] = NINA_HALT_ACCEPT;  return -1;
					case NINA_HALT_REJECT:
						__logprint("machine halted: ", c);
						st[0] = NINA_HALT_REJECT;  return -1;
					case NINA_YIELD:
						__logprint("machine yielded: ", c);
						st[0] = NINA_YIELD;  return -1;
					}
				} else if(a < 0) {
					__logprint("entering " + __stk[__slen - 1]);
					return c;
				} else if(b) {
					__logprint("accept " + __stk[__slen - 1]);
					UNGET(c);
					st[0] = NINA_ACCEPT;  return -1;
				} else if(c == -1) {
					if(!b)  throw new TokenException();
					st[0] = NINA_ACCEPT;  return -1;
				} else {
					__logprint("match failed: ", c);
					__puttrace();
					UNGET(c);
					st[0] = NINA_FAIL;  return -1;
				}
				c = _read(rd);
			} while(true);
		} catch(RuntimeException e) {
			UNGET(c);
			throw e;
		}
	}

	private Boolean execfinally() {
		int a, b;

		if((a = __stk[__slen - 1].finallyState()) >= 0) {
			b = STATE;  STATE = a;
			switch(__stk[__slen - 1].execaction(NINA_BEGIN)) {
			case NINA_HALT_ACCEPT:
				__slen = 0;
				return Boolean.TRUE;
			case NINA_HALT_REJECT:
				__slen = 0;
				return Boolean.FALSE;
			}
			STATE = b;
		}
		return null;
	}

	private int getdeadstate() {
		return __stk[__slen - 1].deadState();
	}

	private int getrecover(Exception e) {
		return __stk[__slen - 1].recover(e);
	}

	 boolean parse(java.io.Reader rd, Engine entry) throws java.io.IOException {
		Boolean b = Boolean.FALSE;
		int[] a = new int[1];
		boolean skip = true;
		int c = 0;

		__logopen();
		try {
			if(__slen == 0) {
				b = Boolean.TRUE;
				__stkpush(0, entry);
			}

			ot: while(true) {
				try {
					if((c = _parse(rd, c, b, skip, a)) != -1) {
						skip = false;
					} else if(a[0] == NINA_FAIL) {
						while((STATE = getdeadstate()) < 0) {
							if((b = execfinally()) != null)  break ot;
							if(__slen-- <= 1) {
								throw new TokenException();
							}
						}
						skip = true;
					} else if(a[0] == NINA_HALT_ACCEPT) {
						if((b = execfinally()) != null)  break;
						__slen = 0;
						b = Boolean.TRUE;  break;
					} else if(a[0] == NINA_HALT_REJECT) {
						if((b = execfinally()) != null)  break;
						__slen = 0;
						b = Boolean.FALSE;  break;
					} else if(a[0] == NINA_YIELD) {
						return false;
					} else if(__slen > 1) {
						if((b = execfinally()) != null)  break;
						STATE = __sts[--__slen];
						skip = true;
					} else {
						if((b = execfinally()) != null)  break;
						b = new Boolean(__stk[--__slen].accepted());
						break;
					}
				} catch(RuntimeException e) {
					exception = e;
					if(__slen <= 0)  throw e;
					while((STATE = getrecover(e)) < 0) {
						if((b = execfinally()) != null)  return b;
						if(__slen-- <= 1)  throw e;
					}
				}
				b = Boolean.TRUE;
			}
			if(!b.booleanValue())  throw new TokenException();
			return b.booleanValue();
		} finally {
			__logclose();
		}
	}

	public boolean parse(java.io.Reader rd) throws java.io.IOException {
		return parse(rd, ENGINE_decultureAction);
	}

	 void setStream(java.io.Reader rd) {
		if(befstream != null) {
			throw new IllegalStateException();
		}
		yieldObject = befstream = rd;
	}

	 Object parseNext() throws java.io.IOException {
		Object o;

		if(befstream == null) {
			throw new IllegalStateException();
		} else if(yieldObject == null) {
			return null;
		} else if(parse(befstream, ENGINE_decultureAction)) {
			if(yieldObject == null)  throw new NullPointerException();
			o = yieldObject;  yieldObject = null;
			return o;
		} else {
			if(yieldObject == null)  throw new NullPointerException();
			return yieldObject;
		}
	}

	 boolean parse(java.io.InputStream rd) throws java.io.IOException {
		return parse(new java.io.InputStreamReader(rd));
	}

private static final Pattern PTN1 = Pattern.compile("<(.+)>");

private Map<String, String> tokens;
private Map<ContextFreeRule, Object> actions = new HashMap<ContextFreeRule, Object>();
private Map<String, String> subautomata = new HashMap<String, String>();
private List<Object> rule = new ArrayList<Object>();
private StringBuffer buf = new StringBuffer();
private Object former;
private int _ch = -1;

public DecultureAction(DecultureDefinition d) {
	tokens = d.getTokens();
}

public Map<ContextFreeRule, Object> getActions() {
	return Collections.unmodifiableMap(actions);
}

public Map<String, String> getSubautomata() {
	return Collections.unmodifiableMap(subautomata);
}

private void _b(int c) {
	if(c >= 0)  buf.appendCodePoint(c);
}

private void _st(int c) {
	if(rule == null)  rule = new ArrayList<Object>();
	if(c == '|') {
		rule.add(former);
	} else if(_ch >= 0) {
		rule.add(Integer.valueOf(_ch));
		_ch = -1;
	} else if(buf.length() > 0) {
		rule.add(buf.toString());
		buf = new StringBuffer();
	}
}

private void _x(int c) {
	_st(0);
	_b(c);
}

private void _pr() {
	Object t = null;
	Object o;
	int k;

	for(k = rule.size() - 1; k >= 0; k--) {
		o = rule.get(k);
		if(o instanceof Integer || tokens.containsKey(o)) {
			t = o;
			break;
		}
	}

	if(t == null || t instanceof PrecedenceTerminal) {
		// do nothing
	} else if(_ch >= 0) {
		rule.set(k, new PrecedenceTerminal(
				new CharacterTerminal(((Integer)t).intValue()),
				new CharacterTerminal(_ch)));
	} else if(buf.length() > 0) {
		rule.set(k, new PrecedenceTerminal(
				new ConstantTerminal(t.toString()),
				new ConstantTerminal(buf.toString())));
	}
	_ch = -1;
	buf = new StringBuffer();
}

private void _aa() {
	ContextFreeRule r;
	Nonterminal l;

	l = ConstantNonterminal.gensym();
	r = new ContextFreeRule(l, new GrammarSymbol[0]);
	rule.add(l);
	actions.put(r, buf.append('}').toString());
	_ch = -1;
	buf = new StringBuffer();
}

private void _ac() {
	Nonterminal l;
	GrammarSymbol[] a;
	GrammarSymbol g;
	ContextFreeRule r;
	Matcher m;
	Object o;

	if(rule == null) {
		return;
	} else if(tokens.containsKey(rule.get(0))) {
		throw new DecultureException();
	}
	l = new ConstantNonterminal(rule.get(0).toString());

	a = new GrammarSymbol[rule.size() - 1];
	for(int k = 1; k < rule.size(); k++) {
		if((o = rule.get(k)) instanceof PrecedenceTerminal) {
			g = (PrecedenceTerminal)o;
		} else if(o instanceof Integer) {
			g = new CharacterTerminal(((Integer)o).intValue());
		} else if(tokens.containsKey(o)) {
			g = new ConstantTerminal(o.toString());
		} else if(o instanceof Nonterminal) {
			g = (Nonterminal)o;
		} else if((m = PTN1.matcher(o.toString())).matches()) {
			subautomata.put(m.group(1), null);
			g = new SubautomatonTerminal(m.group(1));
		} else {
			g = new ConstantNonterminal(o.toString());
		}
		a[k - 1] = g;
	}
	r = new ContextFreeRule(l, a);

	if(buf.length() > 0) {
		actions.put(r, buf.append('}').toString());
		buf = new StringBuffer();
	} else {
		actions.put(r, null);
	}
	former = rule.get(0);
	rule = null;
}

}
