/*
 * Copyright 2009-2010 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.automata.nfa.op;

import java.util.Collections;
import java.util.Set;

import net.morilib.automata.NFAEdges;
import net.morilib.automata.NFAState;
import net.morilib.range.Range;

//
class EpsilonEdge<T> implements NFAEdges<T> {

	private Set<NFAState> set;

	EpsilonEdge(Set<NFAState> s) {
		if(s != null) {
			set = Collections.unmodifiableSet(s);
		} else {
			set = Collections.emptySet();
		}
	}

	@Override
	public Set<NFAState> goNext(T alphabet) {
		return Collections.emptySet();
	}

	@Override
	public Set<NFAState> goNext(int alphabet) {
		return Collections.emptySet();
	}

	@Override
	public Set<NFAState> goNext(char alphabet) {
		return Collections.emptySet();
	}

	@Override
	public Set<NFAState> goNextEpsilon() {
		return set;
	}

	@Override
	public Set<? extends Range> nextAlphabets() {
		return Collections.emptySet();
	}

	@Override
	public boolean isNextEpsilon() {
		return !set.isEmpty();
	}

}