/*
 * Copyright 2009-2010 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.automata.lr;

/**
 * 
 * 
 * @author MORIGUCHI, Yuichiro 2006/07/08
 */
public final class LRConflict {

	//
	private boolean shiftReduce;
	private ContextFreeRule reduceRule, reduceRule2;
	private Object shiftSymbol;

	//
	private LRConflict() {
		// do nothing
	}

	/**
	 * 
	 * @param symbol
	 * @param rule1
	 * @return
	 */
	protected static LRConflict newShiftReduce(
			Object symbol, ContextFreeRule rule1) {
		LRConflict res = new LRConflict();

		res.shiftReduce = true;
		res.shiftSymbol = symbol;
		res.reduceRule  = rule1;
		return res;
	}

	/**
	 * 
	 * @param symbol
	 * @param rule1
	 * @return
	 */
	protected static LRConflict newReduceReduce(
			ContextFreeRule rule1, ContextFreeRule rule2) {
		LRConflict res = new LRConflict();

		res.shiftReduce = false;
		res.reduceRule  = rule1;
		res.reduceRule2 = rule2;
		return res;
	}

	/**
	 * 
	 * @return
	 */
	public boolean isShiftReduce() {
		return shiftReduce;
	}

	/**
	 * 
	 * @return
	 */
	public boolean isReduceReduce() {
		return !shiftReduce;
	}

	/**
	 * 
	 * @return
	 */
	public Object getShiftSymbol() {
		return shiftSymbol;
	}

	/**
	 * 
	 * @return
	 */
	public ContextFreeRule getReduceRule() {
		return reduceRule;
	}

	/**
	 * 
	 * @return
	 */
	public ContextFreeRule getReduceRule2() {
		return reduceRule2;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		StringBuffer buf = new StringBuffer();

		if(shiftReduce) {
			buf.append("shift/reduce conflict: shift ");
			buf.append(shiftSymbol).append(" vs reduce ");
			buf.append(reduceRule);
		} else {
			buf.append("reduce/reduce conflict: reduce ");
			buf.append(reduceRule ).append(" vs reduce ");
			buf.append(reduceRule2);
		}
		return buf.toString();
	}

}