/*
 * Copyright 2009 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.lisp.nano.subr;

import java.util.ArrayList;
import java.util.List;

import net.morilib.lisp.nano.Datum;
import net.morilib.lisp.nano.Environment;
import net.morilib.lisp.nano.LispMessage;
import net.morilib.lisp.nano.LispUtils;
import net.morilib.lisp.nano.LispVector;
import net.morilib.lisp.nano.Subr;
import net.morilib.lisp.nano.Undef;

/**
 * 
 *
 *
 * @author MORIGUCHI, Yuichiro 2009
 */
public class MakeVector extends Subr {

	private List<Datum> makeVector(int len, Datum d) {
		List<Datum> b = new ArrayList<Datum>();

		for(int i = 0; i < len; i++) {
			b.add(d);
		}
		return b;
	}

	private int chk(List<Datum> lst, LispMessage mesg) {
		int t = SubrUtils.getSmallInt(lst.get(0), mesg);

		if(t < 0) {
			throw mesg.getError("err.require.int.nonnegative",
					lst.get(0));
		}
		return t;
	}

	@Override
	public Datum eval(
			Datum body, Environment env, LispMessage mesg) {
		List<Datum> lst = LispUtils.consToList(body, mesg);

		if(lst.size() == 1) {
			return new LispVector(makeVector(chk(lst, mesg),
					Undef.UNDEF));
		} else if(lst.size() == 2) {
			return new LispVector(makeVector(chk(lst, mesg),
					lst.get(1)));
		} else {
			throw mesg.getError("err.argument", symbolName);
			//throw new LispException("wrong number of arguments");
		}
	}

}
