/*
 * Copyright 2009 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.lisp.nano.subr;

import net.morilib.lisp.nano.Datum;
import net.morilib.lisp.nano.Environment;
import net.morilib.lisp.nano.LispDouble;
import net.morilib.lisp.nano.LispInteger;
import net.morilib.lisp.nano.LispMessage;
import net.morilib.lisp.nano.LispRational;

public class Floor extends UnaryArgs {

	@Override
	protected Datum execute(
			Datum c1a, Environment env, LispMessage mesg) {
		if(c1a instanceof LispInteger) {
			return c1a;
		} else if(c1a instanceof LispRational) {
			LispRational q = (LispRational)c1a;
			
			return LispInteger.valueOf(SubrUtils.floor(
					q.getNumerator(), q.getDenominator()));
		} else if(c1a instanceof LispDouble) {
			double d = ((LispDouble)c1a).doubleValue();
			
			return new LispDouble(Math.floor(d));
		}
		throw mesg.getError("err.require.real", c1a);
		//throw new LispException("real number required");
	}

}
